/*
 * Decompiled with CFR 0.152.
 */
package bssoft.stack.sip;

import bssoft.stack.sip.SDPMedia;
import bssoft.stack.sip.SIPStack;
import java.util.Date;

public class SIPSdp {
    public String vH = null;
    public String oH = null;
    public String sH = null;
    public String cH = null;
    public String tH = null;
    public SDPMedia audioM = null;
    public SDPMedia videoM = null;
    public String body = null;
    public String dn = null;
    public String platformIp = null;
    public String audioDescription = null;
    public String videoDescription = null;
    public boolean flag;

    public SIPSdp(String dn, String localIp) {
        if (!SIPStack.bStackLicensed) {
            System.out.println("\ub77c\uc774\uc2a8\uc2a4\ud0a4\ub97c \uc124\uc815\ud558\uc138\uc694.");
            System.exit(0);
        }
        this.dn = dn;
        this.platformIp = localIp;
        long ltime = new Date().getTime();
        this.vH = "v=0" + SIPStack.SIP_LINE_END;
        this.oH = "o=" + dn + " " + ltime + " " + (ltime + 1L) + " IN IP4 " + this.platformIp + SIPStack.SIP_LINE_END;
        this.sH = "s=Smart Android call" + SIPStack.SIP_LINE_END;
        this.cH = "c=IN IP4 " + this.platformIp + SIPStack.SIP_LINE_END;
        this.tH = "t=0 0" + SIPStack.SIP_LINE_END;
        this.audioDescription = "";
        this.videoDescription = "";
        this.flag = true;
    }

    public SIPSdp(String dn, String localIp, String localSdpIp) {
        if (!SIPStack.bStackLicensed) {
            System.out.println("\ub77c\uc774\uc2a8\uc2a4\ud0a4\ub97c \uc124\uc815\ud558\uc138\uc694.");
            System.exit(0);
        }
        this.dn = dn;
        this.platformIp = localIp;
        long ltime = new Date().getTime();
        this.vH = "v=0" + SIPStack.SIP_LINE_END;
        this.oH = "o=" + dn + " " + ltime + " " + (ltime + 1L) + " IN IP4 " + localSdpIp + SIPStack.SIP_LINE_END;
        this.sH = "s=Smart Android call" + SIPStack.SIP_LINE_END;
        this.cH = "c=IN IP4 " + localSdpIp + SIPStack.SIP_LINE_END;
        this.tH = "t=0 0" + SIPStack.SIP_LINE_END;
        this.audioDescription = "";
        this.videoDescription = "";
        this.flag = true;
    }

    public SIPSdp(String body) {
        if (!SIPStack.bStackLicensed) {
            System.out.println("\ub77c\uc774\uc2a8\uc2a4\ud0a4\ub97c \uc124\uc815\ud558\uc138\uc694.");
            System.exit(0);
        }
        if (body != null && body.length() > 0) {
            this.body = body;
            int iS = 0;
            int iE = 0;
            iS = body.indexOf("v=");
            if (iS >= 0) {
                iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
            }
            if (iS >= 0 && iE > iS) {
                this.vH = body.substring(iS, iE + 2);
            }
            iS = 0;
            iE = 0;
            iS = body.indexOf("o=");
            if (iS >= 0) {
                iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
            }
            if (iS >= 0 && iE > iS) {
                this.oH = body.substring(iS, iE + 2);
            }
            iS = 0;
            iE = 0;
            iS = body.indexOf("s=");
            if (iS >= 0) {
                iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
            }
            if (iS >= 0 && iE > iS) {
                this.sH = body.substring(iS, iE + 2);
            }
            iS = 0;
            iE = 0;
            iS = body.indexOf("c=");
            if (iS >= 0) {
                iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
            }
            if (iS >= 0 && iE > iS) {
                this.cH = body.substring(iS, iE + 2);
            }
            iS = 0;
            iE = 0;
            iS = body.indexOf("t=");
            if (iS >= 0) {
                iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
            }
            if (iS >= 0 && iE > iS) {
                this.tH = body.substring(iS, iE + 2);
            }
            if (this.vH != null && this.vH.length() > 0 && this.oH != null && this.oH.length() > 0 && this.tH != null && this.tH.length() > 0) {
                this.platformIp = "0.0.0.0";
                if (this.cH != null && this.cH.length() > 0 && this.cH.startsWith("c=IN IP4 ")) {
                    iE = this.cH.indexOf(SIPStack.SIP_LINE_END);
                    this.platformIp = this.cH.substring("c=IN IP4 ".length(), iE);
                }
                if ((iS = body.indexOf("m=audio ")) > 0) {
                    iE = body.indexOf("m=", iS + 8);
                    if (iE > 0 && iE > iS) {
                        this.audioM = new SDPMedia(body.substring(iS, iE), this.platformIp);
                    } else if (iE < 0) {
                        this.audioM = new SDPMedia(body.substring(iS), this.platformIp);
                    }
                }
                if ((iS = body.indexOf("m=video ")) > 0) {
                    iE = body.indexOf("m=", iS + 8);
                    if (iE > 0 && iE > iS) {
                        this.videoM = new SDPMedia(body.substring(iS, iE), this.platformIp);
                    } else if (iE < 0) {
                        this.videoM = new SDPMedia(body.substring(iS), this.platformIp);
                    }
                }
            }
            this.flag = true;
        }
    }

    public boolean setMediaPort(int mediaType, int port) {
        if (mediaType == SIPStack.SIP_MEDIATYPE_AUDIO) {
            if (this.audioM == null) {
                this.audioM = new SDPMedia(mediaType);
                if (this.audioM != null && this.audioM.flag) {
                    return this.audioM.setMediaAddress(this.platformIp, port);
                }
            }
        } else if (mediaType == SIPStack.SIP_MEDIATYPE_VIDEO && this.videoM == null) {
            this.videoM = new SDPMedia(mediaType);
            if (this.videoM != null && this.videoM.flag) {
                return this.videoM.setMediaAddress(this.platformIp, port);
            }
        }
        return false;
    }

    public boolean setCodec(int mediaType, int codec) {
        if (mediaType == SIPStack.SIP_MEDIATYPE_AUDIO) {
            if (this.audioM != null && this.audioM.flag) {
                return this.audioM.setCodec(codec);
            }
        } else if (mediaType == SIPStack.SIP_MEDIATYPE_VIDEO && this.videoM != null && this.videoM.flag) {
            return this.videoM.setCodec(codec);
        }
        return false;
    }

    public boolean setCodec(int mediaType, int codec, String describe) {
        if (mediaType == SIPStack.SIP_MEDIATYPE_AUDIO) {
            if (this.audioM != null && this.audioM.flag) {
                return this.audioM.setCodec(codec, describe);
            }
        } else if (mediaType == SIPStack.SIP_MEDIATYPE_VIDEO && this.videoM != null && this.videoM.flag) {
            return this.videoM.setCodec(codec, describe);
        }
        return false;
    }

    public boolean setFmtpDescribe(int mediaType, int codec, String describe) {
        if (mediaType == SIPStack.SIP_MEDIATYPE_AUDIO) {
            if (this.audioM != null && this.audioM.flag) {
                return this.audioM.setFmtpDescribe(codec, describe);
            }
        } else if (mediaType == SIPStack.SIP_MEDIATYPE_VIDEO && this.videoM != null && this.videoM.flag) {
            return this.videoM.setFmtpDescribe(codec, describe);
        }
        return false;
    }

    public void resetSdp() {
        this.flag = false;
    }

    public String getBodyString() {
        this.audioDescription = "";
        this.videoDescription = "";
        if (!this.flag) {
            return null;
        }
        if (this.audioM != null && this.audioM.flag) {
            this.audioDescription = this.audioM.getMediaString();
            if (this.audioDescription == null) {
                this.audioDescription = "";
            }
        }
        if (this.videoM != null && this.videoM.flag) {
            this.videoDescription = this.videoM.getMediaString();
            if (this.videoDescription == null) {
                this.videoDescription = "";
            }
        }
        this.body = String.valueOf(this.vH) + this.oH + this.sH + this.cH + this.tH + this.audioDescription + this.videoDescription;
        return this.body;
    }

    public String getFinalBodyString() {
        this.audioDescription = "";
        this.videoDescription = "";
        if (!this.flag) {
            return null;
        }
        if (this.audioM != null && this.audioM.flag) {
            this.audioDescription = this.audioM.getFinalMediaString();
            if (this.audioDescription == null) {
                this.audioDescription = "";
            }
        }
        if (this.videoM != null && this.videoM.flag) {
            this.videoDescription = this.videoM.getFinalMediaString();
            if (this.videoDescription == null) {
                this.videoDescription = "";
            }
        }
        this.body = String.valueOf(this.vH) + this.oH + this.sH + this.cH + this.tH + this.audioDescription + this.videoDescription;
        return this.body;
    }

    public boolean update(String body) {
        return true;
    }
}

