/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class HeatingV2API
extends WallPadDevAPI {
    private final String TAG = "HeatingV2API";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"HeatingV2API", (String)s);
    }

    public HeatingV2API(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("HeatingV2API create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "HEATINGV2";
        this.data = new Data();
        int ret = this.Refresh((byte)100, false);
        if (ret == 0) {
            byte RoomCount = this.data.Device.info.RoomCount;
            Log.i((String)"HeatingV2API", (String)("GetInfo() - OK!!! (RoomCount:" + RoomCount + ")"));
            this.data.Device.SetRoomCount(RoomCount);
        } else {
            Log.i((String)"HeatingV2API", (String)("GetInfo() - fail!!! " + ret));
        }
        ret = this.Refresh((byte)-1, false);
        Log.i((String)"HeatingV2API", (String)("Refresh() - ret:" + ret));
        if (this.data.Device.info.Support.Boiler) {
            ret = this.Refresh((byte)101, false);
            Log.i((String)"HeatingV2API", (String)("GetBoiler() - ret:" + ret));
        }
        if (this.data.Device.info.Support.AI) {
            ret = this.Refresh((byte)102, false);
            Log.i((String)"HeatingV2API", (String)("GetSpecialFunc() - ret:" + ret));
        }
    }

    public int Refresh(byte Index, boolean real) {
        if ((Index < 0 || Index > 7) && Index != -1 && Index != 100 && Index != 101 && Index != 102) {
            Log.w((String)"HeatingV2API", (String)("[Refresh] Param (Index) Out Of Range !!! (" + Index + ")"));
            return -300;
        }
        if (Index == 100 && real) {
            Log.w((String)"HeatingV2API", (String)"[Refresh] If the Index is REFRESH_IDX.INFO does not support the real(true)");
            return -300;
        }
        if (Index != 100 && this.data.Device.info.RoomCount <= 0) {
            Log.w((String)"HeatingV2API", (String)("[Refresh] DEVICE IS NOT READY (" + Index + ")"));
            return -110;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = null;
        if (Index >= 0 && Index <= 7) {
            if (this.CheckParamRoom(Index) != 0) {
                Log.w((String)"HeatingV2API", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
                return -300;
            }
            ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingRoom(ret);
        }
        if (Index == -1) {
            int i;
            if (real) {
                int iret = this.SendNReadCMD_int(MainCMD, SubCMD, -1, 0, 0, 0, 0);
                if (iret != 0) {
                    return -111;
                }
                MainCMD = "NOSINKCTRL";
            }
            for (i = 0; i < this.data.Device.info.RoomCount && this.ParsingRoom(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) == 0; ++i) {
            }
            if (i < this.data.Device.info.RoomCount) {
                Log.w((String)"HeatingV2API", (String)("[Refresh] REFRESH_IDX.ALL fail (i:" + i + ")"));
                return -111;
            }
            return 0;
        }
        if (Index == 100) {
            ret = this.SendNReadCMD_str("NOSINKCTRL", SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingInfo(ret);
        }
        if (Index == 101) {
            ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingBoiler(ret);
        }
        if (Index == 102) {
            ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingSpecialFunc(ret);
        }
        Log.w((String)"HeatingV2API", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
        return -300;
    }

    private int ParsingRoom(String ret) {
        String FUNC_NAME = "[ParsingRoom]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.HeatingV2.RoomData roomData = new DataClasses.HeatingV2.RoomData();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            roomData.Mode = Byte.parseByte(retData[index++]);
            roomData.bValveStatus = Boolean.parseBoolean(retData[index++]);
            roomData.SetTemp = Double.parseDouble(retData[index++]);
            roomData.NowTemp = Double.parseDouble(retData[index++]);
            roomData.Error.setByte(Byte.parseByte(retData[index++]));
            if (this.data.Device.info.Support.Sleep) {
                roomData.Sleep.setByte(Byte.parseByte(retData[index++]));
            } else {
                ++index;
            }
            if (this.data.Device.info.Support.Reservation) {
                roomData.Reservation.setInt(Integer.parseInt(retData[index++]));
            }
            this.data.Device.Room[Current] = roomData;
        }
        catch (Exception e) {
            Log.e((String)"HeatingV2API", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingInfo(String ret) {
        String FUNC_NAME = "[ParsingInfo]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            Log.i((String)"HeatingV2API", (String)("HeatingV2API Parsing Length = " + retData.length));
            if (retData == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.HeatingV2.Info info = new DataClasses.HeatingV2.Info();
            int index = 1;
            info.RoomCount = Byte.parseByte(retData[index++]);
            info.Vender = Byte.parseByte(retData[index++]);
            info.FwVer_Year = Byte.parseByte(retData[index++]);
            info.FwVer_Month = Byte.parseByte(retData[index++]);
            info.FwVer_Day = Byte.parseByte(retData[index++]);
            info.FwVer_Number = Byte.parseByte(retData[index++]);
            info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
            info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
            info.Support.MinSetTemp = Byte.parseByte(retData[index++]);
            info.Support.MaxSetTemp = Byte.parseByte(retData[index++]);
            info.Support.SetTempPoint05 = Boolean.parseBoolean(retData[index++]);
            info.Support.Outing = Boolean.parseBoolean(retData[index++]);
            info.Support.Sleep = Boolean.parseBoolean(retData[index++]);
            info.Support.Reservation = Boolean.parseBoolean(retData[index++]);
            info.Support.Pause = Boolean.parseBoolean(retData[index++]);
            info.Support.AI = Boolean.parseBoolean(retData[index++]);
            info.Support.OutsideTempUse = Boolean.parseBoolean(retData[index++]);
            info.Support.Boiler = Boolean.parseBoolean(retData[index++]);
            info.Support.Leak = retData.length == 20 ? Boolean.parseBoolean(retData[index++]) : false;
            this.data.Device.info = info;
        }
        catch (Exception e) {
            Log.e((String)"HeatingV2API", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingBoiler(String ret) {
        String FUNC_NAME = "[ParsingBoiler]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (!this.data.Device.info.Support.Boiler) {
                Log.w((String)"HeatingV2API", (String)"[GetBoiler] No Support Boiler !!!");
                return -300;
            }
            if (ret == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.HeatingV2.BoilerData Boiler = new DataClasses.HeatingV2.BoilerData();
            int index = 1;
            Boiler.bFrostProtectMode = Boolean.parseBoolean(retData[index++]);
            Boiler.ErrorCode = Byte.parseByte(retData[index++]);
            Boiler.HeatingWater.bSetTempUnit5 = Boolean.parseBoolean(retData[index++]);
            Boiler.HeatingWater.SetTemp = Byte.parseByte(retData[index++]);
            Boiler.HeatingWater.MinSetTemp = Byte.parseByte(retData[index++]);
            Boiler.HeatingWater.MaxSetTemp = Byte.parseByte(retData[index++]);
            Boiler.HotWater.bSetTempUnit5 = Boolean.parseBoolean(retData[index++]);
            Boiler.HotWater.SetTemp = Byte.parseByte(retData[index++]);
            Boiler.HotWater.MinSetTemp = Byte.parseByte(retData[index++]);
            Boiler.HotWater.MaxSetTemp = Byte.parseByte(retData[index++]);
            this.data.Boiler = Boiler;
        }
        catch (Exception e) {
            Log.e((String)"HeatingV2API", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingSpecialFunc(String ret) {
        String FUNC_NAME = "[ParsingSpecialFunc]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (!this.data.Device.info.Support.AI) {
                Log.w((String)"HeatingV2API", (String)"[GetSpecialFunc] No Support AI !!!");
                return -300;
            }
            if (ret == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"HeatingV2API", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.HeatingV2.SpecialFuncData SpecialFunc = new DataClasses.HeatingV2.SpecialFuncData();
            int index = 1;
            SpecialFunc.Mode = Byte.parseByte(retData[index++]);
            SpecialFunc.OutsideTemp = Double.parseDouble(retData[index++]);
            this.data.SpecialFunc = SpecialFunc;
        }
        catch (Exception e) {
            Log.e((String)"HeatingV2API", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    public int SetPollingMode(byte ChangePollingMode, byte RoomIndex) {
        int ret;
        if (ChangePollingMode != 2 && ChangePollingMode != 3 && ChangePollingMode != 4 && ChangePollingMode != 5) {
            return -300;
        }
        if (ChangePollingMode == 3 && (ret = this.CheckParamRoom(RoomIndex)) != 0) {
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetPollingMode", ChangePollingMode, RoomIndex, 0, 0, 0);
    }

    public int SetEachRoomTemp(byte RoomIndex, double SetTemp) {
        return this.SetEachRoomStatus(RoomIndex, DataClasses.HeatingV2.MODE.Idle, SetTemp);
    }

    public int SetEachRoomMode(byte RoomIndex, byte SetMode) {
        return this.SetEachRoomStatus(RoomIndex, SetMode, 0.0);
    }

    public int SetEachRoomStatus(byte RoomIndex, byte SetMode, double SetTemp) {
        int ret = this.CheckParamRoom(RoomIndex);
        if (ret != 0) {
            Log.w((String)"HeatingV2API", (String)("[SetEachRoomStatus] RoomIndex Out Of Range !!! (" + RoomIndex + ")"));
            return ret;
        }
        ret = this.CheckParamSetMode(SetMode);
        if (ret != 0) {
            Log.w((String)"HeatingV2API", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", SetMode) + ")"));
            return -300;
        }
        byte ByteTemp = 0;
        int Point = 0;
        if (SetTemp != 0.0) {
            ByteTemp = (byte)SetTemp;
            if (ByteTemp < this.data.Device.info.Support.MinSetTemp || ByteTemp > this.data.Device.info.Support.MaxSetTemp) {
                Log.w((String)"HeatingV2API", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! - (" + ByteTemp + ")"));
                return -300;
            }
            int n = Point = this.PointExist(SetTemp) ? 1 : 0;
            if (Point != 0 && !this.data.Device.info.Support.SetTempPoint05) {
                Log.w((String)"HeatingV2API", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", SetMode) + ")"));
                return -300;
            }
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetEachRoomStatus", RoomIndex, SetMode, ByteTemp, Point, 0);
    }

    public int SetAllRoomStatus(byte SetMode) {
        int ret = this.CheckParamSetMode(SetMode);
        if (ret != 0) {
            Log.w((String)"HeatingV2API", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", SetMode) + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAllRoomStatus", SetMode, 0, 0, 0, 0);
    }

    public int SetSleep(byte RoomIndex, byte SetTemp, byte SetTime) {
        if (!this.data.Device.info.Support.Sleep) {
            Log.w((String)"HeatingV2API", (String)"[SetSleep] Sleep No Support !!!");
            return -110;
        }
        int ret = this.CheckParamRoom(RoomIndex);
        if (ret != 0) {
            Log.w((String)"HeatingV2API", (String)("[SetSleep] RoomIndex Out Of Range !!! (" + RoomIndex + ")"));
            return ret;
        }
        if (SetTemp < 0 || SetTemp > 3) {
            Log.w((String)"HeatingV2API", (String)("[SetSleep] SetTemp Out Of Range !!! (" + String.format("0x%02X", SetTemp) + ")"));
            return -300;
        }
        if (SetTime < 0 || SetTime > 19) {
            Log.w((String)"HeatingV2API", (String)("[SetSleep] SetTime Out Of Range !!! (" + String.format("0x%02X", SetTime) + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetSleep", RoomIndex, SetTemp, SetTime, 0, 0);
    }

    public int SetReservation(byte RoomIndex, int Reservation) {
        if (!this.data.Device.info.Support.Reservation) {
            Log.w((String)"HeatingV2API", (String)"[SetSleep] Reservation No Support !!!");
            return -110;
        }
        int ret = this.CheckParamRoom(RoomIndex);
        if (ret != 0) {
            Log.w((String)"HeatingV2API", (String)("[SetSleep] RoomIndex Out Of Range !!! (" + RoomIndex + ")"));
            return ret;
        }
        byte[] ReserByte = new byte[]{0, 0, 0};
        ReserByte[0] = (byte)(Reservation >> 0 & 0xFF);
        ReserByte[1] = (byte)(Reservation >> 8 & 0xFF);
        ReserByte[2] = (byte)(Reservation >> 16 & 0xFF);
        return this.SendNReadCMD_int("SINKCTRL", "SetReservation", RoomIndex, ReserByte[0], ReserByte[1], ReserByte[2], 0);
    }

    public int SetBoiler(byte HeatingWaterTemp, byte HotWaterTemp) {
        if (!this.data.Device.info.Support.Boiler) {
            Log.w((String)"HeatingV2API", (String)"[SetSleep] Boiler No Support !!!");
            return -110;
        }
        if (HeatingWaterTemp == 0 && HotWaterTemp == 0) {
            Log.w((String)"HeatingV2API", (String)"[SetBoiler] HeatingWaterTemp & HotWaterTemp  is '0' Data !!!");
            return -300;
        }
        if (this.data.Boiler == null) {
            Log.w((String)"HeatingV2API", (String)"[SetSleep] data.Boiler is null !!!");
            int ret = this.Refresh((byte)101, true);
            Log.d((String)"HeatingV2API", (String)("[SetSleep] GetBoiler = " + ret));
            if (ret != 0) {
                return -110;
            }
        }
        if (HeatingWaterTemp != 0) {
            byte HeatingWaterTempMIN = this.data.Boiler.HeatingWater.MinSetTemp;
            byte HeatingWaterTempMAX = this.data.Boiler.HeatingWater.MaxSetTemp;
            if (HeatingWaterTemp < HeatingWaterTempMIN || HeatingWaterTemp > HeatingWaterTempMAX) {
                Log.w((String)"HeatingV2API", (String)("[SetBoiler] (HeatingWaterTemp) Request Param Out Of Range !!!" + String.format("0x%02X", HeatingWaterTemp)));
                return -300;
            }
        }
        if (HotWaterTemp != 0) {
            byte HotWaterTempMIN = this.data.Boiler.HotWater.MinSetTemp;
            byte HotWaterTempMAX = this.data.Boiler.HotWater.MaxSetTemp;
            if (HotWaterTemp < HotWaterTempMIN || HotWaterTemp > HotWaterTempMAX) {
                Log.w((String)"HeatingV2API", (String)("[SetBoiler] (HotWaterTemp) Request Param Out Of Range !!!" + String.format("0x%02X", HotWaterTemp)));
                return -300;
            }
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetBoiler", HeatingWaterTemp, HotWaterTemp, 0, 0, 0);
    }

    private int CheckParamRoom(byte RoomIndex) {
        byte RoomCount = this.data.Device.info.RoomCount;
        if (RoomCount <= 0) {
            return -110;
        }
        if (this.data.Device == null) {
            return -110;
        }
        if (this.data.Device.Room == null) {
            return -110;
        }
        if (this.data.Device.Room.length <= RoomIndex) {
            return -110;
        }
        return 0;
    }

    private int CheckParamSetMode(byte Mode) {
        if (!DataClasses.HeatingV2.MODE.CheckSetMode(Mode)) {
            return -300;
        }
        if (Mode == DataClasses.HeatingV2.MODE.Outing || Mode == DataClasses.HeatingV2.MODE.OutingRelease ? !this.data.Device.info.Support.Outing : (Mode == DataClasses.HeatingV2.MODE.Sleep ? !this.data.Device.info.Support.Sleep : (Mode == DataClasses.HeatingV2.MODE.Reservation ? !this.data.Device.info.Support.Reservation : (Mode == DataClasses.HeatingV2.MODE.Pause || Mode == DataClasses.HeatingV2.MODE.PauseRelease) && !this.data.Device.info.Support.Pause))) {
            return -300;
        }
        return 0;
    }

    private boolean PointExist(double n) {
        int IntValue;
        double FilterData = Double.parseDouble(String.format("%.1f", n));
        double Point = FilterData - (double)(IntValue = (int)FilterData);
        return Point >= 0.5;
    }

    public static class Data {
        public DataClasses.HeatingV2 Device = new DataClasses.HeatingV2();
        public DataClasses.HeatingV2.BoilerData Boiler = null;
        public DataClasses.HeatingV2.SpecialFuncData SpecialFunc = null;
    }

    public static final class POLLING_MODE {
        public static final byte Normal = 2;
        public static final byte FixRoom = 3;
        public static final byte Boiler = 4;
        public static final byte SpecialFunc = 5;
    }

    public static final class REFRESH_IDX {
        public static final byte ROOM1 = 0;
        public static final byte ROOM2 = 1;
        public static final byte ROOM3 = 2;
        public static final byte ROOM4 = 3;
        public static final byte ROOM5 = 4;
        public static final byte ROOM6 = 5;
        public static final byte ROOM7 = 6;
        public static final byte ROOM8 = 7;
        public static final byte ALL = -1;
        public static final byte INFO = 100;
        public static final byte BOILER = 101;
        public static final byte SPECIALFUNC = 102;
    }
}

