/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class GasAPI
extends WallPadDevAPI {
    private final String TAG = "GasAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"GasAPI", (String)s);
    }

    public GasAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("GasAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "GASVALVE";
        this.data = new Data();
    }

    public int Refresh(byte Index, boolean real) {
        String SubCMD;
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"GasAPI", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"GasAPI", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", Index, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        Log.d((String)"WALLPADAPI", (String)("DLockAPI getstate cmd ret : " + ret));
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 3) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.Device[Index].GasStatus = Byte.parseByte(retlist[index++]);
                this.data.Device[Index].Fault = Byte.parseByte(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"GasAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetClose(byte Index) {
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"GasAPI", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"GasAPI", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetClose", Index, 0, 0, 0, 0);
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                int DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.DeviceCnt = DeviceCount;
                    this.data.Device = new Data.Status[DeviceCount];
                    for (int i = 0; i < DeviceCount; ++i) {
                        this.data.Device[i] = new Data.Status();
                    }
                    return 0;
                }
                return -1;
            }
            catch (Exception e) {
                Log.e((String)"GasAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public Status[] Device = null;

        public static class Status {
            public byte GasStatus = GASSTATUS.Operation;
            public byte Fault = 0;

            public String ToDebugString() {
                String retStr = "==========================\r\nGasData\r\n==========================\r\nGasStatus : " + GASSTATUS.ToDebugString(this.GasStatus) + "\r\nFault     : " + String.format("0x%02X", this.Fault) + "\r\n==========================\r\n";
                return retStr;
            }
        }
    }

    public static class GASSTATUS {
        public static byte Close = 0;
        public static byte Open = 1;
        public static byte Operation = (byte)2;

        public static boolean CheckRange(byte nStatus) {
            if (nStatus == Close) {
                return true;
            }
            if (nStatus == Open) {
                return true;
            }
            return nStatus == Operation;
        }

        public static String ToDebugString(byte nStatus) {
            String retStr = nStatus == Close ? "Close" : (nStatus == Open ? "Open" : (nStatus == Operation ? "Operation" : "UnDefined"));
            return retStr;
        }
    }
}

