/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.homeautomation;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class HomeAutomation_Etc {
    private static final String TAG = "HomeAutomation_Etc";
    Context context;
    public static final String BR_ACTION_NAME = "HOME_AUTOMATION_ETC";
    public static final String BR_TYPE = "TYPE";
    public static final String BR_TYPE_PASSWORD = "TYPE_PASSWORD";
    public static final String BR_TYPE_REALMETER_YEAR = "TYPE_REALMETER_YEAR";
    public static final String BR_TYPE_REALMETER_MONTH = "TYPE_REALMETER_MONTH";
    public static final String BR_TYPE_REALMETER_ELECT = "TYPE_REALMETER_ELECT";
    public static final String BR_TYPE_REALMETER_GAS = "TYPE_REALMETER_GAS";
    public static final String BR_TYPE_REALMETER_WATER = "TYPE_REALMETER_WATER";
    public static final String BR_TYPE_REALMETER_HEATING = "TYPE_REALMETER_HEATING";
    public static final String BR_TYPE_REALMETER_HOTWATER = "TYPE_REALMETER_HOTWATER";
    public static final int TYPE_PASSWORD = 0;
    public static final int TYPE_REALMETER_REQUEST = 1;
    public static final int TYPE_REALMETER_REPLY = 2;

    public HomeAutomation_Etc(Context ctx) {
        this.context = ctx;
        Log.d((String)TAG, (String)"HomeAutomation_Emergency API Start");
    }

    public String BR_Parsing_Password(Intent intent) {
        String Password = intent.getStringExtra(BR_TYPE_PASSWORD);
        if (Password == null) {
            Log.e((String)TAG, (String)"BR_Parsing - Password is error : ");
            return null;
        }
        return Password;
    }

    public byte[] BR_Parsing_RealMeter_request(Intent intent) {
        byte[] RetByte = new byte[4];
        int Year = intent.getIntExtra(BR_TYPE_REALMETER_YEAR, -999);
        int Month = intent.getIntExtra(BR_TYPE_REALMETER_MONTH, -999);
        if (Year < 0) {
            Log.e((String)TAG, (String)("BR_Parsing_RealMeter_request - Year : " + Year));
            return null;
        }
        if (Month < 0) {
            Log.e((String)TAG, (String)("BR_Parsing_RealMeter_request - Month : " + Month));
            return null;
        }
        RetByte[0] = (byte)((Year -= 2000) / 10);
        RetByte[1] = (byte)(Year % 10);
        RetByte[2] = (byte)(Month / 10);
        RetByte[3] = (byte)(Month % 10);
        return RetByte;
    }

    public double[] BR_Parsing_RealMeter_reply(Intent intent) {
        double[] RetByte = new double[5];
        double elect = intent.getDoubleExtra(BR_TYPE_REALMETER_ELECT, -999.0);
        double gas = intent.getDoubleExtra(BR_TYPE_REALMETER_GAS, -999.0);
        double water = intent.getDoubleExtra(BR_TYPE_REALMETER_WATER, -999.0);
        double heating = intent.getDoubleExtra(BR_TYPE_REALMETER_HEATING, -999.0);
        double hotwater = intent.getDoubleExtra(BR_TYPE_REALMETER_HOTWATER, -999.0);
        if (elect < 0.0) {
            Log.e((String)TAG, (String)("BR_Parsing_RealMeter_reply - elect : " + elect));
            return null;
        }
        if (gas < 0.0) {
            Log.e((String)TAG, (String)("BR_Parsing_RealMeter_reply - gas : " + gas));
            return null;
        }
        if (water < 0.0) {
            Log.e((String)TAG, (String)("BR_Parsing_RealMeter_reply - water : " + water));
            return null;
        }
        if (heating < 0.0) {
            Log.e((String)TAG, (String)("BR_Parsing_RealMeter_reply - heating : " + heating));
            return null;
        }
        if (hotwater < 0.0) {
            Log.e((String)TAG, (String)("BR_Parsing_RealMeter_reply - hotwater : " + hotwater));
            return null;
        }
        RetByte[0] = elect;
        RetByte[1] = gas;
        RetByte[2] = water;
        RetByte[3] = heating;
        RetByte[4] = hotwater;
        return RetByte;
    }

    public boolean BR_Send_Password(String Password) {
        try {
            if (Password == null) {
                Log.e((String)TAG, (String)"BR_Send - Password is null");
                return false;
            }
            if (Password.length() != 4) {
                Log.e((String)TAG, (String)("BR_Send - Password length is error : " + Password));
                return false;
            }
            Intent iIntent = new Intent();
            iIntent.setAction(BR_ACTION_NAME);
            iIntent.putExtra(BR_TYPE, 0);
            iIntent.putExtra(BR_TYPE_PASSWORD, Password);
            this.context.sendBroadcast(iIntent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean BR_Send_RealMeterReqest(int Year, int Month) {
        try {
            if (Month < 1 || Month > 12) {
                Log.e((String)TAG, (String)("BR_Send_RealMeterReqest - Month : " + Month));
                return false;
            }
            Intent iIntent = new Intent();
            iIntent.setAction(BR_ACTION_NAME);
            iIntent.putExtra(BR_TYPE, 1);
            iIntent.putExtra(BR_TYPE_REALMETER_YEAR, Year);
            iIntent.putExtra(BR_TYPE_REALMETER_MONTH, Month);
            this.context.sendBroadcast(iIntent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean BR_Send_RealMeterReply(double[] DoubleArray) {
        try {
            if (DoubleArray == null) {
                return false;
            }
            if (DoubleArray.length != 5) {
                Log.e((String)TAG, (String)("BR_Send_RealMeterReply - FloatArray.length : " + DoubleArray.length));
                return false;
            }
            Intent iIntent = new Intent();
            iIntent.setAction(BR_ACTION_NAME);
            iIntent.putExtra(BR_TYPE, 2);
            iIntent.putExtra(BR_TYPE_REALMETER_ELECT, DoubleArray[0]);
            iIntent.putExtra(BR_TYPE_REALMETER_GAS, DoubleArray[1]);
            iIntent.putExtra(BR_TYPE_REALMETER_WATER, DoubleArray[2]);
            iIntent.putExtra(BR_TYPE_REALMETER_HEATING, DoubleArray[3]);
            iIntent.putExtra(BR_TYPE_REALMETER_HOTWATER, DoubleArray[4]);
            this.context.sendBroadcast(iIntent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

