/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.homeautomation;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.artncore.WallPadDataMgr.WallpadStatusData;
import java.util.List;

public class HomeAutomation_Call {
    private static final String TAG = "HomeAutomation_Call";
    Context context;
    public static final String BR_ACTION_NAME = "HOME_AUTOMATION_CALL";
    public static final String BR_ACTION_NAME_OPTION = "HOME_AUTOMATION_CALL_OPTION";
    public static final String BR_DEVICE = "DEVICE";
    public static final String BR_TYPE_CALL = "TYPE_CALL";
    public static final String BR_ID_DONG = "ID_DONG";
    public static final String BR_ID_HO = "ID_HO";
    public static final String BR_BLOCK_NEWCALL = "BLOCK_NEWCALL";
    public static final String BR_BLOCK_NEWCALL_RELEASESEC = "BLOCK_NEWCALL_RELEASESEC";
    public static final String APP_NAME_WALLPADDEVSERVICE = "WallPadDevService";
    public static final String APP_NAME_WALLPADCALL = "WallPadCall";
    public static final int DEVICE_NONE = 0;
    public static final int DEVICE_GUARD = 1;
    public static final int DEVICE_LOBBY = 2;
    public static final int DEVICE_NEIBOR = 3;
    public static final int CALLTYPE_NONE = 0;
    public static final int CALLTYPE_RECEIVE_CALL_REQUEST = 1;
    public static final int CALLTYPE_SEND_CALL_ACK = 2;
    public static final int CALLTYPE_SEND_CALL_ACK_FAIL = 3;
    public static final int CALLTYPE_SEND_CALL_START = 4;
    public static final int CALLTYPE_RECEIVE_CALL_END = 5;
    public static final int CALLTYPE_SEND_CALL_END = 6;
    public static final int CALLTYPE_SEND_CALL_REQUEST = 7;
    public static final int CALLTYPE_RECEIVE_CALL_ACK = 8;
    public static final int CALLTYPE_RECEIVE_CALL_ACK_FAIL = 9;
    public static final int CALLTYPE_RECEIVE_CALL_START = 10;
    public static final int CALLTYPE_SEND_DOOR_OPEN = 11;
    public static final int CALLTYPE_RECEIVE_DOOR_OPEN_ACK = 12;
    int m_nCallType = 0;
    String strWallPadAnalogCallPakageName = "kr.co.icontrols.wallpadcall";

    public HomeAutomation_Call(Context ctx) {
        this.context = ctx;
        Log.d((String)TAG, (String)"HomeAutomation_Call API Start");
    }

    public Call_Info BR_Parsing(Intent intent, String AppName) {
        int Dong;
        Log.e((String)TAG, (String)("[BR_Parsing] AppName : " + AppName));
        Call_Info call_info = null;
        int Device2 = intent.getIntExtra(BR_DEVICE, 0);
        if (Device2 < 0 || Device2 > 3) {
            Log.e((String)TAG, (String)("BR_Parsing - Device is error : " + Device2));
            return null;
        }
        int CallType = intent.getIntExtra(BR_TYPE_CALL, 0);
        if (CallType < 0 || 12 < CallType) {
            Log.e((String)TAG, (String)("BR_Parsing - CallType is error : " + CallType));
            return null;
        }
        if (AppName.equalsIgnoreCase(APP_NAME_WALLPADDEVSERVICE)) {
            switch (CallType) {
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("BR_Parsing - WallPadDevService - CallType is error : " + CallType));
                    return null;
                }
            }
        }
        if (AppName.equalsIgnoreCase(APP_NAME_WALLPADCALL)) {
            switch (CallType) {
                case 1: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 12: {
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("BR_Parsing - WallPadCall - CallType is error : " + CallType));
                    return null;
                }
            }
        }
        if ((Dong = intent.getIntExtra(BR_ID_DONG, -1)) < 0 || Dong > 9999) {
            Log.e((String)TAG, (String)("BR_Parsing - Dong is error : " + Dong));
            return null;
        }
        if (Device2 == 1 && Dong != 0) {
            Log.e((String)TAG, (String)("BR_Parsing - Dong is error : " + Dong + "(DEVICE_GUARD)"));
            return null;
        }
        int Ho = intent.getIntExtra(BR_ID_HO, -1);
        if (Ho < 0 || Ho > 9999) {
            Log.e((String)TAG, (String)("BR_Parsing - Ho is error : " + Ho));
            return null;
        }
        call_info = new Call_Info();
        call_info.Type_Device = Device2;
        call_info.Type_Call = CallType;
        call_info.ID_Dong = Dong;
        call_info.ID_Ho = Ho;
        Log.d((String)TAG, (String)("BR_Parsing - call_info.Type_Device : " + call_info.Type_Device));
        Log.d((String)TAG, (String)("BR_Parsing - call_info.Type_Call : " + call_info.Type_Call));
        Log.d((String)TAG, (String)("BR_Parsing - call_info.ID_Dong : " + call_info.ID_Dong));
        Log.d((String)TAG, (String)("BR_Parsing - call_info.ID_Ho : " + call_info.ID_Ho));
        return call_info;
    }

    public boolean BR_Send(int DeviceType, int CallType, int ID_Dong, int ID_Ho) {
        if (DeviceType < 0 || DeviceType > 3) {
            Log.e((String)TAG, (String)("BR_Send - DeviceType is error : " + DeviceType));
            return false;
        }
        if (CallType < 0 || CallType > 12) {
            Log.e((String)TAG, (String)("BR_Send - CallType is error : " + CallType));
            return false;
        }
        if (ID_Dong < 0 || ID_Dong > 9999) {
            Log.e((String)TAG, (String)("BR_Send - ID_Dong is error : " + ID_Dong));
            return false;
        }
        if (DeviceType == 1 && ID_Dong != 0) {
            Log.e((String)TAG, (String)("BR_Send - ID_Dong is error : " + ID_Dong + "(DEVICE_GUARD)"));
            return false;
        }
        if (ID_Ho < 0 || ID_Ho > 9999) {
            Log.e((String)TAG, (String)("BR_Send - ID_Dong is error : " + ID_Ho));
            return false;
        }
        Log.d((String)TAG, (String)("BR_Send - DeviceType : " + DeviceType));
        Log.d((String)TAG, (String)("BR_Send - CallType : " + CallType));
        Log.d((String)TAG, (String)("BR_Send - ID_Dong : " + ID_Dong));
        Log.d((String)TAG, (String)("BR_Send - ID_Ho : " + ID_Ho));
        this.sendCallBR(DeviceType, CallType, ID_Dong, ID_Ho);
        return true;
    }

    public void setCallStaus(int nStatus) {
        this.m_nCallType = nStatus;
        Log.d((String)TAG, (String)("BR_Send - CallType1 : " + this.m_nCallType));
    }

    public void sendCallBR(int nCallType, int nEventType, int nDong, int nHo) {
        try {
            Log.i((String)TAG, (String)("[sendCallBR] nCallType [" + nCallType + "], nEventType [" + nEventType + "], nDong [" + nDong + "], nHo [" + nHo + "]"));
            if (nEventType == 1) {
                this.receiveNewCall(nCallType, nEventType, nDong, nHo);
            } else {
                Intent mIntent = new Intent();
                mIntent.setAction(BR_ACTION_NAME);
                mIntent.putExtra(BR_DEVICE, nCallType);
                mIntent.putExtra(BR_TYPE_CALL, nEventType);
                mIntent.putExtra(BR_ID_DONG, nDong);
                mIntent.putExtra(BR_ID_HO, nHo);
                this.context.sendBroadcast(mIntent);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] sendCallBR(int nCallType, int nEventType, int nDong, int nHo)");
            e.printStackTrace();
        }
    }

    public void sendBlockCallFalg(boolean bBlock, int nAutoReleaseSec) {
        try {
            Log.i((String)TAG, (String)("[sendBlockCallFalg] bBlock [" + bBlock + "], nAutoReleaseSec [" + nAutoReleaseSec + "]"));
            Intent mIntent = new Intent();
            mIntent.setAction(BR_ACTION_NAME_OPTION);
            mIntent.putExtra(BR_BLOCK_NEWCALL, bBlock);
            mIntent.putExtra(BR_BLOCK_NEWCALL_RELEASESEC, nAutoReleaseSec);
            this.context.sendBroadcast(mIntent);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] sendBlockCallFalg(boolean bBlock, int nAutoReleaseSec)");
            e.printStackTrace();
        }
    }

    public void receiveNewCall(int nCallType, int nEventType, int nDong, int nHo) {
        try {
            Log.i((String)TAG, (String)("[receiveNewCall] nCallType [" + nCallType + "], nEventType [" + nEventType + "], nDong [" + nDong + "], nHo [" + nHo + "]], m_nCallType [" + this.m_nCallType + "]"));
            CALLEVENTTYPE eEventType = CALLEVENTTYPE.RECEIVE_CALL;
            CALLTYPE eCallType = CALLTYPE.NONE;
            if (nCallType == 2) {
                eCallType = CALLTYPE.LOBBY;
            } else if (nCallType == 1) {
                eCallType = CALLTYPE.GUARD;
            } else if (nCallType == 3) {
                eCallType = CALLTYPE.RESIDENCE;
            } else {
                Log.e((String)TAG, (String)"[receiveNewCall] SIPID is not correct!!!");
                return;
            }
            if (this.m_nCallType == 0) {
                Log.w((String)TAG, (String)"[runCallMainActivity] ########## START ##########");
                WallpadStatusData mWallpadStatusData = new WallpadStatusData(this.context);
                int nAlramStatus = mWallpadStatusData.GetAlarmStatus();
                mWallpadStatusData.closeDB();
                if (nAlramStatus != 3) {
                    this.sendBR_AppFinish(this.context);
                }
                this.sendDirectACKBR(nCallType, 2, nDong, nHo);
                ComponentName mComponentName = new ComponentName("kr.co.icontrols.wallpadcall", "kr.co.icontrols.wallpadcall.MainActivity");
                Intent mIntent = new Intent("android.intent.action.MAIN");
                mIntent.putExtra(CALLTRIGGER.CALLOWNER, CALLOWNER.NONE.toString());
                mIntent.putExtra(CALLTRIGGER.CALLEVENTTYPE, eEventType.toString());
                mIntent.putExtra(CALLTRIGGER.CALLTYPE, eCallType.toString());
                mIntent.putExtra(CALLTRIGGER.REMOTEINFO_DONG, nDong);
                mIntent.putExtra(CALLTRIGGER.REMOTEINFO_HO, nHo);
                mIntent.setFlags(0x10000000);
                mIntent.setComponent(mComponentName);
                this.context.startActivity(mIntent);
            } else {
                Log.w((String)TAG, (String)"[runCallMainActivity] wallpadcall is already running!!");
                Log.e((String)TAG, (String)"[runCallMainActivity] ############################## RUNNING ##############################");
                Intent mIntent = new Intent();
                mIntent.setAction(BR_ACTION_NAME);
                mIntent.putExtra(BR_DEVICE, nCallType);
                mIntent.putExtra(BR_TYPE_CALL, nEventType);
                mIntent.putExtra(BR_ID_DONG, nDong);
                mIntent.putExtra(BR_ID_HO, nHo);
                this.context.sendBroadcast(mIntent);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] runCallMainActivity()");
            e.printStackTrace();
        }
    }

    private boolean isCallAppRunning() {
        try {
            for (int i = 0; i < 5; ++i) {
                Log.w((String)TAG, (String)("[isCallAppRunning] Check Count [" + i + "]"));
                if (!this.getTopActivity().equals(this.strWallPadAnalogCallPakageName)) {
                    return true;
                }
                Thread.sleep(100L);
            }
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] isCallAppRunning()");
            e.printStackTrace();
            return false;
        }
    }

    private void sendDirectACKBR(int nCallType, int nEventType, int nDong, int nHo) {
        try {
            Log.i((String)TAG, (String)("[sendDirectACKBR] nCallType [" + nCallType + "], nEventType [" + nEventType + "], nDong [" + nDong + "], nHo [" + nHo + "]"));
            Intent mIntent = new Intent();
            mIntent.setAction(BR_ACTION_NAME);
            mIntent.putExtra(BR_DEVICE, nCallType);
            mIntent.putExtra(BR_TYPE_CALL, nEventType);
            mIntent.putExtra(BR_ID_DONG, nDong);
            mIntent.putExtra(BR_ID_HO, nHo);
            this.context.sendBroadcast(mIntent);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] sendDirectACKBR(int nCallType, int nEventType, int nDong, int nHo)");
            e.printStackTrace();
        }
    }

    private String getTopActivity() {
        try {
            ActivityManager mActivityManager = (ActivityManager)this.context.getSystemService("activity");
            List mTaskInfo = mActivityManager.getRunningTasks(1);
            Log.i((String)TAG, (String)("[getTopActivity] getClassName = " + ((ActivityManager.RunningTaskInfo)mTaskInfo.get((int)0)).topActivity.getClassName()));
            ComponentName mComponentName = ((ActivityManager.RunningTaskInfo)mTaskInfo.get((int)0)).topActivity;
            Log.i((String)TAG, (String)("[getTopActivity] getPackageName = " + mComponentName.getPackageName()));
            return mComponentName.getPackageName();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] getTopActivity()");
            e.printStackTrace();
            return null;
        }
    }

    private void sendBR_AppFinish(Context context) {
        try {
            Log.w((String)TAG, (String)"[sendBR_AppFinish] Send App Finish!!");
            Intent mIntent = new Intent();
            mIntent.setAction("kr.co.icontrols.wallpad.BR_APP_FINISH");
            context.sendBroadcast(mIntent);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] sendBR_AppFinish(Context context)");
            e.printStackTrace();
        }
    }

    public static enum CALLOWNER {
        NONE,
        WALLPAD,
        SUB_WALLPAD,
        KITCHEN_TV,
        BATH_PHONE,
        BATH_TV,
        UNIVERSAL_DEVICE,
        ERROR;


        public static CALLOWNER getCALLOWNER(String value) {
            try {
                if (value.equals(NONE.toString())) {
                    return NONE;
                }
                if (value.equals(WALLPAD.toString())) {
                    return WALLPAD;
                }
                if (value.equals(SUB_WALLPAD.toString())) {
                    return SUB_WALLPAD;
                }
                if (value.equals(KITCHEN_TV.toString())) {
                    return KITCHEN_TV;
                }
                if (value.equals(BATH_PHONE.toString())) {
                    return BATH_PHONE;
                }
                if (value.equals(BATH_TV.toString())) {
                    return BATH_TV;
                }
                if (value.equals(UNIVERSAL_DEVICE.toString())) {
                    return UNIVERSAL_DEVICE;
                }
                if (value.equals(ERROR.toString())) {
                    return ERROR;
                }
                return null;
            }
            catch (Exception e) {
                Log.e((String)HomeAutomation_Call.TAG, (String)"[Exception] getCALLOWNER()");
                e.printStackTrace();
                return null;
            }
        }
    }

    public static enum CALLEVENTTYPE {
        RECEIVE_CALL,
        TRYING_CALL,
        RECEIVE_CALL_2ND,
        RECEIVE_CALL_ACK,
        REQUEST_FRONT_MONITORING,
        CONNECT_CALL,
        TERMINATE_CALL,
        CANCEL_CALL,
        CANCEL_CALL_2ND,
        REJECT_CALL,
        REJECT_BUSY_CALL,
        FORWARD_CALL,
        CALLERID,
        TIMEOUT_1STCALL,
        TIMEOUT_2NDCALL,
        TIMEOUT_3RDCALL,
        MOIP_VIDEO_SET,
        DOOR_OPEN,
        PSTN_RING,
        PSTN_DTMF,
        NONE;


        public static CALLEVENTTYPE getCALLEVENTTYPE(String value) {
            try {
                if (value.equals(RECEIVE_CALL.toString())) {
                    return RECEIVE_CALL;
                }
                if (value.equals(TRYING_CALL.toString())) {
                    return TRYING_CALL;
                }
                if (value.equals(RECEIVE_CALL_2ND.toString())) {
                    return RECEIVE_CALL_2ND;
                }
                if (value.equals(RECEIVE_CALL_ACK.toString())) {
                    return RECEIVE_CALL_ACK;
                }
                if (value.equals(REQUEST_FRONT_MONITORING.toString())) {
                    return REQUEST_FRONT_MONITORING;
                }
                if (value.equals(CONNECT_CALL.toString())) {
                    return CONNECT_CALL;
                }
                if (value.equals(TERMINATE_CALL.toString())) {
                    return TERMINATE_CALL;
                }
                if (value.equals(CANCEL_CALL.toString())) {
                    return CANCEL_CALL;
                }
                if (value.equals(REJECT_CALL.toString())) {
                    return REJECT_CALL;
                }
                if (value.equals(REJECT_BUSY_CALL.toString())) {
                    return REJECT_BUSY_CALL;
                }
                if (value.equals(FORWARD_CALL.toString())) {
                    return FORWARD_CALL;
                }
                if (value.equals(CALLERID.toString())) {
                    return CALLERID;
                }
                if (value.equals(TIMEOUT_1STCALL.toString())) {
                    return TIMEOUT_1STCALL;
                }
                if (value.equals(TIMEOUT_2NDCALL.toString())) {
                    return TIMEOUT_2NDCALL;
                }
                if (value.equals(TIMEOUT_3RDCALL.toString())) {
                    return TIMEOUT_3RDCALL;
                }
                if (value.equals(MOIP_VIDEO_SET.toString())) {
                    return MOIP_VIDEO_SET;
                }
                if (value.equals(DOOR_OPEN.toString())) {
                    return DOOR_OPEN;
                }
                if (value.equals(PSTN_RING.toString())) {
                    return PSTN_RING;
                }
                if (value.equals(PSTN_DTMF.toString())) {
                    return PSTN_DTMF;
                }
                if (value.equals(NONE.toString())) {
                    return NONE;
                }
                return null;
            }
            catch (Exception e) {
                Log.e((String)HomeAutomation_Call.TAG, (String)"[Exception] getCALLEVENTTYPE()");
                e.printStackTrace();
                return null;
            }
        }
    }

    public static enum CALLTYPE {
        NONE,
        FRONT,
        RESIDENCE,
        LOBBY,
        GUARD,
        PSTN,
        IHUB,
        HISTORY_CALL,
        HISTORY_VISITORPIC,
        ERROR;


        public static CALLTYPE getCALLTYPE(String value) {
            try {
                if (value.equals(NONE.toString())) {
                    return NONE;
                }
                if (value.equals(FRONT.toString())) {
                    return FRONT;
                }
                if (value.equals(RESIDENCE.toString())) {
                    return RESIDENCE;
                }
                if (value.equals(LOBBY.toString())) {
                    return LOBBY;
                }
                if (value.equals(GUARD.toString())) {
                    return GUARD;
                }
                if (value.equals(PSTN.toString())) {
                    return PSTN;
                }
                if (value.equals(IHUB.toString())) {
                    return IHUB;
                }
                if (value.equals(HISTORY_CALL.toString())) {
                    return HISTORY_CALL;
                }
                if (value.equals(HISTORY_VISITORPIC.toString())) {
                    return HISTORY_VISITORPIC;
                }
                if (value.equals(ERROR.toString())) {
                    return ERROR;
                }
                return null;
            }
            catch (Exception e) {
                Log.e((String)HomeAutomation_Call.TAG, (String)"[Exception] getCALLTYPE()");
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class CALLTRIGGER {
        public static String CALLOWNER = "CALLOWNER";
        public static String CALLEVENTTYPE = "CALLEVENTTYPE";
        public static String CALLTYPE = "CALLTYPE";
        public static String REMOTEINFO = "REMOTEINFO";
        public static String REMOTEINFO_DONG = "REMOTEINFO_DONG";
        public static String REMOTEINFO_HO = "REMOTEINFO_HO";

        public static enum TYPE {
            MENU,
            FRONT,
            LOBBY,
            GUARD,
            RESIDENCE,
            PSTN;

        }

        public static enum SOURCE {
            USER,
            CALL_RECEIVE,
            SUBPHONE;

        }
    }

    public class Call_Info {
        public int Type_Device = 0;
        public int Type_Call = 0;
        public int ID_Dong = 0;
        public int ID_Ho = 0;
    }
}

