/*
 * Decompiled with CFR 0.152.
 */
package co.kr.cctv;

import android.app.Activity;
import android.os.AsyncTask;
import co.kr.cctv.CctvPlayerEventListener;
import co.kr.cctv.CctvPlayerException;
import co.kr.cctv.FFMpegView;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class CctvPlayer {
    private FFMpegView rtspPlayer;
    private Activity activity;
    private RtspStream rtspStream;
    private CctvPlayerEventListener cctvPlayerEventListener;
    final String libVer = "v1.1.1024";
    private String streamUrl;
    public static final String svcNameGetCctvViewerInfo = "get_cctv_viewerinfo";
    private final String reqXmlGetCctvViewerInfo = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<imap ver=\"1.0\" address=\"${address}\" sender=\"Mobile\">\n\t<service type=\"request\" name=\"get_cctv_viewerinfo\" result=\"ok\" />\n</imap>";

    public String getVersion() {
        return "lib v1.1.1024/" + this.rtspPlayer.getJniVersion();
    }

    public CctvPlayer(Activity activity, FFMpegView rtspView, CctvPlayerEventListener listener) {
        this.activity = activity;
        this.rtspPlayer = rtspView;
        this.rtspPlayer.setCctvEventListener(listener);
        this.cctvPlayerEventListener = listener;
    }

    public void resume() {
        this.play(this.streamUrl);
    }

    public void stop() {
        this.rtspPlayer.close();
        this.streamUrl = null;
    }

    public void play(String url) {
        if (url == null || url.length() < 9) {
            return;
        }
        this.streamUrl = url;
        new RtspStream().execute(new String[]{this.streamUrl});
    }

    public void getCctvViewerInfo(String ipaddr, int port, int soTimeout) {
        new SockStream().execute(new String[]{ipaddr, Integer.toString(port), Integer.toString(soTimeout)});
    }

    public void clearXmlElements(ArrayList<HashMap<String, String>> arrayList) {
        if (arrayList != null) {
            int i = 0;
            while (i < arrayList.size()) {
                arrayList.get(i).clear();
                ++i;
            }
            arrayList.clear();
        }
    }

    private class RtspStream
    extends AsyncTask<String, Integer, Boolean> {
        CctvPlayerException exception = null;

        private RtspStream() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            try {
                this.exception = null;
                CctvPlayer.this.rtspPlayer.stopPlayback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected Boolean doInBackground(String ... params) {
            try {
                int ffHandle = CctvPlayer.this.rtspPlayer.open(params[0]);
                if (ffHandle > 0 || ffHandle < -8) {
                    return true;
                }
                this.exception = new CctvPlayerException(ffHandle);
                return false;
            }
            catch (Throwable e) {
                this.exception = new CctvPlayerException(e);
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
            try {
                if (result.booleanValue()) {
                    CctvPlayer.this.rtspPlayer.startPlayback();
                    try {
                        CctvPlayer.this.cctvPlayerEventListener.onCctvPlayerPostPlay();
                    }
                    catch (Throwable throwable) {}
                } else if (this.exception != null) {
                    try {
                        CctvPlayer.this.cctvPlayerEventListener.onCctvPlayerException(this.exception);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class SockStream
    extends AsyncTask<String, Integer, Boolean> {
        CctvPlayerException exception = null;
        Socket socket = null;
        ArrayList<HashMap<String, String>> arrayList = null;

        private SockStream() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                CctvPlayer.this.clearXmlElements(this.arrayList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected Boolean doInBackground(String ... params) {
            BufferedWriter bw = null;
            try {
                this.socket = new Socket(params[0], Integer.parseInt(params[1]));
                if (Integer.parseInt(params[2]) > 0) {
                    this.socket.setSoTimeout(Integer.parseInt(params[2]));
                }
                bw = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                String req = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<imap ver=\"1.0\" address=\"${address}\" sender=\"Mobile\">\n\t<service type=\"request\" name=\"get_cctv_viewerinfo\" result=\"ok\" />\n</imap>".replace("${address}", this.socket.getLocalSocketAddress().toString());
                bw.write(req);
                bw.flush();
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                XmlPullParser parser = factory.newPullParser();
                parser.setInput(this.socket.getInputStream(), "EUC-KR");
                this.arrayList = new ArrayList();
                boolean requiredElement = false;
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    switch (eventType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            String tag = parser.getName();
                            if (tag.equals("service")) {
                                if (!(parser.getAttributeValue(null, "type").equals("reply") && parser.getAttributeValue(null, "name").equals(CctvPlayer.svcNameGetCctvViewerInfo) && parser.getAttributeValue(null, "result").equals("ok"))) {
                                    this.exception = new CctvPlayerException((Throwable)new XmlPullParserException("Invalid service element..."));
                                    Boolean bl = false;
                                    return bl;
                                }
                                requiredElement = true;
                                break;
                            }
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("element", tag);
                            int i = 0;
                            while (i < parser.getAttributeCount()) {
                                map.put(parser.getAttributeName(i), parser.getAttributeValue(i));
                                ++i;
                            }
                            this.arrayList.add(map);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    eventType = parser.next();
                }
                if (!requiredElement) {
                    this.exception = new CctvPlayerException((Throwable)new XmlPullParserException("Invalid XML format..."));
                    Boolean bl = false;
                    return bl;
                }
                Boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                this.exception = new CctvPlayerException(e);
                Boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (Throwable throwable) {}
                bw = null;
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Throwable throwable) {}
                this.socket = null;
            }
        }

        protected void onPostExecute(Boolean result) {
            try {
                if (result.booleanValue()) {
                    try {
                        CctvPlayer.this.cctvPlayerEventListener.onCctvPlayerPostRequest(this.arrayList);
                    }
                    catch (Throwable throwable) {}
                } else if (this.exception != null) {
                    try {
                        CctvPlayer.this.cctvPlayerEventListener.onCctvPlayerException(this.exception);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

