/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class LightAPI
extends WallPadDevAPI {
    private final String TAG = "LightAPI";
    private final boolean DEBUG_LOG_ON = true;
    public DataClasses.Light data;

    private void DebugLogOutput(String s) {
        Log.d((String)"LightAPI", (String)s);
    }

    public LightAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("LightAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "LIGHT";
        this.data = new DataClasses.Light();
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 11) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.LightCount = Integer.parseInt(retlist[index++]);
                this.data.OnOff[0] = Boolean.parseBoolean(retlist[index++]);
                this.data.OnOff[1] = Boolean.parseBoolean(retlist[index++]);
                this.data.OnOff[2] = Boolean.parseBoolean(retlist[index++]);
                this.data.OnOff[3] = Boolean.parseBoolean(retlist[index++]);
                this.data.OnOff[4] = Boolean.parseBoolean(retlist[index++]);
                this.data.OnOff[5] = Boolean.parseBoolean(retlist[index++]);
                this.data.OnOff[6] = Boolean.parseBoolean(retlist[index++]);
                this.data.OnOff[7] = Boolean.parseBoolean(retlist[index++]);
                this.data.Fault = Boolean.parseBoolean(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"LightAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetLightOnOff(byte LightNumber, boolean OnOff) {
        if (LightNumber > 8 && LightNumber != -1) {
            Log.w((String)"LightAPI", (String)("[SetLightOnOff] Param Out Of Range (LightNumber:" + LightNumber + " , LightCount:" + this.data.LightCount + ")"));
            return -1;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightOnOff", LightNumber, ByteOnOff, 0, 0, 0);
    }
}

