/*
 * Decompiled with CFR 0.152.
 */
package bssoft.stack.sip;

import bssoft.stack.sip.BSSVideo;
import bssoft.stack.sip.RFC2833;
import bssoft.stack.sip.SIPHeader;
import bssoft.stack.sip.SIPSdp;
import bssoft.stack.sip.SIPStack;
import bssoft.stack.sip.UPDATEHeaders;
import java.util.Date;
import java.util.StringTokenizer;

public class SIPCall {
    public String commandLine = null;
    public String viaH = null;
    public StringBuffer viaArray = new StringBuffer();
    public String routeH = null;
    public StringBuffer routeArray = new StringBuffer();
    public String recordrouteH = null;
    public StringBuffer recordrouteArray = new StringBuffer();
    public String maxforwardH = null;
    public String contactH = null;
    public String toH = null;
    public String fromH = null;
    public String callidH = null;
    public String cseqH = null;
    public String expiresH = null;
    public String allowH = null;
    public String useragentH = null;
    public String remoteuseragentH = null;
    public String contentlengthH = null;
    public String contenttypeH = null;
    public String authorizationINVITEH = null;
    public String authorizationCANCELH = null;
    public String authorizationBYEH = null;
    public String authorizationACKH = null;
    public String passertedidentityH = null;
    public String serverIp = null;
    public int serverPort = 5060;
    public String serverDomain = null;
    public String remoteIp = null;
    public int remotePort = 5060;
    public String remoteContactIp = null;
    public int remoteContactPort = 5060;
    public String routeIp = null;
    public int routePort = 5060;
    public String remoteContactUri = null;
    public String localIp = null;
    public int localPort = 5060;
    public String id = null;
    public String cid = null;
    public String authid = null;
    public String authpassword = null;
    public String fromTag = null;
    public String toTag = null;
    public String fromHeaderValue = null;
    public String toHeaderValue = null;
    public String callId = null;
    public String dnis = null;
    public String viaBranch = null;
    public int CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE;
    public int INVITE_CSEQ = 0;
    public int CANCEL_CSEQ = 0;
    public int ACK_CSEQ = 0;
    public int BYE_CSEQ = 0;
    public int callDirection = SIPStack.SIP_CALLDIRECTION_NONE;
    public int responseCode = 0;
    public int callState = 0;
    public int callMode = SIPStack.SIP_CALLMODE_NONE;
    public Date callTime_TI = null;
    public Date callTime_T0 = null;
    public Date callTime_T00 = null;
    public int invitingTimes = 0;
    public Date callTime_T1 = null;
    public Date callTime_T2 = null;
    public Date callTime_T3 = null;
    public Date callTime_T4 = null;
    public Date callTime_T40 = null;
    public Date callTime_T5 = null;
    public Date callTime_T6 = null;
    public Date callTime_T7 = null;
    public Date callTime_T8 = null;
    public Date callTime_T9 = null;
    public int expiresTI = 0;
    public int expiresT0 = 0;
    public int expiresT00 = 0;
    public int expiresT1 = 0;
    public int expiresT2 = 0;
    public int expiresT3 = 0;
    public int expiresT4 = 0;
    public int expiresT5 = 0;
    public int expiresT6 = 0;
    public int expiresT7 = 0;
    public int expiresT8 = 0;
    public int expiresT9 = 0;
    public SIPSdp sdp = null;
    public SIPSdp remoteSdp = null;
    public String message = null;
    public boolean flag;
    public UPDATEHeaders updateHeaders = null;
    public boolean bHolding = false;
    public boolean bPending = false;
    public boolean bDtmfdetected = false;
    public int detectedDtmf = 0;
    public int dtmfDuration = 0;
    public boolean bCancelRequest = false;
    public boolean bRejectRequest = false;
    public boolean bNewcallRequest = false;
    public boolean bUpdateRequest = false;
    public boolean bAsMaster = false;
    public boolean bForwardRequest = false;
    public boolean bByedisconnected = false;
    public String number = "";
    public String dong_number = "";
    public String ho_number = "";
    public boolean bDirectcall = false;
    public boolean bResponsebackgroundcall = false;
    public boolean bResponsebackgroundcallReady = false;
    public Date responsebackgroundcallTimer = new Date();
    public int hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
    public int hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;

    public SIPCall() {
        if (!SIPStack.bStackLicensed) {
            System.out.println("\ub77c\uc774\uc2a8\uc2a4\ud0a4\ub97c \uc124\uc815\ud558\uc138\uc694.");
            System.exit(0);
        }
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("call handle created.");
        }
        this.updateHeaders = new UPDATEHeaders();
        this.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE;
        this.callState = 0;
        this.callMode = SIPStack.SIP_CALLMODE_BASIC;
        this.callTime_TI = new Date();
        this.callTime_T0 = new Date();
        this.callTime_T00 = new Date();
        this.invitingTimes = 0;
        this.callTime_T1 = new Date();
        this.callTime_T2 = new Date();
        this.callTime_T3 = new Date();
        this.callTime_T4 = new Date();
        this.callTime_T40 = new Date();
        this.callTime_T5 = new Date();
        this.callTime_T6 = new Date();
        this.callTime_T7 = new Date();
        this.callTime_T8 = new Date();
        this.callTime_T9 = new Date();
        this.expiresTI = 0;
        this.expiresT0 = 0;
        this.expiresT00 = 0;
        this.expiresT1 = 0;
        this.expiresT2 = 0;
        this.expiresT3 = 0;
        this.expiresT4 = 0;
        this.expiresT5 = 0;
        this.expiresT6 = 0;
        this.expiresT7 = 0;
        this.expiresT8 = 0;
        this.expiresT9 = 0;
        this.sdp = null;
        this.remoteSdp = null;
        this.bHolding = false;
        this.bPending = false;
        this.bCancelRequest = false;
        this.bRejectRequest = false;
        this.bNewcallRequest = false;
        this.bUpdateRequest = false;
        this.bAsMaster = false;
        this.bForwardRequest = false;
        this.bByedisconnected = false;
        this.number = "";
        this.viaBranch = null;
        this.bResponsebackgroundcall = false;
        this.bResponsebackgroundcallReady = false;
        this.responsebackgroundcallTimer = new Date();
        this.callDirection = SIPStack.SIP_CALLDIRECTION_NONE;
        this.bDirectcall = SIPStack.bDirectCall;
        this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
        BSSVideo.bProgressvideooffer = false;
        BSSVideo.bCover = true;
        this.flag = false;
    }

    public SIPCall(boolean bPending) {
        if (!SIPStack.bStackLicensed) {
            System.out.println("\ub77c\uc774\uc2a8\uc2a4\ud0a4\ub97c \uc124\uc815\ud558\uc138\uc694.");
            System.exit(0);
        }
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("call handle created.");
        }
        this.updateHeaders = new UPDATEHeaders();
        this.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE;
        this.callState = 0;
        this.callMode = SIPStack.SIP_CALLMODE_BASIC;
        this.callTime_TI = new Date();
        this.callTime_T0 = new Date();
        this.callTime_T00 = new Date();
        this.invitingTimes = 0;
        this.callTime_T1 = new Date();
        this.callTime_T2 = new Date();
        this.callTime_T3 = new Date();
        this.callTime_T4 = new Date();
        this.callTime_T40 = new Date();
        this.callTime_T5 = new Date();
        this.callTime_T6 = new Date();
        this.callTime_T7 = new Date();
        this.callTime_T8 = new Date();
        this.callTime_T9 = new Date();
        this.expiresTI = 0;
        this.expiresT0 = 0;
        this.expiresT00 = 0;
        this.expiresT1 = 0;
        this.expiresT2 = 0;
        this.expiresT3 = 0;
        this.expiresT4 = 0;
        this.expiresT5 = 0;
        this.expiresT6 = 0;
        this.expiresT7 = 0;
        this.expiresT8 = 0;
        this.expiresT9 = 0;
        this.sdp = null;
        this.remoteSdp = null;
        this.bHolding = false;
        this.bCancelRequest = false;
        this.bRejectRequest = false;
        this.bNewcallRequest = false;
        this.bUpdateRequest = false;
        this.bAsMaster = false;
        this.bForwardRequest = false;
        this.bByedisconnected = false;
        this.bResponsebackgroundcall = false;
        this.bResponsebackgroundcallReady = false;
        this.responsebackgroundcallTimer = new Date();
        this.number = "";
        this.viaBranch = null;
        this.bDirectcall = SIPStack.bDirectCall;
        this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
        BSSVideo.bProgressvideooffer = false;
        BSSVideo.bCover = true;
        this.flag = false;
    }

    public void resetCall() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("call handle reset.");
            SIPStack.printAudioRtpPortInfo();
        }
        this.commandLine = null;
        this.viaH = null;
        this.viaArray = null;
        this.routeH = null;
        this.routeArray = null;
        this.recordrouteH = null;
        this.recordrouteArray = null;
        this.maxforwardH = null;
        this.contactH = null;
        this.toH = null;
        this.fromH = null;
        this.callidH = null;
        this.cseqH = null;
        this.expiresH = null;
        this.allowH = null;
        this.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
        this.remoteuseragentH = null;
        this.contentlengthH = null;
        this.contenttypeH = null;
        this.authorizationINVITEH = null;
        this.authorizationCANCELH = null;
        this.authorizationBYEH = null;
        this.authorizationACKH = null;
        this.passertedidentityH = null;
        this.serverIp = null;
        this.serverPort = 5060;
        this.serverDomain = null;
        this.remoteIp = null;
        this.remotePort = 5060;
        this.remoteContactIp = null;
        this.remoteContactPort = 5060;
        this.remoteContactUri = null;
        this.localIp = null;
        this.localPort = 5060;
        this.id = null;
        this.cid = null;
        this.authid = null;
        this.authpassword = null;
        this.fromTag = null;
        this.toTag = null;
        this.fromHeaderValue = null;
        this.toHeaderValue = null;
        this.callId = null;
        this.dnis = null;
        this.CSEQ_NUMBER = SIPStack.SIP_SEQUENCE_INVITE;
        this.callState = 0;
        this.callMode = SIPStack.SIP_CALLMODE_BASIC;
        this.callTime_TI = new Date();
        this.callTime_T0 = new Date();
        this.callTime_T00 = new Date();
        this.invitingTimes = 0;
        this.callTime_T1 = new Date();
        this.callTime_T2 = new Date();
        this.callTime_T3 = new Date();
        this.callTime_T4 = new Date();
        this.callTime_T40 = new Date();
        this.callTime_T5 = new Date();
        this.callTime_T6 = new Date();
        this.callTime_T7 = new Date();
        this.callTime_T8 = new Date();
        this.callTime_T9 = new Date();
        this.expiresTI = 0;
        this.expiresT0 = 0;
        this.expiresT00 = 0;
        this.expiresT1 = 0;
        this.expiresT2 = 0;
        this.expiresT3 = 0;
        this.expiresT4 = 0;
        this.expiresT5 = 0;
        this.expiresT6 = 0;
        this.expiresT7 = 0;
        this.expiresT8 = 0;
        this.expiresT9 = 0;
        if (this.sdp != null && this.sdp.flag && this.sdp.audioM != null) {
            SIPStack.freeAudioRtpPort(this.sdp.audioM.mediaPort);
        }
        this.sdp = null;
        this.remoteSdp = null;
        this.message = null;
        this.bHolding = false;
        this.bPending = false;
        this.bCancelRequest = false;
        this.bRejectRequest = false;
        this.bNewcallRequest = false;
        this.bUpdateRequest = false;
        this.bAsMaster = false;
        this.bForwardRequest = false;
        this.bByedisconnected = false;
        this.bResponsebackgroundcall = false;
        this.bResponsebackgroundcallReady = false;
        this.responsebackgroundcallTimer = new Date();
        this.number = "";
        this.viaBranch = null;
        this.callDirection = SIPStack.SIP_CALLDIRECTION_NONE;
        this.bDirectcall = SIPStack.bDirectCall;
        this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
        BSSVideo.bProgressvideooffer = false;
        BSSVideo.bCover = true;
        this.flag = false;
        SIPStack.exceptionCountAtCurrentCall = 0;
        System.gc();
    }

    public void initializeRedirectCall() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("redirect call handle initialize.");
        }
        this.viaH = null;
        this.viaArray = null;
        this.routeH = null;
        this.routeArray = null;
        this.recordrouteH = null;
        this.recordrouteArray = null;
        this.remoteContactIp = null;
        this.remoteContactPort = 5060;
        this.remoteContactUri = null;
        this.callId = null;
        this.authorizationINVITEH = null;
        this.authorizationCANCELH = null;
        this.authorizationBYEH = null;
        this.authorizationACKH = null;
        this.viaBranch = null;
        this.callState = 0;
        this.callMode = SIPStack.SIP_CALLMODE_BASIC;
        this.callTime_TI = new Date();
        this.callTime_T0 = new Date();
        this.callTime_T00 = new Date();
        this.invitingTimes = 0;
        this.callTime_T1 = new Date();
        this.callTime_T2 = new Date();
        this.callTime_T3 = new Date();
        this.callTime_T4 = new Date();
        this.callTime_T40 = new Date();
        this.callTime_T5 = new Date();
        this.callTime_T6 = new Date();
        this.callTime_T7 = new Date();
        this.callTime_T8 = new Date();
        this.callTime_T9 = new Date();
        this.expiresTI = 0;
        this.expiresT0 = 0;
        this.expiresT00 = 0;
        this.expiresT1 = 0;
        this.expiresT2 = 0;
        this.expiresT3 = 0;
        this.expiresT4 = 0;
        this.expiresT5 = 0;
        this.expiresT6 = 0;
        this.expiresT7 = 0;
        this.expiresT8 = 0;
        this.expiresT9 = 0;
        if (this.sdp != null && this.sdp.flag && this.sdp.audioM != null) {
            SIPStack.freeAudioRtpPort(this.sdp.audioM.mediaPort);
        }
        this.sdp = null;
        this.remoteSdp = null;
        this.message = null;
        this.bHolding = false;
        this.bPending = false;
        this.bCancelRequest = false;
        this.bRejectRequest = false;
        this.bNewcallRequest = false;
        this.bUpdateRequest = false;
        this.bAsMaster = false;
        this.bForwardRequest = false;
        this.bByedisconnected = false;
        this.bResponsebackgroundcall = false;
        this.bResponsebackgroundcallReady = false;
        this.responsebackgroundcallTimer = new Date();
        this.number = "";
        this.viaBranch = null;
        this.callDirection = SIPStack.SIP_CALLDIRECTION_NONE;
        this.bDirectcall = SIPStack.bDirectCall;
        this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
        BSSVideo.bProgressvideooffer = false;
        BSSVideo.bCover = true;
    }

    public boolean activeCallHandle(String id, String cid, String authid, String authpassword, String number, String serverIp, int serverPort, String serverDomain, String localIp, int localPort) {
        if (this.flag) {
            return false;
        }
        this.resetCall();
        this.flag = true;
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("call handle activated.");
        }
        this.id = id;
        this.cid = cid;
        this.authid = authid;
        this.authpassword = authpassword;
        this.dnis = number;
        this.serverIp = serverIp;
        this.serverPort = serverPort;
        this.serverDomain = serverDomain;
        this.remoteIp = serverIp;
        this.remotePort = serverPort;
        this.localIp = localIp;
        this.localPort = localPort;
        this.callTime_TI = new Date();
        this.callTime_T0 = new Date();
        this.callTime_T00 = new Date();
        this.invitingTimes = 0;
        this.callTime_T1 = new Date();
        this.callTime_T2 = new Date();
        this.callTime_T3 = new Date();
        this.callTime_T4 = new Date();
        this.callTime_T40 = new Date();
        this.callTime_T5 = new Date();
        this.callTime_T6 = new Date();
        this.callTime_T7 = new Date();
        this.callTime_T8 = new Date();
        this.callTime_T9 = new Date();
        this.expiresTI = 0;
        this.expiresT0 = 0;
        this.expiresT00 = 0;
        this.expiresT1 = 0;
        this.expiresT2 = 0;
        this.expiresT3 = 0;
        this.expiresT4 = 0;
        this.expiresT5 = 0;
        this.expiresT6 = 0;
        this.expiresT7 = 0;
        this.expiresT8 = 0;
        this.expiresT9 = 0;
        this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
        BSSVideo.bProgressvideooffer = false;
        BSSVideo.bCover = true;
        return true;
    }

    public boolean activePendingCallHandle(String id, String cid, String authid, String authpassword, String number, String serverIp, int serverPort, String serverDomain, String localIp, int localPort) {
        if (this.flag) {
            return false;
        }
        this.resetCall();
        this.flag = true;
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("conference call activated.");
        }
        this.id = id;
        this.cid = cid;
        this.authid = authid;
        this.authpassword = authpassword;
        this.dnis = number;
        this.serverIp = serverIp;
        this.serverPort = serverPort;
        this.serverDomain = serverDomain;
        this.remoteIp = serverIp;
        this.remotePort = serverPort;
        this.localIp = localIp;
        this.localPort = localPort;
        this.bPending = true;
        this.callTime_TI = new Date();
        this.callTime_T0 = new Date();
        this.callTime_T00 = new Date();
        this.invitingTimes = 0;
        this.callTime_T1 = new Date();
        this.callTime_T2 = new Date();
        this.callTime_T3 = new Date();
        this.callTime_T4 = new Date();
        this.callTime_T40 = new Date();
        this.callTime_T5 = new Date();
        this.callTime_T6 = new Date();
        this.callTime_T7 = new Date();
        this.callTime_T8 = new Date();
        this.callTime_T9 = new Date();
        this.expiresTI = 0;
        this.expiresT0 = 0;
        this.expiresT00 = 0;
        this.expiresT1 = 0;
        this.expiresT2 = 0;
        this.expiresT3 = 0;
        this.expiresT4 = 0;
        this.expiresT5 = 0;
        this.expiresT6 = 0;
        this.expiresT7 = 0;
        this.expiresT8 = 0;
        this.expiresT9 = 0;
        this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
        BSSVideo.bProgressvideooffer = false;
        BSSVideo.bCover = true;
        return true;
    }

    public boolean constructHeaders(String message, String remoteIp, int remotePort) {
        if (message == null || message.length() == 0) {
            return false;
        }
        this.viaH = null;
        this.viaArray = new StringBuffer();
        this.routeH = null;
        this.routeArray = new StringBuffer();
        this.recordrouteH = null;
        this.recordrouteArray = new StringBuffer();
        this.message = message;
        StringTokenizer tokenArray = new StringTokenizer(message, SIPStack.SIP_LINE_END, true);
        block0: while (tokenArray.hasMoreTokens()) {
            int iM;
            String token = tokenArray.nextToken().trim();
            if (token.length() <= 0 || token.compareTo("\r") == 0 || token.compareTo("\n") == 0) continue;
            if (token.startsWith("From: ")) {
                this.fromH = token;
                this.fromHeaderValue = token.substring(6);
                continue;
            }
            if (token.startsWith("f: ")) {
                this.fromH = token;
                this.fromHeaderValue = token.substring(3);
                continue;
            }
            if (token.startsWith("To: ")) {
                this.toH = token;
                if (this.toH.indexOf("tag=") < 0) {
                    this.toTag = "" + new Date().getTime();
                    this.toH = String.valueOf(token) + ";tag=" + this.toTag;
                    this.toHeaderValue = String.valueOf(token.substring(4)) + ";tag=" + this.toTag;
                    continue;
                }
                this.toHeaderValue = token.substring(4);
                continue;
            }
            if (token.startsWith("t: ")) {
                this.toH = token;
                if (this.toH.indexOf("tag=") < 0) {
                    this.toTag = "" + new Date().getTime();
                    this.toH = String.valueOf(token) + ";tag=" + this.toTag;
                    this.toHeaderValue = String.valueOf(token.substring(3)) + ";tag=" + this.toTag;
                    continue;
                }
                this.toHeaderValue = token.substring(3);
                continue;
            }
            if (token.startsWith("Via: ")) {
                if (this.viaH == null) {
                    this.viaH = token;
                    if (token.indexOf(";received=") < 0) {
                        String branch = "";
                        int index = token.indexOf(";branch=");
                        if (index > 0) {
                            branch = token.substring(index + 8);
                        }
                        this.viaBranch = branch != null && branch.length() > 0 ? ((index = branch.indexOf(";")) > 0 ? branch.substring(0, index) : branch) : "";
                        index = token.indexOf(";branch=");
                        this.viaH = index > 0 ? token.substring(0, index) : token;
                        index = this.viaH.indexOf(";rport=");
                        if (index > 0) {
                            this.viaH = this.viaH.substring(0, index);
                        }
                        this.viaH = String.valueOf(this.viaH) + ";received=" + remoteIp + ";rport=" + remotePort + ";branch=" + this.viaBranch;
                    }
                    this.viaArray.append(String.valueOf(this.viaH) + SIPStack.SIP_LINE_END);
                    continue;
                }
                this.viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (token.startsWith("v: ")) {
                if (this.viaH == null) {
                    this.viaH = token;
                    if (token.indexOf(";received=") < 0) {
                        String branch = "";
                        int index = token.indexOf(";branch=");
                        if (index > 0) {
                            branch = token.substring(index + 8);
                        }
                        this.viaBranch = branch != null && branch.length() > 0 ? ((index = branch.indexOf(";")) > 0 ? branch.substring(0, index) : branch) : branch;
                        index = token.indexOf(";branch=");
                        this.viaH = index > 0 ? token.substring(0, index) : token;
                        index = this.viaH.indexOf(";rport=");
                        if (index > 0) {
                            this.viaH = this.viaH.substring(0, index);
                        }
                        this.viaH = String.valueOf(this.viaH) + ";received=" + remoteIp + ";rport=" + remotePort + ";branch=" + this.viaBranch;
                    }
                    this.viaArray.append(String.valueOf(this.viaH) + SIPStack.SIP_LINE_END);
                    continue;
                }
                this.viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (token.startsWith("Record-Route: ")) {
                if (this.recordrouteH == null) {
                    this.routeH = null;
                    this.routeArray = new StringBuffer();
                    this.recordrouteH = token;
                    this.recordrouteArray.append(String.valueOf(this.recordrouteH) + SIPStack.SIP_LINE_END);
                    this.routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                    continue;
                }
                this.recordrouteArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                this.routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (token.startsWith("Contact: ")) {
                this.contactH = token;
                if (token.length() <= 0) continue;
                int iS = 0;
                iS = token.indexOf("sip:");
                if (iS <= 0) continue;
                String str = null;
                int iE = 0;
                iE = token.indexOf(">", iS);
                str = iE > 0 ? token.substring(iS, iE) : token.substring(iS);
                iE = str.indexOf(";");
                if (iE > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(";")) > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(" ")) > 0) {
                    str = str.substring(0, iE);
                }
                if (str.length() > 0) {
                    this.remoteContactUri = str;
                }
                if (str.length() <= 0) continue;
                iS = str.indexOf("@");
                iM = (str = iS > 0 ? str.substring(iS + 1) : str.substring(4)).indexOf(":", iS);
                if (iM < 0) {
                    this.remoteContactIp = str;
                    this.remoteContactPort = 5060;
                    continue;
                }
                this.remoteContactIp = str.substring(0, iM).trim();
                this.remoteContactPort = Integer.parseInt(str.substring(iM + 1).trim());
                continue;
            }
            if (token.startsWith("m: ")) {
                this.contactH = token;
                if (token.length() <= 0) continue;
                int iS = 0;
                iS = token.indexOf("sip:");
                if (iS <= 0) continue;
                String str = null;
                int iE = 0;
                iE = token.indexOf(">", iS);
                str = iE > 0 ? token.substring(iS, iE) : token.substring(iS);
                iE = str.indexOf(";");
                if (iE > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(";")) > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(" ")) > 0) {
                    str = str.substring(0, iE);
                }
                if (str.length() > 0) {
                    this.remoteContactUri = str;
                }
                if (str.length() <= 0) continue;
                iS = str.indexOf("@");
                iM = (str = iS > 0 ? str.substring(iS + 1) : str.substring(4)).indexOf(":", iS);
                if (iM < 0) {
                    this.remoteContactIp = str;
                    this.remoteContactPort = 5060;
                    continue;
                }
                this.remoteContactIp = str.substring(0, iM).trim();
                this.remoteContactPort = Integer.parseInt(str.substring(iM + 1).trim());
                continue;
            }
            if (token.startsWith("Call-ID: ")) {
                this.callidH = token;
                this.callId = token.substring(9).trim();
                if (this.callId.startsWith(BSSVideo.HNS_PREFIX_LOBBY)) {
                    this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_LOBBY;
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_GUARD)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_NEIGHBOR)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                    BSSVideo.bProgressvideooffer = false;
                    continue;
                }
                if (this.callId.startsWith(BSSVideo.HNS_PREFIX_GUARD)) {
                    this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_GUARD;
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_GUARD)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_LOBBY)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_LOBBY;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_NEIGHBOR)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                    BSSVideo.bProgressvideooffer = false;
                    continue;
                }
                if (this.callId.startsWith(BSSVideo.HNS_PREFIX_NEIGHBOR)) {
                    this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_GUARD)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_NEIGHBOR)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                        BSSVideo.bProgressvideooffer = false;
                        continue;
                    }
                    this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                    BSSVideo.bProgressvideooffer = false;
                    continue;
                }
                this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
                this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                BSSVideo.bProgressvideooffer = false;
                continue;
            }
            if (token.startsWith("i: ")) {
                this.callidH = token;
                this.callId = token.substring(3).trim();
                if (this.callId.startsWith(BSSVideo.HNS_PREFIX_LOBBY)) {
                    this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_LOBBY;
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_GUARD)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_NEIGHBOR)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                    BSSVideo.bProgressvideooffer = false;
                    continue;
                }
                if (this.callId.startsWith(BSSVideo.HNS_PREFIX_GUARD)) {
                    this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_GUARD;
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_GUARD)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_LOBBY)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_LOBBY;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_NEIGHBOR)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                    BSSVideo.bProgressvideooffer = false;
                    continue;
                }
                if (this.callId.startsWith(BSSVideo.HNS_PREFIX_NEIGHBOR)) {
                    this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_GUARD)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_GUARD;
                        BSSVideo.bProgressvideooffer = true;
                        continue;
                    }
                    if (this.callId.endsWith(BSSVideo.HNS_POSTFIX_NEIGHBOR)) {
                        this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NEIGHBOR;
                        BSSVideo.bProgressvideooffer = false;
                        continue;
                    }
                    this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                    BSSVideo.bProgressvideooffer = false;
                    continue;
                }
                this.hnsOriginatorServiceType = BSSVideo.HNS_SERVICE_NONE;
                this.hnsReceiverServiceType = BSSVideo.HNS_SERVICE_NONE;
                BSSVideo.bProgressvideooffer = false;
                continue;
            }
            if (token.startsWith("CSeq: ")) {
                this.cseqH = token;
                StringTokenizer fieldArray = new StringTokenizer(token, " ", true);
                int tokenCount = 0;
                while (fieldArray.hasMoreTokens()) {
                    String fieldtoken = fieldArray.nextToken();
                    if (fieldtoken.length() <= 0 || fieldtoken.compareTo(" ") == 0 || ++tokenCount != 2) continue;
                    this.CSEQ_NUMBER = Integer.parseInt(fieldtoken);
                    continue block0;
                }
                continue;
            }
            if (token.startsWith("Content-Type: ")) {
                this.contenttypeH = token;
                continue;
            }
            if (token.startsWith("c: ")) {
                this.contenttypeH = token;
                continue;
            }
            if (token.startsWith("Content-Length: ")) {
                this.contentlengthH = token;
                continue;
            }
            if (token.startsWith("l: ")) {
                this.contentlengthH = token;
                continue;
            }
            if (token.startsWith("User-Agent: ")) {
                this.remoteuseragentH = token;
                this.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
                continue;
            }
            if (!token.startsWith("P-Asserted-Identity: ")) continue;
            this.passertedidentityH = token;
        }
        this.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
        this.maxforwardH = "Max-Forwards: 70";
        int audioport = SIPStack.getFreeAudioRtpPort();
        if (audioport > 0) {
            this.constructSdp();
        }
        if (this.sdp != null && this.sdp.flag) {
            this.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
            if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
            } else {
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
            }
            this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
            this.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
        }
        if (this.parseRemoteSdp(message) && this.remoteSdp != null && this.remoteSdp.flag && this.remoteSdp.audioM != null && this.sdp != null && this.sdp.flag && this.sdp.audioM != null && this.remoteSdp.audioM.flow != null && this.remoteSdp.audioM.flow.length() > 0) {
            if (this.remoteSdp.audioM.flow.compareTo("sendrecv") == 0) {
                this.sdp.audioM.setFlow("sendrecv");
            } else if (this.remoteSdp.audioM.flow.compareTo("sendonly") == 0) {
                this.sdp.audioM.setFlow("recvonly");
            } else if (this.remoteSdp.audioM.flow.compareTo("recvonly") == 0) {
                this.sdp.audioM.setFlow("sendonly");
            }
        }
        this.negotiateAudioCodec();
        return true;
    }

    public boolean constructUPDATEHeaders(String message, String remoteIp, int remotePort) {
        if (message == null || message.length() == 0) {
            return false;
        }
        this.resetUpdateheaders();
        this.setUpdateheaders();
        this.viaH = null;
        this.viaArray = new StringBuffer();
        this.routeH = null;
        this.routeArray = new StringBuffer();
        this.recordrouteH = null;
        this.recordrouteArray = new StringBuffer();
        this.message = message;
        StringTokenizer tokenArray = new StringTokenizer(message, SIPStack.SIP_LINE_END, true);
        block0: while (tokenArray.hasMoreTokens()) {
            int iM;
            String token = tokenArray.nextToken().trim();
            if (token.length() <= 0 || token.compareTo("\r") == 0 || token.compareTo("\n") == 0) continue;
            if (token.startsWith("From: ")) {
                this.fromH = token;
                int iS = this.fromH.indexOf(";tag=");
                if (iS > 0) {
                    String str = null;
                    int iE = this.fromH.indexOf(";", iS + 5);
                    str = iE >= 0 ? (iE > iS + 5 ? this.fromH.substring(iS + 5, iE) : "") : this.fromH.substring(iS + 5);
                    if (str != null && str.length() > 0) {
                        this.fromTag = str.trim();
                    }
                }
                this.fromHeaderValue = token.substring(6);
                System.out.println("FROM TAG:" + this.fromTag);
                continue;
            }
            if (token.startsWith("f: ")) {
                this.fromH = token;
                int iS = this.fromH.indexOf(";tag=");
                if (iS > 0) {
                    String str = null;
                    int iE = this.fromH.indexOf(";", iS + 5);
                    str = iE >= 0 ? (iE > iS + 5 ? this.fromH.substring(iS + 5, iE) : "") : this.fromH.substring(iS + 5);
                    if (str != null && str.length() > 0) {
                        this.fromTag = str.trim();
                    }
                }
                this.fromHeaderValue = token.substring(3);
                System.out.println("FROM TAG:" + this.fromTag);
                continue;
            }
            if (token.startsWith("To: ")) {
                this.toH = token;
                int iS = this.toH.indexOf(";tag=");
                if (iS > 0) {
                    String str = null;
                    int iE = this.toH.indexOf(";", iS + 5);
                    str = iE >= 0 ? (iE > iS + 5 ? this.toH.substring(iS + 5, iE) : "") : this.toH.substring(iS + 5);
                    if (str != null && str.length() > 0) {
                        this.toTag = str.trim();
                    }
                }
                this.toHeaderValue = token.substring(4);
                System.out.println("TO TAG:" + this.toTag);
                continue;
            }
            if (token.startsWith("To: ")) {
                this.toH = token;
                int iS = this.toH.indexOf(";tag=");
                if (iS > 0) {
                    String str = null;
                    int iE = this.toH.indexOf(";", iS + 5);
                    str = iE >= 0 ? (iE > iS + 5 ? this.toH.substring(iS + 5, iE) : "") : this.toH.substring(iS + 5);
                    if (str != null && str.length() > 0) {
                        this.toTag = str.trim();
                    }
                }
                this.toHeaderValue = token.substring(3);
                System.out.println("TO TAG:" + this.toTag);
                continue;
            }
            if (token.startsWith("Via: ")) {
                if (this.viaH == null) {
                    this.viaH = token;
                    if (token.indexOf(";received=") < 0) {
                        String branch = "";
                        int index = token.indexOf(";branch=");
                        if (index > 0) {
                            branch = token.substring(index + 8);
                        }
                        this.viaBranch = branch != null && branch.length() > 0 ? ((index = branch.indexOf(";")) > 0 ? branch.substring(0, index) : branch) : "";
                        index = token.indexOf(";branch=");
                        this.viaH = index > 0 ? token.substring(0, index) : token;
                        index = this.viaH.indexOf(";rport=");
                        if (index > 0) {
                            this.viaH = this.viaH.substring(0, index);
                        }
                        this.viaH = String.valueOf(this.viaH) + ";received=" + remoteIp + ";rport=" + remotePort + ";branch=" + this.viaBranch;
                    }
                    this.viaArray.append(String.valueOf(this.viaH) + SIPStack.SIP_LINE_END);
                    continue;
                }
                this.viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (token.startsWith("v: ")) {
                if (this.viaH == null) {
                    this.viaH = token;
                    if (token.indexOf(";received=") < 0) {
                        String branch = "";
                        int index = token.indexOf(";branch=");
                        if (index > 0) {
                            branch = token.substring(index + 8);
                        }
                        this.viaBranch = branch != null && branch.length() > 0 ? ((index = branch.indexOf(";")) > 0 ? branch.substring(0, index) : branch) : branch;
                        index = token.indexOf(";branch=");
                        this.viaH = index > 0 ? token.substring(0, index) : token;
                        index = this.viaH.indexOf(";rport=");
                        if (index > 0) {
                            this.viaH = this.viaH.substring(0, index);
                        }
                        this.viaH = String.valueOf(this.viaH) + ";received=" + remoteIp + ";rport=" + remotePort + ";branch=" + this.viaBranch;
                    }
                    this.viaArray.append(String.valueOf(this.viaH) + SIPStack.SIP_LINE_END);
                    continue;
                }
                this.viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (token.startsWith("Record-Route: ")) {
                if (this.recordrouteH == null) {
                    this.routeH = null;
                    this.routeArray = new StringBuffer();
                    this.recordrouteH = token;
                    this.recordrouteArray.append(String.valueOf(this.recordrouteH) + SIPStack.SIP_LINE_END);
                    this.routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                    continue;
                }
                this.recordrouteArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                this.routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (token.startsWith("Contact: ")) {
                this.contactH = token;
                if (token.length() <= 0) continue;
                int iS = 0;
                iS = token.indexOf("sip:");
                if (iS <= 0) continue;
                String str = null;
                int iE = 0;
                iE = token.indexOf(">", iS);
                str = iE > 0 ? token.substring(iS, iE) : token.substring(iS);
                iE = str.indexOf(";");
                if (iE > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(";")) > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(" ")) > 0) {
                    str = str.substring(0, iE);
                }
                if (str.length() > 0) {
                    this.remoteContactUri = str;
                }
                if (str.length() <= 0) continue;
                iS = str.indexOf("@");
                iM = (str = iS > 0 ? str.substring(iS + 1) : str.substring(4)).indexOf(":", iS);
                if (iM < 0) {
                    this.remoteContactIp = str;
                    this.remoteContactPort = 5060;
                    continue;
                }
                this.remoteContactIp = str.substring(0, iM).trim();
                this.remoteContactPort = Integer.parseInt(str.substring(iM + 1).trim());
                continue;
            }
            if (token.startsWith("m: ")) {
                this.contactH = token;
                if (token.length() <= 0) continue;
                int iS = 0;
                iS = token.indexOf("sip:");
                if (iS <= 0) continue;
                String str = null;
                int iE = 0;
                iE = token.indexOf(">", iS);
                str = iE > 0 ? token.substring(iS, iE) : token.substring(iS);
                iE = str.indexOf(";");
                if (iE > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(";")) > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(" ")) > 0) {
                    str = str.substring(0, iE);
                }
                if (str.length() > 0) {
                    this.remoteContactUri = str;
                }
                if (str.length() <= 0) continue;
                iS = str.indexOf("@");
                iM = (str = iS > 0 ? str.substring(iS + 1) : str.substring(4)).indexOf(":", iS);
                if (iM < 0) {
                    this.remoteContactIp = str;
                    this.remoteContactPort = 5060;
                    continue;
                }
                this.remoteContactIp = str.substring(0, iM).trim();
                this.remoteContactPort = Integer.parseInt(str.substring(iM + 1).trim());
                continue;
            }
            if (token.startsWith("Call-ID: ")) {
                this.callidH = token;
                this.callId = token.substring(9).trim();
                continue;
            }
            if (token.startsWith("i: ")) {
                this.callidH = token;
                this.callId = token.substring(3).trim();
                continue;
            }
            if (token.startsWith("CSeq: ")) {
                this.cseqH = token;
                StringTokenizer fieldArray = new StringTokenizer(token, " ", true);
                int tokenCount = 0;
                while (fieldArray.hasMoreTokens()) {
                    String fieldtoken = fieldArray.nextToken();
                    if (fieldtoken.length() <= 0 || fieldtoken.compareTo(" ") == 0 || ++tokenCount != 2) continue;
                    this.CSEQ_NUMBER = Integer.parseInt(fieldtoken);
                    continue block0;
                }
                continue;
            }
            if (token.startsWith("Content-Type: ")) {
                this.contenttypeH = token;
                continue;
            }
            if (token.startsWith("c: ")) {
                this.contenttypeH = token;
                continue;
            }
            if (token.startsWith("Content-Length: ")) {
                this.contentlengthH = token;
                continue;
            }
            if (token.startsWith("l: ")) {
                this.contentlengthH = token;
                continue;
            }
            if (token.startsWith("User-Agent: ")) {
                this.remoteuseragentH = token;
                this.useragentH = "User-Agent: KwangHaeSoft SmartSip release 0100o";
                continue;
            }
            if (!token.startsWith("P-Asserted-Identity: ")) continue;
            this.passertedidentityH = token;
        }
        this.allowH = "Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
        this.maxforwardH = "Max-Forwards: 70";
        int audioport = this.updateHeaders.sdp.audioM.mediaPort;
        if (audioport > 0) {
            this.constructSdp();
        }
        if (this.sdp != null && this.sdp.flag) {
            this.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
            if (SIPStack.PRIMARY_CODEC_AUDIO == SIPStack.SIP_CODEC_G711U) {
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
            } else {
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
            }
            this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
            this.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
        }
        if (this.parseRemoteSdp(message) && this.remoteSdp != null && this.remoteSdp.flag && this.remoteSdp.audioM != null && this.sdp != null && this.sdp.flag && this.sdp.audioM != null && this.remoteSdp.audioM.flow != null && this.remoteSdp.audioM.flow.length() > 0) {
            if (this.remoteSdp.audioM.flow.compareTo("sendrecv") == 0) {
                this.sdp.audioM.setFlow("sendrecv");
            } else if (this.remoteSdp.audioM.flow.compareTo("sendonly") == 0) {
                this.sdp.audioM.setFlow("recvonly");
            } else if (this.remoteSdp.audioM.flow.compareTo("recvonly") == 0) {
                this.sdp.audioM.setFlow("sendonly");
            }
        }
        this.negotiateAudioCodec();
        return true;
    }

    public void reverseRecordRoute(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        this.recordrouteArray = null;
        this.routeH = null;
        StringTokenizer tokenArray = new StringTokenizer(message, SIPStack.SIP_LINE_END, true);
        while (tokenArray.hasMoreTokens()) {
            int iM;
            int iE;
            String str;
            int iS;
            String token = tokenArray.nextToken().trim();
            if (token.length() <= 0 || token.compareTo("\r") == 0 || token.compareTo("\n") == 0) continue;
            if (token.startsWith("Record-Route: ")) {
                this.routeH = token.substring(7).trim();
                if (this.routeArray == null) {
                    this.routeArray = new StringBuffer();
                    this.routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                    continue;
                }
                if (this.routeArray != null && this.routeArray.length() > 0) {
                    this.routeArray.insert(0, String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                    continue;
                }
                if (this.routeArray == null) continue;
                this.routeArray.append(String.valueOf(token.substring(7)) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (token.startsWith("Contact: ")) {
                this.contactH = token;
                if (token.length() <= 0) continue;
                iS = 0;
                iS = token.indexOf("sip:");
                if (iS <= 0) continue;
                str = null;
                iE = 0;
                iE = token.indexOf(">", iS);
                str = iE > 0 ? token.substring(iS, iE) : token.substring(iS);
                iE = str.indexOf(";");
                if (iE > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(";")) > 0) {
                    str = str.substring(0, iE);
                }
                if ((iE = str.indexOf(" ")) > 0) {
                    str = str.substring(0, iE);
                }
                if (str.length() > 0) {
                    this.remoteContactUri = str;
                }
                if (str.length() <= 0) continue;
                iS = str.indexOf("@");
                iM = (str = iS > 0 ? str.substring(iS + 1) : str.substring(4)).indexOf(":", iS);
                if (iM < 0) {
                    this.remoteContactIp = str;
                    this.remoteContactPort = 5060;
                    continue;
                }
                this.remoteContactIp = str.substring(0, iM).trim();
                this.remoteContactPort = Integer.parseInt(str.substring(iM + 1).trim());
                continue;
            }
            if (!token.startsWith("m: ")) continue;
            this.contactH = token;
            if (token.length() <= 0) continue;
            iS = 0;
            iS = token.indexOf("sip:");
            if (iS <= 0) continue;
            str = null;
            iE = 0;
            iE = token.indexOf(">", iS);
            str = iE > 0 ? token.substring(iS, iE) : token.substring(iS);
            iE = str.indexOf(";");
            if (iE > 0) {
                str = str.substring(0, iE);
            }
            if ((iE = str.indexOf(";")) > 0) {
                str = str.substring(0, iE);
            }
            if ((iE = str.indexOf(" ")) > 0) {
                str = str.substring(0, iE);
            }
            if (str.length() > 0) {
                this.remoteContactUri = str;
            }
            if (str.length() <= 0) continue;
            iS = str.indexOf("@");
            iM = (str = iS > 0 ? str.substring(iS + 1) : str.substring(4)).indexOf(":", iS);
            if (iM < 0) {
                this.remoteContactIp = str;
                this.remoteContactPort = 5060;
                continue;
            }
            this.remoteContactIp = str.substring(0, iM).trim();
            this.remoteContactPort = Integer.parseInt(str.substring(iM + 1).trim());
        }
    }

    public String getViaArray(String message) {
        if (message == null || message.length() == 0) {
            return null;
        }
        StringBuffer viaArray = new StringBuffer();
        String viaH = null;
        StringTokenizer tokenArray = new StringTokenizer(message, SIPStack.SIP_LINE_END, true);
        while (tokenArray.hasMoreTokens()) {
            int index;
            String branch;
            String token = tokenArray.nextToken().trim();
            if (token.length() <= 0 || token.compareTo("\r") == 0 || token.compareTo("\n") == 0) continue;
            if (token.startsWith("Via: ")) {
                if (viaH == null) {
                    viaH = token;
                    if (token.indexOf(";received=") < 0) {
                        branch = "";
                        index = token.indexOf(";branch=");
                        if (index > 0) {
                            branch = token.substring(index + 8);
                        }
                        this.viaBranch = branch != null && branch.length() > 0 ? ((index = branch.indexOf(";")) > 0 ? branch.substring(0, index) : branch) : "";
                        index = token.indexOf(";branch=");
                        viaH = index > 0 ? token.substring(0, index) : token;
                        index = viaH.indexOf(";rport=");
                        if (index > 0) {
                            viaH = viaH.substring(0, index);
                        }
                        viaH = String.valueOf(viaH) + ";received=" + this.remoteIp + ";rport=" + this.remotePort + ";branch=" + this.viaBranch;
                    }
                    viaArray.append(String.valueOf(viaH) + SIPStack.SIP_LINE_END);
                    continue;
                }
                viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
                continue;
            }
            if (!token.startsWith("v: ")) continue;
            if (viaH == null) {
                viaH = token;
                if (token.indexOf(";received=") < 0) {
                    branch = "";
                    index = token.indexOf(";branch=");
                    if (index > 0) {
                        branch = token.substring(index + 8);
                    }
                    this.viaBranch = branch != null && branch.length() > 0 ? ((index = branch.indexOf(";")) > 0 ? branch.substring(0, index) : branch) : branch;
                    index = token.indexOf(";branch=");
                    viaH = index > 0 ? token.substring(0, index) : token;
                    index = viaH.indexOf(";rport=");
                    if (index > 0) {
                        viaH = viaH.substring(0, index);
                    }
                    viaH = String.valueOf(viaH) + ";received=" + this.remoteIp + ";rport=" + this.remotePort + ";branch=" + this.viaBranch;
                }
                viaArray.append(String.valueOf(viaH) + SIPStack.SIP_LINE_END);
                continue;
            }
            viaArray.append(String.valueOf(token) + SIPStack.SIP_LINE_END);
        }
        return viaArray.toString();
    }

    public boolean constructSdp() {
        if (this.sdp != null && this.sdp.flag) {
            return false;
        }
        this.sdp = SIPStack.localSdpIp != null && SIPStack.localSdpIp.length() > 0 && SIPStack.usePrivateWiMax ? new SIPSdp(this.dnis, this.localIp, SIPStack.localSdpIp) : new SIPSdp(this.dnis, this.localIp);
        return this.sdp != null && this.sdp.flag;
    }

    public boolean parseRemoteSdp(String message) {
        if (message == null || message.length() == 0) {
            return false;
        }
        boolean bContinueParsing = true;
        int iS = 0;
        int iE = 0;
        String header = null;
        if (bContinueParsing) {
            String headerValue;
            bContinueParsing = false;
            iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "Content-Type: ");
            if (iS > 0) {
                iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                if (iS > 0 && iE > 0) {
                    header = message.substring(iS + 2, iE);
                    headerValue = null;
                    if (header != null && header.length() > 0) {
                        headerValue = header.substring(14);
                    }
                    if (headerValue != null && headerValue.length() > 0 && headerValue.toLowerCase().compareTo("application/sdp") == 0) {
                        bContinueParsing = true;
                    }
                }
            } else {
                iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "c: ");
                if (iS > 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                    if (iS > 0 && iE > 0) {
                        header = message.substring(iS + 2, iE);
                        headerValue = null;
                        if (header != null && header.length() > 0) {
                            headerValue = header.substring(3);
                        }
                        if (headerValue != null && headerValue.length() > 0 && headerValue.toLowerCase().compareTo("application/sdp") == 0) {
                            bContinueParsing = true;
                        }
                    }
                }
            }
        }
        iS = 0;
        iE = 0;
        header = null;
        int contentLength = 0;
        if (bContinueParsing) {
            String headerValue;
            bContinueParsing = false;
            iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "Content-Length: ");
            if (iS > 0) {
                iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                if (iS > 0 && iE > 0) {
                    header = message.substring(iS + 2, iE);
                    headerValue = null;
                    if (header != null && header.length() > 0) {
                        headerValue = header.substring(16);
                    }
                    if (headerValue != null && headerValue.length() > 0) {
                        contentLength = Integer.parseInt(headerValue);
                        bContinueParsing = true;
                    }
                }
            } else {
                iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "l: ");
                if (iS > 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                    if (iS > 0 && iE > 0) {
                        header = message.substring(iS + 2, iE);
                        headerValue = null;
                        if (header != null && header.length() > 0) {
                            headerValue = header.substring(3);
                        }
                        if (headerValue != null && headerValue.length() > 0) {
                            contentLength = Integer.parseInt(headerValue);
                            bContinueParsing = true;
                        }
                    }
                }
            }
        }
        iS = 0;
        iE = 0;
        header = null;
        String body = null;
        if (bContinueParsing) {
            bContinueParsing = false;
            iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_DOUBLEEND) + "v=0" + SIPStack.SIP_LINE_END);
            if (iS > 0 && (body = message.substring(iS + 4)) != null && body.length() >= contentLength) {
                bContinueParsing = true;
            }
        }
        if (bContinueParsing) {
            this.remoteSdp = new SIPSdp(body);
            if (this.remoteSdp != null && this.remoteSdp.flag) {
                return true;
            }
        }
        return false;
    }

    public boolean parseDtmfSdp(String message, int dtmftype) {
        if (message == null || message.length() == 0) {
            return false;
        }
        boolean bContinueParsing = true;
        int iS = 0;
        int iE = 0;
        int dtmf = 0;
        this.bDtmfdetected = false;
        String header = null;
        if (dtmftype == SIPStack.SIP_DTMFINFO_DTMFRELAY) {
            if (bContinueParsing) {
                String headerValue;
                bContinueParsing = false;
                iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "Content-Type: ");
                if (iS > 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                    if (iS > 0 && iE > 0) {
                        header = message.substring(iS + 2, iE);
                        headerValue = null;
                        if (header != null && header.length() > 0) {
                            headerValue = header.substring(14);
                        }
                        if (headerValue != null && headerValue.length() > 0 && headerValue.toLowerCase().compareTo("application/dtmf-relay") == 0) {
                            bContinueParsing = true;
                        }
                    }
                } else {
                    iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "c: ");
                    if (iS > 0) {
                        iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                        if (iS > 0 && iE > 0) {
                            header = message.substring(iS + 2, iE);
                            headerValue = null;
                            if (header != null && header.length() > 0) {
                                headerValue = header.substring(3);
                            }
                            if (headerValue != null && headerValue.length() > 0 && headerValue.toLowerCase().compareTo("application/dtmf-relay") == 0) {
                                bContinueParsing = true;
                            }
                        }
                    }
                }
            }
            iS = 0;
            iE = 0;
            header = null;
            int contentLength = 0;
            if (bContinueParsing) {
                String headerValue;
                bContinueParsing = false;
                iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "Content-Length: ");
                if (iS > 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                    if (iS > 0 && iE > 0) {
                        header = message.substring(iS + 2, iE);
                        headerValue = null;
                        if (header != null && header.length() > 0) {
                            headerValue = header.substring(16);
                        }
                        if (headerValue != null && headerValue.length() > 0) {
                            contentLength = Integer.parseInt(headerValue);
                            bContinueParsing = true;
                        }
                    }
                } else {
                    iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "l: ");
                    if (iS > 0) {
                        iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                        if (iS > 0 && iE > 0) {
                            header = message.substring(iS + 2, iE);
                            headerValue = null;
                            if (header != null && header.length() > 0) {
                                headerValue = header.substring(3);
                            }
                            if (headerValue != null && headerValue.length() > 0) {
                                contentLength = Integer.parseInt(headerValue);
                                bContinueParsing = true;
                            }
                        }
                    }
                }
            }
            iS = 0;
            iE = 0;
            header = null;
            String body = null;
            if (bContinueParsing) {
                bContinueParsing = false;
                iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_DOUBLEEND) + "Signal=");
                if (iS > 0 && (body = message.substring(iS + 4)) != null && body.length() >= contentLength) {
                    bContinueParsing = true;
                }
            }
            if (bContinueParsing) {
                bContinueParsing = false;
                String sH = null;
                iS = body.indexOf("Signal=");
                if (iS >= 0) {
                    iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
                }
                if (iS >= 0 && iE > iS && (dtmf = Integer.parseInt(sH = body.substring(iS + 7, iE).trim())) >= 0 && dtmf < 12) {
                    bContinueParsing = true;
                    this.detectedDtmf = dtmf;
                    this.bDtmfdetected = true;
                    this.dtmfDuration = 0;
                }
                if (bContinueParsing) {
                    iS = body.indexOf("Duration=");
                    if (iS >= 0) {
                        iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
                    }
                    if (iS >= 0 && iE > iS) {
                        sH = body.substring(iS + 9, iE).trim();
                        this.dtmfDuration = Integer.parseInt(sH);
                    }
                }
            }
            return this.bDtmfdetected;
        }
        if (dtmftype == SIPStack.SIP_DTMFINFO_DTMF) {
            if (bContinueParsing) {
                String headerValue;
                bContinueParsing = false;
                iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "Content-Type: ");
                if (iS > 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                    if (iS > 0 && iE > 0) {
                        header = message.substring(iS + 2, iE);
                        headerValue = null;
                        if (header != null && header.length() > 0) {
                            headerValue = header.substring(14);
                        }
                        if (headerValue != null && headerValue.length() > 0 && headerValue.toLowerCase().compareTo("application/dtmf") == 0) {
                            bContinueParsing = true;
                        }
                    }
                } else {
                    iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "c: ");
                    if (iS > 0) {
                        iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                        if (iS > 0 && iE > 0) {
                            header = message.substring(iS + 2, iE);
                            headerValue = null;
                            if (header != null && header.length() > 0) {
                                headerValue = header.substring(3);
                            }
                            if (headerValue != null && headerValue.length() > 0 && headerValue.toLowerCase().compareTo("application/dtmf") == 0) {
                                bContinueParsing = true;
                            }
                        }
                    }
                }
            }
            iS = 0;
            iE = 0;
            header = null;
            int contentLength = 0;
            if (bContinueParsing) {
                String headerValue;
                bContinueParsing = false;
                iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "Content-Length: ");
                if (iS > 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                    if (iS > 0 && iE > 0) {
                        header = message.substring(iS + 2, iE);
                        headerValue = null;
                        if (header != null && header.length() > 0) {
                            headerValue = header.substring(16);
                        }
                        if (headerValue != null && headerValue.length() > 0) {
                            contentLength = Integer.parseInt(headerValue);
                            bContinueParsing = true;
                        }
                    }
                } else {
                    iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "l: ");
                    if (iS > 0) {
                        iE = message.indexOf(SIPStack.SIP_LINE_END, iS + 2);
                        if (iS > 0 && iE > 0) {
                            header = message.substring(iS + 2, iE);
                            headerValue = null;
                            if (header != null && header.length() > 0) {
                                headerValue = header.substring(3);
                            }
                            if (headerValue != null && headerValue.length() > 0) {
                                contentLength = Integer.parseInt(headerValue);
                                bContinueParsing = true;
                            }
                        }
                    }
                }
            }
            iS = 0;
            iE = 0;
            header = null;
            String body = null;
            if (bContinueParsing) {
                bContinueParsing = false;
                iS = message.indexOf(SIPStack.SIP_LINE_DOUBLEEND);
                if (iS > 0 && (body = message.substring(iS + 4)) != null && body.length() >= contentLength) {
                    bContinueParsing = true;
                }
            }
            if (bContinueParsing) {
                bContinueParsing = false;
                String sH = null;
                iS = 0;
                iE = body.indexOf(SIPStack.SIP_LINE_END, iS);
                if (iE > iS && (dtmf = Integer.parseInt(sH = body.substring(iS, iE).trim())) >= 0 && dtmf < 12) {
                    bContinueParsing = true;
                    this.detectedDtmf = dtmf;
                    this.bDtmfdetected = true;
                    this.dtmfDuration = 0;
                }
            }
            return this.bDtmfdetected;
        }
        return false;
    }

    public boolean negotiateAudioCodec() {
        if (this.sdp != null && this.sdp.flag && this.sdp.audioM != null && this.sdp.audioM.flag && this.remoteSdp != null && this.remoteSdp.flag && this.remoteSdp.audioM != null && this.remoteSdp.audioM.flag) {
            int finalCodec;
            if (this.callDirection == SIPStack.SIP_CALLDIRECTION_OUT) {
                int finalCodec2 = this.remoteSdp.audioM.negotiateAudioCodec(this.sdp.audioM.codecS.toString());
                if (finalCodec2 >= 0) {
                    this.sdp.audioM.setCommonCodec(finalCodec2);
                    return true;
                }
            } else if (this.callDirection == SIPStack.SIP_CALLDIRECTION_IN && (finalCodec = this.sdp.audioM.negotiateAudioCodec(this.remoteSdp.audioM.codecS.toString())) >= 0) {
                this.remoteSdp.audioM.setCommonCodec(finalCodec);
                return true;
            }
        }
        return false;
    }

    public boolean negotiateVideoCodec() {
        return true;
    }

    public void exceptionTI() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("IDLE CALL EXCEPTION occurred.");
        }
        this.resetCall();
    }

    public void exceptionT0() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("INVITING CALL EXCEPTION occurred.");
        }
        this.resetCall();
    }

    public void exceptionT1() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("PROCEEDING CALL EXCEPTION occurred.");
        }
    }

    public void exceptionT2() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("PROGRESSING CALL EXCEPTION occurred.");
        }
    }

    public void exceptionT3() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("ACCEPTED CALL EXCEPTION occurred.");
        }
    }

    public void exceptionT4() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("CONNECTED CALL EXCEPTION occurred.");
        }
    }

    public void exceptionT5() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("DISCONNECTING CALL EXCEPTION occurred.");
        }
        this.resetCall();
    }

    public void exceptionT6() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("TERMINATING CALL EXCEPTION occurred.");
        }
        this.resetCall();
    }

    public void exceptionT7() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("OFFERRED CALL EXCEPTION occurred.");
        }
    }

    public void exceptionT8() {
        if (SIPStack.SIP_CALLHANDLE_DEBUG) {
            System.out.println("CANCELLING CALL EXCEPTION occurred.");
        }
        this.resetCall();
    }

    public void setUpdateheaders() {
        if (this.updateHeaders == null) {
            return;
        }
        this.updateHeaders.commandLine = this.commandLine;
        this.updateHeaders.viaH = this.viaH;
        this.updateHeaders.viaArray = this.viaArray;
        this.updateHeaders.routeH = this.routeH;
        this.updateHeaders.routeArray = this.routeArray;
        this.updateHeaders.recordrouteH = this.recordrouteH;
        this.updateHeaders.recordrouteArray = this.recordrouteArray;
        this.updateHeaders.maxforwardH = this.maxforwardH;
        this.updateHeaders.contactH = this.contactH;
        this.updateHeaders.toH = this.toH;
        this.updateHeaders.fromH = this.fromH;
        this.updateHeaders.callidH = this.callidH;
        this.updateHeaders.cseqH = this.cseqH;
        this.updateHeaders.expiresH = this.expiresH;
        this.updateHeaders.allowH = this.allowH;
        this.updateHeaders.useragentH = this.useragentH;
        this.updateHeaders.remoteuseragentH = this.remoteuseragentH;
        this.updateHeaders.contentlengthH = this.contentlengthH;
        this.updateHeaders.contenttypeH = this.contenttypeH;
        this.updateHeaders.authorizationINVITEH = this.authorizationINVITEH;
        this.updateHeaders.authorizationCANCELH = this.authorizationCANCELH;
        this.updateHeaders.authorizationBYEH = this.authorizationBYEH;
        this.updateHeaders.authorizationACKH = this.authorizationACKH;
        this.updateHeaders.passertedidentityH = this.passertedidentityH;
        this.updateHeaders.serverIp = this.serverIp;
        this.updateHeaders.serverPort = this.serverPort;
        this.updateHeaders.serverDomain = this.serverDomain;
        this.updateHeaders.remoteIp = this.remoteIp;
        this.updateHeaders.remotePort = this.remotePort;
        this.updateHeaders.remoteContactIp = this.remoteContactIp;
        this.updateHeaders.remoteContactPort = this.remoteContactPort;
        this.updateHeaders.remoteContactUri = this.remoteContactUri;
        this.updateHeaders.localIp = this.localIp;
        this.updateHeaders.localPort = this.localPort;
        this.updateHeaders.id = this.id;
        this.updateHeaders.cid = this.cid;
        this.updateHeaders.authid = this.authid;
        this.updateHeaders.authpassword = this.authpassword;
        this.updateHeaders.fromTag = this.fromTag;
        this.updateHeaders.toTag = this.toTag;
        this.updateHeaders.fromHeaderValue = this.fromHeaderValue;
        this.updateHeaders.toHeaderValue = this.toHeaderValue;
        this.updateHeaders.callId = this.callId;
        this.updateHeaders.dnis = this.dnis;
        this.updateHeaders.CSEQ_NUMBER = this.CSEQ_NUMBER;
        this.updateHeaders.INVITE_CSEQ = this.INVITE_CSEQ;
        this.updateHeaders.CANCEL_CSEQ = this.CANCEL_CSEQ;
        this.updateHeaders.ACK_CSEQ = this.ACK_CSEQ;
        this.updateHeaders.BYE_CSEQ = this.BYE_CSEQ;
        this.updateHeaders.callDirection = this.callDirection;
        this.updateHeaders.viaBranch = this.viaBranch;
        this.updateHeaders.callState = this.callState;
        this.updateHeaders.callMode = this.callMode;
        this.updateHeaders.callTime_TI = this.callTime_TI;
        this.updateHeaders.callTime_T0 = this.callTime_T0;
        this.updateHeaders.callTime_T00 = this.callTime_T00;
        this.updateHeaders.invitingTimes = this.invitingTimes;
        this.updateHeaders.callTime_T1 = this.callTime_T1;
        this.updateHeaders.callTime_T2 = this.callTime_T2;
        this.updateHeaders.callTime_T3 = this.callTime_T3;
        this.updateHeaders.callTime_T4 = this.callTime_T4;
        this.updateHeaders.callTime_T40 = this.callTime_T40;
        this.updateHeaders.callTime_T5 = this.callTime_T5;
        this.updateHeaders.callTime_T6 = this.callTime_T6;
        this.updateHeaders.callTime_T7 = this.callTime_T7;
        this.updateHeaders.callTime_T8 = this.callTime_T8;
        this.updateHeaders.callTime_T9 = this.callTime_T9;
        this.updateHeaders.expiresTI = this.expiresTI;
        this.updateHeaders.expiresT0 = this.expiresT0;
        this.updateHeaders.expiresT1 = this.expiresT1;
        this.updateHeaders.expiresT2 = this.expiresT2;
        this.updateHeaders.expiresT3 = this.expiresT3;
        this.updateHeaders.expiresT4 = this.expiresT4;
        this.updateHeaders.expiresT5 = this.expiresT5;
        this.updateHeaders.expiresT6 = this.expiresT6;
        this.updateHeaders.expiresT7 = this.expiresT7;
        this.updateHeaders.expiresT8 = this.expiresT8;
        this.updateHeaders.expiresT9 = this.expiresT9;
        this.updateHeaders.sdp = this.sdp;
        this.updateHeaders.remoteSdp = this.remoteSdp;
        this.updateHeaders.message = this.message;
        this.commandLine = null;
        this.viaH = null;
        this.viaArray = null;
        this.routeH = null;
        this.routeArray = null;
        this.recordrouteH = null;
        this.recordrouteArray = null;
        this.maxforwardH = null;
        this.contactH = null;
        this.toH = null;
        this.fromH = null;
        this.callidH = null;
        this.cseqH = null;
        this.expiresH = null;
        this.allowH = null;
        this.useragentH = null;
        this.remoteuseragentH = null;
        this.contentlengthH = null;
        this.contenttypeH = null;
        this.authorizationINVITEH = null;
        this.authorizationCANCELH = null;
        this.authorizationBYEH = null;
        this.authorizationACKH = null;
        this.passertedidentityH = null;
        this.fromTag = null;
        this.toTag = null;
        this.callId = null;
        this.viaBranch = null;
        this.sdp = null;
        this.remoteSdp = null;
        this.message = null;
        this.updateHeaders.flag = true;
    }

    public void setUpdateheaders(String flow) {
        if (this.updateHeaders == null) {
            return;
        }
        this.updateHeaders.commandLine = this.commandLine;
        this.updateHeaders.viaH = this.viaH;
        this.updateHeaders.viaArray = this.viaArray;
        this.updateHeaders.routeH = this.routeH;
        this.updateHeaders.routeArray = this.routeArray;
        this.updateHeaders.recordrouteH = this.recordrouteH;
        this.updateHeaders.recordrouteArray = this.recordrouteArray;
        this.updateHeaders.maxforwardH = this.maxforwardH;
        this.updateHeaders.contactH = this.contactH;
        this.updateHeaders.toH = this.toH;
        this.updateHeaders.fromH = this.fromH;
        this.updateHeaders.callidH = this.callidH;
        this.updateHeaders.cseqH = this.cseqH;
        this.updateHeaders.expiresH = this.expiresH;
        this.updateHeaders.allowH = this.allowH;
        this.updateHeaders.useragentH = this.useragentH;
        this.updateHeaders.remoteuseragentH = this.remoteuseragentH;
        this.updateHeaders.contentlengthH = this.contentlengthH;
        this.updateHeaders.contenttypeH = this.contenttypeH;
        this.updateHeaders.authorizationINVITEH = this.authorizationINVITEH;
        this.updateHeaders.authorizationCANCELH = this.authorizationCANCELH;
        this.updateHeaders.authorizationBYEH = this.authorizationBYEH;
        this.updateHeaders.authorizationACKH = this.authorizationACKH;
        this.updateHeaders.passertedidentityH = this.passertedidentityH;
        this.updateHeaders.serverIp = this.serverIp;
        this.updateHeaders.serverPort = this.serverPort;
        this.updateHeaders.serverDomain = this.serverDomain;
        this.updateHeaders.remoteIp = this.remoteIp;
        this.updateHeaders.remotePort = this.remotePort;
        this.updateHeaders.remoteContactIp = this.remoteContactIp;
        this.updateHeaders.remoteContactPort = this.remoteContactPort;
        this.updateHeaders.remoteContactUri = this.remoteContactUri;
        this.updateHeaders.localIp = this.localIp;
        this.updateHeaders.localPort = this.localPort;
        this.updateHeaders.id = this.id;
        this.updateHeaders.cid = this.cid;
        this.updateHeaders.authid = this.authid;
        this.updateHeaders.authpassword = this.authpassword;
        this.updateHeaders.fromTag = this.fromTag;
        this.updateHeaders.toTag = this.toTag;
        this.updateHeaders.fromHeaderValue = this.fromHeaderValue;
        this.updateHeaders.toHeaderValue = this.toHeaderValue;
        this.updateHeaders.callId = this.callId;
        this.updateHeaders.dnis = this.dnis;
        this.updateHeaders.CSEQ_NUMBER = this.CSEQ_NUMBER;
        this.updateHeaders.INVITE_CSEQ = this.INVITE_CSEQ;
        this.updateHeaders.CANCEL_CSEQ = this.CANCEL_CSEQ;
        this.updateHeaders.ACK_CSEQ = this.ACK_CSEQ;
        this.updateHeaders.BYE_CSEQ = this.BYE_CSEQ;
        this.updateHeaders.callDirection = this.callDirection;
        this.updateHeaders.viaBranch = this.viaBranch;
        this.updateHeaders.callState = this.callState;
        this.updateHeaders.callMode = this.callMode;
        this.updateHeaders.callTime_TI = this.callTime_TI;
        this.updateHeaders.callTime_T0 = this.callTime_T0;
        this.updateHeaders.callTime_T00 = this.callTime_T00;
        this.updateHeaders.invitingTimes = this.invitingTimes;
        this.updateHeaders.callTime_T1 = this.callTime_T1;
        this.updateHeaders.callTime_T2 = this.callTime_T2;
        this.updateHeaders.callTime_T3 = this.callTime_T3;
        this.updateHeaders.callTime_T4 = this.callTime_T4;
        this.updateHeaders.callTime_T40 = this.callTime_T40;
        this.updateHeaders.callTime_T5 = this.callTime_T5;
        this.updateHeaders.callTime_T6 = this.callTime_T6;
        this.updateHeaders.callTime_T7 = this.callTime_T7;
        this.updateHeaders.callTime_T8 = this.callTime_T8;
        this.updateHeaders.callTime_T9 = this.callTime_T9;
        this.updateHeaders.expiresTI = this.expiresTI;
        this.updateHeaders.expiresT0 = this.expiresT0;
        this.updateHeaders.expiresT1 = this.expiresT1;
        this.updateHeaders.expiresT2 = this.expiresT2;
        this.updateHeaders.expiresT3 = this.expiresT3;
        this.updateHeaders.expiresT4 = this.expiresT4;
        this.updateHeaders.expiresT5 = this.expiresT5;
        this.updateHeaders.expiresT6 = this.expiresT6;
        this.updateHeaders.expiresT7 = this.expiresT7;
        this.updateHeaders.expiresT8 = this.expiresT8;
        this.updateHeaders.expiresT9 = this.expiresT9;
        this.updateHeaders.sdp = this.sdp;
        this.updateHeaders.remoteSdp = this.remoteSdp;
        this.updateHeaders.message = this.message;
        this.commandLine = null;
        this.viaH = null;
        this.viaArray = null;
        this.recordrouteH = null;
        this.recordrouteArray = null;
        this.maxforwardH = null;
        this.contactH = null;
        if (this.updateHeaders.callDirection == SIPStack.SIP_CALLDIRECTION_IN) {
            if (this.updateHeaders.fromH != null && this.updateHeaders.fromH.length() > 5) {
                this.toH = this.updateHeaders.fromH.startsWith("f: ") ? "t:" + this.updateHeaders.fromH.substring(2) : "To:" + this.updateHeaders.fromH.substring(5);
            }
            if (this.updateHeaders.toH != null && this.updateHeaders.toH.length() > 3) {
                this.fromH = this.updateHeaders.toH.startsWith("t: ") ? "From:" + this.updateHeaders.toH.substring(2) : "From:" + this.updateHeaders.toH.substring(3);
            }
            this.fromTag = this.updateHeaders.toTag;
            this.toTag = this.updateHeaders.fromTag;
        }
        this.cseqH = null;
        this.expiresH = null;
        this.allowH = null;
        this.useragentH = null;
        this.remoteuseragentH = null;
        this.contentlengthH = null;
        this.contenttypeH = null;
        this.viaBranch = null;
        if (this.updateHeaders.callDirection == SIPStack.SIP_CALLDIRECTION_IN) {
            this.authorizationINVITEH = null;
            this.authorizationCANCELH = null;
            this.authorizationBYEH = null;
            this.authorizationACKH = null;
        }
        this.passertedidentityH = null;
        this.callState = 20;
        this.callMode = SIPStack.SIP_CALLMODE_HOLD;
        this.callTime_TI = new Date();
        this.callTime_T0 = new Date();
        this.callTime_T00 = new Date();
        this.invitingTimes = 0;
        this.callTime_T1 = new Date();
        this.callTime_T2 = new Date();
        this.callTime_T3 = new Date();
        this.callTime_T4 = new Date();
        this.callTime_T40 = new Date();
        this.callTime_T5 = new Date();
        this.callTime_T6 = new Date();
        this.callTime_T7 = new Date();
        this.callTime_T8 = new Date();
        this.callTime_T9 = new Date();
        this.expiresTI = 0;
        this.expiresT0 = 0;
        this.expiresT1 = 0;
        this.expiresT2 = 0;
        this.expiresT3 = 0;
        this.expiresT4 = 0;
        this.expiresT5 = 0;
        this.expiresT6 = 0;
        this.expiresT7 = 0;
        this.expiresT8 = 0;
        this.expiresT9 = 0;
        this.sdp = null;
        this.remoteSdp = null;
        int audioport = this.updateHeaders.sdp.audioM.mediaPort;
        if (audioport > 0) {
            this.constructSdp();
        }
        if (this.sdp != null && this.sdp.flag) {
            this.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO, audioport);
            if (this.sdp.audioM != null) {
                if (this.updateHeaders.sdp.audioM.commonCodec == SIPStack.SIP_CODEC_G711U) {
                    this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711U, "PCMU/8000");
                } else if (this.updateHeaders.sdp.audioM.commonCodec == SIPStack.SIP_CODEC_G711A) {
                    this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, SIPStack.SIP_CODEC_G711A, "PCMA/8000");
                }
                this.sdp.setCodec(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "telephone-event/8000");
                this.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
                this.sdp.audioM.setFlow(flow);
            }
        }
        this.message = null;
        this.updateHeaders.flag = true;
    }

    public void restoreUpdateheaders() {
        if (this.updateHeaders == null || !this.updateHeaders.flag) {
            return;
        }
        this.commandLine = this.updateHeaders.commandLine;
        this.viaH = this.updateHeaders.viaH;
        this.viaArray = this.updateHeaders.viaArray;
        this.routeH = this.updateHeaders.routeH;
        this.routeArray = this.updateHeaders.routeArray;
        this.recordrouteH = this.updateHeaders.recordrouteH;
        this.recordrouteArray = this.updateHeaders.recordrouteArray;
        this.maxforwardH = this.updateHeaders.maxforwardH;
        this.contactH = this.updateHeaders.contactH;
        this.toH = this.updateHeaders.toH;
        this.fromH = this.updateHeaders.fromH;
        this.callidH = this.updateHeaders.callidH;
        this.cseqH = this.updateHeaders.cseqH;
        this.expiresH = this.updateHeaders.expiresH;
        this.allowH = this.updateHeaders.allowH;
        this.useragentH = this.updateHeaders.useragentH;
        this.remoteuseragentH = this.updateHeaders.remoteuseragentH;
        this.contentlengthH = this.updateHeaders.contentlengthH;
        this.contenttypeH = this.updateHeaders.contenttypeH;
        this.authorizationINVITEH = this.updateHeaders.authorizationINVITEH;
        this.authorizationCANCELH = this.updateHeaders.authorizationCANCELH;
        this.authorizationBYEH = this.updateHeaders.authorizationBYEH;
        this.authorizationACKH = this.updateHeaders.authorizationACKH;
        this.passertedidentityH = this.updateHeaders.passertedidentityH;
        this.serverIp = this.updateHeaders.serverIp;
        this.serverPort = this.updateHeaders.serverPort;
        this.serverDomain = this.updateHeaders.serverDomain;
        this.remoteIp = this.updateHeaders.remoteIp;
        this.remotePort = this.updateHeaders.remotePort;
        this.remoteContactIp = this.updateHeaders.remoteContactIp;
        this.remoteContactPort = this.updateHeaders.remoteContactPort;
        this.remoteContactUri = this.updateHeaders.remoteContactUri;
        this.localIp = this.updateHeaders.localIp;
        this.localPort = this.updateHeaders.localPort;
        this.id = this.updateHeaders.id;
        this.cid = this.updateHeaders.cid;
        this.authid = this.updateHeaders.authid;
        this.authpassword = this.updateHeaders.authpassword;
        this.fromTag = this.updateHeaders.fromTag;
        this.toTag = this.updateHeaders.toTag;
        this.fromHeaderValue = this.updateHeaders.fromHeaderValue;
        this.toHeaderValue = this.updateHeaders.toHeaderValue;
        this.callId = this.updateHeaders.callId;
        this.dnis = this.updateHeaders.dnis;
        this.CSEQ_NUMBER = this.updateHeaders.CSEQ_NUMBER;
        this.INVITE_CSEQ = this.updateHeaders.INVITE_CSEQ;
        this.CANCEL_CSEQ = this.updateHeaders.CANCEL_CSEQ;
        this.ACK_CSEQ = this.updateHeaders.ACK_CSEQ;
        this.BYE_CSEQ = this.updateHeaders.BYE_CSEQ;
        this.callDirection = this.updateHeaders.callDirection;
        this.viaBranch = this.updateHeaders.viaBranch;
        this.callState = this.updateHeaders.callState;
        this.callMode = this.updateHeaders.callMode;
        this.callTime_TI = this.updateHeaders.callTime_TI;
        this.callTime_T0 = this.updateHeaders.callTime_T0;
        this.callTime_T00 = this.updateHeaders.callTime_T00;
        this.invitingTimes = this.updateHeaders.invitingTimes;
        this.callTime_T1 = this.updateHeaders.callTime_T1;
        this.callTime_T2 = this.updateHeaders.callTime_T2;
        this.callTime_T3 = this.updateHeaders.callTime_T3;
        this.callTime_T4 = this.updateHeaders.callTime_T4;
        this.callTime_T40 = this.updateHeaders.callTime_T40;
        this.callTime_T5 = this.updateHeaders.callTime_T5;
        this.callTime_T6 = this.updateHeaders.callTime_T6;
        this.callTime_T7 = this.updateHeaders.callTime_T7;
        this.callTime_T8 = this.updateHeaders.callTime_T8;
        this.callTime_T9 = this.updateHeaders.callTime_T9;
        this.expiresTI = this.updateHeaders.expiresTI;
        this.expiresT0 = this.updateHeaders.expiresT0;
        this.expiresT1 = this.updateHeaders.expiresT1;
        this.expiresT2 = this.updateHeaders.expiresT2;
        this.expiresT3 = this.updateHeaders.expiresT3;
        this.expiresT4 = this.updateHeaders.expiresT4;
        this.expiresT5 = this.updateHeaders.expiresT5;
        this.expiresT6 = this.updateHeaders.expiresT6;
        this.expiresT7 = this.updateHeaders.expiresT7;
        this.expiresT8 = this.updateHeaders.expiresT8;
        this.expiresT9 = this.updateHeaders.expiresT9;
        this.sdp = this.updateHeaders.sdp;
        this.remoteSdp = this.updateHeaders.remoteSdp;
        this.message = this.updateHeaders.message;
        this.updateHeaders.flag = false;
    }

    public void resetUpdateheaders() {
        if (this.updateHeaders == null || !this.updateHeaders.flag) {
            return;
        }
        this.updateHeaders.reset();
    }

    public boolean isCurrentCall(String message) {
        try {
            SIPHeader sipHeader = new SIPHeader(message, SIPStack.SIP_HEADERTYPE_CALLID);
            if (sipHeader != null && sipHeader.flag && sipHeader.headerValue != null && sipHeader.headerValue.length() > 0 && this.callId != null && sipHeader.headerValue.compareTo(this.callId) == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getCallState() {
        switch (this.callState) {
            case 0: {
                return "Idle";
            }
            case 1: {
                return "Inviting";
            }
            case 2: {
                return "Offerred";
            }
            case 3: {
                return "Proceeding";
            }
            case 4: {
                return "Progressing";
            }
            case 5: {
                return "Accepted";
            }
            case 6: {
                return "Remoteaccepted";
            }
            case 7: {
                return "Connected";
            }
            case 8: {
                return "Disconnecting";
            }
            case 9: {
                return "Terminating";
            }
            case 10: {
                return "Unauthorized";
            }
            case 11: {
                return "Cancelling";
            }
            case 13: {
                return "Recancelling";
            }
            case 14: {
                return "Cancelremoteaccepted";
            }
            case 12: {
                return "Cancelled";
            }
            case 15: {
                return "Rejected";
            }
            case 16: {
                return "Redirected";
            }
            case 20: {
                return "Updating";
            }
            case 21: {
                return "Updateproceeding";
            }
            case 22: {
                return "Updateprogressing";
            }
            case 23: {
                return "Updateofferred";
            }
            case 24: {
                return "Updateaccepted";
            }
            case 25: {
                return "Updaterejected";
            }
            case 26: {
                return "Updateremoteaccepted";
            }
            case 27: {
                return "Updateremoterejected";
            }
            case 28: {
                return "Updateunauthorized";
            }
            case 29: {
                return "Updateredirected";
            }
        }
        return "Undefined";
    }
}

