/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

final class Base64 {
    private static final char[] BASE64CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char PAD = '=';
    private static final String CRLF = "\r\n";

    private Base64() {
    }

    public static String encode(String str) {
        StringBuffer output = new StringBuffer();
        byte[] source = str.getBytes();
        int i = 0;
        while (i < source.length) {
            int buffer = 0;
            if (i % 54 == 0 && i != 0) {
                output.append(CRLF);
            }
            if (source.length <= i + 1) {
                buffer = Base64.eightbit(source[i]) << 16;
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 18)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 12)]);
                output.append('=');
                output.append('=');
            } else if (source.length <= i + 2) {
                buffer = Base64.eightbit(source[i]) << 16 | Base64.eightbit(source[i + 1]) << 8;
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 18)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 12)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 6)]);
                output.append('=');
            } else {
                buffer = Base64.eightbit(source[i]) << 16 | Base64.eightbit(source[i + 1]) << 8 | Base64.eightbit(source[i + 2]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 18)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 12)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 6)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer)]);
            }
            i += 3;
        }
        return output.toString();
    }

    public static String encode(byte[] source, boolean bReturn) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < source.length) {
            int buffer = 0;
            if (i % 54 == 0 && i != 0 && bReturn) {
                output.append(CRLF);
            }
            if (source.length <= i + 1) {
                buffer = Base64.eightbit(source[i]) << 16;
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 18)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 12)]);
                output.append('=');
                output.append('=');
            } else if (source.length <= i + 2) {
                buffer = Base64.eightbit(source[i]) << 16 | Base64.eightbit(source[i + 1]) << 8;
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 18)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 12)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 6)]);
                output.append('=');
            } else {
                buffer = Base64.eightbit(source[i]) << 16 | Base64.eightbit(source[i + 1]) << 8 | Base64.eightbit(source[i + 2]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 18)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 12)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer >> 6)]);
                output.append(BASE64CHARS[Base64.sixbit(buffer)]);
            }
            i += 3;
        }
        return output.toString();
    }

    public static String decode(String str) {
        StringBuffer output = new StringBuffer();
        byte[] source = str.getBytes();
        int data = 0;
        int buffer = 0;
        int bytesRead = 0;
        int i = 0;
        while (i < source.length) {
            block9: {
                block8: {
                    if (bytesRead >= 4) break block8;
                    data = Base64.decodeInt(source[i]);
                    if (data == -1) break block9;
                    if (data == -2 && bytesRead != 2 && bytesRead != 3) {
                        return null;
                    }
                    if (data == -2 && bytesRead == 2) {
                        output.append((char)Base64.eightbit(buffer >> 4));
                        return output.toString();
                    }
                    if (data == -2 && bytesRead == 3) {
                        output.append((char)Base64.eightbit(buffer >> 10));
                        output.append((char)Base64.eightbit(buffer >> 2));
                        return output.toString();
                    }
                    buffer = buffer << 6 | Base64.sixbit(data);
                    ++bytesRead;
                }
                if (bytesRead == 4) {
                    output.append((char)Base64.eightbit(buffer >> 16));
                    output.append((char)Base64.eightbit(buffer >> 8));
                    output.append((char)Base64.eightbit(buffer));
                    buffer = 0;
                    bytesRead = 0;
                }
            }
            ++i;
        }
        return output.toString();
    }

    private static int decodeInt(int input) {
        if (input >= 65 && input <= 90) {
            return input - 65;
        }
        if (input >= 97 && input <= 122) {
            return input - 97 + 26;
        }
        if (input >= 48 && input <= 57) {
            return input - 48 + 52;
        }
        if (input == 43) {
            return 62;
        }
        if (input == 47) {
            return 63;
        }
        if (input == 61) {
            return -2;
        }
        return -1;
    }

    private static int sixbit(int input) {
        return input & 0x3F;
    }

    private static int eightbit(int input) {
        return input & 0xFF;
    }
}

