/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class EnergyModuleAPI
extends WallPadDevAPI {
    private final String TAG = "EnergyModuleAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"EnergyModuleAPI", (String)s);
    }

    public EnergyModuleAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("EnergyModuleAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "ENERGYMODULE";
        this.data = new Data();
        this.GetDeviceCount();
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"EnergyModuleAPI", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"EnergyModuleAPI", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.DeviceCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.DeviceCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            boolean Install;
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.EnergyModule Device2 = new DataClasses.EnergyModule();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            if (Install = Boolean.parseBoolean(retData[index++])) {
                byte CircuitCount = Byte.parseByte(retData[index++]);
                Device2.setCircuitCount(CircuitCount);
                Device2.info.Install = Install;
                Device2.info.CircuitCount = CircuitCount;
                Device2.info.Vender = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Year = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Month = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Day = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Number = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
                Device2.info.AccPw_Unit = Boolean.parseBoolean(retData[index++]);
                Device2.circuit.CircuitCount = Byte.parseByte(retData[index++]);
                Device2.circuit.UnitError = Boolean.parseBoolean(retData[index++]);
                for (byte i = 0; i < CircuitCount; i = (byte)(i + 1)) {
                    Device2.circuit.NowPw[i] = Double.parseDouble(retData[index++]);
                    Device2.circuit.AccPw[i] = Double.parseDouble(retData[index++]);
                    Device2.circuit.AccOverFlow[i] = Boolean.parseBoolean(retData[index++]);
                }
                this.data.Device[Current] = Device2;
            } else {
                Device2.info.Install = false;
                this.data.Device[Current] = Device2;
            }
        }
        catch (Exception e) {
            Log.e((String)"EnergyModuleAPI", (String)"[Exception Error] ProcResult");
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.DeviceCnt = DeviceCount;
                    this.data.Device = new DataClasses.EnergyModule[DeviceCount];
                    return 0;
                }
                return -1;
            }
            catch (Exception e) {
                Log.e((String)"EnergyModuleAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int AccPwReset() {
        return this.SendNReadCMD_int("SINKCTRL", "AccPwReset", 0, 0, 0, 0, 0);
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public DataClasses.EnergyModule[] Device = null;
    }
}

