/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.annotation.SuppressLint;
import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

@SuppressLint(value={"DefaultLocale"})
public class IGW200dAPI
extends WallPadDevAPI {
    private final String TAG = "IGW200dAPI";
    private final boolean DEBUG_LOG_ON = true;
    public static final String BR_NAME_BASE = "kr.co.icontrols.wallpaddevservice.BR_IGW200D_";
    public static final String CID_BR_NAME = "kr.co.icontrols.wallpaddevservice.BR_IGW200D_CID_ALARM";
    public static final String SENSOR_BR_NAME = "kr.co.icontrols.wallpaddevservice.BR_IGW200D_SENSOR_ALARM";
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"IGW200dAPI", (String)s);
    }

    public IGW200dAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("IGW200dAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "IGW200D";
        this.data = new Data();
    }

    public int Refresh(boolean real) {
        String MainCMD = null;
        MainCMD = "NOSINKCTRL";
        String SubCMD = "Refresh";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 34) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.senIn.Motion = Boolean.parseBoolean(retlist[index++]);
                this.data.senIn.Magnetic = Boolean.parseBoolean(retlist[index++]);
                this.data.senIn.BathEMER = Boolean.parseBoolean(retlist[index++]);
                this.data.senIn.APU = Boolean.parseBoolean(retlist[index++]);
                this.data.senIn.EVAC_Home = Boolean.parseBoolean(retlist[index++]);
                this.data.senIn.EVAC_UP = Boolean.parseBoolean(retlist[index++]);
                index = 9;
                this.data.senOut.BathACK = Boolean.parseBoolean(retlist[index++]);
                this.data.senOut.EVACDN_AR = Boolean.parseBoolean(retlist[index++]);
                this.data.senOut.EnergyReset = Boolean.parseBoolean(retlist[index++]);
                index = 17;
                this.data.telIn.TelCall = Boolean.parseBoolean(retlist[index++]);
                this.data.telIn.TelCID = Boolean.parseBoolean(retlist[index++]);
                this.data.telIn.DoorCall = Boolean.parseBoolean(retlist[index++]);
                index = 25;
                this.data.telOut.DoorPower = Boolean.parseBoolean(retlist[index++]);
                this.data.telOut.BellControl = Boolean.parseBoolean(retlist[index++]);
                this.data.telOut.DoorMute = Boolean.parseBoolean(retlist[index++]);
                this.data.telOut.VideoSelect = Boolean.parseBoolean(retlist[index++]);
                index = 33;
                this.data.TelPath = Byte.parseByte(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"IGW200dAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                Log.e((String)"IGW200dAPI", (String)("[Refresh] - " + e.toString()));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public String GetVer() {
        String MainCMD = "SINKCTRL";
        String SubCMD = "GetVer";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        String[] retlist = ret.split(";");
        if (retlist[0].equals("SUCCESS")) {
            return retlist[1];
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return this.ErrorCode.ErrStr();
    }

    public int ControlTelPath(byte ChangePath) {
        switch (ChangePath) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return -300;
            }
        }
        return this.SendNReadCMD_int("SINKCTRL", "ControlTelPath", ChangePath, 0, 0, 0, 0);
    }

    public int BathEmerAckRelase() {
        return this.SendNReadCMD_int("SINKCTRL", "BathEmerAckRelase", 0, 0, 0, 0, 0);
    }

    public int EnergyReset() {
        return this.SendNReadCMD_int("SINKCTRL", "EnergyReset", 0, 0, 0, 0, 0);
    }

    public int ControlOutput(byte kind, boolean OnOff) {
        switch (kind) {
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            default: {
                return -300;
            }
        }
        int onoff = 0;
        if (OnOff) {
            onoff = 1;
        }
        return this.SendNReadCMD_int("NOSINKCTRL", "ControlOutput", kind, onoff, 0, 0, 0);
    }

    public int SetWddrCont(boolean Open) {
        return this.SendNReadCMD_int("SINKCTRL", "SetWddrCont", Open ? 2 : 1, 0, 0, 0, 0);
    }

    public int SetWddrOpenDelayCont(int DelayTime) {
        if (DelayTime != 0 && DelayTime != 3 && DelayTime != 5 && DelayTime != 10) {
            Log.w((String)"IGW200dAPI", (String)("[SetWddrOpenDelayCont] DelayTime is Error :" + DelayTime));
            return -1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetWddrOpenDelayCont", DelayTime, 0, 0, 0, 0);
    }

    public static class Data {
        public SenIn senIn = new SenIn();
        public SenOut senOut = new SenOut();
        public TelIn telIn = new TelIn();
        public TelOut telOut = new TelOut();
        public byte TelPath = 0;

        public static class TelOut {
            public boolean DoorPower = false;
            public boolean BellControl = false;
            public boolean DoorMute = false;
            public boolean VideoSelect = false;
        }

        public static class TelIn {
            public boolean TelCall = false;
            public boolean TelCID = false;
            public boolean DoorCall = false;
        }

        public static class SenOut {
            public boolean BathACK = false;
            public boolean EVACDN_AR = false;
            public boolean EnergyReset = false;
        }

        public static class SenIn {
            public boolean Motion = false;
            public boolean Magnetic = false;
            public boolean BathEMER = false;
            public boolean APU = false;
            public boolean EVAC_Home = false;
            public boolean EVAC_UP = false;
        }
    }

    public static final class OUTPUT {
        public static final byte DOOR_POWER = 24;
        public static final byte BELL_CONT = 25;
        public static final byte DOOR_MUTE = 26;
        public static final byte VIDEO_SEL = 27;
    }

    public static final class TEL_PATH {
        public static final byte OFF = 0;
        public static final byte WPAD_TEL = 1;
        public static final byte WPAD_DOOR = 2;
        public static final byte SUB_DOOR = 3;
        public static final byte MOIP_SUB = 4;
    }
}

