/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.annotation.SuppressLint;
import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

@SuppressLint(value={"DefaultLocale"})
public class IGW300API
extends WallPadDevAPI {
    private final String TAG = "IGW300API";
    private final boolean DEBUG_LOG_ON = true;
    public static final String BR_NAME_BASE = "kr.co.icontrols.wallpaddevservice.BR_IGW300_";
    public static final String SENSOR_BR_NAME = "kr.co.icontrols.wallpaddevservice.BR_IGW300_SENSOR_ALARM";
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"IGW300API", (String)s);
    }

    public IGW300API(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("IGW300API create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "IGW300";
        this.data = new Data();
    }

    public int Refresh(boolean real) {
        String MainCMD = null;
        MainCMD = "NOSINKCTRL";
        String SubCMD = "Refresh";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 34) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.senIn.Out_Motion = Boolean.parseBoolean(retlist[index++]);
                this.data.senIn.Magnetic = Boolean.parseBoolean(retlist[index++]);
                int n = ++index;
                this.data.senIn.APU = Boolean.parseBoolean(retlist[n]);
                int n2 = ++index;
                this.data.senIn.EVAC_Home = Boolean.parseBoolean(retlist[n2]);
                int n3 = ++index;
                this.data.senIn.EVAC_UP = Boolean.parseBoolean(retlist[n3]);
                int n4 = ++index;
                ++index;
                this.data.senIn.In_Motion = Boolean.parseBoolean(retlist[n4]);
                index = 9;
                int n5 = ++index;
                ++index;
                this.data.senOut.EVACDN_AR = Boolean.parseBoolean(retlist[n5]);
                ++index;
                index = 17;
                this.data.telIn.TelCall = Boolean.parseBoolean(retlist[index++]);
                int n6 = ++index;
                ++index;
                this.data.telIn.DoorCall = Boolean.parseBoolean(retlist[n6]);
                index = 25;
                this.data.telOut.DoorPower = Boolean.parseBoolean(retlist[index++]);
                this.data.telOut.BellControl = Boolean.parseBoolean(retlist[index++]);
                int n7 = ++index;
                ++index;
                this.data.telOut.VideoSelect = Boolean.parseBoolean(retlist[n7]);
                index = 33;
                this.data.TelPath = Byte.parseByte(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"IGW300API", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                Log.e((String)"IGW300API", (String)("[Refresh] - " + e.toString()));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public String GetVer() {
        String MainCMD = "SINKCTRL";
        String SubCMD = "GetVer";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        String[] retlist = ret.split(";");
        if (retlist[0].equals("SUCCESS")) {
            return retlist[1];
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return this.ErrorCode.ErrStr();
    }

    public int ControlTelPath(byte ChangePath) {
        switch (ChangePath) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                return -300;
            }
        }
        return this.SendNReadCMD_int("SINKCTRL", "ControlTelPath", ChangePath, 0, 0, 0, 0);
    }

    public int ControlOutput(byte kind, boolean OnOff) {
        switch (kind) {
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 27: {
                break;
            }
            default: {
                return -300;
            }
        }
        int onoff = 0;
        if (OnOff) {
            onoff = 1;
        }
        return this.SendNReadCMD_int("NOSINKCTRL", "ControlOutput", kind, onoff, 0, 0, 0);
    }

    public int SetWddrCont(boolean Open) {
        return this.SendNReadCMD_int("SINKCTRL", "SetWddrCont", Open ? 2 : 1, 0, 0, 0, 0);
    }

    public int SetWddrOpenDelayCont(int DelayTime) {
        if (DelayTime != 0 && DelayTime != 3 && DelayTime != 5 && DelayTime != 10) {
            Log.w((String)"IGW300API", (String)("[SetWddrOpenDelayCont] DelayTime is Error :" + DelayTime));
            return -1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetWddrOpenDelayCont", DelayTime, 0, 0, 0, 0);
    }

    public EmLockData GetEmLockStatus() {
        String ret = this.SendNReadCMD_str("SINKCTRL", "GetEmLockStatus", 0, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist.length != 3) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            EmLockData emLockData = new EmLockData();
            try {
                index = 1;
                emLockData.OnOff = Boolean.parseBoolean(retlist[index++]);
                emLockData.Time = Integer.parseInt(retlist[index++]);
                return emLockData;
            }
            catch (Exception e) {
                Log.e((String)"IGW300API", (String)("[GetEmLockStatus] - [Exception Error] Parse (" + index + ")"));
                Log.e((String)"IGW300API", (String)("[GetEmLockStatus] - " + e.toString()));
                e.printStackTrace();
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    public int SetEmLockCont(boolean OnOff, int Time) {
        if (Time > 100) {
            Log.w((String)"IGW300API", (String)("[SetEmLockCont] Time is Error :" + Time));
            return -1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetEmLockCont", OnOff ? 1 : 0, Time, 0, 0, 0);
    }

    public class EmLockData {
        public boolean OnOff = false;
        public int Time = 0;

        private EmLockData() {
        }
    }

    public static class Data {
        public SenIn senIn = new SenIn();
        public SenOut senOut = new SenOut();
        public TelIn telIn = new TelIn();
        public TelOut telOut = new TelOut();
        public byte TelPath = 0;

        public static class TelOut {
            public boolean DoorPower = false;
            public boolean BellControl = false;
            public boolean VideoSelect = false;
        }

        public static class TelIn {
            public boolean TelCall = false;
            public boolean DoorCall = false;
        }

        public static class SenOut {
            public boolean EVACDN_AR = false;
        }

        public static class SenIn {
            public boolean Out_Motion = false;
            public boolean Magnetic = false;
            public boolean APU = false;
            public boolean EVAC_Home = false;
            public boolean EVAC_UP = false;
            public boolean In_Motion = false;
        }
    }

    public static final class OUTPUT {
        public static final byte DOOR_POWER = 24;
        public static final byte BELL_CONT = 25;
        public static final byte VIDEO_SEL = 27;
    }

    public static final class TEL_PATH {
        public static final byte OFF = 0;
        public static final byte WPAD_TEL = 1;
        public static final byte WPAD_DOOR = 2;
        public static final byte SUB_DOOR = 3;
        public static final byte MOIP_SUB = 4;
        public static final byte SUB_TEL = 5;
        public static final byte WPAD_DOOR__TEL_HOLD = 6;
    }
}

