/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Debug;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Utility {
    public static TimeZone pcTimeZone = TimeZone.getDefault();
    public static int ONE_HOUR_MILI = 3600000;
    private static SimpleDateFormat pcDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static SimpleDateFormat dvrDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static TimeZone dvrTimeZone = null;
    public static final int MSG_STREAMINFO = 5;
    public static final int MSG_IS_NET_ERROR = 6;
    public static final int MSG_CONTENTINFO = 7;
    private static int prevDVRTimeZoneMili;

    static {
        pcDateFormat.setTimeZone(pcTimeZone);
        prevDVRTimeZoneMili = -100;
    }

    public static long getDVRLocalTimeMili(long dvrGMTMili, long dvrTimeZoneMili, boolean isDVRDST) {
        return dvrGMTMili + Utility.getTimeDiffDVRtoPCMili(dvrTimeZoneMili, isDVRDST);
    }

    public static long getTimeDiffDVRtoPCMili(long dvrTimeZoneMili, boolean isDVRDST) {
        if (isDVRDST) {
            return dvrTimeZoneMili + (long)ONE_HOUR_MILI - (long)(pcTimeZone.getRawOffset() + pcTimeZone.getDSTSavings());
        }
        return dvrTimeZoneMili - (long)(pcTimeZone.getRawOffset() + pcTimeZone.getDSTSavings());
    }

    public static String getDVRLocalTime(long dvrGMTMili, int dvrTimeZoneMili, boolean isDVRDST) {
        if (prevDVRTimeZoneMili != dvrTimeZoneMili || prevDVRTimeZoneMili == -100) {
            prevDVRTimeZoneMili = dvrTimeZoneMili;
            Utility.updateDVRTimeZone(0);
        }
        return Utility.getDVRLocalTime(dvrGMTMili + (long)prevDVRTimeZoneMili, isDVRDST);
    }

    private static void updateDVRTimeZone(int dvrTimeZoneMili) {
        String[] tz = TimeZone.getAvailableIDs(dvrTimeZoneMili);
        dvrTimeZone = TimeZone.getTimeZone(tz[0]);
        dvrDateFormat.setTimeZone(dvrTimeZone);
    }

    private static String getDVRLocalTime(long dvrGMTMili, boolean isDVRDST) {
        if (isDVRDST) {
            return dvrDateFormat.format(new Date(dvrGMTMili + (long)ONE_HOUR_MILI));
        }
        return dvrDateFormat.format(new Date(dvrGMTMili));
    }

    public static int getStrLength(byte[] _byte, int length) {
        int i = 0;
        while (i < length) {
            if (_byte[i] == 0) {
                return i;
            }
            ++i;
        }
        return length;
    }

    public static byte[] intTobyte(int integer, ByteOrder order) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.order(order);
        buff.putInt(integer);
        return buff.array();
    }

    public static void intToByte(byte[] target, int index, int value) {
        int size = 4;
        int i = 0;
        while (i < 4) {
            int offset = i * 8;
            target[index + i] = (byte)(value >> offset & 0xFF);
            ++i;
        }
    }

    public static int byteToInt(byte[] value, int index) {
        int size = 4;
        int ret = 0;
        int i = 0;
        while (i < 4) {
            int shift = i * 8;
            ret += (value[i + index] & 0xFF) << shift;
            ++i;
        }
        return ret;
    }

    public static void insertBuf_int(byte[] buf, int[] buf_index, int value) {
        int index = buf_index[0];
        buf[index + 0] = (byte)(value >> 24 & 0xFF);
        buf[index + 1] = (byte)(value >> 16 & 0xFF);
        buf[index + 2] = (byte)(value >> 8 & 0xFF);
        buf[index + 3] = (byte)(value & 0xFF);
        buf_index[0] = buf_index[0] + 4;
    }

    public static void insertBuf_short(byte[] buf, int[] buf_index, short value) {
        int index = buf_index[0];
        buf[index] = (byte)(value >> 8 & 0xFF);
        buf[index + 1] = (byte)(value & 0xFF);
        buf_index[0] = buf_index[0] + 2;
    }

    public static void insertBuf_byte(byte[] buf, int[] buf_index, byte value) {
        int index = buf_index[0];
        buf[index] = value;
        buf_index[0] = buf_index[0] + 1;
    }

    public static byte gen_key() {
        return (byte)(System.currentTimeMillis() / 1000L % 127L + 1L);
    }

    public static String byteToString(char[] buf, int start, int end) {
        int i = 0;
        while (i < end) {
            if (buf[start + i] == '\u0000') {
                end = i;
                break;
            }
            ++i;
        }
        char[] tmpbuff = new char[end];
        i = 0;
        while (i < end) {
            char temp;
            tmpbuff[i] = temp = buf[i + start];
            ++i;
        }
        String str = new String(tmpbuff);
        return str;
    }

    public static void try2SleepMilliSec(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void saveBitmaptoJpeg(Bitmap bitmap, String folder, String name) {
        String ex_storage = Environment.getExternalStorageDirectory().getAbsolutePath();
        String foler_name = "/" + folder + "/";
        String file_name = String.valueOf(name) + ".jpg";
        String string_path = String.valueOf(ex_storage) + foler_name;
        try {
            File file_path = new File(string_path);
            if (!file_path.isDirectory()) {
                file_path.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(String.valueOf(string_path) + file_name);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException exception) {
            Log.e((String)"FileNotFoundException", (String)exception.getMessage());
        }
        catch (IOException exception) {
            Log.e((String)"IOException", (String)exception.getMessage());
        }
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static void PrintProcessMemory(Context context, String strProcessName) {
        long total = Debug.getNativeHeapSize();
        long free = Debug.getNativeHeapFreeSize();
        long alloc = Debug.getNativeHeapAllocatedSize();
        Log.d((String)"WebEye", (String)("total(" + total + "), free(" + free + "), alloc(" + alloc + ")"));
        Log.d((String)"WebEye", (String)("use " + (total - free) + "/" + total));
    }
}

