/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Pair;
import com.wgi.libwebeye.BaseNetCtrl;
import com.wgi.libwebeye.ContentInfo;
import com.wgi.libwebeye.ImageDecoder;
import com.wgi.libwebeye.JWebEyeParm;
import com.wgi.libwebeye.MonitorInterface;
import com.wgi.libwebeye.StreamInfo;
import com.wgi.libwebeye.Utility;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class MonitorNetCtrl
extends BaseNetCtrl {
    private String TAG = "WebEye_MonitorNetCtrl ";
    private int division = 4;
    public boolean isChannelPicker = false;
    private int streamType = 6;
    public int addFunction = 0;
    private boolean bResolutionMap = false;
    static final int MAX_FRAME_SIZE = 512032;
    static final int ERR_NO_VIDEO = 69633;
    static final int ERR_DISABLED_CHANNEL = 69634;
    public static final byte CONT_VID = 0;
    public static final byte CONT_AUD = 1;
    public static final byte RES_TINY = 0;
    public static final byte RES_QCIF = 1;
    public static final byte RES_CIF = 2;
    public static final byte RES_HALF = 3;
    public static final byte RES_FULL = 4;
    public static final byte RES_M_QCIF = 5;
    public static final byte RES_M_CIF = 6;
    public static final byte RES_M_HALF = 7;
    public static final byte RES_M_D1 = 8;
    public static final byte RES_720P = 9;
    public static final byte RES_SXGA = 10;
    public static final byte RES_1080P = 11;
    public static final String S_HALF = "HALF";
    public static final String S_FULL = "FULL";
    public static final String S_QHD = "QHD";
    public static final String S_180p = "180p";
    public static final String S_QFHD = "QFHD";
    public static final String S_q960H = "q960H";
    public static final String S_NHD = "nHD";
    public static final String SS_QHD = "qHD";
    public static final String S_FHD = "FHD";
    public static final String S_960H = "960H";
    public boolean usedInChannelPicker = false;
    public int channel_picker_checker = 0;
    private ImageDecoder image_decoder;
    private StreamInfo[] streams = null;
    private ContentInfo[] contents = null;
    private boolean bServiceStarted = false;
    ArrayList<Pair<String, String>> resolutionlist = new ArrayList();
    private int codecInitChecker = 0;
    private static ArrayList<MonitorNetCtrl> Ctrl_array = new ArrayList();
    public boolean bSupportPTZ = false;
    private boolean bCheckMemory = false;
    private long lPrevTick = 0L;
    private Context parent;
    static byte[][] static_buf = new byte[32][];
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    Handler initImageDecodeHandle = new Handler(){

        public void handleMessage(Message msg) {
            if (MonitorNetCtrl.this.image_decoder != null) {
                MonitorNetCtrl.this.image_decoder.close();
                MonitorNetCtrl.this.image_decoder = null;
                MonitorNetCtrl.this.image_decoder = new ImageDecoder((MonitorInterface)MonitorNetCtrl.this.webeyeParm.webeyeService, MonitorNetCtrl.this.webeyeParm.channelNum, true);
                MonitorNetCtrl.this.image_decoder.initCodec(MonitorNetCtrl.this.webeyeParm);
                ((MonitorNetCtrl)MonitorNetCtrl.this).image_decoder.is_Nal_analysis = 1;
            } else {
                Log.e((String)MonitorNetCtrl.this.TAG, (String)"image_decoder is null");
            }
        }
    };

    static {
        System.loadLibrary("decoder");
    }

    public MonitorNetCtrl(JWebEyeParm _parm, Context main) {
        this.webeyeParm = _parm;
        this.TAG = String.valueOf(this.TAG) + _parm.channelNum;
        Ctrl_array.add(this);
        this.codecInitChecker = 0;
        this.parent = main;
    }

    public void requestContentInfo() {
        byte[] header = new byte[12];
        if (this.contents != null) {
            this.contents = null;
        }
        this.writeHeader(header, 0, 4, 1);
        try {
            if (this.outStream == null) {
                Log.e((String)this.TAG, (String)"socket is null");
                return;
            }
            this.outStream.write(header);
            this.outStream.write(-1);
            this.outStream.flush();
            Log.d((String)this.TAG, (String)" request content info");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestStreamsInfo() {
        byte[] header = new byte[12];
        if (this.streams != null) {
            this.streams = null;
        }
        this.writeHeader(header, 0, 10, 1);
        try {
            if (this.outStream == null) {
                Log.e((String)this.TAG, (String)"socket is null");
                return;
            }
            this.outStream.write(header);
            this.outStream.write((byte)this.webeyeParm.channelNum);
            this.outStream.flush();
            Log.d((String)this.TAG, (String)("Channel " + this.webeyeParm.channelNum + " request stream info"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestResolutionMap() {
        byte[] header = new byte[12];
        byte[] empty = new byte[4];
        if (this.streams != null) {
            this.streams = null;
        }
        this.writeHeader(header, 0, 12, 4);
        try {
            this.outStream.write(header);
            this.outStream.write(empty);
            this.outStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (this.RequestLogin() != 0) {
            this.webeyeParm.webeyeService.loginFail(this.webeyeParm, -1);
            this.onDisconnect();
            return;
        }
        long lastSendTime = System.currentTimeMillis();
        this.isNetError = false;
        BaseNetCtrl.JWESP10Header resHeader = new BaseNetCtrl.JWESP10Header();
        while (!this.isTerminate) {
            if (this.bCheckMemory) {
                if (this.lPrevTick == 0L) {
                    this.lPrevTick = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.lPrevTick >= 3000L) {
                    Utility.PrintProcessMemory(this.parent, "com.wgi.WebEye");
                    this.lPrevTick = System.currentTimeMillis();
                }
            }
            if (this.isConnected && !this.isNetError) {
                if (!this.readHeader(resHeader)) {
                    this.isNetError = true;
                    Log.e((String)this.TAG, (String)"is Net Error :  readHeader(resHeader) == false");
                } else {
                    if (resHeader.errorCode != 0 && resHeader.categoryId == 1) {
                        if (resHeader.errorCode == 69634) {
                            switch (this.webeyeParm.monNum) {
                                case 2: {
                                    ((MonitorInterface)this.webeyeParm.webeyeService).displayImage2(null, true, this.webeyeParm.channelNum);
                                    break;
                                }
                                case 3: {
                                    ((MonitorInterface)this.webeyeParm.webeyeService).displayImage3(null, true, this.webeyeParm.channelNum);
                                    break;
                                }
                                case 4: {
                                    ((MonitorInterface)this.webeyeParm.webeyeService).displayImage4(null, true, this.webeyeParm.channelNum);
                                    break;
                                }
                                default: {
                                    ((MonitorInterface)this.webeyeParm.webeyeService).displayImage(null, true, this.webeyeParm.channelNum);
                                    break;
                                }
                            }
                        } else {
                            this.webeyeParm.webeyeService.loginFail(this.webeyeParm, resHeader.errorCode);
                            try {
                                this.inStream.close();
                                this.inStream = null;
                                if (this.RequestLogin() != 0) {
                                    this.webeyeParm.webeyeService.loginFail(this.webeyeParm, -1);
                                    this.onDisconnect();
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.inStream == null) {
                        Log.e((String)this.TAG, (String)">>>>>>>>>>> Stream is null");
                        return;
                    }
                    if (resHeader.bodySize >= 0) {
                        this.processingMessage(resHeader, this.inStream);
                    } else {
                        Log.e((String)this.TAG, (String)("errorCode : " + resHeader.errorCode + " bodySize : " + resHeader.bodySize + " commandID : " + resHeader.commandId + " categoryID : " + resHeader.categoryId));
                    }
                    try {
                        MonitorNetCtrl.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                long curTime = System.currentTimeMillis();
                if (curTime - lastSendTime <= 15000L) continue;
                this.sendKeepAlive();
                lastSendTime = curTime;
                continue;
            }
            if (!this.isConnected) {
                Log.e((String)this.TAG, (String)"Thread : in not connected");
            }
            if (this.isNetError) {
                Log.e((String)this.TAG, (String)"Thread : is Net Error");
                ((MonitorInterface)this.webeyeParm.webeyeService).getHandler().obtainMessage(6, this.webeyeParm.monNum, this.webeyeParm.channelNum).sendToTarget();
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        resHeader = null;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    /*
     * Exception decompiling
     */
    private void processingMessage(BaseNetCtrl.JWESP10Header header, DataInputStream stream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CASE]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void onReceiveFrame(DataInputStream stream, int bodySize) {
        try {
            if (bodySize == 0) {
                return;
            }
            int encType = 3;
            boolean res = false;
            byte contentType = stream.readByte();
            if (contentType != 0) {
                return;
            }
            byte frameVer = stream.readByte();
            int frameCount = stream.readShort();
            int i = 0;
            while (i < frameCount) {
                byte chNum = stream.readByte();
                if (chNum != this.webeyeParm.channelNum) {
                    return;
                }
                int errorCode = stream.readInt();
                if (errorCode != 0) {
                    return;
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("Exception occured");
        }
    }

    public int changeService(JWebEyeParm parm) {
        if (this.image_decoder == null) {
            this.image_decoder = new ImageDecoder((MonitorInterface)this.webeyeParm.webeyeService, this.webeyeParm.channelNum, this.isChannelPicker);
        } else if (!this.isChannelPicker && this.image_decoder.isRunning()) {
            this.image_decoder.close();
            this.image_decoder = null;
        }
        this.startService(parm);
        return 0;
    }

    public int startService(JWebEyeParm parm, boolean requestMode) {
        this.webeyeParm = parm;
        int result = this.startService(requestMode);
        return result;
    }

    public int pauseService() {
        return 0;
    }

    public int resumeService() {
        byte[] header;
        block13: {
            if (this.image_decoder == null) {
                return -999;
            }
            if (this.image_decoder.isRunning()) {
                this.image_decoder.close();
                this.image_decoder = null;
            } else {
                this.image_decoder.close();
                this.image_decoder = null;
            }
            this.image_decoder = new ImageDecoder((MonitorInterface)this.webeyeParm.webeyeService, this.webeyeParm.channelNum, this.isChannelPicker);
            header = new byte[12];
            this.streamType = this.webeyeParm.getEncType();
            if (this.streamType == 4) {
                this.writeHeader(header, 0, 6, 44);
                this.webeyeParm.requestMode = 0;
            } else if (this.streamType == 3) {
                this.writeHeader(header, 0, 6, 44);
                if ((this.addFunction & 8) == 8) {
                    this.webeyeParm.requestMode = 1;
                }
            } else if (this.streamType == 6) {
                this.writeHeader(header, 0, 6, 44);
                this.webeyeParm.requestMode = 0;
            } else {
                this.writeHeader(header, 0, 6, 30);
            }
            try {
                if (this.outStream != null) break block13;
                return -1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        this.outStream.write(header, 0, header.length);
        this.bSupportPTZ = false;
        ((MonitorInterface)this.webeyeParm.webeyeService).onPTZEnable(this.webeyeParm.monNum, this.bSupportPTZ);
        return this.sendVideoRequestBody();
    }

    public int startServiceChannel(JWebEyeParm parm, int[] channelNumber, int channelCount) {
        this.webeyeParm = parm;
        int result = this.startService(channelNumber, channelCount);
        return result;
    }

    public int startService(JWebEyeParm parm) {
        this.webeyeParm = parm;
        int result = this.startService(false);
        return result;
    }

    private int startService(int[] channelNumber, int channelCount) {
        byte[] header;
        block12: {
            if (this.webeyeParm == null) {
                return -1;
            }
            Log.d((String)this.TAG, (String)("startService(" + channelCount + ")"));
            if (this.image_decoder == null) {
                this.image_decoder = new ImageDecoder((MonitorInterface)this.webeyeParm.webeyeService, this.webeyeParm.channelNum, this.isChannelPicker);
            }
            header = new byte[12];
            this.streamType = this.webeyeParm.getEncType();
            if (this.streamType == 4) {
                this.writeHeader(header, 0, 6, 4 + 40 * channelCount);
                this.webeyeParm.requestMode = 0;
            } else if (this.streamType == 3) {
                this.writeHeader(header, 0, 6, 4 + 40 * channelCount);
                if ((this.addFunction & 8) == 8) {
                    this.webeyeParm.requestMode = 0;
                }
            } else if (this.streamType == 6) {
                this.writeHeader(header, 0, 6, 4 + 40 * channelCount);
                this.webeyeParm.requestMode = 0;
            } else {
                this.writeHeader(header, 0, 6, 30);
            }
            try {
                if (this.outStream != null) break block12;
                return -1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        this.outStream.write(header, 0, header.length);
        this.bSupportPTZ = false;
        ((MonitorInterface)this.webeyeParm.webeyeService).onPTZEnable(this.webeyeParm.monNum, this.bSupportPTZ);
        return this.sendVideoRequestBody(channelNumber, channelCount);
    }

    private int startService(boolean requestMode) {
        byte[] header;
        block12: {
            if (this.webeyeParm == null) {
                return -1;
            }
            if (this.image_decoder == null) {
                this.image_decoder = new ImageDecoder((MonitorInterface)this.webeyeParm.webeyeService, this.webeyeParm.channelNum, this.isChannelPicker);
            }
            header = new byte[12];
            this.streamType = this.webeyeParm.getEncType();
            if (this.streamType == 4) {
                this.writeHeader(header, 0, 6, 44);
                this.webeyeParm.requestMode = 0;
            } else if (this.streamType == 3) {
                this.writeHeader(header, 0, 6, 44);
                if ((this.addFunction & 8) == 8) {
                    this.webeyeParm.requestMode = 0;
                }
            } else if (this.streamType == 6) {
                this.writeHeader(header, 0, 6, 44);
                this.webeyeParm.requestMode = requestMode ? 1 : 0;
            } else {
                this.writeHeader(header, 0, 6, 30);
            }
            try {
                if (this.outStream != null) break block12;
                return -1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        this.outStream.write(header, 0, header.length);
        this.bSupportPTZ = false;
        ((MonitorInterface)this.webeyeParm.webeyeService).onPTZEnable(this.webeyeParm.monNum, this.bSupportPTZ);
        return this.sendVideoRequestBody();
    }

    private int sendVideoRequestBody(int[] channelNumber, int channelCount) {
        Log.d((String)this.TAG, (String)("sendVideoRequestBody(" + channelCount + ")"));
        try {
            this.outStream.writeInt(channelCount);
            int i = 0;
            while (i < channelCount) {
                this.outStream.writeByte(0);
                if (this.streamType == 3 || this.streamType == 4 || this.streamType == 6) {
                    this.outStream.writeByte(this.streamType);
                } else {
                    this.outStream.writeByte(0);
                }
                this.outStream.writeByte((byte)this.webeyeParm.requestMode);
                this.outStream.writeByte((byte)channelNumber[i]);
                System.out.println("sendVideoRequestBody Channel " + channelNumber[i]);
                if (this.streamType == 3 || this.streamType == 4 || this.streamType == 6) {
                    this.outStream.writeInt(32);
                } else {
                    this.outStream.writeInt(28);
                }
                this.outStream.writeInt(0);
                this.outStream.writeShort(0);
                this.outStream.writeInt(this.webeyeParm.frameRate << 24);
                if (this.bResolutionMap) {
                    this.outStream.writeByte((byte)this.webeyeParm.getResolution());
                } else {
                    this.outStream.writeByte((byte)this.webeyeParm.getResolution());
                }
                this.outStream.writeInt(this.webeyeParm.alarmFrameRate << 24);
                this.outStream.writeByte((byte)this.webeyeParm.alarmResolution);
                this.outStream.writeInt(this.webeyeParm.alarmMask_upper);
                this.outStream.writeInt(this.webeyeParm.alarmMask_lower);
                this.outStream.writeInt(this.webeyeParm.alarmDuration);
                if (this.webeyeParm.getEncType() == 3 || this.webeyeParm.getEncType() == 4 || this.webeyeParm.getEncType() == 6) {
                    this.outStream.writeByte((byte)this.webeyeParm.encQuality);
                    this.outStream.writeByte(this.webeyeParm.getEncType());
                    this.outStream.writeByte((byte)this.webeyeParm.encQuality);
                    this.outStream.writeByte(0);
                }
                ++i;
            }
            this.outStream.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    private int sendVideoRequestBody() {
        Log.d((String)this.TAG, (String)"sendVideoRequestBody");
        try {
            this.outStream.writeInt(1);
            this.outStream.writeByte(0);
            if (this.streamType == 3 || this.streamType == 4 || this.streamType == 6) {
                this.outStream.writeByte(this.streamType);
            } else {
                this.outStream.writeByte(0);
            }
            this.outStream.writeByte((byte)this.webeyeParm.requestMode);
            this.outStream.writeByte((byte)this.webeyeParm.channelNum);
            if (this.streamType == 3 || this.streamType == 4 || this.streamType == 6) {
                this.outStream.writeInt(32);
            } else {
                this.outStream.writeInt(28);
            }
            this.outStream.writeInt(0);
            this.outStream.writeShort(0);
            this.outStream.writeInt(this.webeyeParm.frameRate << 24);
            if (this.bResolutionMap) {
                this.outStream.writeByte((byte)this.webeyeParm.getResolution());
            } else {
                this.outStream.writeByte((byte)this.webeyeParm.getResolution());
            }
            this.outStream.writeInt(this.webeyeParm.alarmFrameRate << 24);
            this.outStream.writeByte((byte)this.webeyeParm.alarmResolution);
            this.outStream.writeInt(this.webeyeParm.alarmMask_upper);
            this.outStream.writeInt(this.webeyeParm.alarmMask_lower);
            this.outStream.writeInt(this.webeyeParm.alarmDuration);
            if (this.webeyeParm.getEncType() == 3 || this.webeyeParm.getEncType() == 4 || this.webeyeParm.getEncType() == 6) {
                this.outStream.writeByte((byte)this.webeyeParm.encQuality);
                this.outStream.writeByte(this.webeyeParm.getEncType());
                this.outStream.writeByte((byte)this.webeyeParm.encQuality);
                this.outStream.writeByte(0);
            }
            this.outStream.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    public int stopService() {
        byte[] header;
        block5: {
            if (this.webeyeParm == null) {
                return -1;
            }
            this.bServiceStarted = false;
            System.out.println("stopService : " + this.webeyeParm.monNum);
            header = new byte[12];
            this.writeHeader(header, 0, 7, 8);
            try {
                if (this.outStream != null) break block5;
                return -1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        this.outStream.write(header, 0, header.length);
        this.outStream.writeInt(1);
        this.outStream.writeByte(0);
        this.outStream.writeShort(0);
        this.outStream.writeByte(this.webeyeParm.channelNum);
        this.outStream.flush();
        Log.d((String)this.TAG, (String)("outStream write : stopService " + this.webeyeParm.channelNum));
        if (this.image_decoder != null) {
            this.image_decoder.close();
            this.image_decoder = null;
            this.webeyeParm.sizeSet = 0;
        }
        return 0;
    }

    public int stopService_channelPicker() {
        byte[] header;
        block5: {
            if (this.webeyeParm == null) {
                return -1;
            }
            header = new byte[12];
            this.writeHeader(header, 0, 7, 8);
            try {
                if (this.outStream != null) break block5;
                return -1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        this.outStream.write(header, 0, header.length);
        this.outStream.writeInt(1);
        this.outStream.writeByte(0);
        this.outStream.writeShort(0);
        this.outStream.writeByte(this.webeyeParm.channelNum);
        this.outStream.flush();
        Log.d((String)this.TAG, (String)("outStream write : stopService " + this.webeyeParm.channelNum));
        if (this.image_decoder != null) {
            this.image_decoder.close();
            this.image_decoder = null;
            this.webeyeParm.sizeSet = 0;
        }
        return 0;
    }

    @Override
    public void onDisconnect() {
        if (this.image_decoder != null) {
            this.image_decoder.close();
            this.image_decoder = null;
        }
        super.onDisconnect();
    }

    private int sendAck() {
        byte[] header;
        block4: {
            if (this.webeyeParm == null || !this.isConnected) {
                return -1;
            }
            header = new byte[12];
            this.writeHeader(header, 3, 6, 4);
            try {
                if (this.outStream != null) break block4;
                return -1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        this.outStream.write(header, 0, header.length);
        this.outStream.writeByte(1);
        this.outStream.writeShort(0);
        this.outStream.writeByte(this.webeyeParm.channelNum);
        this.outStream.flush();
        return 0;
    }

    public void setDivision(int num) {
        Log.d((String)this.TAG, (String)("set Division : " + num));
        this.division = num;
    }
}

