/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import android.util.Log;
import com.wgi.libwebeye.JWebEyeInterface;
import com.wgi.libwebeye.StreamInfo;

public class JWebEyeParm {
    private static final String TAG = "WebEye_JWebEyeParm";
    public static final short MAGIC3_HD400MX = 4157;
    public static final short MAGIC4_HD400MX = 232;
    public static final short MAGIC3_HD401MX = 4160;
    public static final short MAGIC4_HD401MX = 235;
    public JWebEyeInterface webeyeService;
    public String alias = "";
    public String username = "guest";
    public String password = "guest";
    public String address = "192.168.0.11";
    public int port = 80;
    public int cnt_channel = 1;
    public int channelNum = 1;
    public int requestMode = 0;
    public int frameRate = 30;
    public int resolution = 2;
    public int alarmFrameRate = 8;
    public int alarmResolution = 2;
    public int alarmMask_upper = -1;
    public int alarmMask_lower = -1;
    public int alarmDuration = 0;
    private int encType = 6;
    public int encQuality = 10;
    public int category = -1;
    public short[] magicNum = null;
    public String resolution_name = "CIF";
    private boolean isShowPalRegion = false;
    public int win_dvr = 0;
    public String serial = "";
    public int monNum = -1;
    private int src_width = 352;
    private int src_height = 240;
    public StreamInfo playbackstream1;
    public StreamInfo playbackstream2;
    public int isSecondStream;
    public int sizeSet = 0;

    public int getWidth() {
        return this.src_width;
    }

    public int getHeight() {
        return this.src_height;
    }

    public void setScreenSize(int width, int height) {
        this.src_width = width;
        this.src_height = height;
    }

    public void setStreamInfo(StreamInfo info) {
        if (info == null) {
            return;
        }
        this.encType = info.encoding_type;
        this.frameRate = info.frame_rate;
        this.resolution = info.resolution;
        this.resolution_name = info.stream_name;
        this.encQuality = info.quality;
        this.alarmFrameRate = info.alarm_frame_rate;
        this.alarmResolution = info.alarm_resolution;
        this.isShowPalRegion = info.signal_type != 0;
        this.setSrc();
    }

    public void setEncType(int encType) {
        this.encType = encType;
        this.setSrc();
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void setResolutionName(String resolution_name) {
        this.resolution_name = resolution_name;
        this.setSrc();
    }

    public int getSrc_width() {
        return this.src_width;
    }

    public int getSrc_height() {
        return this.src_height;
    }

    public int getResolution() {
        return this.resolution;
    }

    public String getResolutionName() {
        return this.resolution_name;
    }

    public int getEncType() {
        return this.encType;
    }

    public boolean isShowPalRegion() {
        return this.isShowPalRegion;
    }

    private void setSrc() {
        if (this.isShowPalRegion) {
            switch (this.resolution) {
                case 0: {
                    this.src_width = 92;
                    this.src_height = 72;
                    break;
                }
                case 1: 
                case 2: {
                    this.src_width = 352;
                    this.src_height = 288;
                    break;
                }
                case 3: {
                    if (this.resolution_name.equals("QHD")) {
                        this.src_width = 320;
                        this.src_height = 180;
                        break;
                    }
                    if (this.resolution_name.equals("180p")) {
                        this.src_width = 320;
                        this.src_height = 176;
                        break;
                    }
                    this.src_width = 704;
                    this.src_height = 288;
                    break;
                }
                case 4: {
                    if (this.resolution_name.equals("QFHD")) {
                        this.src_width = 480;
                        this.src_height = 270;
                        break;
                    }
                    this.src_width = 704;
                    this.src_height = 576;
                    break;
                }
                case 5: {
                    if (this.resolution_name.equals("q960H")) {
                        this.src_width = 480;
                        this.src_height = 288;
                        break;
                    }
                    this.src_width = 176;
                    this.src_height = 144;
                    break;
                }
                case 6: {
                    if (this.resolution_name.equals("nHD")) {
                        this.src_width = 640;
                        this.src_height = 360;
                        break;
                    }
                    this.src_width = 352;
                    this.src_height = 288;
                    break;
                }
                case 7: {
                    this.src_width = 720;
                    this.src_height = 288;
                    break;
                }
                case 8: {
                    if (this.resolution_name.equals("qHD")) {
                        this.src_width = 960;
                        this.src_height = 540;
                        break;
                    }
                    if (this.resolution_name.equals("960H")) {
                        this.src_width = 960;
                        this.src_height = 576;
                        break;
                    }
                    this.src_width = 720;
                    this.src_height = 576;
                    break;
                }
                case 9: {
                    this.src_width = 1280;
                    this.src_height = 720;
                    break;
                }
                case 10: {
                    this.src_width = 1280;
                    this.src_height = 1024;
                    break;
                }
                case 11: {
                    if (this.resolution_name.equals("FHD")) {
                        this.src_width = 1920;
                        this.src_height = 1080;
                        break;
                    }
                    if (this.magicNum != null && this.magicNum[2] == 4157 && this.magicNum[3] == 232) {
                        this.src_width = 1920;
                        this.src_height = 1080;
                        break;
                    }
                    if (this.magicNum != null && this.magicNum[2] == 4160 && this.magicNum[3] == 235) {
                        this.src_width = 1920;
                        this.src_height = 1080;
                        break;
                    }
                    this.src_width = 1920;
                    this.src_height = 1088;
                    break;
                }
                default: {
                    Log.i((String)TAG, (String)("Codec Init Error, resolution : " + this.resolution));
                    break;
                }
            }
        } else {
            switch (this.resolution) {
                case 0: {
                    this.src_width = 90;
                    this.src_height = 60;
                    break;
                }
                case 1: 
                case 2: {
                    this.src_width = 352;
                    this.src_height = 240;
                    break;
                }
                case 3: {
                    if (this.resolution_name.equals("QHD")) {
                        this.src_width = 320;
                        this.src_height = 180;
                        break;
                    }
                    if (this.resolution_name.equals("180p")) {
                        this.src_width = 320;
                        this.src_height = 176;
                        break;
                    }
                    this.src_width = 704;
                    this.src_height = 240;
                    break;
                }
                case 4: {
                    if (this.resolution_name.equals("QFHD")) {
                        this.src_width = 480;
                        this.src_height = 270;
                        break;
                    }
                    this.src_width = 704;
                    this.src_height = 480;
                    break;
                }
                case 5: {
                    if (this.resolution_name.equals("q960H")) {
                        this.src_width = 480;
                        this.src_height = 240;
                        break;
                    }
                    this.src_width = 176;
                    this.src_height = 120;
                    break;
                }
                case 6: {
                    if (this.resolution_name.equals("nHD")) {
                        this.src_width = 640;
                        this.src_height = 360;
                        break;
                    }
                    this.src_width = 352;
                    this.src_height = 240;
                    break;
                }
                case 7: {
                    this.src_width = 720;
                    this.src_height = 240;
                    break;
                }
                case 8: {
                    if (this.resolution_name.equals("qHD")) {
                        this.src_width = 960;
                        this.src_height = 540;
                        break;
                    }
                    if (this.resolution_name.equals("960H")) {
                        this.src_width = 960;
                        this.src_height = 480;
                        break;
                    }
                    this.src_width = 720;
                    this.src_height = 480;
                    break;
                }
                case 9: {
                    this.src_width = 1280;
                    this.src_height = 720;
                    break;
                }
                case 10: {
                    this.src_width = 1280;
                    this.src_height = 1024;
                    break;
                }
                case 11: {
                    if (this.resolution_name.equals("FHD")) {
                        this.src_width = 1920;
                        this.src_height = 1080;
                        break;
                    }
                    if (this.magicNum != null && this.magicNum[2] == 4157 && this.magicNum[3] == 232) {
                        this.src_width = 1920;
                        this.src_height = 1080;
                        break;
                    }
                    if (this.magicNum != null && this.magicNum[2] == 4160 && this.magicNum[3] == 235) {
                        this.src_width = 1920;
                        this.src_height = 1080;
                        break;
                    }
                    this.src_width = 1920;
                    this.src_height = 1088;
                    break;
                }
                default: {
                    Log.i((String)TAG, (String)("Codec Init Error, resolution : " + this.resolution));
                }
            }
        }
    }

    public JWebEyeParm clone() {
        JWebEyeParm parm = new JWebEyeParm();
        parm.webeyeService = this.webeyeService;
        parm.address = this.address;
        parm.port = this.port;
        parm.encType = this.encType;
        parm.frameRate = this.frameRate;
        parm.password = this.password;
        parm.username = this.username;
        parm.resolution = this.resolution;
        parm.resolution_name = this.resolution_name;
        parm.win_dvr = this.win_dvr;
        parm.serial = this.serial;
        parm.isShowPalRegion = this.isShowPalRegion;
        if (this.magicNum != null) {
            parm.magicNum = (short[])this.magicNum.clone();
        }
        parm.setSrc();
        return parm;
    }
}

