/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.wgi.libwebeye.H264Analyzer;
import com.wgi.libwebeye.JWebEyeParm;
import com.wgi.libwebeye.MonitorInterface;
import com.wgi.libwebeye.PlaybackInterface;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ImageDecoder {
    private String TAG = "WebEye_ImageDecoder ";
    private static final int WAITING_DELAY = 1;
    public static final int DIRECT_BUFFER_MAX = 512000;
    public static final int QUEUE_BUFFER_MAX = 0x240000;
    public static final int PLAY_DELAY_MSEC = 250;
    public static final int PACKET_HEADER_LENGTH = 67;
    private static final int NETWORK_DELAY_TIME_CUT_LINE = 3000;
    private static final int NETWORK_DELAY_OBSERVE_TIME = 5000;
    private static final int DECODE_DELAY_BUFFER_CUT_PERCENT = 70;
    private int QUEUE_BUFFER_DROP_COUNT_RATE = 3;
    private static final ReentrantLock static_lock = new ReentrantLock();
    private final ReentrantLock local_lock = new ReentrantLock();
    public static final int MODE_NONE = -1;
    public static final int MODE_JPEG = 101;
    public static final int MODE_DIRECT = 102;
    public static final int MODE_CIRQUEUE = 103;
    private MonitorInterface render_interface;
    private PlaybackInterface render_interface_playback;
    private int playback_monitor_checker;
    public int channel_picker_checker = 0;
    public int is_Nal_analysis = 0;
    public AsyncTask task;
    private int mode = -1;
    public boolean initCodec = false;
    private int monNum = -1;
    private static boolean[] thread_terminated = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    byte[] extra_buf;
    int res;
    int enc_type;
    int frame_rate = 1;
    public int PB_DIRECTION = 0;
    public boolean preserveQueue = false;
    int widthFromFrame = -1;
    int heightFromFrame = -1;
    private boolean bUseFPS = false;
    private int nFrameCount = 0;
    private long lPrevTick = 0L;
    private boolean bCallFrameStart = false;
    private byte[] extra_buf_jpg;
    int corePoolSize = 60;
    int maximumPoolSize = 80;
    int keepAliveTime = 10;
    BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(this.maximumPoolSize);
    Executor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.workQueue);
    int ffmpeg_err;
    public static final int BUFFER_HOLDER_COUNT = 16;
    private DecodeTask_DIRECT.BufferHolder[][] dBuffer;
    private static byte[] cBuffer = null;
    private static byte[] empty_buffer = null;
    private static final String FFTAG = "WebEye_FFmpeg";
    int codec_res = 0;
    int codec_enc = 0;

    static {
        System.loadLibrary("decoder");
    }

    ImageDecoder(MonitorInterface main, int monNum, boolean isChannelPicker) {
        this.TAG = String.valueOf(this.TAG) + monNum;
        this.playback_monitor_checker = 1;
        this.render_interface = main;
        this.monNum = monNum;
        try {
            this.extra_buf_jpg = isChannelPicker ? new byte[256028] : new byte[512044];
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"ImageDecoder() Exception");
        }
    }

    ImageDecoder(PlaybackInterface main, int monNum) {
        this.TAG = String.valueOf(this.TAG) + monNum;
        this.playback_monitor_checker = 2;
        this.render_interface_playback = main;
        this.monNum = monNum;
    }

    public static void InitFFMPEG() {
        ImageDecoder.initBasicPlayer();
    }

    public void initCodec(JWebEyeParm parm) {
        this.QUEUE_BUFFER_DROP_COUNT_RATE = parm.frameRate / 3;
        if (this.QUEUE_BUFFER_DROP_COUNT_RATE <= 0) {
            this.QUEUE_BUFFER_DROP_COUNT_RATE = parm.frameRate;
        }
        int _width = parm.getSrc_width();
        int _height = parm.getSrc_height();
        this.enc_type = parm.getEncType();
        this.res = parm.getResolution();
        this.frame_rate = parm.frameRate;
        if (this.frame_rate <= 0) {
            Log.w((String)this.TAG, (String)("Codec Init : frame rate is " + this.frame_rate));
            this.frame_rate = 1;
        }
        if (this.task != null) {
            this.close();
        }
        Log.e((String)this.TAG, (String)("ImageDecoder Init (" + this.enc_type + ")"));
        switch (this.enc_type) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.mode = 101;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                int isD1 = 0;
                if (this.res == 4) {
                    isD1 = 1;
                }
                if (this.widthFromFrame != -1 && this.heightFromFrame != -1) {
                    this.mode = this.selectThread(parm.requestMode, this.widthFromFrame, this.heightFromFrame, isD1);
                    break;
                }
                this.mode = this.selectThread(parm.requestMode, _width, _height, isD1);
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)("ImageDecoder Init Error : default case (" + this.enc_type + ")"));
            }
        }
    }

    private int selectThread(int requestMode, int width, int height, int d1) {
        if (this.extra_buf == null) {
            this.extra_buf = new byte[67];
        }
        if (this.task != null) {
            this.close();
            this.task.cancel(true);
        }
        switch (requestMode) {
            case 1: {
                this.task = new DecodeTask_DIRECT(width, height, d1);
                if (Build.VERSION.SDK_INT >= 11) {
                    ((DecodeTask_DIRECT)this.task).executeOnExecutor(this.threadPoolExecutor, new Void[0]);
                } else {
                    ((DecodeTask_DIRECT)this.task).execute(new Void[0]);
                }
                return 102;
            }
            case 0: {
                this.task = new DecodeTask_CIRQUEUE(width, height, d1);
                if (Build.VERSION.SDK_INT >= 11) {
                    ((DecodeTask_CIRQUEUE)this.task).executeOnExecutor(this.threadPoolExecutor, new Void[0]);
                } else {
                    ((DecodeTask_CIRQUEUE)this.task).execute(new Void[0]);
                }
                return 103;
            }
        }
        return -1;
    }

    public boolean changeImageSize(int width, int height) {
        switch (this.mode) {
            case 102: {
                if (this.task != null && !thread_terminated[this.monNum - 1]) {
                    ((DecodeTask_DIRECT)this.task)._height = height;
                    ((DecodeTask_DIRECT)this.task)._width = width;
                    return ((DecodeTask_DIRECT)this.task).t_life;
                }
                return false;
            }
            case 103: {
                if (this.task != null && !thread_terminated[this.monNum - 1]) {
                    ((DecodeTask_CIRQUEUE)this.task)._height = height;
                    ((DecodeTask_CIRQUEUE)this.task)._width = width;
                    return ((DecodeTask_CIRQUEUE)this.task).t_life;
                }
                return false;
            }
            case 101: {
                return true;
            }
        }
        return false;
    }

    public boolean isRunning() {
        switch (this.mode) {
            case 102: {
                if (this.task != null && !thread_terminated[this.monNum - 1]) {
                    return ((DecodeTask_DIRECT)this.task).t_life;
                }
                return false;
            }
            case 103: {
                if (this.task != null && !thread_terminated[this.monNum - 1]) {
                    return ((DecodeTask_CIRQUEUE)this.task).t_life;
                }
                return false;
            }
            case 101: {
                return true;
            }
        }
        return false;
    }

    public void addPacket(DataInputStream stream, int length, boolean i_frame, long vitc_time, long vitc_timezone, boolean vitc_isDstNow, boolean vitc_isRefOnly, int channel, boolean isP2i) {
        if (this.task == null) {
            return;
        }
        ((DecodeTask_CIRQUEUE)this.task).put(stream, length, i_frame, vitc_time, channel, vitc_timezone, vitc_isDstNow, vitc_isRefOnly, isP2i);
    }

    public void addPacket(DataInputStream stream, int length, boolean i_frame, long time, int channel, boolean isP2i) {
        switch (this.mode) {
            case -1: {
                int i = 0;
                while (i < length) {
                    try {
                        stream.readByte();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                break;
            }
            case 101: {
                try {
                    if (this.extra_buf_jpg == null) {
                        Log.e((String)this.TAG, (String)"add Packet Error : Buffer is null");
                        return;
                    }
                    if (length >= 512044) {
                        Log.e((String)this.TAG, (String)"===========JPEG buf size is not enough======");
                        return;
                    }
                    if (length >= this.extra_buf_jpg.length) {
                        return;
                    }
                    stream.readFully(this.extra_buf_jpg, 0, length);
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    if (this.channel_picker_checker == 1) {
                        options.inSampleSize = 1;
                        options.inPurgeable = true;
                    } else {
                        options.inSampleSize = 1;
                    }
                    Bitmap image = BitmapFactory.decodeByteArray((byte[])this.extra_buf_jpg, (int)0, (int)length, (BitmapFactory.Options)options);
                    if (image == null) {
                        Log.e((String)this.TAG, (String)("BitmapFactory.decodeByteArray fail " + length));
                        break;
                    }
                    boolean life = false;
                    if (this.mode == 101) {
                        life = true;
                    }
                    switch (this.monNum) {
                        case 2: {
                            if (this.playback_monitor_checker == 1) {
                                this.render_interface.displayImage2(image, life, channel);
                                break;
                            }
                            if (this.playback_monitor_checker != 2) break;
                            this.render_interface_playback.displayImage2(image, life, channel);
                            break;
                        }
                        case 3: {
                            if (this.playback_monitor_checker == 1) {
                                this.render_interface.displayImage3(image, life, channel);
                                break;
                            }
                            if (this.playback_monitor_checker != 2) break;
                            this.render_interface_playback.displayImage3(image, life, channel);
                            break;
                        }
                        case 4: {
                            if (this.playback_monitor_checker == 1) {
                                this.render_interface.displayImage4(image, life, channel);
                                break;
                            }
                            if (this.playback_monitor_checker != 2) break;
                            this.render_interface_playback.displayImage4(image, life, channel);
                            break;
                        }
                        default: {
                            if (this.playback_monitor_checker == 1) {
                                this.render_interface.displayImage(image, life, channel);
                                break;
                            }
                            if (this.playback_monitor_checker != 2) break;
                            this.render_interface_playback.displayImage(image, life, channel);
                        }
                    }
                    image.recycle();
                    image = null;
                    options = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 102: {
                if (this.task == null) break;
                if (i_frame) {
                    ((DecodeTask_DIRECT)this.task).put(stream, length, channel, i_frame, isP2i);
                    break;
                }
                int i = 0;
                while (i < length) {
                    try {
                        stream.readByte();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                break;
            }
            case 103: {
                if (this.task != null) {
                    ((DecodeTask_CIRQUEUE)this.task).put(stream, length, i_frame, time, channel, 0L, false, false, isP2i);
                }
                if (!this.bUseFPS) break;
                if (this.lPrevTick == 0L) {
                    this.lPrevTick = System.currentTimeMillis();
                }
                ++this.nFrameCount;
                if (System.currentTimeMillis() - this.lPrevTick < 1000L) break;
                String strInfo = String.format("[IMAGE DECODER] %d fps", this.nFrameCount);
                Log.d((String)this.TAG, (String)strInfo);
                this.nFrameCount = 0;
                this.lPrevTick = System.currentTimeMillis();
            }
        }
    }

    public void clearQueue() {
        if (this.task != null) {
            switch (this.mode) {
                case 103: {
                    ((DecodeTask_CIRQUEUE)this.task).clearQueue();
                }
            }
        }
    }

    public int QueueSize() {
        int size = -1;
        if (this.task != null) {
            switch (this.mode) {
                case 102: {
                    break;
                }
                case 103: {
                    size = ((DecodeTask_CIRQUEUE)this.task).getQueueSize();
                }
            }
        }
        return size;
    }

    public void close() {
        if (this.task != null) {
            switch (this.mode) {
                case 102: {
                    ((DecodeTask_DIRECT)this.task).cancel(true);
                    ((DecodeTask_DIRECT)this.task).close();
                    break;
                }
                case 103: {
                    ((DecodeTask_CIRQUEUE)this.task).cancel(true);
                    ((DecodeTask_CIRQUEUE)this.task).close();
                    break;
                }
                default: {
                    this.task.cancel(true);
                    this.closeMovie();
                }
            }
            this.task = null;
        }
        this.clearQueue();
        this.extra_buf = null;
        this.mode = -1;
        this.extra_buf_jpg = null;
        empty_buffer = null;
    }

    private int initCodec(int width, int height, int d1) {
        d1 = 0;
        int result = 0;
        try {
            Log.e((String)FFTAG, (String)("init Codec (" + this.codec_res + "," + this.codec_enc + ") to (" + this.res + "," + this.enc_type + ") : " + width + "," + height));
            this.codec_res = this.res;
            this.codec_enc = this.enc_type;
            result = this.initCodec(width, height, this.monNum, d1);
            if (result >= 0) {
                this.initCodec = true;
            } else {
                Log.e((String)FFTAG, (String)"----------------------------------------initCodec Exception------------------------- ");
                this.initCodec = false;
            }
        }
        catch (Exception e) {
            Log.e((String)FFTAG, (String)("initCodec Exception : " + result), (Throwable)e);
        }
        return result;
    }

    private int renderFrame(Bitmap bitmap, byte[] data, int size, int deinterlace) {
        int result = -1;
        if (this.initCodec) {
            try {
                result = this.renderFrame(bitmap, data, size, this.monNum, deinterlace);
            }
            catch (Exception e) {
                Log.e((String)FFTAG, (String)("renderFrame Exception : " + result), (Throwable)e);
            }
        }
        return result;
    }

    private int dropFrame(byte[] data, int size) {
        int result = -1;
        if (this.initCodec) {
            try {
                result = this.dropFrame(data, size, this.monNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private int renderFrame2(Bitmap bitmap, byte[] data, int offset, int size, boolean isP2i) {
        int result = -1;
        if (this.initCodec) {
            try {
                int deinterlace = 0;
                if (isP2i) {
                    deinterlace = 1;
                }
                result = this.renderFrame2(bitmap, data, offset, size, this.monNum, deinterlace);
            }
            catch (Exception e) {
                Log.e((String)FFTAG, (String)("renderFrame Exception : " + result), (Throwable)e);
            }
        }
        return result;
    }

    private int dropFrame2(byte[] data, int offset, int size) {
        int result = -1;
        if (this.initCodec) {
            try {
                result = this.dropFrame2(data, offset, size, this.monNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void closeMovie() {
        try {
            Log.d((String)FFTAG, (String)"closeMovie");
            this.closeMovie(this.monNum);
            this.initCodec = false;
        }
        catch (Exception e) {
            Log.e((String)FFTAG, (String)"closeMovie Exception : ", (Throwable)e);
        }
    }

    private int getWidthFromFrame() {
        return this.widthFromFrame;
    }

    private int getHeightFromFrame() {
        return this.heightFromFrame;
    }

    public void getSizeFromFrame(byte[] data) {
        this.calculateFrameSize(data);
        this.widthFromFrame = this.getFrameWidth();
        this.heightFromFrame = this.getFrameHeight();
    }

    private native void calculateFrameSize(byte[] var1);

    private native int getFrameWidth();

    private native int getFrameHeight();

    private static synchronized native int initBasicPlayer();

    private native int initCodec(int var1, int var2, int var3, int var4);

    private native int renderFrame(Bitmap var1, byte[] var2, int var3, int var4, int var5);

    private native int dropFrame(byte[] var1, int var2, int var3);

    private native int renderFrame2(Bitmap var1, byte[] var2, int var3, int var4, int var5, int var6);

    private native int dropFrame2(byte[] var1, int var2, int var3, int var4);

    private native void closeMovie(int var1);

    class DecodeTask_CIRQUEUE
    extends AsyncTask<Void, Void, Void> {
        public Bitmap image = null;
        boolean t_life;
        public int _width;
        public int _height;
        public int _d1;
        long start_time = 0L;
        long last_time;
        public int needToRestart = 0;
        private long[] network_delay_time_log;
        private int delay_log_iterator;
        private CIRQUEUE queue;
        long prev;

        DecodeTask_CIRQUEUE(int width, int height, int d1) {
            this._height = height;
            this._width = width;
            this._d1 = d1;
            this.network_delay_time_log = new long[ImageDecoder.this.frame_rate * 5000 / 2000];
            this.delay_log_iterator = 0;
            this.queue = new CIRQUEUE();
        }

        public int getQueueSize() {
            int size = -1;
            if (this.queue != null) {
                size = this.queue.i_count();
            }
            return size;
        }

        public void clearQueue() {
            while (this.queue.pop() != null) {
            }
        }

        void changeImage() {
            if (this.image != null) {
                this.image.recycle();
                this.image = null;
            }
            this.image = Bitmap.createBitmap((int)this._width, (int)this._height, (Bitmap.Config)Bitmap.Config.RGB_565);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.t_life = true;
            this.start_time = 0L;
            try {
                if (this.image != null) {
                    this.image.recycle();
                    this.image = null;
                }
                this.image = Bitmap.createBitmap((int)this._width, (int)this._height, (Bitmap.Config)Bitmap.Config.RGB_565);
            }
            catch (Exception e) {
                Log.e((String)ImageDecoder.this.TAG, (String)"Exception : ", (Throwable)e);
            }
        }

        protected void onPostExecute(Void result) {
            if (this.image != null) {
                this.image.recycle();
                this.image = null;
            }
            this.network_delay_time_log = null;
            this.queue = null;
        }

        protected Void doInBackground(Void ... params) {
            while (!thread_terminated[ImageDecoder.this.monNum - 1]) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            thread_terminated[((ImageDecoder)ImageDecoder.this).monNum - 1] = false;
            if (!ImageDecoder.this.initCodec) {
                Log.e((String)ImageDecoder.this.TAG, (String)"checkResolutionChange First (Circular Queue) ");
                ImageDecoder.this.ffmpeg_err = ImageDecoder.this.initCodec(this._width, this._height, this._d1);
            }
            boolean first_i_frame = false;
            Log.e((String)ImageDecoder.this.TAG, (String)("============= ImageCodec (Circular Buffer) : Start Type :  width = " + this._width + "height = " + this._height + "=============="));
            while (this.t_life && !this.isCancelled()) {
                if (ImageDecoder.this.preserveQueue) {
                    Log.e((String)ImageDecoder.this.TAG, (String)"PreserveQueue : ");
                    continue;
                }
                if (this.queue.count() > 0) {
                    AddrHolder info = null;
                    try {
                        if (this.queue.isEmpty()) {
                            Log.e((String)ImageDecoder.this.TAG, (String)"NoSuchElementException~!! : isEmpty");
                            continue;
                        }
                        info = this.queue.pop();
                        if (info == null) {
                            Log.e((String)ImageDecoder.this.TAG, (String)"queue pop is null ");
                            continue;
                        }
                        if (ImageDecoder.this.channel_picker_checker != 0) continue;
                        if (!first_i_frame) {
                            if (!info.iframe) continue;
                            this.DecodeAndDisplay(info);
                            first_i_frame = true;
                            continue;
                        }
                        boolean isDropped = false;
                        int drop_num = (this.queue.count() - 250 * ImageDecoder.this.frame_rate / 1000) / ImageDecoder.this.QUEUE_BUFFER_DROP_COUNT_RATE;
                        if (this.queue.length() > 0x193333) {
                            drop_num = this.queue.count() / 3;
                            Log.e((String)ImageDecoder.this.TAG, (String)"Buffer full : dropped 1/3 of frames");
                        }
                        if (drop_num > 0) {
                            int j = drop_num - 1;
                            while (j >= 0) {
                                if (j < this.queue.count() && this.queue.get((int)j).iframe) {
                                    int k = 0;
                                    while (k < j + 1) {
                                        info = this.queue.pop();
                                        --drop_num;
                                        if (info.iframe && k < j) {
                                            this.DecodeAndDisplay(info);
                                        }
                                        ++k;
                                    }
                                    break;
                                }
                                --j;
                            }
                            if (drop_num > ImageDecoder.this.frame_rate / 3 && this.queue.i_count() > 0) {
                                int n = 0;
                                while (n < this.queue.count()) {
                                    info = this.queue.pop();
                                    --drop_num;
                                    if (!isDropped) {
                                        isDropped = true;
                                    }
                                    if (info.iframe) {
                                        Log.e((String)ImageDecoder.this.TAG, (String)("[fps]drop frame : jump " + n + " packets"));
                                        break;
                                    }
                                    ++n;
                                }
                            } else {
                                long drop_time = System.currentTimeMillis();
                                int k = 0;
                                while (k < drop_num) {
                                    long now_time = System.currentTimeMillis();
                                    if (info.header + info.length < 0x240000) {
                                        if (ImageDecoder.this.is_Nal_analysis == 1 && info.iframe) {
                                            this.checkResolutionChange(cBuffer, info.header);
                                        }
                                        if ((ImageDecoder.this.ffmpeg_err = ImageDecoder.this.dropFrame2(cBuffer, info.header, info.length)) != 0) {
                                            Log.w((String)"Decode", (String)("Decode Error" + ImageDecoder.this.ffmpeg_err));
                                        }
                                    } else {
                                        if (empty_buffer == null) {
                                            empty_buffer = new byte[0x240000];
                                        }
                                        int len1 = 0x240000 - info.header;
                                        int len2 = info.length - len1;
                                        System.arraycopy(cBuffer, info.header, empty_buffer, 0, len1);
                                        System.arraycopy(cBuffer, 0, empty_buffer, len1, len2);
                                        if (ImageDecoder.this.is_Nal_analysis == 1 && info.iframe) {
                                            this.checkResolutionChange(empty_buffer, 0);
                                        }
                                        if ((ImageDecoder.this.ffmpeg_err = ImageDecoder.this.dropFrame(empty_buffer, info.length)) != 0) {
                                            Log.w((String)"Decode", (String)("Decode Error" + ImageDecoder.this.ffmpeg_err));
                                        }
                                    }
                                    info = this.queue.pop();
                                    ++k;
                                }
                            }
                            if (isDropped && !info.iframe) {
                                first_i_frame = false;
                                continue;
                            }
                            this.DecodeAndDisplay(info);
                            continue;
                        }
                        this.DecodeAndDisplay(info);
                        continue;
                    }
                    catch (Exception e) {
                        Log.e((String)ImageDecoder.this.TAG, (String)"Circular Queue : ", (Throwable)e);
                        if (this.t_life) continue;
                        break;
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ImageDecoder.this.closeMovie();
            if (this.image != null) {
                this.image.recycle();
                this.image = null;
            }
            thread_terminated[((ImageDecoder)ImageDecoder.this).monNum - 1] = true;
            Log.e((String)ImageDecoder.this.TAG, (String)">>>>>>>>>>>>>>>>>>>>\uc2a4\ub808\ub4dc \ub05d");
            return null;
        }

        public synchronized void put(DataInputStream stream, int length, boolean i_frame, long msec, int channel, long timezone, boolean isDst, boolean vitc_isRefOnly, boolean isP2i) {
            block18: {
                if (!this.t_life || !ImageDecoder.this.initCodec) {
                    int i = 0;
                    while (i < length) {
                        try {
                            stream.readByte();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    return;
                }
                long currentTimeMillis = System.currentTimeMillis();
                if (ImageDecoder.this.playback_monitor_checker != 2) {
                    long delay;
                    this.prev = msec;
                    currentTimeMillis = System.currentTimeMillis();
                    if (this.start_time == 0L || msec < this.last_time) {
                        this.start_time = currentTimeMillis - msec;
                    }
                    this.last_time = msec;
                    while ((delay = currentTimeMillis - this.start_time - msec) < 0L) {
                        this.start_time += delay;
                    }
                    if (delay > 3000L) {
                        this.network_delay_time_log[this.delay_log_iterator++] = currentTimeMillis;
                        if (this.network_delay_time_log[this.delay_log_iterator %= this.network_delay_time_log.length] > currentTimeMillis - 5000L) {
                            ImageDecoder.this.render_interface.onCPmode();
                        }
                    }
                    currentTimeMillis -= delay;
                } else {
                    currentTimeMillis = msec;
                }
                try {
                    if (this.queue.length() + length < 0x240000) {
                        int start = (this.queue.getHeadPoint() + this.queue.length()) % 0x240000;
                        if (start + length > 0x240000) {
                            int len1 = 0x240000 - start;
                            int len2 = length - len1;
                            stream.readFully(cBuffer, start, len1);
                            stream.readFully(cBuffer, 0, len2);
                        } else {
                            stream.readFully(cBuffer, start, length);
                        }
                        AddrHolder holder = new AddrHolder(start, length, currentTimeMillis, channel, i_frame, msec, timezone, isDst, vitc_isRefOnly, isP2i);
                        this.queue.push(holder);
                        break block18;
                    }
                    Log.e((String)ImageDecoder.this.TAG, (String)"Fatal Error : Queue size over flow~!!!");
                    int i = 0;
                    while (i < length) {
                        try {
                            stream.readByte();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void checkResolutionChange(byte[] src, int srcPos) {
            int vol_size = 54;
            byte[] cBuffer_temp = new byte[vol_size];
            if (srcPos + vol_size >= cBuffer.length) {
                Log.e((String)ImageDecoder.this.TAG, (String)"checkResolutionChange error : ");
                return;
            }
            System.arraycopy(src, srcPos, cBuffer_temp, 0, vol_size);
            H264Analyzer myH264 = new H264Analyzer(cBuffer_temp, vol_size);
            if (myH264.image_width != -1 && myH264.image_height != -1 && (myH264.image_width != this._width || myH264.image_height != this._height)) {
                this._width = myH264.image_width;
                this._height = myH264.image_height;
                this.changeImage();
                Log.e((String)ImageDecoder.this.TAG, (String)"checkResolutionChange Occurs : ");
                ImageDecoder.this.ffmpeg_err = ImageDecoder.this.initCodec(this._width, this._height, this._d1);
                if (ImageDecoder.this.ffmpeg_err < 0) {
                    Log.e((String)ImageDecoder.this.TAG, (String)("decoder init fails : " + ImageDecoder.this.ffmpeg_err));
                }
            }
            cBuffer_temp = null;
        }

        public void DecodeAndDisplay(AddrHolder info) {
            if (info.header + info.length < 0x240000) {
                if (!this.t_life) {
                    return;
                }
                if (ImageDecoder.this.is_Nal_analysis == 1 && info.iframe) {
                    this.checkResolutionChange(cBuffer, info.header);
                }
                if (!this.t_life) {
                    return;
                }
                ImageDecoder.this.ffmpeg_err = ImageDecoder.this.renderFrame2(this.image, cBuffer, info.header, info.length, info.isP2i);
                if (ImageDecoder.this.ffmpeg_err != 0) {
                    Log.w((String)ImageDecoder.this.TAG, (String)("Decode Error " + ImageDecoder.this.ffmpeg_err));
                }
            } else {
                if (empty_buffer == null) {
                    empty_buffer = new byte[0x240000];
                }
                int len1 = 0x240000 - info.header;
                int len2 = info.length - len1;
                System.arraycopy(cBuffer, info.header, empty_buffer, 0, len1);
                System.arraycopy(cBuffer, 0, empty_buffer, len1, len2);
                int deinterlace = 0;
                if (info.isP2i) {
                    deinterlace = 1;
                }
                if (ImageDecoder.this.is_Nal_analysis == 1 && info.iframe) {
                    this.checkResolutionChange(empty_buffer, info.header);
                }
                if ((ImageDecoder.this.ffmpeg_err = ImageDecoder.this.renderFrame(this.image, empty_buffer, info.length, deinterlace)) != 0) {
                    Log.w((String)ImageDecoder.this.TAG, (String)("Decode Error " + ImageDecoder.this.ffmpeg_err));
                }
            }
            if (this.image == null || ImageDecoder.this.ffmpeg_err < 0) {
                return;
            }
            if (!ImageDecoder.this.bCallFrameStart) {
                ImageDecoder.this.bCallFrameStart = true;
                if (ImageDecoder.this.render_interface != null) {
                    ImageDecoder.this.render_interface.onFrameStart();
                }
            }
            if (!this.t_life) {
                return;
            }
            Bitmap displayImage = Bitmap.createBitmap((Bitmap)this.image);
            if (ImageDecoder.this.playback_monitor_checker == 1) {
                ImageDecoder.this.render_interface.displayImage(displayImage, this.t_life, info.ch);
            } else if (ImageDecoder.this.playback_monitor_checker == 2 && !info.vitc_isRefOnly) {
                ImageDecoder.this.render_interface_playback.displayImage(displayImage, this.t_life, info.ch, info.vitc_time, info.vitc_timezone, info.vitc_isDstNow);
            }
        }

        public void close() {
            this.t_life = false;
        }

        private class AddrHolder {
            int header;
            boolean iframe;
            int length;
            long current_time;
            int ch;
            boolean isP2i = false;
            boolean isTop = false;
            long vitc_time;
            long vitc_timezone;
            boolean vitc_isDstNow;
            boolean vitc_isRefOnly;

            AddrHolder(int header, int length, long current_time, int ch, boolean i, boolean p2i) {
                this.header = header;
                this.iframe = i;
                this.length = length;
                this.current_time = current_time;
                this.ch = ch;
                this.isP2i = p2i;
            }

            AddrHolder(int header, int length, long current_time, int ch, boolean i, long frameTime, long frameTimeZone, boolean frameDstNow, boolean vitc_isRefOnly, boolean p2i) {
                this.header = header;
                this.iframe = i;
                this.length = length;
                this.current_time = current_time;
                this.ch = ch;
                this.vitc_time = frameTime;
                this.vitc_timezone = frameTimeZone;
                this.vitc_isDstNow = frameDstNow;
                this.vitc_isRefOnly = vitc_isRefOnly;
                this.isP2i = p2i;
            }
        }

        private class CIRQUEUE {
            private LinkedList<AddrHolder> addresses;
            private int queue_head = 0;
            private int queue_length = 0;
            private int i_count = 0;

            CIRQUEUE() {
                if (cBuffer == null) {
                    cBuffer = new byte[0x240000];
                }
                this.addresses = new LinkedList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public AddrHolder pop() {
                AddrHolder info;
                LinkedList<AddrHolder> linkedList = this.addresses;
                synchronized (linkedList) {
                    info = this.addresses.poll();
                    if (info == null) {
                        Log.e((String)ImageDecoder.this.TAG, (String)"NoSuchElementException~!! : info is null");
                        return null;
                    }
                }
                if (info.iframe) {
                    --this.i_count;
                }
                this.queue_head += info.length;
                this.queue_head %= 0x240000;
                this.queue_length -= info.length;
                return info;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void push(AddrHolder item) {
                LinkedList<AddrHolder> linkedList = this.addresses;
                synchronized (linkedList) {
                    this.addresses.offer(item);
                }
                this.queue_length += item.length;
                if (item.iframe) {
                    ++this.i_count;
                }
            }

            public int getHeadPoint() {
                return this.queue_head;
            }

            public int length() {
                return this.queue_length;
            }

            public int i_count() {
                return this.i_count;
            }

            public int count() {
                return this.addresses.size();
            }

            public boolean isEmpty() {
                return this.addresses.isEmpty();
            }

            public AddrHolder get(int index) {
                return this.addresses.get(index);
            }
        }
    }

    class DecodeTask_DIRECT
    extends AsyncTask<Void, Void, Void> {
        private static final int BUFFER_COUNT_MAX = 3;
        public Bitmap image = null;
        int decoding = -1;
        int recent_frame = -1;
        boolean t_life;
        public int _width;
        public int _height;
        public int _d1;
        public int needToRestart = 0;

        DecodeTask_DIRECT(int width, int height, int d1) {
            this._height = height;
            this._width = width;
            this._d1 = d1;
            if (ImageDecoder.this.dBuffer == null) {
                ImageDecoder.this.dBuffer = new BufferHolder[16][];
            }
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (ImageDecoder.this.dBuffer[ImageDecoder.this.monNum - 1] == null) {
                ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1] = new BufferHolder[3];
                int i = 0;
                while (i < 3) {
                    ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][i] = new BufferHolder();
                    ++i;
                }
            }
            try {
                Log.e((String)ImageDecoder.this.TAG, (String)("Bitmap Image Size : width = " + this._width + " height = " + this._height));
                this.image = Bitmap.createBitmap((int)this._width, (int)this._height, (Bitmap.Config)Bitmap.Config.RGB_565);
            }
            catch (Exception e) {
                Log.e((String)ImageDecoder.this.TAG, (String)"Exception : ", (Throwable)e);
            }
            this.t_life = true;
        }

        protected void onPostExecute(Void result) {
            if (this.image != null) {
                this.image.recycle();
                this.image = null;
            }
            if (ImageDecoder.this.dBuffer != null) {
                int i = 0;
                while (i < 3) {
                    ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][i] = null;
                    ++i;
                }
                ImageDecoder.this.dBuffer = null;
            }
        }

        void changeImage() {
            if (this.image != null) {
                this.image.recycle();
                this.image = null;
            }
            this.image = Bitmap.createBitmap((int)this._width, (int)this._height, (Bitmap.Config)Bitmap.Config.RGB_565);
        }

        public void checkResolutionChange(byte[] src, int srcPos) {
            int vol_size = 54;
            byte[] cBuffer_temp = new byte[vol_size];
            System.arraycopy(src, srcPos, cBuffer_temp, 0, vol_size);
            H264Analyzer myH264 = new H264Analyzer(cBuffer_temp, vol_size);
            if (myH264.image_width != -1 && myH264.image_height != -1 && (myH264.image_width != this._width || myH264.image_height != this._height)) {
                Log.e((String)ImageDecoder.this.TAG, (String)("checkResolutionChange occurs (DirectQueue) : from width:" + this._width + " height:" + this._height + " to width:" + myH264.image_width + " and height:" + myH264.image_height));
                this._width = myH264.image_width;
                this._height = myH264.image_height;
                this.changeImage();
                ImageDecoder.this.ffmpeg_err = ImageDecoder.this.initCodec(this._width, this._height, this._d1);
            }
            cBuffer_temp = null;
        }

        protected Void doInBackground(Void ... params) {
            while (!thread_terminated[ImageDecoder.this.monNum - 1]) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            thread_terminated[((ImageDecoder)ImageDecoder.this).monNum - 1] = false;
            if (!ImageDecoder.this.initCodec) {
                Log.e((String)ImageDecoder.this.TAG, (String)"checkResolutionChange First (DirectQueue) : ");
                ImageDecoder.this.ffmpeg_err = ImageDecoder.this.initCodec(this._width, this._height, this._d1);
                if (ImageDecoder.this.ffmpeg_err < 0) {
                    Log.e((String)ImageDecoder.this.TAG, (String)("ERROR : codec init fail Error code : " + ImageDecoder.this.ffmpeg_err + " (mode:" + ImageDecoder.this.mode + ")"));
                }
            }
            Log.e((String)ImageDecoder.this.TAG, (String)("============= ImageCodec (DirectBuffer) : Start Type :  width = " + this._width + "height = " + this._height + "=============="));
            while (this.t_life && !this.isCancelled()) {
                if (this.recent_frame >= 0) {
                    this.decoding = this.recent_frame;
                    try {
                        this.recent_frame = -1;
                        int deinterlace = 0;
                        if (((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].isP2i) {
                            deinterlace = 1;
                        }
                        if (ImageDecoder.this.is_Nal_analysis == 1 && ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].iframe) {
                            this.checkResolutionChange(((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].buffer, 0);
                        }
                        if ((ImageDecoder.this.ffmpeg_err = ImageDecoder.this.renderFrame(this.image, ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].buffer, ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].length, deinterlace)) < 0) {
                            Log.w((String)ImageDecoder.this.TAG, (String)("Decode Error " + ImageDecoder.this.ffmpeg_err + "," + ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].ch + "," + ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].length));
                            this.decoding = -1;
                            continue;
                        }
                        if (this.image == null) {
                            this.decoding = -1;
                            continue;
                        }
                        Bitmap displayImage = Bitmap.createBitmap((Bitmap)this.image);
                        if (ImageDecoder.this.playback_monitor_checker == 1) {
                            ImageDecoder.this.render_interface.displayImage(displayImage, this.t_life, ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].ch);
                        } else if (ImageDecoder.this.playback_monitor_checker == 2) {
                            ImageDecoder.this.render_interface_playback.displayImage(displayImage, this.t_life, ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][this.decoding].ch);
                        }
                        this.decoding = -1;
                        continue;
                    }
                    catch (Exception e) {
                        Log.e((String)ImageDecoder.this.TAG, (String)"Direct decode Buffer : ", (Throwable)e);
                        if (this.t_life) continue;
                        break;
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ImageDecoder.this.closeMovie();
            thread_terminated[((ImageDecoder)ImageDecoder.this).monNum - 1] = true;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void put(DataInputStream stream, int length, int channel, boolean i_frame, boolean isP2i) {
            if (!this.t_life || !ImageDecoder.this.initCodec) {
                int i = 0;
                while (i < length) {
                    try {
                        stream.readByte();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                Log.d((String)ImageDecoder.this.TAG, (String)"BUFFER NOT READY!!!");
                return;
            }
            int num = 0;
            while (num < 3) {
                if (num != this.decoding && num != this.recent_frame) break;
                ++num;
            }
            if (num < 3) {
                BufferHolder bufferHolder = ImageDecoder.this.dBuffer[ImageDecoder.this.monNum - 1][num];
                synchronized (bufferHolder) {
                    try {
                        stream.readFully(((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][num].buffer, 0, length);
                        ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][num].length = length;
                        ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][num].ch = channel;
                        ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][num].iframe = i_frame;
                        ((ImageDecoder)ImageDecoder.this).dBuffer[((ImageDecoder)ImageDecoder.this).monNum - 1][num].isP2i = isP2i;
                        this.recent_frame = num;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            Log.e((String)ImageDecoder.this.TAG, (String)("Error : Empty Buffer not found (Buffer count over flow) " + num));
        }

        public void close() {
            this.t_life = false;
        }

        public class BufferHolder {
            byte[] buffer = new byte[512000];
            int length = 0;
            int ch = 0;
            boolean isP2i;
            boolean iframe;

            BufferHolder() {
            }

            protected void finalize() throws Throwable {
                this.buffer = null;
            }
        }
    }
}

