/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.artncore.commons.DataClasses;
import java.util.ArrayList;
import java.util.List;

public class WallpadParkInfo
extends wallpaddbmgr {
    private static final String TAG = "WallpadParkInfo";

    public WallpadParkInfo(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("ParkingData")) {
            try {
                this.wdb.execSQL("create table ParkingData (parking_index text, dong text, ho text, card_num text, card_uid text, card_sn text, card_type text, time text, location_text text, location_map text, vehicle_info text, ftp_path text, ftp_info text, message text);");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void DeleteAllParkInfo() {
        String query = "DELETE FROM ParkingData;";
        this.wdb.execSQL(query);
    }

    public void InputParkInfo(String index, String dong, String ho, String card_num, String card_uid, String card_sn, String card_type, String time, String location_text, String location_map, String vehicle_info, String ftp_path, String ftp_info, String message) {
        ContentValues values = new ContentValues();
        values.put("parking_index", index);
        values.put("dong", dong);
        values.put("ho", ho);
        values.put("card_num", card_num);
        values.put("card_uid", card_uid);
        values.put("card_sn", card_sn);
        values.put("card_type", card_type);
        values.put("time", time);
        values.put("location_text", location_text);
        values.put("location_map", location_map);
        values.put("vehicle_info", vehicle_info);
        values.put("ftp_path", ftp_path);
        values.put("ftp_info", ftp_info);
        values.put("message", message);
        this.wdb.insert("ParkingData", null, values);
    }

    public List<String[]> GetParkInfo() {
        String query = "select * from ParkingData order by parking_index asc;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        ArrayList<String[]> RetList = new ArrayList<String[]>();
        while (cursor.moveToNext()) {
            String[] retval = new String[]{cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4), cursor.getString(5), cursor.getString(6), cursor.getString(7), cursor.getString(8), cursor.getString(9), cursor.getString(10), cursor.getString(11), cursor.getString(12), cursor.getString(13)};
            RetList.add(retval);
        }
        cursor.close();
        return RetList;
    }

    public int RowCountCarParking() {
        String query = "select count(*) from ParkingData;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        if (cursor.moveToNext()) {
            String getdata = cursor.getString(0).trim();
            try {
                return Integer.parseInt(getdata);
            }
            catch (Exception e) {
                return -999;
            }
        }
        cursor.close();
        return -999;
    }

    public DataClasses.CarParkingData[] getCarParkingData() {
        List<String[]> RetList = this.GetParkInfo();
        if (RetList == null) {
            Log.d((String)TAG, (String)"if(RetList == null)");
            return null;
        }
        if (RetList.size() == 0) {
            Log.d((String)TAG, (String)"if(RetList.size() == 0)");
            return null;
        }
        DataClasses.CarParkingData[] carParkingData = new DataClasses.CarParkingData[RetList.size()];
        try {
            for (int i = 0; i < RetList.size(); ++i) {
                carParkingData[i] = new DataClasses.CarParkingData();
                carParkingData[i].index = Integer.parseInt(RetList.get(i)[0]);
                carParkingData[i].card_num = RetList.get(i)[3];
                carParkingData[i].card_uid = RetList.get(i)[4];
                carParkingData[i].card_sn = RetList.get(i)[5];
                carParkingData[i].card_type = RetList.get(i)[6];
                String[] SplitedInfo = RetList.get(i)[7].split("\\.");
                if (SplitedInfo.length != 6) {
                    Log.d((String)TAG, (String)"if(SplitedInfo.length != 6)");
                    return null;
                }
                carParkingData[i].time.set(Integer.parseInt(SplitedInfo[0]), Integer.parseInt(SplitedInfo[1]) - 1, Integer.parseInt(SplitedInfo[2]), Integer.parseInt(SplitedInfo[3]), Integer.parseInt(SplitedInfo[4]), Integer.parseInt(SplitedInfo[5]));
                carParkingData[i].location_text = RetList.get(i)[8];
                carParkingData[i].location_map = RetList.get(i)[9];
                carParkingData[i].vehicle_info = RetList.get(i)[10];
                carParkingData[i].ftp_path = RetList.get(i)[11];
                carParkingData[i].ftp_idpass_info = RetList.get(i)[12];
                carParkingData[i].message = RetList.get(i)[13];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return carParkingData;
    }
}

