/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class PurityAPI
extends WallPadDevAPI {
    private final String TAG = "PurityAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"PurityAPI", (String)s);
    }

    public PurityAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("PurityAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "PURITY";
        this.data = new Data();
        int ret = this.Refresh((byte)100, false);
        if (ret == 0) {
            byte PurityCount = this.data.Device.info.InsidePurityCount;
            Log.i((String)"PurityAPI", (String)("GetInfo() - OK!!! (RoomCount:" + PurityCount + ")"));
            this.data.Device.SetPurityCount(PurityCount);
        } else {
            Log.i((String)"PurityAPI", (String)("GetInfo() - fail!!! " + ret));
        }
    }

    public int Refresh(byte Index, boolean real) {
        if ((Index < 0 || Index > 14) && Index != -1 && Index != 100) {
            Log.w((String)"PurityAPI", (String)("[Refresh] Param (Index) Out Of Range !!! (" + Index + ")"));
            return -300;
        }
        if (Index == 100 && real) {
            Log.w((String)"PurityAPI", (String)"[Refresh] If the Index is REFRESH_IDX.INFO does not support the real(true)");
            return -300;
        }
        if (Index != 100 && this.data.Device.info.InsidePurityCount <= 0) {
            Log.w((String)"PurityAPI", (String)("[Refresh] DEVICE IS NOT READY (" + Index + ")"));
            return -110;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = null;
        if (Index >= 0 && Index <= 14) {
            if (this.CheckParamAircon(Index) != 0) {
                Log.w((String)"PurityAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
                return -300;
            }
            ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingPurity(ret);
        }
        if (Index == -1) {
            int i;
            if (real) {
                int iret = this.SendNReadCMD_int(MainCMD, SubCMD, -1, 0, 0, 0, 0);
                if (iret != 0) {
                    return -111;
                }
                MainCMD = "NOSINKCTRL";
            }
            for (i = 0; i < this.data.Device.info.InsidePurityCount && this.ParsingPurity(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) == 0; ++i) {
            }
            if (i < this.data.Device.info.InsidePurityCount) {
                Log.w((String)"PurityAPI", (String)("[Refresh] REFRESH_IDX.ALL fail (i:" + i + ")"));
                return -111;
            }
            return 0;
        }
        if (Index == 100) {
            ret = this.SendNReadCMD_str("NOSINKCTRL", SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingInfo(ret);
        }
        Log.w((String)"PurityAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
        return -300;
    }

    private int ParsingPurity(String ret) {
        String FUNC_NAME = "[ParsingRoom]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"PurityAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"PurityAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"PurityAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"PurityAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.Purity.PurityData purityData = new DataClasses.Purity.PurityData();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            purityData.ervData.OnOff = Byte.parseByte(retData[index++]);
            purityData.ervData.Filter = Byte.parseByte(retData[index++]);
            purityData.ervData.Mode = Byte.parseByte(retData[index++]);
            purityData.ervData.Volume = Byte.parseByte(retData[index++]);
            purityData.Mode = Byte.parseByte(retData[index++]);
            purityData.Volume = Byte.parseByte(retData[index++]);
            purityData.OnOff = Byte.parseByte(retData[index++]);
            purityData.AddService = Byte.parseByte(retData[index++]);
            purityData.airSensingData.AirSense = Byte.parseByte(retData[index++]);
            purityData.airSensingData.Co2 = Byte.parseByte(retData[index++]);
            purityData.airSensingData.Dust = Byte.parseByte(retData[index++]);
            purityData.airSensingData.FindDust = Byte.parseByte(retData[index++]);
            purityData.airSensingData.Humidity = Byte.parseByte(retData[index++]);
            purityData.airSensingData.Temp = Byte.parseByte(retData[index++]);
            purityData.airSensingData.Voc = Byte.parseByte(retData[index++]);
            purityData.airSensingData.UltraFindDust = Byte.parseByte(retData[index++]);
            purityData.airSensingData.dustValue[0] = Byte.parseByte(retData[index++]);
            purityData.airSensingData.dustValue[1] = Byte.parseByte(retData[index++]);
            purityData.airSensingData.fineDustValue[0] = Byte.parseByte(retData[index++]);
            purityData.airSensingData.fineDustValue[1] = Byte.parseByte(retData[index++]);
            purityData.airSensingData.co2Value[0] = Byte.parseByte(retData[index++]);
            purityData.airSensingData.co2Value[1] = Byte.parseByte(retData[index++]);
            this.data.Device.purityData[Current] = purityData;
        }
        catch (Exception e) {
            Log.e((String)"PurityAPI", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingInfo(String ret) {
        String FUNC_NAME = "[ParsingInfo]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"PurityAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"PurityAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"PurityAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"PurityAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.Purity.Info info = new DataClasses.Purity.Info();
            int index = 1;
            info.Vendor = Byte.parseByte(retData[index++]);
            info.InsidePurityCount = Byte.parseByte(retData[index++]);
            info.Support.VolumeControl = Boolean.parseBoolean(retData[index++]);
            info.Support.ModeControl = Boolean.parseBoolean(retData[index++]);
            info.Support.AirSensing = Boolean.parseBoolean(retData[index++]);
            info.Support.NoWindFunc = Boolean.parseBoolean(retData[index++]);
            info.Support.SleepFunc = Boolean.parseBoolean(retData[index++]);
            info.PurityStatus = Byte.parseByte(retData[index++]);
            info.FwVer_Month = Byte.parseByte(retData[index++]);
            info.FwVer_Day = Byte.parseByte(retData[index++]);
            info.FwVer_Number = Byte.parseByte(retData[index++]);
            info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
            info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
            this.data.Device.info = info;
        }
        catch (Exception e) {
            Log.e((String)"PurityAPI", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    public int SetEachRoomStatus(byte roomIndex, int setMode) {
        int ret = this.CheckParamAircon(roomIndex);
        if (ret != 0) {
            Log.w((String)"PurityAPI", (String)("[SetEachRoomStatus] RoomIndex Out Of Range !!! (" + roomIndex + ")"));
            return ret;
        }
        ret = this.CheckParamSetMode(setMode);
        if (ret != 0) {
            Log.w((String)"PurityAPI", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", setMode) + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetEachRoomStatus", roomIndex, setMode, 0, 0, 0);
    }

    public int SetAllRoomStatus(int item, int control) {
        int ret = this.CheckParamSetMode(control);
        if (ret != 0) {
            Log.w((String)"PurityAPI", (String)("[SetEachRoomStatus] SetControl Out Of Range !!! (" + String.format("%02X", control) + ")"));
            return -300;
        }
        this.DebugLogOutput("[PurityAPI----------------------------------------] SetAllRoomStatus - OK");
        return this.SendNReadCMD_int("SINKCTRL", "SetAllRoomStatus", item, control, 0, 0, 0);
    }

    public int SetPollingMode(byte ChangePollingMode, byte RoomIndex) {
        int ret;
        if (ChangePollingMode != 2 && ChangePollingMode != 3) {
            return -300;
        }
        if (ChangePollingMode == 3 && (ret = this.CheckParamAircon(RoomIndex)) != 0) {
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetPollingMode", ChangePollingMode, RoomIndex, 0, 0, 0);
    }

    private int CheckParamAircon(byte AirIndex) {
        byte AirCount = this.data.Device.info.InsidePurityCount;
        if (AirCount <= 0) {
            return -110;
        }
        if (this.data.Device == null) {
            return -110;
        }
        if (this.data.Device.purityData == null) {
            return -110;
        }
        if (this.data.Device.purityData.length <= AirIndex) {
            return -110;
        }
        return 0;
    }

    private int CheckParamSetMode(int Mode) {
        return 0;
    }

    public static class Data {
        public DataClasses.Purity Device = new DataClasses.Purity();
    }

    public static final class POLLING_MODE {
        public static final byte Normal = 2;
        public static final byte FixRoom = 3;
    }

    public static final class REFRESH_IDX {
        public static final byte PURITY1 = 0;
        public static final byte PURITY2 = 1;
        public static final byte PURITY3 = 2;
        public static final byte PURITY4 = 3;
        public static final byte PURITY5 = 4;
        public static final byte PURITY6 = 5;
        public static final byte PURITY7 = 6;
        public static final byte PURITY8 = 7;
        public static final byte PURITY9 = 8;
        public static final byte PURITY10 = 9;
        public static final byte PURITY11 = 10;
        public static final byte PURITY12 = 11;
        public static final byte PURITY13 = 12;
        public static final byte PURITY14 = 13;
        public static final byte PURITY15 = 14;
        public static final byte ALL = -1;
        public static final byte INFO = 100;
    }
}

