/*
 * Decompiled with CFR 0.152.
 */
package bssoft.stack.sip;

import bssoft.stack.sip.GetIpDns;
import bssoft.stack.sip.SIPmd5;
import bssoft.stack.sip.UserDial;
import bssoft.stack.sip.stackKey;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.StringTokenizer;

public class SIPStack {
    public static int SIP_LOCAL_PORT = 5060;
    public static int SIP_SIGNAL_PORT = 5060;
    public static int MAX_SIGNAL_PORTS = 100;
    public static int SIP_METHODTYPE_NONE = 0;
    public static int SIP_METHODTYPE_REGISTER = 1;
    public static int SIP_METHODTYPE_INVITE = 2;
    public static int SIP_METHODTYPE_CANCEL = 3;
    public static int SIP_METHODTYPE_BYE = 4;
    public static int SIP_METHODTYPE_INFO = 5;
    public static int SIP_METHODTYPE_OPTIONS = 6;
    public static int SIP_METHODTYPE_ACK = 7;
    public static int SIP_METHODTYPE_REFER = 8;
    public static int SIP_METHODTYPE_NOTIFY = 9;
    public static int SIP_METHODTYPE_MESSAGE = 10;
    public static int SIP_METHODTYPE_SUBSCRIBE = 11;
    public static int SIP_METHODTYPE_PRACK = 12;
    public static int SIP_METHODTYPE_PUBLISH = 13;
    public static int SIP_METHODTYPE_RESPONSE = 14;
    public static int SIP_HEADERTYPE_NONE = 0;
    public static int SIP_HEADERTYPE_ACCEPT = 1;
    public static int SIP_HEADERTYPE_ACCEPTENCODING = 2;
    public static int SIP_HEADERTYPE_ACCEPTLANGUAGE = 3;
    public static int SIP_HEADERTYPE_ALERTINFO = 4;
    public static int SIP_HEADERTYPE_ALLOW = 5;
    public static int SIP_HEADERTYPE_ALLOWEVENTS = 6;
    public static int SIP_HEADERTYPE_AUTHENTICATIONINFO = 7;
    public static int SIP_HEADERTYPE_AUTHORIZATION = 8;
    public static int SIP_HEADERTYPE_CALLID = 9;
    public static int SIP_HEADERTYPE_CALLINFO = 10;
    public static int SIP_HEADERTYPE_CONTACT = 11;
    public static int SIP_HEADERTYPE_CONTENTDISPOSITION = 12;
    public static int SIP_HEADERTYPE_CONTENTENCODING = 13;
    public static int SIP_HEADERTYPE_CONTENTLANGUAGE = 14;
    public static int SIP_HEADERTYPE_CONTENTLENGTH = 15;
    public static int SIP_HEADERTYPE_CONTENTTYPE = 16;
    public static int SIP_HEADERTYPE_CSEQ = 17;
    public static int SIP_HEADERTYPE_DATE = 18;
    public static int SIP_HEADERTYPE_EVENT = 19;
    public static int SIP_HEADERTYPE_ERRORINFO = 20;
    public static int SIP_HEADERTYPE_EXPIRES = 21;
    public static int SIP_HEADERTYPE_FROM = 22;
    public static int SIP_HEADERTYPE_INREPLYTO = 23;
    public static int SIP_HEADERTYPE_MAXFORWARDS = 24;
    public static int SIP_HEADERTYPE_MINEXPIRES = 25;
    public static int SIP_HEADERTYPE_MIMEVERSION = 26;
    public static int SIP_HEADERTYPE_ORGANIZATION = 27;
    public static int SIP_HEADERTYPE_PRIORITY = 28;
    public static int SIP_HEADERTYPE_PROXYAUTHENTICATE = 29;
    public static int SIP_HEADERTYPE_PROXYAUTHORIZATION = 30;
    public static int SIP_HEADERTYPE_PROXYREQUIRE = 31;
    public static int SIP_HEADERTYPE_PASSERTEDIDENTITY = 32;
    public static int SIP_HEADERTYPE_RECORDROUTE = 33;
    public static int SIP_HEADERTYPE_REPLYTO = 34;
    public static int SIP_HEADERTYPE_REQUIRE = 35;
    public static int SIP_HEADERTYPE_RETRYAFTER = 36;
    public static int SIP_HEADERTYPE_ROUTE = 37;
    public static int SIP_HEADERTYPE_SERVER = 38;
    public static int SIP_HEADERTYPE_SUBJECT = 39;
    public static int SIP_HEADERTYPE_SUPPORTED = 40;
    public static int SIP_HEADERTYPE_TIMESTAMP = 41;
    public static int SIP_HEADERTYPE_TO = 42;
    public static int SIP_HEADERTYPE_UNSUPPORTED = 43;
    public static int SIP_HEADERTYPE_USERAGENT = 44;
    public static int SIP_HEADERTYPE_VIA = 45;
    public static int SIP_HEADERTYPE_WARNING = 46;
    public static int SIP_HEADERTYPE_WWWAUTHENTICATE = 47;
    public static int SIP_HEADERTYPE_WwwAUTHENTICATE = 48;
    public static String SIP_LINE_END = "\r\n";
    public static String SIP_LINE_DOUBLEEND = "\r\n\r\n";
    public static String SIP_LINE_END_SINGLE = "\n";
    public static String USER_AGENT = "BSSHns release 0100o";
    public static int SIP_MSGTYPE_NONE = 0;
    public static int SIP_MSGTYPE_REQUEST = 1;
    public static int SIP_MSGTYPE_RESPONSE = 2;
    public static int SIP_REGSTATE_IDLE = 0;
    public static int SIP_REGSTATE_REGISTERING = 1;
    public static int SIP_REGSTATE_REGISTERED = 2;
    public static int SIP_REGSTATE_UNREGISTERING = 3;
    public static int SIP_REGSTATE_AUTHORIZING = 4;
    public static int SIP_REGSTATE_UNAUTHORIZED = 5;
    public static int SIP_REGSTATE_UNAVAILABLE = 6;
    public static final int SIP_CALLSTATE_IDLE = 0;
    public static final int SIP_CALLSTATE_INVITING = 1;
    public static final int SIP_CALLSTATE_OFFERRED = 2;
    public static final int SIP_CALLSTATE_PROCEEDING = 3;
    public static final int SIP_CALLSTATE_PROGRESSING = 4;
    public static final int SIP_CALLSTATE_ACCEPTED = 5;
    public static final int SIP_CALLSTATE_REMOTEACCEPTED = 6;
    public static final int SIP_CALLSTATE_CONNECTED = 7;
    public static final int SIP_CALLSTATE_DISCONNECTING = 8;
    public static final int SIP_CALLSTATE_TERMINATING = 9;
    public static final int SIP_CALLSTATE_UNAUTHORIZED = 10;
    public static final int SIP_CALLSTATE_CANCELLING = 11;
    public static final int SIP_CALLSTATE_CANCELLED = 12;
    public static final int SIP_CALLSTATE_RECANCELLING = 13;
    public static final int SIP_CALLSTATE_CANCELREMOTEACCEPTED = 14;
    public static final int SIP_CALLSTATE_REJECTED = 15;
    public static final int SIP_CALLSTATE_REDIRECTED = 16;
    public static final int SIP_CALLSTATE_UPDATING = 20;
    public static final int SIP_CALLSTATE_UPDATEPROCEEDING = 21;
    public static final int SIP_CALLSTATE_UPDATEPROGRESSING = 22;
    public static final int SIP_CALLSTATE_UPDATEOFFERRED = 23;
    public static final int SIP_CALLSTATE_UPDATEACCEPTED = 24;
    public static final int SIP_CALLSTATE_UPDATEREJECTED = 25;
    public static final int SIP_CALLSTATE_UPDATEREMOTEACCEPTED = 26;
    public static final int SIP_CALLSTATE_UPDATEREMOTEREJECTED = 27;
    public static final int SIP_CALLSTATE_UPDATEUNAUTHORIZED = 28;
    public static final int SIP_CALLSTATE_UPDATEREDIRECTED = 29;
    public static int SIP_CALLMODE_NONE = 0;
    public static int SIP_CALLMODE_BASIC = 1;
    public static int SIP_CALLMODE_HOLD = 2;
    public static int SIP_SERVICEMODE_BASIC = 0;
    public static int SIP_SERVICEMODE_CONFERENCE = 1;
    public static int SIP_CALLDIRECTION_NONE = 0;
    public static int SIP_CALLDIRECTION_IN = 1;
    public static int SIP_CALLDIRECTION_OUT = 2;
    public static int SIP_MEDIATYPE_NONE = 0;
    public static int SIP_MEDIATYPE_AUDIO = 1;
    public static int SIP_MEDIATYPE_VIDEO = 2;
    public static int SIP_CODEC_NONE = -1;
    public static int SIP_CODEC_G711U = 0;
    public static int SIP_CODEC_G711A = 8;
    public static int SIP_CODEC_G7231 = 4;
    public static int SIP_CODEC_G729 = 18;
    public static int SIP_CODEC_H263 = 34;
    public static int SIP_CODEC_H264 = 98;
    public static int PRIMARY_CODEC_AUDIO = SIP_CODEC_G711U;
    public static int PRIMARY_CODEC_VIDEO = SIP_CODEC_H264;
    public static int SIP_DTMFINFO_DTMFRELAY = 0;
    public static int SIP_DTMFINFO_DTMF = 1;
    public static int SIP_SEQUENCE_INVITE = 1;
    public static int SIP_SEQUENCE_REGISTER = 1;
    public static int SIP_MEDIA_INITPORT = 3000;
    public static int SIP_MEDIA_PORTS = 5;
    public static int SIP_MEDIAFLOW_NONE = 0;
    public static int SIP_MEDIAFLOW_SENDRECV = 1;
    public static int SIP_MEDIAFLOW_SENDONLY = 2;
    public static int SIP_MEDIAFLOW_RECVONLY = 3;
    public static int RTP_AUDIO_SIZE = 1024;
    public static int RTP_VIDEO_SIZE = 30000;
    public static boolean[] SIP_MEDIA_PORTFLAG = new boolean[SIP_MEDIA_PORTS];
    public static int CS_TIMEOUT_TI = 3;
    public static int CS_TIMEOUT_T0 = 15;
    public static int CS_TIMEOUT_T00 = 10;
    public static int CS_TIMEOUT_T000 = 5;
    public static int CS_TIMEOUT_T1 = 30;
    public static int CS_TIMEOUT_T2 = 120;
    public static int CS_TIMEOUT_T3 = 7;
    public static int CS_TIMEOUT_T4 = 7200;
    public static int CS_TIMEOUT_T5 = 7;
    public static int CS_TIMEOUT_T6 = 0;
    public static int CS_TIMEOUT_T7 = 30;
    public static int CS_TIMEOUT_T8 = 7;
    public static int CS_TIMEOUT_T80 = 2;
    public static int CS_TIMEOUT_RESPONSE = 1;
    public static int NETWORKIF_CHECK_TIME = 5;
    public static int TEARDOWN_CODE_NORMAL = 0;
    public static int TEARDOWN_CODE_EEREJECT = 1;
    public static int TEARDOWN_CODE_ERREJECT = 2;
    public static int TEARDOWN_CODE_NOTFOUND = 3;
    public static int TEARDOWN_CODE_ERROR = 4;
    public static int SIP_NETIF_UNAVAILABLE = 0;
    public static int SIP_NETIF_AVAILABLE = 1;
    public static int SIP_NETIF_UNREACHABLE = 2;
    public static int REPEAT_SENDCOUNT = 3;
    public static int SIP_MAXMESSAGE_SIZE = 2500;
    public static boolean SIP_MESSAGE_DEBUG = false;
    public static boolean SIP_CALLHANDLE_DEBUG = false;
    public static Date bootTime = new Date();
    public static int exceptionCountAtCurrentCall = 0;
    public static boolean ventureCall = true;
    public static boolean bLimitedUse = false;
    public static int BACKGROUNDIDLE_MAX_SECONDS = 28800;
    public static int networkStatus = SIP_NETIF_UNAVAILABLE;
    public static String generalPhoneNumber = "";
    public static String hwModelName = "";
    public static String hwId = "";
    public static String firmVersion = "";
    public static String hwImsi = "";
    public static String hwImei = "";
    public static String gcmRegistId = "";
    public static boolean bGCMRegistSend = false;
    public static String ANDROID_API_KEY = "AIzaSyDZcNyOPs5iTQ9kGZaF56Ngf4eCQDzMEl0";
    public static boolean isInternetWiMax = false;
    public static boolean isInternetWiFi = false;
    public static boolean isInternetMobile = false;
    public static String localSdpIp = "0.0.0.0";
    public static boolean usePrivateWiMax = true;
    public static boolean bShutdownApplication = false;
    public static boolean bOuttraffic = false;
    public static boolean bIntraffic = false;
    public static String macAddress = "";
    public static boolean bTtsservice = false;
    public static boolean bSupportTts = false;
    public static int WIFI_CALL_SIGNAL_MIN = 3;
    public static Date networkInfoCheckTime = new Date();
    public static int WIFI_SIGNAL_VALUE = 0;
    public static String mobileLanguage = "ko";
    public static boolean bActive = false;
    public static boolean bVibrator = true;
    public static boolean bVibrating = false;
    public static int iVibrator = 0;
    public static GetIpDns ipdns = new GetIpDns();
    public static boolean bNetworkActive = false;
    public static int antenaOnStep = 0;
    public static boolean bProximityOn = false;
    public static int localPort = SIP_LOCAL_PORT;
    public static String strLocalip = null;
    public static boolean bBackgroundRunning = false;
    public static boolean bGeneralPhoneDetected = false;
    public static stackKey stackkey = new stackKey();
    public static Date backgroundEnteredTime = new Date();
    public static boolean bdialContextActive = false;
    public static UserDial userDial = new UserDial();
    public static int SIPCTRL_INTERVAL = 40;
    public static boolean bVideocommunication = true;
    public static boolean bDirectCall = true;
    protected static boolean bStackLicensed = false;
    public static boolean bUseSendTimer = false;
    public static boolean bUseCtrlTimer = false;

    public static int getCSeqMethod(String s) {
        int iMethodType = SIP_METHODTYPE_NONE;
        int iS = s.indexOf("CSeq: ");
        int iE = 0;
        if (iS >= 0) {
            iE = s.indexOf(SIP_LINE_END, iS);
        }
        if (iE <= 0) {
            return iMethodType;
        }
        String strCSEQ = s.substring(iS, iE);
        StringTokenizer tokenArray = new StringTokenizer(strCSEQ, " ", true);
        int tokenCount = 0;
        while (tokenArray.hasMoreTokens()) {
            String token = tokenArray.nextToken();
            if (token.length() <= 0 || token.compareTo(" ") == 0 || ++tokenCount != 3) continue;
            if (token.compareTo("REGISTER") == 0) {
                iMethodType = SIP_METHODTYPE_REGISTER;
                break;
            }
            if (token.compareTo("INVITE") == 0) {
                iMethodType = SIP_METHODTYPE_INVITE;
                break;
            }
            if (token.compareTo("CANCEL") == 0) {
                iMethodType = SIP_METHODTYPE_CANCEL;
                break;
            }
            if (token.compareTo("BYE") == 0) {
                iMethodType = SIP_METHODTYPE_BYE;
                break;
            }
            if (token.compareTo("INFO") == 0) {
                iMethodType = SIP_METHODTYPE_INFO;
                break;
            }
            if (token.compareTo("OPTIONS") == 0) {
                iMethodType = SIP_METHODTYPE_OPTIONS;
                break;
            }
            if (token.compareTo("ACK") == 0) {
                iMethodType = SIP_METHODTYPE_ACK;
                break;
            }
            if (token.compareTo("REFER") == 0) {
                iMethodType = SIP_METHODTYPE_REFER;
                break;
            }
            if (token.compareTo("NOTIFY") == 0) {
                iMethodType = SIP_METHODTYPE_NOTIFY;
                break;
            }
            if (token.compareTo("MESSAGE") == 0) {
                iMethodType = SIP_METHODTYPE_MESSAGE;
                break;
            }
            if (token.compareTo("SUBSCRIBE") == 0) {
                iMethodType = SIP_METHODTYPE_SUBSCRIBE;
                break;
            }
            if (token.compareTo("PRACK") != 0) break;
            iMethodType = SIP_METHODTYPE_PRACK;
            break;
        }
        return iMethodType;
    }

    public static int getRequestlineMethod(String str) {
        int iMethodType = SIP_METHODTYPE_NONE;
        if (str.startsWith("INVITE") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_INVITE;
        } else if (str.startsWith("BYE") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_BYE;
        } else if (str.startsWith("ACK") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_ACK;
        } else if (str.startsWith("CANCEL") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_CANCEL;
        } else if (str.startsWith("OPTIONS") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_OPTIONS;
        } else if (str.startsWith("INFO") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_INFO;
        } else if (str.startsWith("PRACK") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_PRACK;
        } else if (str.startsWith("MESSAGE") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_MESSAGE;
        } else if (str.startsWith("SUBSCRIBE") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_SUBSCRIBE;
        } else if (str.startsWith("REFER") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_REFER;
        } else if (str.startsWith("NOTIFY") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_NOTIFY;
        } else if (str.startsWith("REGISTER") && str.endsWith("SIP/2.0\r")) {
            iMethodType = SIP_METHODTYPE_REGISTER;
        } else if (str.startsWith("SIP/2.0") && str.endsWith("\r")) {
            iMethodType = SIP_METHODTYPE_RESPONSE;
        }
        return iMethodType;
    }

    public static void setLicense(String strLicense) {
        String license;
        if (bLimitedUse) {
            Date currentDate = new Date();
            int month = currentDate.getMonth() + 1;
            int day = currentDate.getDate();
            int year = currentDate.getYear() + 1900;
            if (year != 2014 || month > 12) {
                System.out.println("\uc0ac\uc6a9\uae30\uac04 \uc885\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                bStackLicensed = false;
                System.exit(0);
            }
        }
        if (strLicense.compareTo(license = "\uc8fc\uc2dd\ud68c\uc0ac\uc544\uc774\ucf58\ud2b8\ub864\uc2a4 200701243005451") == 0) {
            bStackLicensed = true;
        } else {
            System.out.println("SIP \ub77c\uc774\uc2a8\uc2a4\uac00 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            bStackLicensed = false;
        }
        System.out.println("\uc774 \uc2a4\ud0dd\uc740 \uc544\uc774\ucf58\ud2b8\ub864\uc2a4 \ud648\ub124\ud2b8\uc6cc\ud06c\uc6a9\uc785\ub2c8\ub2e4.");
    }

    public static String getResponseDescription(int code) {
        switch (code) {
            case 100: {
                return "Trying";
            }
            case 180: {
                return "Ringing";
            }
            case 181: {
                return "Call Is Being Forwarded";
            }
            case 182: {
                return "Call Queued";
            }
            case 183: {
                return "Session Progress";
            }
            case 200: {
                return "OK";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 305: {
                return "Use Proxy";
            }
            case 380: {
                return "Alternative Service";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 420: {
                return "Bad Extension";
            }
            case 421: {
                return "Extension Required";
            }
            case 423: {
                return "Interval Too Brief";
            }
            case 480: {
                return "Temporarily Unavailable";
            }
            case 481: {
                return "Call Leg Does Not Exist";
            }
            case 482: {
                return "Loop Detected";
            }
            case 483: {
                return "Two Many Hops";
            }
            case 484: {
                return "Address Incomplete";
            }
            case 485: {
                return "Ambiguous";
            }
            case 486: {
                return "Busy Here";
            }
            case 487: {
                return "Request Canceled";
            }
            case 488: {
                return "Not Acceptable Here";
            }
            case 500: {
                return "Server Internal Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "Version Not Supported";
            }
            case 600: {
                return "Busy Everywhere";
            }
            case 603: {
                return "Decline";
            }
            case 604: {
                return "Does Not Exist Anywhere";
            }
            case 606: {
                return "Not Acceptable";
            }
        }
        return "";
    }

    public static String BSSMD5Get(String data) {
        if (data == null || data.length() <= 0) {
            return null;
        }
        try {
            SIPmd5 md = SIPmd5.getInstance();
            return md.hashData(data.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.out);
            ++exceptionCountAtCurrentCall;
            return null;
        }
    }

    public static String getViaBranch() {
        Date today = new Date();
        return "z9hG4bK-" + today.getTime() + "-" + (int)today.getTime() % 7;
    }

    public static String newTag(String prefix) {
        Date today = new Date();
        return String.valueOf(prefix) + today.getTime() + "-" + today.hashCode();
    }

    public static String newTag() {
        Date today = new Date();
        return String.valueOf(today.getTime()) + "." + today.hashCode();
    }

    public static int getFreeAudioRtpPort() {
        int i = 0;
        while (i < SIP_MEDIA_PORTS) {
            if (!SIP_MEDIA_PORTFLAG[i]) {
                SIPStack.SIP_MEDIA_PORTFLAG[i] = true;
                return SIP_MEDIA_INITPORT + i * 2;
            }
            ++i;
        }
        return 0;
    }

    public static boolean freeAudioRtpPort(int port) {
        int index = (port - SIP_MEDIA_INITPORT) / 2;
        if (index >= 0 && index < SIP_MEDIA_PORTS) {
            SIPStack.SIP_MEDIA_PORTFLAG[index] = false;
            return true;
        }
        return false;
    }

    public static void printAudioRtpPortInfo() {
        System.out.print(">>>> RTP PORT STATUS  ");
        int i = 0;
        while (i < SIP_MEDIA_PORTS) {
            System.out.print("  " + SIP_MEDIA_PORTFLAG[i]);
            ++i;
        }
        System.out.println("  ");
    }

    public static String getIPV4(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        String ip = null;
        try {
            InetAddress ia = InetAddress.getByName(host);
            byte[] address = ia.getAddress();
            if (address.length == 4) {
                int unsignedByte1 = address[0] < 0 ? address[0] + 256 : address[0];
                int unsignedByte2 = address[1] < 0 ? address[1] + 256 : address[1];
                int unsignedByte3 = address[2] < 0 ? address[2] + 256 : address[2];
                int unsignedByte4 = address[3] < 0 ? address[3] + 256 : address[3];
                ip = String.valueOf(unsignedByte1) + "." + unsignedByte2 + "." + unsignedByte3 + "." + unsignedByte4;
            }
        }
        catch (UnknownHostException uhe) {
            System.err.println(uhe);
            ++exceptionCountAtCurrentCall;
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return ip;
    }

    public static boolean isPrivateIp(String ip) {
        if (ip == null || ip.length() < 7) {
            return false;
        }
        boolean bPrivate = false;
        StringTokenizer st = new StringTokenizer(ip, ".", true);
        int tokenCount = 0;
        String token = null;
        int ipdigit_0 = 0;
        int ipdigit_1 = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            if (token == null || token.length() <= 0 || token.length() > 3 || token.compareTo(".") == 0) continue;
            if (tokenCount == 0) {
                ipdigit_0 = Integer.parseInt(token.trim());
            } else if (tokenCount == 1) {
                ipdigit_1 = Integer.parseInt(token.trim());
            }
            ++tokenCount;
        }
        if (tokenCount == 4) {
            bPrivate = ipdigit_0 == 10 || ipdigit_0 == 172 && ipdigit_1 >= 16 && ipdigit_1 <= 31 || ipdigit_0 == 192 && ipdigit_1 == 168;
        }
        return bPrivate;
    }

    public static boolean getLicensed() {
        return bStackLicensed;
    }
}

