/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.commons;

import android.util.Log;
import com.artncore.commons.define;
import java.util.Calendar;

public class DataClasses {

    public static class AirQualityData {
        public Info info = new Info();
        public Device device = new Device();

        public static class Device {
            public boolean bPMSensorStatus = false;
            public boolean bCo2SensorStatus = false;
            public boolean bAutoLEDCtrl = true;
            public boolean bAutoFanCtrl = true;
            public byte hLEDBrightness = (byte)2;
            public byte hFanMode = 0;
            public double dFigure_PM10 = 0.0;
            public double dFigure_PM2p5 = 0.0;
            public double dFigure_PM1p0 = 0.0;
            public double dFigure_CO2 = 0.0;
            public byte hLevel_PM10 = 0;
            public byte hLevel_PM2p5 = 0;
            public byte hLevel_PM1p0 = 0;
            public byte hLevel_CO2 = 0;

            public String ToDebugString() {
                String retStr = "==========================\r\nDeviceData \r\n==========================\r\nbPMSensorStatus     : " + this.bPMSensorStatus + "\r\nbPMSensorStatus      : " + this.bPMSensorStatus + "\r\nbAutoLEDCtrl      : " + this.bAutoLEDCtrl + "\r\nbAutoFanCtrl      : " + this.bAutoFanCtrl + "\r\nhLEDBrightness      : " + this.hLEDBrightness + "\r\nhFanMode      : " + this.hFanMode + "\r\n\r\nhLevel_PM10       : " + this.hLevel_PM10 + "\r\ndFigure_PM10       : " + this.dFigure_PM10 + "\r\n\r\nhLevel_PM2p5      : " + this.hLevel_PM2p5 + "\r\ndFigure_PM2p5      : " + this.dFigure_PM2p5 + "\r\n\r\nhLevel_PM1p0       : " + this.hLevel_PM1p0 + "\r\ndFigure_PM1p0       : " + this.dFigure_PM1p0 + "\r\n\r\nhLevel_CO2            : " + this.hLevel_CO2 + "\r\ndFigure_CO2            : " + this.dFigure_CO2 + "\r\n==========================";
                return retStr;
            }

            public static class AIRLevel {

                public static final class LEVEL8 {

                    public static final class CO2 {
                        public static final byte BEST = 33;
                        public static final byte GOOD = 34;
                        public static final byte FINE = 35;
                        public static final byte NORMAL = 36;
                        public static final byte BAD = 37;
                        public static final byte QUITEBAD = 38;
                        public static final byte WORSE = 39;
                        public static final byte WORST = 40;
                    }

                    public static final class PM2_5 {
                        public static final byte BEST = 17;
                        public static final byte GOOD = 18;
                        public static final byte FINE = 19;
                        public static final byte NORMAL = 20;
                        public static final byte BAD = 21;
                        public static final byte QUITEBAD = 22;
                        public static final byte WORSE = 23;
                        public static final byte WORST = 24;
                    }

                    public static final class PM10 {
                        public static final byte BEST = 1;
                        public static final byte GOOD = 2;
                        public static final byte FINE = 3;
                        public static final byte NORMAL = 4;
                        public static final byte BAD = 5;
                        public static final byte QUITEBAD = 6;
                        public static final byte WORSE = 7;
                        public static final byte WORST = 8;
                    }
                }

                public static final class LEVEL4 {

                    public static final class CO2 {
                        public static final byte GOOD = 34;
                        public static final byte NORMAL = 35;
                        public static final byte BAD = 36;
                        public static final byte WORSE = 37;
                    }

                    public static final class PM2_5 {
                        public static final byte GOOD = 18;
                        public static final byte NORMAL = 19;
                        public static final byte BAD = 20;
                        public static final byte WORSE = 21;
                    }

                    public static final class PM10 {
                        public static final byte GOOD = 2;
                        public static final byte NORMAL = 3;
                        public static final byte BAD = 4;
                        public static final byte WORSE = 5;
                    }
                }

                public static final class LEVEL6 {

                    public static final class CO2 {
                        public static final byte BEST = 33;
                        public static final byte GOOD = 34;
                        public static final byte NORMAL = 35;
                        public static final byte BAD = 36;
                        public static final byte WORSE = 37;
                        public static final byte WORST = 38;
                    }

                    public static final class PM2_5 {
                        public static final byte BEST = 17;
                        public static final byte GOOD = 18;
                        public static final byte NORMAL = 19;
                        public static final byte BAD = 20;
                        public static final byte WORSE = 21;
                        public static final byte WORST = 22;
                    }

                    public static final class PM10 {
                        public static final byte BEST = 1;
                        public static final byte GOOD = 2;
                        public static final byte NORMAL = 3;
                        public static final byte BAD = 4;
                        public static final byte WORSE = 5;
                        public static final byte WORST = 6;
                    }
                }
            }

            public static class FanMode {
                public static final byte Always = 0;
                public static final byte Off = 1;
                public static final byte Repeat = 2;
                public static final byte Auto = -1;

                public static boolean checkRange(byte hMode) {
                    return hMode >= 0 && 2 >= hMode || hMode == -1;
                }
            }

            public static class LEDBrightness {
                public static final byte Level_00 = 0;
                public static final byte Level_01 = 1;
                public static final byte Level_02 = 2;
                public static final byte Level_Auto = -1;

                public static boolean checkRange(byte hLevel) {
                    return hLevel >= 0 && 2 >= hLevel || hLevel == -1;
                }
            }
        }

        public static class Info {
            public SupportClass Support = new SupportClass();
            public byte FWVer_Year;
            public byte FWVer_Month;
            public byte FWVer_Day;
            public byte FWVer_No;
            public byte ProtocolVer_Main;
            public byte ProtocolVer_Sub;
            public byte Vendor;
            public boolean Install = false;

            public String ToDebugString() {
                String retStr = "==========================\r\n Info\r\n==========================\r\nInstall         : " + this.Install + "\r\nFwVer           : " + (this.FWVer_Year + 2000) + "." + this.FWVer_Month + "." + this.FWVer_Day + "." + this.FWVer_No + "\r\nProtocolVer     : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\nVendor  \t     : " + this.Vendor + "\r\n[Support]\r\nbSensePM2p5   : " + this.Support.bSensePM2p5 + "\r\nbSensePM10    : " + this.Support.bSensePM10 + "\r\nbSensePM1p0   : " + this.Support.bSensePM1p0 + "\r\nbSenseCO2       : " + this.Support.bSenseCO2 + "\r\nbCtrlableLEDBrightness   : " + this.Support.bCtrlableLEDBrightness + "\r\nbCtrlableFanMode   : " + this.Support.bCtrlableFanMode + "\r\n==========================";
                return retStr;
            }

            public class SupportClass {
                public boolean bSensePM10 = false;
                public boolean bSensePM2p5 = false;
                public boolean bSensePM1p0 = false;
                public boolean bSenseCO2 = false;
                public boolean bCtrlableLEDBrightness = false;
                public boolean bCtrlableFanMode = false;
            }
        }
    }

    public static class InterlayerNoiseSensor {
        public Info info = new Info();
        public Device device = new Device();

        public String ToDebugString() {
            String retStr = "==========================\r\nInterlayerNoiseSensor\r\n==========================\r\n";
            retStr = retStr + "info = " + this.info.ToDebugString();
            retStr = retStr + "device = " + this.device.ToDebugString();
            retStr = retStr + "==========================";
            return retStr;
        }

        public static class Info {
            public boolean Install = false;
            public byte Vender = 0;
            public byte FwVer_Year = 0;
            public byte FwVer_Month = 0;
            public byte FwVer_Day = 0;
            public byte FwVer_Number = 0;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;

            public String ToDebugString() {
                String retStr = "==========================\r\n( InterLayer Noise Sensor - Info)\r\n==========================\r\nVender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }
        }

        public static class Device {
            private boolean NoiseOccur = false;
            private boolean CommError = false;

            public boolean SetNoiseOccur(boolean input) {
                this.NoiseOccur = input;
                return true;
            }

            public boolean GetNoiseOccur() {
                return this.NoiseOccur;
            }

            public boolean SetCommStatus(boolean input) {
                this.CommError = input;
                return true;
            }

            public boolean GetCommStatus() {
                return this.CommError;
            }

            public String ToDebugString() {
                String retStr = "==========================\r\n(InterLayer Noise Sensor - Device) \r\n==========================\r\nCommError       : " + this.CommError + "\r\nNoiseOccur        : " + this.NoiseOccur + "\r\n==========================";
                return retStr;
            }
        }
    }

    public static class NoticeData {
        public String Date = "";
        public int Number = 0;
        public String Message = "";

        public String ToDebugString() {
            String retStr = "==========================\r\nNoticeData\r\n==========================\r\n";
            retStr = retStr + "Date :" + this.Date + " \r\nNumber :" + this.Number + " \r\nmessage :" + this.Message + " \r\n";
            retStr = retStr + "==========================";
            return retStr;
        }

        public void SetNoticeData(String date, int number, String message) {
            this.Date = date;
            this.Number = number;
            this.Message = message;
        }
    }

    public static class GasDebugData {
        public String time = "null";
        public String packet = "null";

        public String ToDebugString() {
            String retStr = "==========================\r\nGasDebugData\r\n==========================\r\n";
            retStr = retStr + "time :" + this.time + " \r\npacket :" + this.packet + "\r\n";
            retStr = retStr + "==========================";
            return retStr;
        }
    }

    public static class CarEventData {
        public Calendar time = Calendar.getInstance();
        public int EventType = 0;
        public String CarNum = "null";
        public String location = "null";
        public String message = "null";

        public String ToDebugString() {
            String retStr = "==========================\r\nCarEventData\r\n==========================\r\n";
            String temp_time = this.time != null ? String.format("%04d-%02d-%02d %02d:%02d:%02d", this.time.get(1), this.time.get(2) + 1, this.time.get(5), this.time.get(11), this.time.get(12), this.time.get(13)) : "null";
            retStr = retStr + "time :" + temp_time + " \r\nEventType :" + this.EventType + " \r\nLocation :" + this.location + " \r\nCarNum :" + this.CarNum + " \r\nmessage :" + this.message + " \r\n";
            retStr = retStr + "==========================";
            return retStr;
        }
    }

    public static class CarParkingData {
        public int index = 0;
        public String card_num = "null";
        public String card_uid = "null";
        public String card_sn = "null";
        public String card_type = "null";
        public Calendar time = Calendar.getInstance();
        public String location_text = "null";
        public String location_map = "null";
        public String vehicle_info = "null";
        public String ftp_path = "null";
        public String ftp_idpass_info = "null";
        public String message = "null";

        public String ToDebugString() {
            String retStr = "==========================\r\nCarParkingData\r\n==========================\r\n";
            String temp_time = this.time != null ? String.format("%04d-%02d-%02d %02d:%02d:%02d", this.time.get(1), this.time.get(2) + 1, this.time.get(5), this.time.get(11), this.time.get(12), this.time.get(13)) : "null";
            retStr = retStr + "index :" + this.index + " \r\ncard_num :" + this.card_num + " \r\ncard_uid :" + this.card_uid + " \r\ncard_sn :" + this.card_sn + " \r\ncard_type :" + this.card_type + " \r\ntime :" + temp_time + " \r\nlocation_text :" + this.location_text + " \r\nlocation_map :" + this.location_map + " \r\nvehicle_info :" + this.vehicle_info + " \r\nftp_path :" + this.ftp_path + " \r\nftp_idpass_info :" + this.ftp_idpass_info + " \r\nmessage :" + this.message + " \r\n";
            retStr = retStr + "==========================";
            return retStr;
        }
    }

    public static class Purity {
        public Info info = new Info();
        public PurityData[] purityData = null;

        public boolean SetPurityCount(byte cnt) {
            if (this.info == null) {
                return false;
            }
            if (cnt <= 0 || cnt > 15) {
                return false;
            }
            this.info.InsidePurityCount = cnt;
            this.purityData = new PurityData[cnt];
            for (byte i = 0; i < cnt; i = (byte)(i + 1)) {
                this.purityData[i] = new PurityData();
            }
            return true;
        }

        public static class ERROR {
            public boolean bError = false;
            public boolean bEtc = false;

            private String ToStrBoolean(boolean in) {
                if (in) {
                    return "O";
                }
                return "X";
            }
        }

        public static class AllRoomData {
            public byte RoomCount;
            public EachRoomData[] Room;

            public AllRoomData(byte nRoomCount) {
                this.RoomCount = nRoomCount;
                this.Room = new EachRoomData[this.RoomCount];
                for (byte i = 0; i < this.RoomCount; i = (byte)(i + 1)) {
                    this.Room[i] = new EachRoomData();
                }
            }

            public String ToDebugString() {
                String retStr = "==========================\r\nAllRoomData\r\n==========================\r\n";
                for (byte i = 0; i < this.RoomCount; i = (byte)(i + 1)) {
                }
                retStr = retStr + "==========================";
                return retStr;
            }

            public class EachRoomData {
                public byte Mode = MODE.AI;
                public byte Volume = VOLUME.Auto;
            }
        }

        public static class CtrlRoomData {
            public byte Control = 0;
        }

        public static class AirSensingData {
            public byte AirSense;
            public byte Dust;
            public byte FindDust;
            public byte UltraFindDust;
            public byte Co2;
            public byte Voc;
            public byte Temp;
            public byte Humidity;
            public byte[] dustValue;
            public byte[] fineDustValue;
            public byte[] co2Value;
            byte[] ModeArray = new byte[]{0, 0, 0, 0, 0, 0};

            public AirSensingData() {
                this.dustValue = new byte[]{0, 0};
                this.fineDustValue = new byte[]{0, 0};
                this.co2Value = new byte[]{0, 0};
            }

            public String ToDebugString(byte RoomIndex) {
                String retStr = "==========================\r\nAirData (" + (RoomIndex + 1) + ") \r\n==========================\r\nAirSense    : " + MODE.ToDebugString(this.AirSense) + "\r\nDust        : " + MODE.ToDebugString(this.Dust) + "\r\nFindDust    : " + MODE.ToDebugString(this.FindDust) + "\r\nCo2         : " + MODE.ToDebugString(this.Co2) + "\r\nVoc         : " + MODE.ToDebugString(this.Voc) + "\r\nTemp        : " + MODE.ToDebugString(this.Temp) + "\r\nHumidity    : " + MODE.ToDebugString(this.Humidity) + "\r\nUltraFindDust    : " + MODE.ToDebugString(this.UltraFindDust) + "\r\n==========================";
                return retStr;
            }
        }

        public static class ErvData {
            public byte OnOff;
            public byte Mode;
            public byte Filter;
            public byte Volume;

            public String ToDebugString(byte RoomIndex) {
                String retStr = "==========================\r\nErvData (" + (RoomIndex + 1) + ") \r\n==========================\r\nOnOff         : " + MODE.ToDebugString(this.OnOff) + "\r\nMode         : " + MODE.ToDebugString(this.Mode) + "\r\nFilter         : " + MODE.ToDebugString(this.Filter) + "\r\nVolume         : " + MODE.ToDebugString(this.Volume) + "\r\n==========================";
                return retStr;
            }
        }

        public static class PurityData {
            public byte OnOff;
            public byte Mode;
            public byte Volume;
            public byte AddService;
            public ErvData ervData = new ErvData();
            public AirSensingData airSensingData = new AirSensingData();

            public String ToDebugString(byte RoomIndex) {
                String retStr = "==========================\r\nPurityData (" + (RoomIndex + 1) + ") \r\n==========================\r\nOnOff        : " + MODE.ToDebugString(this.OnOff) + "\r\nMode         : " + MODE.ToDebugString(this.Mode) + "\r\nVolume       : " + MODE.ToDebugString(this.Volume) + "\r\n==========================";
                return retStr;
            }
        }

        public static class VOLUME {
            public static byte Auto = 0;
            public static byte Weak = 1;
            public static byte Medium = (byte)2;
            public static byte Strong = (byte)3;

            public static boolean CheckGetVolume(byte Mode) {
                if (Mode == Auto) {
                    return true;
                }
                if (Mode == Weak) {
                    return true;
                }
                if (Mode == Medium) {
                    return true;
                }
                return Mode == Strong;
            }
        }

        public static class FILTERALARM {
            public static byte False = 0;
            public static byte True = 1;
            public static byte NoInfo = (byte)2;

            public static String ToDebugString(byte FilterAlarm) {
                String retStr = FilterAlarm == False ? "False" : (FilterAlarm == True ? "True" : (FilterAlarm == NoInfo ? "NoInfo" : "UnDefined"));
                return retStr;
            }

            public static boolean CheckGetFilterAlarm(byte FilterAlarm) {
                if (FilterAlarm == False) {
                    return true;
                }
                if (FilterAlarm == True) {
                    return true;
                }
                return FilterAlarm == NoInfo;
            }
        }

        public static class ERV_MODE {
            public static byte AI = 0;
            public static byte HeatChange = 1;
            public static byte Bypass = (byte)2;

            public static String ToDebugString(byte Mode) {
                String retStr = Mode == AI ? "AI" : (Mode == HeatChange ? "HeatChange" : (Mode == Bypass ? "Bypass" : "UnDefined"));
                return retStr;
            }

            public static boolean CheckGetMode(byte Mode) {
                if (Mode == AI) {
                    return true;
                }
                if (Mode == HeatChange) {
                    return true;
                }
                return Mode == Bypass;
            }
        }

        public static class ADDSERVICE {
            public static byte NotUse = 0;
            public static byte NoWind = 1;
            public static byte Sleep = (byte)2;

            public static String ToDebugString(byte add) {
                String retStr = add == NotUse ? "NotUse" : (add == NoWind ? "NoWind" : (add == Sleep ? "Sleep" : "UnDefined"));
                return retStr;
            }

            public static boolean CheckGetAddService(byte add) {
                if (add == NotUse) {
                    return true;
                }
                if (add == NoWind) {
                    return true;
                }
                return add == Sleep;
            }
        }

        public static class MODE {
            public static byte AI = 0;
            public static byte Purity = 1;
            public static byte Venti = (byte)2;

            public static String ToDebugString(byte Mode) {
                String retStr = Mode == AI ? "AI" : (Mode == Purity ? "Purity" : (Mode == Venti ? "Venti" : "UnDefined"));
                return retStr;
            }

            public static boolean CheckGetMode(byte Mode) {
                if (Mode == AI) {
                    return true;
                }
                if (Mode == Purity) {
                    return true;
                }
                return Mode == Venti;
            }
        }

        public static class ONOFF {
            public static byte PurityON = 1;
            public static byte PurityOFF = 0;

            public static String ToDebugString(byte Mode) {
                String retStr = Mode == PurityON ? "PurityON" : (Mode == PurityOFF ? "PurityOFF" : "UnDefined");
                return retStr;
            }

            public static boolean CheckGetOnOff(byte OnOff) {
                if (OnOff == PurityON) {
                    return true;
                }
                return OnOff == PurityOFF;
            }

            public static boolean GetOnOff(byte Mode) {
                if (Mode == PurityON) {
                    return true;
                }
                if (Mode == PurityOFF) {
                    return false;
                }
                return false;
            }
        }

        public static class Status {
            public static byte WAIT_OUTDOOR = 0;
            public static byte WAIT_INSIDE = 1;
            public static byte WAIT_ALL = (byte)2;
            public static byte COMPLETE = (byte)3;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == WAIT_OUTDOOR) {
                    return true;
                }
                if (nStatus == WAIT_INSIDE) {
                    return true;
                }
                if (nStatus == WAIT_ALL) {
                    return true;
                }
                return nStatus == COMPLETE;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == WAIT_OUTDOOR ? "OFF" : (nStatus == WAIT_INSIDE ? "STAND_BY" : (nStatus == WAIT_ALL ? "NOT_SUPPORT" : (nStatus == COMPLETE ? "ON" : "UnDefined")));
                return retStr;
            }
        }

        public static class Info {
            public byte InsidePurityCount = 0;
            public byte PurityStatus;
            public byte Vendor;
            public byte FwVer_Year;
            public byte FwVer_Month;
            public byte FwVer_Day;
            public byte FwVer_Number;
            public byte ProtocolVer_Main;
            public byte ProtocolVer_Sub;
            public SupportInfo Support = new SupportInfo();

            public Info() {
                this.PurityStatus = Status.WAIT_OUTDOOR;
            }

            public String ToDebugString() {
                String retStr = "==========================\r\nInfo\r\n==========================\r\nInsidePurityCount    : " + this.InsidePurityCount + "\r\nVendor       : " + String.format("0x%02X", this.Vendor) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }

            public class SupportInfo {
                public boolean VolumeControl;
                public boolean ModeControl;
                public boolean AirSensing;
                public boolean NoWindFunc;
                public boolean SleepFunc;
            }
        }
    }

    public static class SystemAircon {
        public Info info = new Info();
        public Setting setting = new Setting();
        public AirconUnitData[] Aircon = null;

        public boolean setInsideAirConditionerCnt(byte hCnt) {
            if (this.info == null) {
                return false;
            }
            if (hCnt <= 0 || hCnt > 15) {
                return false;
            }
            this.info.hInsideAirconCnt = hCnt;
            this.Aircon = new AirconUnitData[hCnt];
            for (byte i = 0; i < hCnt; i = (byte)(i + 1)) {
                this.Aircon[i] = new AirconUnitData();
            }
            return true;
        }

        public static class AirconUnitData {
            public byte hInsideID = 0;
            public byte hPower = POWER.NoInfo;
            public byte hMode = MODE.NoInfo;
            public byte hAirVol = AIRVOLUME.NoInfo;
            public byte hSetTemper = 0;
            public byte hCurrentTemper = 0;
            public boolean bAirSwing;
            public boolean bOutAirconError = false;
            public boolean bInsideAirconError = false;
            public byte hErrorCode1 = 0;
            public byte hErrorCode2 = 0;

            public String ToDebugString() {
                String retStr = "==========================\r\nhInsideID         : " + this.hInsideID + "\r\nhPower         : " + POWER.ToDebugString(this.hPower) + "\r\nhMode         : " + MODE.ToDebugString(this.hMode) + "\r\nhAirVol         : " + AIRVOLUME.ToDebugString(this.hAirVol) + "\r\nhSetTemper      : " + this.hSetTemper + "\r\nhCurrentTemper      : " + this.hCurrentTemper + "\r\nbAirSwing      : " + this.bAirSwing + "\r\nbOutAirconError      : " + this.bOutAirconError + "\r\nbInsideAirconError      : " + this.bInsideAirconError + "\r\nhErrorCode1    : " + String.format("0x%02X", this.hErrorCode1) + "\r\nhErrorCode2       : " + String.format("0x%02X", this.hErrorCode2) + "\r\n==========================";
                return retStr;
            }
        }

        public static class AIRVOLUME {
            public static byte Auto = 0;
            public static byte Low = 1;
            public static byte Mid = (byte)2;
            public static byte High = (byte)3;
            public static byte NoInfo = (byte)-1;

            public static boolean checkAirVolRange(byte hAirVol) {
                if (hAirVol == Auto) {
                    return true;
                }
                if (hAirVol == Low) {
                    return true;
                }
                if (hAirVol == Mid) {
                    return true;
                }
                if (hAirVol == High) {
                    return true;
                }
                return hAirVol == NoInfo;
            }

            public static String ToDebugString(byte hAirVol) {
                String retStr = hAirVol == Auto ? "Auto" : (hAirVol == Low ? "Low" : (hAirVol == Mid ? "Mid" : (hAirVol == High ? "High" : (hAirVol == NoInfo ? "NoInfo" : "UnDefined"))));
                return retStr;
            }
        }

        public static class MODE {
            public static byte Auto = 0;
            public static byte Cooling = 1;
            public static byte Dehumidify = (byte)2;
            public static byte Fan = (byte)3;
            public static byte Heating = (byte)4;
            public static byte NoInfo = (byte)-1;

            public static String ToDebugString(byte Mode) {
                String retStr = Mode == Auto ? "Auto" : (Mode == Cooling ? "Cooling" : (Mode == Dehumidify ? "Dehumidify" : (Mode == Fan ? "Fan" : (Mode == Heating ? "Heating" : (Mode == NoInfo ? "NoInfo" : "UnDefined")))));
                return retStr;
            }

            public static boolean checkModeRange(byte Mode) {
                if (Mode == Auto) {
                    return true;
                }
                if (Mode == Cooling) {
                    return true;
                }
                if (Mode == Dehumidify) {
                    return true;
                }
                if (Mode == Fan) {
                    return true;
                }
                if (Mode == Heating) {
                    return true;
                }
                return Mode == NoInfo;
            }
        }

        public static class POWER {
            public static byte NoInfo = 0;
            public static byte On = 1;
            public static byte Off = (byte)2;
            public static byte RemoveHeat = (byte)3;

            public static String ToDebugString(byte hPower) {
                String retStr = hPower == NoInfo ? "NoInfo" : (hPower == On ? "On" : (hPower == Off ? "Off" : (hPower == RemoveHeat ? "RemoveHeat" : "UnDefined")));
                return retStr;
            }

            public static boolean checkPowerRange(byte hPower) {
                if (hPower == NoInfo) {
                    return true;
                }
                if (hPower == On) {
                    return true;
                }
                if (hPower == Off) {
                    return true;
                }
                return hPower == RemoveHeat;
            }

            public static boolean getPower(byte hPower) {
                return hPower == On;
            }
        }

        public static class Status {
            public static byte WAIT_OUTDOOR = 0;
            public static byte WAIT_INSIDE = 1;
            public static byte WAIT_ALL = (byte)2;
            public static byte COMPLETE = (byte)3;

            public static boolean checkRange(byte nStatus) {
                if (nStatus == WAIT_OUTDOOR) {
                    return true;
                }
                if (nStatus == WAIT_INSIDE) {
                    return true;
                }
                if (nStatus == WAIT_ALL) {
                    return true;
                }
                return nStatus == COMPLETE;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == WAIT_OUTDOOR ? "OFF" : (nStatus == WAIT_INSIDE ? "STAND_BY" : (nStatus == WAIT_ALL ? "NOT_SUPPORT" : (nStatus == COMPLETE ? "ON" : "UnDefined")));
                return retStr;
            }
        }

        public static class Setting {
            public byte hSettingStatus = 0;
            public byte hAirconSetting = 1;
            public byte hManufactureSetting = 1;
            public GroupInfo groupinfo = new GroupInfo();

            public String ToDebugString() {
                String retStr = "==========================\r\nSetting\r\n==========================\r\nhSettingStatus    : " + String.format("0x%02X", this.hSettingStatus) + "\r\nhAirconSetting       : " + String.format("0x%02X", this.hAirconSetting) + "\r\nhManufactureSetting       : " + String.format("0x%02X", this.hManufactureSetting) + "\r\n==========================";
                return retStr;
            }

            public static class Group {
                public byte hNo = 0;
                public byte hGroupValue01 = 0;
                public byte hGroupValue02 = 0;

                public String ToDebugString() {
                    String retStr = "==========================\r\nGroup\r\n==========================\r\nhNo    : " + String.format("0x%02X", this.hNo) + "\r\nhGroupValue01       : " + String.format("0x%02X", this.hGroupValue01) + "\r\nhGroupValue02       : " + String.format("0x%02X", this.hGroupValue02) + "\r\n==========================";
                    return retStr;
                }
            }

            public static class GroupInfo {
                public byte hSettingStatus = 0;
                public byte hGroupCnt = 0;
                public Group[] group;

                public GroupInfo() {
                    this.setGroupCnt(this.hGroupCnt);
                }

                public boolean setGroupCnt(byte hCnt) {
                    if (hCnt <= 0 || hCnt > 15) {
                        return false;
                    }
                    this.hGroupCnt = hCnt;
                    this.group = new Group[hCnt];
                    for (byte i = 0; i < hCnt; i = (byte)(i + 1)) {
                        this.group[i] = new Group();
                    }
                    return true;
                }

                public String ToDebugString() {
                    String retStr = "==========================\r\nSetting\r\n==========================\r\nhSettingStatus    : " + String.format("0x%02X", this.hSettingStatus) + "\r\nhGroupCnt       : " + String.format("0x%02X", this.hGroupCnt) + "\r\n==========================";
                    return retStr;
                }
            }
        }

        public static class Info {
            public byte hInsideAirconCnt = 0;
            public byte hOutsideAirconCnt = 0;
            public byte hFirtstOutAirconCnt = 0;
            public byte hAirconStatus;
            public byte hVendor = 0;
            public byte hFwVer_Year = 0;
            public byte hFwVer_Month = 0;
            public byte hFwVer_Day = 0;
            public byte hFwVer_No = 0;
            public byte hProtocolVer_Main = 0;
            public byte hProtocolVer_Sub = 0;
            public SupportInfo Support = new SupportInfo();

            public Info() {
                this.hAirconStatus = Status.WAIT_OUTDOOR;
            }

            public String ToDebugString() {
                String retStr = "==========================\r\nInfo\r\n==========================\r\nhInsideAirconCnt    : " + this.hInsideAirconCnt + "\r\nhOutsideAirconCnt    : " + this.hOutsideAirconCnt + "\r\nhFirtstOutAirconCnt    : " + this.hFirtstOutAirconCnt + "\r\nhAirconStatus    : " + this.hAirconStatus + "\r\nhVendor       : " + String.format("0x%02X", this.hVendor) + "\r\nhFwVer        : " + (this.hFwVer_Year + 2000) + "." + this.hFwVer_Month + "." + this.hFwVer_Day + "." + this.hFwVer_No + "\r\nhProtocolVer  : V" + this.hProtocolVer_Main + "." + this.hProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }

            public class SupportInfo {
                public byte hMinCoolSetTemper = (byte)18;
                public byte hMaxCoolSetTemper = (byte)30;
                public byte hMinHeatSetTemper = (byte)16;
                public byte hMaxHeatSetTemper = (byte)45;
                public boolean bV2CMDUsage = false;
                public boolean bModeCtrl = false;
                public boolean bAirVolCtrl = false;
                public boolean bCtrlOnResidualHeatRemoval = false;
                public boolean bChangeTemperRange = false;
                public boolean bFCUInterlock = false;
                public boolean bModeCooling = false;
                public boolean bModeFan = false;
                public boolean bModeHeating = false;
                public boolean bModeDehumidify = false;
                public boolean bModeAuto = false;
                public boolean bAirSwing = false;

                public String ToDebugString() {
                    String retStr = "==========================\r\nSupportInfo\r\n==========================\r\nhMinCoolSetTemper     : " + Info.this.Support.hMinCoolSetTemper + "\r\nhMaxCoolSetTemper     : " + Info.this.Support.hMaxCoolSetTemper + "\r\nhMinHeatSetTemper     : " + Info.this.Support.hMinHeatSetTemper + "\r\nhMaxHeatSetTemper     : " + Info.this.Support.hMaxHeatSetTemper + "\r\nbV2CMDUsage     : " + Info.this.Support.bV2CMDUsage + "\r\nbModeCtrl     : " + Info.this.Support.bModeCtrl + "\r\nbAirVolCtrl     : " + Info.this.Support.bAirVolCtrl + "\r\nbCtrlOnResidualHeatRemoval     : " + Info.this.Support.bCtrlOnResidualHeatRemoval + "\r\nbChangeTemperRange     : " + Info.this.Support.bChangeTemperRange + "\r\nbFCUInterlock     : " + Info.this.Support.bFCUInterlock + "\r\nbModeCooling     : " + Info.this.Support.bModeCooling + "\r\nbModeFan     : " + Info.this.Support.bModeFan + "\r\nbModeHeating     : " + Info.this.Support.bModeHeating + "\r\nbModeDehumidify     : " + Info.this.Support.bModeDehumidify + "\r\nnModeAuto     : " + Info.this.Support.bModeAuto + "\r\nbAirSwing     : " + Info.this.Support.bAirSwing + "\r\n==========================";
                    return retStr;
                }
            }
        }
    }

    public static class LedDimming {
        public Info info = new Info();
        public Device device = new Device();

        public static class COLOR {
            public static byte UnSet = (byte)-1;
            public static byte Min = 0;
            public static byte Max = (byte)100;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus >= Min && nStatus <= Max) {
                    return true;
                }
                return nStatus == UnSet;
            }
        }

        public static class Level {
            public static byte UnSet = (byte)-1;
            public static byte Min = 0;
            public static byte Max = (byte)100;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus >= Min && nStatus <= Max) {
                    return true;
                }
                return nStatus == UnSet;
            }
        }

        public static class POWER {
            public static byte UnSet = (byte)-1;
            public static byte On = 1;
            public static byte Off = (byte)2;

            public static boolean CheckRange(byte nStatus) {
                return nStatus >= UnSet && nStatus <= Off;
            }

            public static String ToDebugString(byte Color) {
                String retStr = Color == UnSet ? "UnSet" : (Color == On ? "On" : (Color == Off ? "Off" : "UnDefined"));
                return retStr;
            }
        }

        public static class Device {
            public boolean OnOff = false;
            public byte Level = 0;
            public byte Color = 0;
            public double DC_Voltage = 0.0;
            public boolean Sensor = false;
            public byte Sensitivity = 0;
            public double BoardDegree = 0.0;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Circuit\r\n==========================\r\nOnOff : " + this.OnOff + "\r\nLevel : " + this.Level + "\r\nColor : " + this.Color + "\r\nDC_Voltage : " + this.DC_Voltage + "\r\nSensor : " + this.Sensor + "\r\nSensitivity : " + this.Sensitivity + "\r\nBoardDegree : " + this.BoardDegree + "\r\n";
                retStr = retStr + "==========================";
                return retStr;
            }
        }

        public static class Info {
            public boolean Install = false;
            public SUPPORT Support = new SUPPORT();
            public byte Vender = 0;
            public byte FwVer_Year = 0;
            public byte FwVer_Month = 0;
            public byte FwVer_Day = 0;
            public byte FwVer_Number = 0;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Info\r\n==========================\r\nInstall   : " + this.Install + "\r\n" + this.Support.ToDebugString() + "Vender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }

            public static class SUPPORT {
                public boolean OnOff = false;
                public boolean Level = false;
                public boolean Color = false;
                public boolean DC_Voltage = false;
                public boolean Sensor = false;
                public boolean Sensitivity = false;
                public boolean BoardDegree = false;
                public boolean AllControlType = false;

                public String ToDebugString() {
                    String retStr = "[SUPPORT]\r\nOnOff : " + this.OnOff + "\r\nLevel : " + this.Level + "\r\nColor : " + this.Color + "\r\nDC_Voltage : " + this.DC_Voltage + "\r\nSensor : " + this.Sensor + "\r\nSensitivity : " + this.Sensitivity + "\r\nBoardDegree : " + this.BoardDegree + "\r\nAllControlType : " + this.AllControlType + "\r\n";
                    return retStr;
                }
            }
        }
    }

    public static class EnergyMeterV2 {
        public Info info = new Info();
        public Device device = new Device();

        public static class Info {
            public boolean Install = false;
            public SUPPORT Support = new SUPPORT();
            public byte FwVer_Year = 0;
            public byte FwVer_Month = 0;
            public byte FwVer_Day = 0;
            public byte FwVer_Number = 0;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;
            public byte Vender = 0;
            public byte LedCount = 0;
            public byte ConcentCount = 0;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Info\r\n==========================\r\nInstall   : " + this.Install + "\r\n" + this.Support.ToDebugString() + "Vender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\nLedCount     : " + this.LedCount + "\r\nConcentCount : " + this.ConcentCount + "\r\n==========================";
                return retStr;
            }

            public static class SUPPORT {
                public boolean TimeShow = false;
                public boolean ProgramSwitch = false;
                public boolean FCU_Control = false;
                public int EM_Type = 0;

                public String ToDebugString() {
                    String retStr = "[SUPPORT]\r\nTimeShow        : " + this.TimeShow + "\r\nProgramSwitch   : " + this.ProgramSwitch + "\r\nFCU_Control     : " + this.FCU_Control + "\r\nEM_Type         : " + this.EM_Type + "\r\n";
                    return retStr;
                }
            }
        }

        public static class Device {
            public LedController[] ledController = null;

            public boolean SetLedCount(byte nLightCount) {
                if (nLightCount >= 0 && nLightCount <= 12) {
                    this.ledController = new LedController[nLightCount];
                    for (int i = 0; i < nLightCount; ++i) {
                        this.ledController[i] = new LedController();
                    }
                    return true;
                }
                return false;
            }
        }
    }

    public static class LedController {
        public Info info = new Info();
        public Device device = new Device();

        public static class COLOR {
            public static byte UnSet = (byte)-1;
            public static byte Min = 0;
            public static byte Max = (byte)100;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus >= Min && nStatus <= Max) {
                    return true;
                }
                return nStatus == UnSet;
            }
        }

        public static class LEVEL {
            public static byte UnSet = (byte)-1;
            public static byte Min = 0;
            public static byte Max = (byte)100;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus >= Min && nStatus <= Max) {
                    return true;
                }
                return nStatus == UnSet;
            }
        }

        public static class POWER {
            public static byte UnSet = (byte)-1;
            public static byte On = 1;
            public static byte Off = (byte)2;

            public static boolean CheckRange(byte nStatus) {
                return nStatus >= UnSet && nStatus <= Off;
            }

            public static String ToDebugString(byte Color) {
                String retStr = Color == UnSet ? "UnSet" : (Color == On ? "On" : (Color == Off ? "Off" : "UnDefined"));
                return retStr;
            }
        }

        public static class Device {
            public byte OnOff = POWER.UnSet;
            public byte Level = LEVEL.UnSet;
            public byte Color = COLOR.UnSet;
            public double DC_Voltage = 0.0;
            public boolean Sensor = false;
            public byte Sensitivity = 0;
            public double BoardDegree = 0.0;
            public int SensorDetectCount = 0;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Circuit\r\n==========================\r\nOnOff : " + this.OnOff + "\r\nLevel : " + this.Level + "\r\nColor : " + this.Color + "\r\nDC_Voltage : " + this.DC_Voltage + "\r\nSensor : " + this.Sensor + "\r\nSensitivity : " + this.Sensitivity + "\r\nBoardDegree : " + this.BoardDegree + "\r\nSensorDetectCount : " + this.SensorDetectCount + "\r\n";
                retStr = retStr + "==========================";
                return retStr;
            }
        }

        public static class Info {
            public boolean Install = false;
            public SUPPORT Support = new SUPPORT();
            public byte Vender = 0;
            public byte FwVer_Year = 0;
            public byte FwVer_Month = 0;
            public byte FwVer_Day = 0;
            public byte FwVer_Number = 0;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Info\r\n==========================\r\nInstall   : " + this.Install + "\r\n" + this.Support.ToDebugString() + "Vender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }

            public static class SUPPORT {
                public boolean OnOff = false;
                public boolean Level = false;
                public boolean Color = false;
                public boolean DC_Voltage = false;
                public boolean Sensor = false;
                public boolean Sensitivity = false;
                public boolean BoardDegree = false;
                public boolean AllControlType = false;
                public boolean SensorDetectCount = false;

                public String ToDebugString() {
                    String retStr = "[SUPPORT]\r\nOnOff : " + this.OnOff + "\r\nLevel : " + this.Level + "\r\nColor : " + this.Color + "\r\nDC_Voltage : " + this.DC_Voltage + "\r\nSensor : " + this.Sensor + "\r\nSensitivity : " + this.Sensitivity + "\r\nBoardDegree : " + this.BoardDegree + "\r\nAllControlType : " + this.AllControlType + "\r\nSensorDetectCount : " + this.SensorDetectCount + "\r\n";
                    return retStr;
                }
            }
        }
    }

    public static class MultiSwitch {
        public Info info = new Info();
        public Device device;

        public MultiSwitch() {
            this.setCount((byte)0, (byte)0);
        }

        public void setCount(byte nLightCount, byte nConcentCount) {
            if (this.info == null) {
                return;
            }
            this.info.LightCount = nLightCount > 0 ? nLightCount : (byte)0;
            this.info.ConcentCount = nConcentCount > 0 ? nConcentCount : (byte)0;
            this.device = new Device(this.info.LightCount, this.info.ConcentCount);
        }

        public static class CONCENT_MODE {
            public static byte Auto = 1;
            public static byte Always = (byte)2;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == Auto) {
                    return true;
                }
                return nStatus == Always;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == Auto ? "Auto" : (nStatus == Always ? "Always" : "UnDefined");
                return retStr;
            }
        }

        public static class CONCENT_STATUS {
            public static byte On = 1;
            public static byte Off = (byte)2;
            public static byte CutOff = (byte)3;
            public static byte OverLoadOff = (byte)4;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == On) {
                    return true;
                }
                if (nStatus == Off) {
                    return true;
                }
                if (nStatus == CutOff) {
                    return true;
                }
                return nStatus == OverLoadOff;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == On ? "On" : (nStatus == Off ? "Off" : (nStatus == CutOff ? "CutOff" : (nStatus == OverLoadOff ? "OverLoadOff" : "UnDefined")));
                return retStr;
            }
        }

        public static class BATCHOFF_STATUS {
            public static byte Set = 1;
            public static byte Clr = (byte)2;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == Set) {
                    return true;
                }
                return nStatus == Clr;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == Set ? "Set" : (nStatus == Clr ? "Clr" : "UnDefined");
                return retStr;
            }
        }

        public static class Device {
            public byte LightCount;
            private boolean[] LightOnOff;
            public byte BatchOffStatus;
            public byte ConcentCount;
            private Concent[] concent;

            public boolean GetLightOnOff(int index) {
                if (this.LightOnOff == null) {
                    return false;
                }
                if (index > this.LightOnOff.length) {
                    return false;
                }
                return this.LightOnOff[index];
            }

            public boolean SetLightOnOff(int index, boolean OnOff) {
                if (this.LightOnOff == null) {
                    return false;
                }
                if (index > this.LightOnOff.length) {
                    return false;
                }
                this.LightOnOff[index] = OnOff;
                return true;
            }

            public Concent GetConcent(int index) {
                if (this.concent == null) {
                    return null;
                }
                if (index > this.concent.length) {
                    return null;
                }
                return this.concent[index];
            }

            public boolean SetConcent(int index, byte Status2, byte Mode, double NowPw, double CutOffVal) {
                if (this.concent == null) {
                    return false;
                }
                if (index > this.concent.length) {
                    return false;
                }
                Concent setConcent = this.concent[index];
                setConcent.Status = Status2;
                setConcent.Mode = Mode;
                setConcent.NowPw = NowPw;
                setConcent.CutOffVal = CutOffVal;
                return true;
            }

            public Device(byte nLightCount, byte nConcentCount) {
                byte i;
                if (nLightCount > 0) {
                    this.LightCount = nLightCount;
                    this.LightOnOff = new boolean[nLightCount];
                    for (i = 0; i < nLightCount; i = (byte)(i + 1)) {
                        this.LightOnOff[i] = false;
                    }
                } else {
                    this.LightCount = 0;
                    this.LightOnOff = null;
                }
                this.BatchOffStatus = BATCHOFF_STATUS.Clr;
                if (nConcentCount > 0) {
                    this.ConcentCount = nConcentCount;
                    this.concent = new Concent[nConcentCount];
                    for (i = 0; i < nConcentCount; i = (byte)(i + 1)) {
                        this.concent[i] = new Concent();
                    }
                } else {
                    this.ConcentCount = 0;
                    this.concent = null;
                }
            }

            public String ToDebugString(byte DeviceIdx) {
                byte i;
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Circuit\r\n==========================\r\nLightCount : " + this.LightCount + "\r\n";
                if (this.LightOnOff != null) {
                    retStr = retStr + "LightOnOff : ";
                    for (i = 0; i < this.LightCount; i = (byte)(i + 1)) {
                        retStr = retStr + "[" + (i + 1) + "]";
                        retStr = this.LightOnOff[i] ? retStr + "O " : retStr + "X ";
                        retStr = retStr + "   ";
                    }
                    retStr = retStr + "\r\n";
                }
                retStr = retStr + "\r\n";
                retStr = retStr + "ConcentCount : " + this.ConcentCount + "\r\n";
                if (this.concent != null) {
                    for (i = 0; i < this.ConcentCount; i = (byte)(i + 1)) {
                        retStr = retStr + this.concent[i].ToDebugString(i) + "\r\n";
                    }
                }
                retStr = retStr + "==========================";
                return retStr;
            }

            public static class Concent {
                public byte Status = CONCENT_STATUS.Off;
                public byte Mode = CONCENT_MODE.Always;
                public double NowPw = 0.0;
                public double CutOffVal = 0.0;

                public String ToDebugString(int index) {
                    String retStr = "[" + (index + 1) + "] ";
                    retStr = retStr + "Status:" + CONCENT_STATUS.ToDebugString(this.Status) + " / ";
                    retStr = retStr + "Mode:" + CONCENT_MODE.ToDebugString(this.Mode) + " / ";
                    retStr = retStr + "NowPw:" + this.NowPw + " / ";
                    retStr = retStr + "CutOffVal:" + this.CutOffVal;
                    return retStr;
                }
            }
        }

        public static class Info {
            public boolean Install = false;
            public byte LightCount = 0;
            public byte ConcentCount = 0;
            public byte Vender = 0;
            public boolean TimeShow = false;
            public byte FwVer_Year = 0;
            public byte FwVer_Month = 0;
            public byte FwVer_Day = 0;
            public byte FwVer_Number = 0;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Info\r\n==========================\r\nLightCount   : " + this.LightCount + "\r\nConcentCount : " + this.ConcentCount + "\r\nVender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\nTimeShow     : " + this.TimeShow + "\r\n==========================";
                return retStr;
            }
        }
    }

    public static class FP_DoorLock {
        public Info info = new Info();
        public Device device = new Device();

        public static class Device {
            public STATUS status = new STATUS();

            public static class NOTI_FAULT {
                public static byte Invasion_Detect = (byte)65;
                public static byte Sensor_Fault = (byte)66;
                public static byte Battery_Low = (byte)67;
                public static byte LongTime_Open = (byte)68;
                public static byte ForceLock = (byte)69;
                public static byte FireWarning = (byte)70;
                public static byte PWD_Delete = (byte)-96;
                public static byte PWD_Reg = (byte)-95;
                public static byte CARD_Delete = (byte)-80;
                public static byte CARD_Reg = (byte)-79;
                public static byte FingerPrint_Delete = (byte)-64;
                public static byte FingerPrint_Reg = (byte)-63;
                public static byte REMOCON_Delete = (byte)-48;
                public static byte REMOCON_Reg = (byte)-47;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == Invasion_Detect) {
                        return true;
                    }
                    if (nStatus == Sensor_Fault) {
                        return true;
                    }
                    if (nStatus == Battery_Low) {
                        return true;
                    }
                    if (nStatus == LongTime_Open) {
                        return true;
                    }
                    if (nStatus == ForceLock) {
                        return true;
                    }
                    if (nStatus == FireWarning) {
                        return true;
                    }
                    if (nStatus == PWD_Delete) {
                        return true;
                    }
                    if (nStatus == PWD_Reg) {
                        return true;
                    }
                    if (nStatus == CARD_Delete) {
                        return true;
                    }
                    if (nStatus == CARD_Reg) {
                        return true;
                    }
                    if (nStatus == FingerPrint_Delete) {
                        return true;
                    }
                    if (nStatus == FingerPrint_Reg) {
                        return true;
                    }
                    if (nStatus == REMOCON_Delete) {
                        return true;
                    }
                    return nStatus == REMOCON_Reg;
                }

                public static String ToDebugString(byte nStatus) {
                    String retStr = nStatus == Invasion_Detect ? "Invasion_Detect" : (nStatus == Sensor_Fault ? "Sensor_Fault" : (nStatus == Battery_Low ? "Battery_Low" : (nStatus == LongTime_Open ? "LongTime_Open" : (nStatus == ForceLock ? "ForceLock" : (nStatus == FireWarning ? "FireWarning" : (nStatus == PWD_Delete ? "PWD_Delete" : (nStatus == PWD_Reg ? "PWD_Reg" : (nStatus == CARD_Delete ? "CARD_Delete" : (nStatus == CARD_Reg ? "CARD_Reg" : (nStatus == FingerPrint_Delete ? "FingerPrint_Delete" : (nStatus == FingerPrint_Reg ? "FingerPrint_Reg" : (nStatus == REMOCON_Delete ? "REMOCON_Delete" : (nStatus == REMOCON_Reg ? "REMOCON_Reg" : "UnDefined")))))))))))));
                    return retStr;
                }
            }

            public static class OUTING_STATUS {
                public static byte Outing_On = (byte)65;
                public static byte Outing_Off = (byte)66;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == Outing_On) {
                        return true;
                    }
                    return nStatus == Outing_Off;
                }

                public static String ToDebugString(byte nStatus) {
                    String retStr = nStatus == Outing_On ? "Outing_On" : (nStatus == Outing_Off ? "Outing_Off" : "UnDefined");
                    return retStr;
                }
            }

            public static class ENTER_INFO {
                public static byte Normal = (byte)-18;
                public static byte Enter_Password = (byte)16;
                public static byte Enter_Card = (byte)32;
                public static byte Enter_FingerPrint = (byte)48;
                public static byte Enter_Remocon = (byte)64;
                public static byte Error_PwdCard_Over5 = (byte)-16;
                public static byte Error_Fp_Over10 = (byte)-15;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == Normal) {
                        return true;
                    }
                    if (nStatus == Enter_Password) {
                        return true;
                    }
                    if (nStatus == Enter_Card) {
                        return true;
                    }
                    if (nStatus == Enter_FingerPrint) {
                        return true;
                    }
                    if (nStatus == Enter_Remocon) {
                        return true;
                    }
                    if (nStatus == Error_PwdCard_Over5) {
                        return true;
                    }
                    return nStatus == Error_Fp_Over10;
                }

                public static String ToDebugString(byte nStatus) {
                    String retStr = nStatus == Normal ? "Normal" : (nStatus == Enter_Password ? "Enter_Password" : (nStatus == Enter_Card ? "Enter_Card" : (nStatus == Enter_FingerPrint ? "Enter_FingerPrint" : (nStatus == Enter_Remocon ? "Enter_Remocon" : (nStatus == Error_PwdCard_Over5 ? "Error_PwdCard_Over5" : (nStatus == Error_Fp_Over10 ? "Error_Fp_Over10" : "UnDefined"))))));
                    return retStr;
                }
            }

            public static class OPEN_STANDBY_MODE {
                public static byte NotSupport = 0;
                public static byte Standby_Off = 1;
                public static byte Standby_On = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NotSupport) {
                        return true;
                    }
                    if (nStatus == Standby_Off) {
                        return true;
                    }
                    return nStatus == Standby_On;
                }

                public static String ToDebugString(byte nStatus) {
                    String retStr = nStatus == NotSupport ? "NotSupport" : (nStatus == Standby_Off ? "Standby_Off" : (nStatus == Standby_On ? "Standby_On" : "UnDefined"));
                    return retStr;
                }
            }

            public static class TOUCHSTATUS {
                public static byte NotSupport = 0;
                public static byte Touch_Off = 1;
                public static byte Touch_On = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NotSupport) {
                        return true;
                    }
                    if (nStatus == Touch_Off) {
                        return true;
                    }
                    return nStatus == Touch_On;
                }

                public static String ToDebugString(byte nStatus) {
                    String retStr = nStatus == NotSupport ? "NotSupport" : (nStatus == Touch_Off ? "Touch_Off" : (nStatus == Touch_On ? "Touch_On" : "UnDefined"));
                    return retStr;
                }
            }

            public static class DOORSTATUS {
                public static byte Close = 0;
                public static byte Open = 1;
                public static byte Operation = (byte)2;
                public static byte Open_LockingForce = (byte)3;
                public static byte Close_LockingForce = (byte)4;
                public static byte Close_Fault = (byte)5;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == Close) {
                        return true;
                    }
                    if (nStatus == Open) {
                        return true;
                    }
                    if (nStatus == Operation) {
                        return true;
                    }
                    if (nStatus == Open_LockingForce) {
                        return true;
                    }
                    if (nStatus == Close_LockingForce) {
                        return true;
                    }
                    return nStatus == Close_Fault;
                }

                public static String ToDebugString(byte nStatus) {
                    String retStr = nStatus == Close ? "Close" : (nStatus == Open ? "Open" : (nStatus == Operation ? "Operation" : (nStatus == Open_LockingForce ? "Open_LockingForce" : (nStatus == Close_LockingForce ? "Close_LockingForce" : (nStatus == Close_Fault ? "Close_Fault" : "UnDefined")))));
                    return retStr;
                }
            }

            public static class STATUS {
                public byte doorstatus = DOORSTATUS.Close;
                public byte TouchStatus = TOUCHSTATUS.NotSupport;
                public byte OpenStandByMode = OPEN_STANDBY_MODE.NotSupport;
                public byte EnterInfo = ENTER_INFO.Normal;
                public byte EnterID = 0;
                public byte Outing = 0;
                public byte NotiNFault = 0;

                public String ToDebugString() {
                    String retStr = "==========================\r\nDevice - Status\r\n==========================\r\ndoorstatus       : " + DOORSTATUS.ToDebugString(this.doorstatus) + "\r\nTouchStatus      : " + TOUCHSTATUS.ToDebugString(this.TouchStatus) + "\r\nOpenStandByMode  : " + OPEN_STANDBY_MODE.ToDebugString(this.OpenStandByMode) + "\r\nEnterInfo        : " + ENTER_INFO.ToDebugString(this.EnterInfo) + "\r\nEnterID          : " + this.EnterID + "\r\nOuting           : " + OUTING_STATUS.ToDebugString(this.Outing) + "\r\nNotiNFault       : " + NOTI_FAULT.ToDebugString(this.NotiNFault) + "\r\n==========================";
                    return retStr;
                }
            }
        }

        public static class Info {
            public boolean Install = false;
            public boolean Touch_Recog = false;
            public boolean OpenStandByMode = false;
            public boolean Fingerprint_Recog = false;
            public boolean EnterId_Classify = false;
            public boolean Security_Run = false;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;

            public String ToDebugString() {
                String retStr = "==========================\r\nDevice - Info\r\n==========================\r\nTouch_Recog       : " + this.Touch_Recog + "\r\nOpenStandByMode   : " + this.OpenStandByMode + "\r\nFingerprint_Recog : " + this.Fingerprint_Recog + "\r\nEnterId_Classify  : " + this.EnterId_Classify + "\r\nSecurity_Run      : " + this.Security_Run + "\r\nProtocolVer       : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }
        }
    }

    public static class InRoomDetectSesnor {
        public INFO info = new INFO();
        public STATUS status = new STATUS();

        public static class SCENARIO_MODE {
            public static byte UNKOWN = 0;
            public static byte BASIC = 1;
            public static byte NIGHT_KITCHEN = (byte)2;
            public static byte USER_CUSTOM = (byte)4;
            public static byte KITCHEN_SAFE = (byte)8;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == BASIC) {
                    return true;
                }
                if (nStatus == NIGHT_KITCHEN) {
                    return true;
                }
                if (nStatus == USER_CUSTOM) {
                    return true;
                }
                return nStatus == KITCHEN_SAFE;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == BASIC ? "BASIC" : (nStatus == NIGHT_KITCHEN ? "NIGHT_KITCHEN" : (nStatus == USER_CUSTOM ? "USER_CUSTOM" : (nStatus == KITCHEN_SAFE ? "KITCHEN_SAFE" : "UnDefined")));
                return retStr;
            }
        }

        public static class DETECTSTATUS {
            public static byte DETECT_OFF = 0;
            public static byte DETECT_ON = 1;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == DETECT_OFF) {
                    return true;
                }
                return nStatus == DETECT_ON;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == DETECT_OFF ? "OFF" : (nStatus == DETECT_ON ? "ON" : "UnDefined");
                return retStr;
            }
        }

        public static class ACTIONMODE {
            public static byte OFF = 0;
            public static byte ON = 1;
            public static byte ADDRESS_CHECK = (byte)2;
            public static byte TEST_MODE = (byte)3;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == OFF) {
                    return true;
                }
                if (nStatus == ON) {
                    return true;
                }
                if (nStatus == ADDRESS_CHECK) {
                    return true;
                }
                return nStatus == TEST_MODE;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == OFF ? "OFF" : (nStatus == ON ? "ON" : (nStatus == ADDRESS_CHECK ? "ADDRESS_CHECK" : (nStatus == TEST_MODE ? "TEST_MODE" : "UnDefined")));
                return retStr;
            }
        }

        public static class STATUS {
            public byte ActMode = ACTIONMODE.OFF;
            public byte DetectStatus = DETECTSTATUS.DETECT_OFF;
            public boolean NonDetectOffStart = false;
            public byte SensingValue = 0;
            public byte KeepingTime = 0;
            public byte DetectCount_Upper = 0;
            public byte DetectCount_Down = 0;
            public int DetectCountSum = 0;
            public byte Scenario_Mode = SCENARIO_MODE.UNKOWN;

            public String ToDebugString() {
                String retStr = "==========================\r\nSTATUS\r\n==========================\r\nActMode           : " + ACTIONMODE.ToDebugString(this.ActMode) + "\r\nDetectStatus      : " + DETECTSTATUS.ToDebugString(this.DetectStatus) + "\r\nNonDetectOffStart : " + this.NonDetectOffStart + "\r\n\r\nSensingValue      : " + this.SensingValue + "\r\nKeepingTime       : " + this.KeepingTime + "  Sec\r\nDetectCount_Upper : " + this.DetectCount_Upper + "(" + String.format("%02X ", this.DetectCount_Upper) + ")\r\nDetectCount_Down  : " + this.DetectCount_Down + "(" + String.format("%02X ", this.DetectCount_Down) + ")\r\nDetectCountSum    : " + this.DetectCountSum + "\r\n==========================";
                return retStr;
            }
        }

        public static class INFO {
            public boolean Install = false;
            public byte FwVer_Year = 0;
            public byte FwVer_Month = 0;
            public byte FwVer_Day = 0;
            public byte FwVer_Number = 0;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;
            public byte Vendor = 0;

            public String ToDebugString() {
                String retStr = "==========================\r\nINFO\r\n==========================\r\nInstall           : " + this.Install + "\r\n\r\nFwVer_Year        : " + this.FwVer_Year + "\r\nFwVer_Month       : " + this.FwVer_Month + "\r\nFwVer_Day         : " + this.FwVer_Day + "\r\nFwVer_Number      : " + this.FwVer_Number + "\r\nProtocolVer_Main  : " + this.ProtocolVer_Main + "\r\nProtocolVer_Sub   : " + this.ProtocolVer_Sub + "\r\nVendor            : " + this.Vendor + "\r\n==========================";
                return retStr;
            }
        }
    }

    public static class ElectricRange {
        public Info info = new Info();
        public Device device;

        public ElectricRange() {
            this.setCount((byte)0);
        }

        public void setCount(byte nFireCount) {
            if (this.info == null) {
                return;
            }
            this.info.FireHoleCount = nFireCount >= 1 ? nFireCount : (byte)0;
            this.device = new Device(this.info.FireHoleCount);
        }

        public static class FIREHOLE_MODE {
            public static byte OFF = 0;
            public static byte HEATING = 1;
            public static byte HEAT_SAVE = (byte)2;
            public static byte WATER_BOIL = (byte)3;
            public static byte SOAKING = (byte)4;
            public static byte FRYPAN = (byte)5;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == OFF) {
                    return true;
                }
                if (nStatus == HEATING) {
                    return true;
                }
                if (nStatus == HEAT_SAVE) {
                    return true;
                }
                if (nStatus == WATER_BOIL) {
                    return true;
                }
                if (nStatus == SOAKING) {
                    return true;
                }
                return nStatus == FRYPAN;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == OFF ? "OFF" : (nStatus == HEATING ? "HEATING" : (nStatus == HEAT_SAVE ? "HEAT_SAVE" : (nStatus == WATER_BOIL ? "WATER_BOIL" : (nStatus == SOAKING ? "SOAKING" : (nStatus == FRYPAN ? "FRYPAN" : "UnDefined")))));
                return retStr;
            }
        }

        public static class FIREHOLE_STATUS {
            public static byte ON = 1;
            public static byte OFF = (byte)2;
            public static byte REMAIN_HEAT_OFF = (byte)3;
            public static byte REMAIN_HEAT_ON = (byte)4;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == ON) {
                    return true;
                }
                if (nStatus == OFF) {
                    return true;
                }
                if (nStatus == REMAIN_HEAT_OFF) {
                    return true;
                }
                return nStatus == REMAIN_HEAT_ON;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == ON ? "ON" : (nStatus == OFF ? "OFF" : (nStatus == REMAIN_HEAT_OFF ? "REMAIN_HEAT_OFF" : (nStatus == REMAIN_HEAT_ON ? "REMAIN_HEAT_ON" : "UnDefined")));
                return retStr;
            }
        }

        public static class FIREHOLE_KIND {
            public static byte HIGHLIGHT = 0;
            public static byte INDUCTION = 1;
            public static byte NONE = (byte)9;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == HIGHLIGHT) {
                    return true;
                }
                return nStatus == INDUCTION;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == HIGHLIGHT ? "HIGHLIGHT" : (nStatus == INDUCTION ? "INDUCTION" : "UnDefined");
                return retStr;
            }
        }

        public static class Device {
            public byte FireHoleCount;
            public FireHole[] FireHoles;

            public FireHole GetFireHole(int index) {
                if (this.FireHoles == null) {
                    return null;
                }
                if (index > this.FireHoles.length) {
                    return null;
                }
                return this.FireHoles[index];
            }

            public boolean SetFireHole(int index, byte kind, byte Status2, byte Mode, byte Level2) {
                if (this.FireHoles == null) {
                    return false;
                }
                if (index > this.FireHoles.length) {
                    return false;
                }
                FireHole setFireHole = this.FireHoles[index];
                setFireHole.Kind = kind;
                setFireHole.Status = Status2;
                setFireHole.Mode = Mode;
                setFireHole.Level = Level2;
                return true;
            }

            public Device(byte nFireHoleCount) {
                if (nFireHoleCount > 0) {
                    this.FireHoleCount = nFireHoleCount;
                    this.FireHoles = new FireHole[nFireHoleCount];
                    for (byte i = 0; i < this.FireHoleCount; i = (byte)(i + 1)) {
                        this.FireHoles[i] = new FireHole();
                    }
                } else {
                    this.FireHoleCount = 0;
                    this.FireHoles = null;
                }
            }

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - FireHoles\r\n==========================\r\nFireHoleCount : " + this.FireHoleCount + "\r\n";
                if (this.FireHoles != null) {
                    for (byte i = 0; i < this.FireHoleCount; i = (byte)(i + 1)) {
                        retStr = retStr + this.FireHoles[i].ToDebugString(i) + "\r\n";
                    }
                }
                retStr = retStr + "==========================";
                return retStr;
            }

            public static class FireHole {
                public byte Kind = FIREHOLE_KIND.NONE;
                public byte Status = FIREHOLE_STATUS.OFF;
                public byte RemainHeat = FIREHOLE_STATUS.REMAIN_HEAT_OFF;
                public byte Mode = FIREHOLE_MODE.OFF;
                public byte Level = 0;
                public byte Timer_Upper = 0;
                public byte Timer_Lower = 0;
                public FAULT Fault = new FAULT(0);

                public String ToDebugString(int index) {
                    String retStr = "[" + (index + 1) + "] ";
                    retStr = retStr + "Kind:" + FIREHOLE_KIND.ToDebugString(this.Kind) + " / ";
                    retStr = retStr + "Status:" + FIREHOLE_STATUS.ToDebugString(this.Status) + " / ";
                    retStr = retStr + "RemainHeat:" + FIREHOLE_STATUS.ToDebugString(this.RemainHeat) + " / ";
                    retStr = retStr + "Mode:" + FIREHOLE_MODE.ToDebugString(this.Mode) + " / ";
                    retStr = retStr + "Level:" + this.Level + " / ";
                    retStr = retStr + "Timer_Upper:" + this.Timer_Upper + " / ";
                    retStr = retStr + "Timer_Lower:" + this.Timer_Lower + " / ";
                    return retStr;
                }
            }
        }

        public static class FAULT {
            public boolean FuseError;
            public boolean SensorError;
            public byte FaultByte;

            public FAULT(byte inFault) {
                this.FaultByte = inFault;
                this.FuseError = (inFault & 1) != 0;
                this.SensorError = (inFault & 2) != 0;
            }
        }

        public static class SUPPORT {
            public boolean OnOffCtr;
            public boolean InductionExist;
            public boolean FireLevelCtr;
            public boolean ConsumeElecMeasure;
            public byte SupportByte;

            public SUPPORT(byte inSupport) {
                this.SupportByte = inSupport;
                this.OnOffCtr = (inSupport & 1) != 0;
                this.InductionExist = (inSupport & 2) != 0;
                this.FireLevelCtr = (inSupport & 4) != 0;
                this.ConsumeElecMeasure = (inSupport & 8) != 0;
            }
        }

        public static class Info {
            public boolean Install = false;
            public SUPPORT Support = new SUPPORT(0);
            public byte FireHoleCount = 0;
            public byte Vender = 0;
            public byte FwVer_Year = 0;
            public byte FwVer_Month = 0;
            public byte FwVer_Day = 0;
            public byte FwVer_Number = 0;
            public byte ProtocolVer_Main = 0;
            public byte ProtocolVer_Sub = 0;
            public byte Model_Number = 0;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Info\r\n==========================\r\nFireHoleCount : " + this.FireHoleCount + "\r\nVender        : " + String.format("0x%02X", this.Vender) + "\r\nModel_Number  : " + this.Model_Number + "\r\nFwVer         : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer   : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }
        }
    }

    public static class Light {
        public int LightCount = 0;
        public boolean[] OnOff = new boolean[8];
        public boolean Fault;

        public Light() {
            for (int i = 0; i < this.OnOff.length; ++i) {
                this.OnOff[i] = false;
            }
            this.Fault = false;
        }

        public String ToDebugString() {
            String retStr = "==========================\r\nSTATUS\r\n==========================\r\nCount : " + this.LightCount + "\r\nFault : " + this.Fault + "\r\n";
            for (int i = 0; i < this.LightCount; ++i) {
                retStr = retStr + "[" + (i + 1) + "]";
                retStr = this.OnOff[i] ? retStr + "O " : retStr + "X ";
                retStr = retStr + "   ";
            }
            retStr = retStr + "\r\n";
            retStr = retStr + "==========================";
            return retStr;
        }
    }

    public static class Venti {
        public boolean OnOff = false;
        public boolean Reservation = false;
        public byte Wind = 1;
        public byte Sleep = 0;
        public byte EtcCtr = 0;
        public int Timer = 0;
        public FAULT Fault;
        public SUPPORT Support;
        public SUPPORT2 Support2;
        public boolean ByPass = false;
        public byte HeaterTimeRemaining = 0;
        public byte HeaterStatus = HEATER.NOT_SUPPORT;
        public boolean AutoDriving = false;
        public boolean BathRoom = false;
        public boolean InnerCycle = false;
        public boolean OutAirClean = false;
        public boolean AirCleanAuto = false;
        public boolean HDCAutoAirClean = false;

        public Venti() {
            this.Fault = new FAULT(0);
            this.Support = new SUPPORT(0);
            this.Support2 = new SUPPORT2(0);
        }

        public String ToDebugString() {
            String retStr = "==========================\r\nSTATUS\r\n==========================\r\nOnOff       : " + this.OnOff + "\r\nReservation : " + this.Reservation + "\r\nWind        : " + WIND.ToDebugString(this.Wind) + "\r\nByPass : " + this.ByPass + "\r\nAutoDriving : " + this.AutoDriving + "\r\nBathRoom : " + this.BathRoom + "\r\nInnerCycle : " + this.InnerCycle + "\r\nOutAirClean : " + this.OutAirClean + "\r\nAirCleanAuto : " + this.AirCleanAuto + "\r\nHDCAutoAirClean : " + this.HDCAutoAirClean + "\r\nSleep       : " + SLEEP.ToDebugString(this.Sleep) + "\r\nHeaterStatus       : " + HEATER.ToDebugString(this.HeaterStatus) + "\r\nHeaterTimeRemaining : " + this.HeaterTimeRemaining + "\r\nEtcCtr      : " + ETC_CTR.ToDebugString(this.EtcCtr) + "\r\nTimer       : " + this.Timer + "\r\nFault       : " + String.format("0x%02X", this.Fault.FaultByte) + "\r\nSupport     : " + String.format("0x%02X", this.Support.SupportByte) + "\r\nSupport2    : " + String.format("0x%02X", this.Support2.SupportByte2) + "\r\n==========================";
            return retStr;
        }

        public String ToFaultString() {
            String retStr = "==========================\r\nFAULT\r\n==========================\r\nFault       : " + String.format("0x%02X", this.Fault.FaultByte) + "\r\nFilterChangeFree       : " + this.Fault.FilterChangeFree + "\r\nFilterChangeMedium       : " + this.Fault.FilterChangeMedium + "\r\nMotorError       : " + this.Fault.MotorError + "\r\nTempSensorError       : " + this.Fault.TempSensorError + "\r\nTempSensorError       : " + this.Fault.TempSensorError + "\r\nSafeMode       : " + this.Fault.SafeMode + "\r\nSupplyFanError       : " + this.Fault.SupplyFanError + "\r\nExhaustFanError       : " + this.Fault.ExhaustFanError + "\r\n==========================";
            return retStr;
        }

        public static class SUPPORT2 {
            public boolean WindowVenti;
            public boolean SleepMode;
            public boolean Wind0Use;
            public byte SupportByte2;

            public SUPPORT2(byte Support2) {
                this.SupportByte2 = Support2;
                this.WindowVenti = (Support2 & 1) != 0;
                this.SleepMode = (Support2 & 2) != 0;
                this.Wind0Use = (Support2 & 4) != 0;
            }
        }

        public static class SUPPORT {
            public boolean RoomController;
            public boolean ByPass;
            public boolean Heater;
            public boolean FilterReset;
            public boolean AutoDriving;
            public boolean BathRoom;
            public boolean InnerCycle;
            public boolean OutAirClean;
            public byte SupportByte;

            public SUPPORT(byte inSupport) {
                this.SupportByte = inSupport;
                this.RoomController = (inSupport & 1) != 0;
                this.ByPass = (inSupport & 2) != 0;
                this.Heater = (inSupport & 4) != 0;
                this.FilterReset = (inSupport & 8) != 0;
                this.AutoDriving = (inSupport & 0x10) != 0;
                this.BathRoom = (inSupport & 0x20) != 0;
                this.InnerCycle = (inSupport & 0x40) != 0;
                this.OutAirClean = (inSupport & 0xFFFFFF80) != 0;
            }
        }

        public static class FAULT {
            public boolean FilterChangeFree;
            public boolean FilterChangeMedium;
            public boolean MotorError;
            public boolean TempSensorError;
            public boolean SafeMode;
            public boolean SupplyFanError;
            public boolean ExhaustFanError;
            public byte FaultByte;

            public FAULT(byte inFault) {
                this.FaultByte = inFault;
                this.FilterChangeFree = (inFault & 1) != 0;
                this.FilterChangeMedium = (inFault & 2) != 0;
                this.MotorError = (inFault & 4) != 0;
                this.TempSensorError = (inFault & 8) != 0;
                this.SafeMode = (inFault & 0x10) != 0;
                this.SupplyFanError = (inFault & 0x20) != 0;
                this.ExhaustFanError = (inFault & 0x40) != 0;
            }
        }

        public static class HEATER {
            public static byte OFF = 0;
            public static byte STAND_BY = 1;
            public static byte NOT_SUPPORT = (byte)2;
            public static byte ON = (byte)3;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == OFF) {
                    return true;
                }
                if (nStatus == STAND_BY) {
                    return true;
                }
                if (nStatus == NOT_SUPPORT) {
                    return true;
                }
                return nStatus == ON;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == OFF ? "OFF" : (nStatus == STAND_BY ? "STAND_BY" : (nStatus == NOT_SUPPORT ? "NOT_SUPPORT" : (nStatus == ON ? "ON" : "UnDefined")));
                return retStr;
            }
        }

        public static class ETC_CTR {
            public static byte CTR_NON = 0;
            public static byte CTR_EXIST = 1;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == CTR_NON) {
                    return true;
                }
                return nStatus == CTR_EXIST;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == CTR_NON ? "CTR_NON" : (nStatus == CTR_EXIST ? "CTR_EXIST" : "UnDefined");
                return retStr;
            }
        }

        public static class SLEEP {
            public static byte SLEEP_OFF = 0;
            public static byte SLEEP_ON = 1;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == SLEEP_OFF) {
                    return true;
                }
                return nStatus == SLEEP_ON;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == SLEEP_OFF ? "SLEEP_OFF" : (nStatus == SLEEP_ON ? "SLEEP_ON" : "UnDefined");
                return retStr;
            }
        }

        public static class WIND {
            public static byte LOW = 1;
            public static byte MID = (byte)2;
            public static byte HI = (byte)3;
            public static byte AUTO = (byte)4;
            public static byte BYPASS = (byte)5;

            public static boolean CheckRange(byte nStatus) {
                if (nStatus == LOW) {
                    return true;
                }
                if (nStatus == MID) {
                    return true;
                }
                if (nStatus == HI) {
                    return true;
                }
                if (nStatus == AUTO) {
                    return true;
                }
                return nStatus == BYPASS;
            }

            public static String ToDebugString(byte nStatus) {
                String retStr = nStatus == LOW ? "LOW" : (nStatus == MID ? "MID" : (nStatus == HI ? "HI" : (nStatus == AUTO ? "AUTO" : (nStatus == BYPASS ? "BYPASS" : "UnDefined"))));
                return retStr;
            }
        }
    }

    public static class RealTimeMeter {
        public EachDataList Elec = new EachDataList();
        public EachDataList Water = new EachDataList();
        public EachDataList HotWater = new EachDataList();
        public EachDataList Gas = new EachDataList();
        public EachDataList Calorie = new EachDataList();
        public int nElecErrorCnt = 0;
        public int nWaterErrorCnt = 0;
        public int nHotWaterErrorCnt = 0;
        public int nGasErrorCnt = 0;
        public int nHeatingErrorCnt = 0;

        public boolean GetAllSupport() {
            return this.Elec.Support && this.Water.Support && this.HotWater.Support && this.Gas.Support && this.Calorie.Support;
        }

        public String ToDebugString() {
            String retStr = "==========================\r\nRealTimeMeter\r\n==========================\r\nElec     - " + this.Elec.ToDebugString() + "\r\nWater    - " + this.Water.ToDebugString() + "\r\nHotWater - " + this.HotWater.ToDebugString() + "\r\nGas      - " + this.Gas.ToDebugString() + "\r\nCalorie  - " + this.Calorie.ToDebugString() + "\r\nnElecErrorCnt: " + this.nElecErrorCnt + "\r\nnWaterErrorCnt: " + this.nWaterErrorCnt + "\r\nnHotWaterErrorCnt: " + this.nHotWaterErrorCnt + "\r\nnGasErrorCnt: " + this.nGasErrorCnt + "\r\nnHeatingErrorCnt: " + this.nHeatingErrorCnt + "\r\n==========================";
            return retStr;
        }

        public class EachDataList {
            public boolean Support = false;
            public double Acc = 0.0;
            public double Now = 0.0;

            public void Input(boolean nSupport, double nAcc, double nNow) {
                this.Support = nSupport;
                this.Acc = nAcc;
                this.Now = nNow;
            }

            public String ToDebugString() {
                return "Support : " + this.Support + " / Acc : " + this.Acc + " / Now : " + this.Now;
            }
        }
    }

    public static class HeatingV2 {
        public Info info = new Info();
        public RoomData[] Room = null;

        public boolean SetRoomCount(byte cnt) {
            if (this.info == null) {
                return false;
            }
            if (cnt <= 0 || cnt > 8) {
                return false;
            }
            this.info.RoomCount = cnt;
            this.Room = new RoomData[cnt];
            for (byte i = 0; i < cnt; i = (byte)(i + 1)) {
                this.Room[i] = new RoomData();
            }
            return true;
        }

        public static class SpecialFuncData {
            public byte Mode = AIMODE.OFF;
            public double OutsideTemp = 0.0;

            public String ToDebugString() {
                String retStr = "==========================\r\nSpecialFuncData\r\n==========================\r\nAIMode      : " + AIMODE.ToDebugString(this.Mode) + "\r\nOutsideTemp : " + this.OutsideTemp + "\r\n==========================\r\n";
                return retStr;
            }

            public static class AIMODE {
                public static byte Idle = 0;
                public static byte ON = 1;
                public static byte OFF = (byte)2;

                public static String ToDebugString(byte Mode) {
                    String retStr = Mode == Idle ? "Idle" : (Mode == ON ? "ON" : (Mode == OFF ? "OFF" : "UnDefined"));
                    return retStr;
                }

                public static boolean CheckGetMode(byte Mode) {
                    if (Mode == Idle) {
                        return false;
                    }
                    if (Mode == ON) {
                        return true;
                    }
                    return Mode == OFF;
                }

                public static boolean CheckSetMode(byte Mode) {
                    if (Mode == Idle) {
                        return true;
                    }
                    if (Mode == ON) {
                        return true;
                    }
                    return Mode == OFF;
                }
            }
        }

        public static class BoilerData {
            public boolean bFrostProtectMode = false;
            public byte ErrorCode = 0;
            public SetTempData HeatingWater = new SetTempData();
            public SetTempData HotWater = new SetTempData();

            public String ToDebugString() {
                String retStr = "==========================\r\nBoilerData\r\n==========================\r\nbFrostProtectMode : " + this.bFrostProtectMode + "\r\nErrorCode         : " + String.format("0x%02X", this.ErrorCode) + "\r\nHeatingWater      : " + this.HeatingWater.ToDebugString() + "\r\nHotWater          : " + this.HotWater.ToDebugString() + "\r\n==========================\r\n";
                return retStr;
            }

            public class SetTempData {
                public boolean bSetTempUnit5 = false;
                public byte SetTemp = 0;
                public byte MinSetTemp = 0;
                public byte MaxSetTemp = 0;

                public String ToDebugString() {
                    String retStr = "bSetTempUnit5 : " + this.bSetTempUnit5 + " / SetTemp : " + this.SetTemp + " / MinSetTemp : " + this.MinSetTemp + " / MaxSetTemp : " + this.MaxSetTemp + "\r\n";
                    return retStr;
                }
            }
        }

        public static class AllRoomData {
            public byte RoomCount;
            public EachRoomData[] Room;

            public AllRoomData(byte nRoomCount) {
                this.RoomCount = nRoomCount;
                this.Room = new EachRoomData[this.RoomCount];
                for (byte i = 0; i < this.RoomCount; i = (byte)(i + 1)) {
                    this.Room[i] = new EachRoomData();
                }
            }

            public String ToDebugString() {
                String retStr = "==========================\r\nAllRoomData\r\n==========================\r\n";
                for (byte i = 0; i < this.RoomCount; i = (byte)(i + 1)) {
                    retStr = retStr + this.Room[i].ToDebugString(i);
                }
                retStr = retStr + "==========================";
                return retStr;
            }

            public class EachRoomData {
                public byte Mode = MODE.HeatingOFF;
                public boolean bValveStatus = false;
                public double SetTemp = 10.0;
                public double NowTemp = 15.0;

                public String ToDebugString(byte RoomIndex) {
                    String retStr = "RoomData (" + (RoomIndex + 1) + ") \r\nMode         : " + MODE.ToDebugString(this.Mode) + "  /  bValveStatus : " + this.bValveStatus + "\r\nSetTemp      : " + this.SetTemp + "  /  NowTemp      : " + this.NowTemp + "\r\n";
                    return retStr;
                }
            }
        }

        public static class MODE {
            public static byte Idle = 0;
            public static byte HeatingON = 1;
            public static byte HeatingOFF = (byte)2;
            public static byte Outing = (byte)3;
            public static byte OutingRelease = (byte)4;
            public static byte Sleep = (byte)5;
            public static byte Reservation = (byte)6;
            public static byte Pause = (byte)7;
            public static byte PauseRelease = (byte)8;

            public static String ToDebugString(byte Mode) {
                String retStr = Mode == Idle ? "Idle" : (Mode == HeatingON ? "HeatingON" : (Mode == HeatingOFF ? "HeatingOFF" : (Mode == Outing ? "Outing" : (Mode == OutingRelease ? "OutingRelease" : (Mode == Sleep ? "Sleep" : (Mode == Reservation ? "Reservation" : (Mode == Pause ? "Pause" : (Mode == PauseRelease ? "PauseRelease" : "UnDefined"))))))));
                return retStr;
            }

            public static boolean CheckGetMode(byte Mode) {
                if (Mode == Idle) {
                    return false;
                }
                if (Mode == HeatingON) {
                    return true;
                }
                if (Mode == HeatingOFF) {
                    return true;
                }
                if (Mode == Outing) {
                    return true;
                }
                if (Mode == OutingRelease) {
                    return false;
                }
                if (Mode == Sleep) {
                    return true;
                }
                if (Mode == Reservation) {
                    return true;
                }
                if (Mode == Pause) {
                    return true;
                }
                if (Mode == PauseRelease) {
                    return false;
                }
                return false;
            }

            public static boolean CheckSetMode(byte Mode) {
                if (Mode == Idle) {
                    return true;
                }
                if (Mode == HeatingON) {
                    return true;
                }
                if (Mode == HeatingOFF) {
                    return true;
                }
                if (Mode == Outing) {
                    return true;
                }
                if (Mode == OutingRelease) {
                    return true;
                }
                if (Mode == Sleep) {
                    return true;
                }
                if (Mode == Reservation) {
                    return true;
                }
                if (Mode == Pause) {
                    return true;
                }
                return Mode == PauseRelease;
            }

            public static boolean GetOnOff(byte Mode) {
                if (Mode == HeatingON) {
                    return true;
                }
                if (Mode == HeatingOFF) {
                    return false;
                }
                if (Mode == Outing) {
                    return false;
                }
                if (Mode == Sleep) {
                    return true;
                }
                if (Mode == Reservation) {
                    return true;
                }
                if (Mode == Pause) {
                    return false;
                }
                return false;
            }
        }

        public static class RESERVATION {
            private boolean SupportNUse = false;
            private boolean[] SettingInfo = new boolean[24];

            public boolean getSupportNUse() {
                return this.SupportNUse;
            }

            public RESERVATION() {
                for (int i = 0; i < this.SettingInfo.length; ++i) {
                    this.SettingInfo[i] = false;
                }
            }

            public boolean setSchedule(int index, boolean OnOff) {
                if (index < 0 || index >= 24) {
                    return false;
                }
                if (this.SettingInfo == null) {
                    return false;
                }
                this.SettingInfo[index] = OnOff;
                this.SupportNUse = true;
                return true;
            }

            public boolean getSchedule(int index) {
                if (index < 0 || index >= 24) {
                    return false;
                }
                if (this.SettingInfo == null) {
                    return false;
                }
                return this.SettingInfo[index];
            }

            public byte[] getByte() {
                byte[] retArrayByte = new byte[]{0, 0, 0};
                if (!this.SupportNUse) {
                    return retArrayByte;
                }
                int index = 0;
                for (int i = 0; i < 3; ++i) {
                    for (int y = 0; y < 8; ++y) {
                        if (!this.SettingInfo[index++]) continue;
                        int n = i;
                        retArrayByte[n] = (byte)(retArrayByte[n] | define.BIT_ARRAY[y]);
                    }
                }
                return retArrayByte;
            }

            public void setByte(byte[] in) {
                if (in == null) {
                    return;
                }
                if (in.length != 3) {
                    return;
                }
                int SettingInfoIndex = 0;
                boolean OnOff = false;
                for (int cnt = 0; cnt < 3; ++cnt) {
                    byte data = in[cnt];
                    for (int i = 0; i < 8; ++i) {
                        OnOff = (data & define.BIT_ARRAY[i]) != 0;
                        this.setSchedule(SettingInfoIndex++, OnOff);
                    }
                }
            }

            public int getInt() {
                int retInt = 0;
                if (!this.SupportNUse) {
                    return retInt;
                }
                int shift = 1;
                for (int i = 0; i < 24; ++i) {
                    if (this.getSchedule(i)) {
                        retInt |= shift;
                    }
                    shift <<= 1;
                }
                return retInt;
            }

            public void setInt(int in) {
                int shift = 1;
                for (int i = 0; i < 24; ++i) {
                    if ((in & shift) != 0) {
                        this.setSchedule(i, true);
                    } else {
                        this.setSchedule(i, false);
                    }
                    shift <<= 1;
                }
            }

            public String ToDebugString() {
                if (this.SettingInfo == null) {
                    return "null";
                }
                if (!this.SupportNUse) {
                    return "NotSupport";
                }
                String retStr = "|";
                for (int i = 0; i < this.SettingInfo.length; ++i) {
                    retStr = this.SettingInfo[i] ? retStr + "O" : retStr + "X";
                    if (i != 5 && i != 11 && i != 17) continue;
                    retStr = retStr + "|";
                }
                retStr = retStr + "|";
                return retStr;
            }
        }

        public static class SLEEP {
            private boolean SupportNUse = false;
            private byte Time = 0;
            private byte Temp = 0;

            public boolean getSupportNUse() {
                return this.SupportNUse;
            }

            public byte getTime() {
                return this.Time;
            }

            public String getTimeStr() {
                String[] str = new String[]{"\ubbf8\uc124\uc815", "3\uc2dc\uac04", "3\uc2dc\uac0430\ubd84", "4\uc2dc\uac04", "4\uc2dc\uac0430\ubd84", "5\uc2dc\uac04", "5\uc2dc\uac0430\ubd84", "6\uc2dc\uac04", "6\uc2dc\uac0430\ubd84", "7\uc2dc\uac04", "7\uc2dc\uac0430\ubd84", "8\uc2dc\uac04", "8\uc2dc\uac0430\ubd84", "9\uc2dc\uac04", "9\uc2dc\uac0430\ubd84", "10\uc2dc\uac04", "10\uc2dc\uac0430\ubd84", "11\uc2dc\uac04", "11\uc2dc\uac0430\ubd84", "12\uc2dc\uac04"};
                try {
                    return str[this.Time];
                }
                catch (Exception e) {
                    Log.e((String)"DataClasses", (String)"[getTimeStr]");
                    e.printStackTrace();
                    return null;
                }
            }

            public boolean setTime(byte setTime) {
                if (setTime < 0 || setTime > 19) {
                    return false;
                }
                this.Time = setTime;
                this.CheckSupportNUse();
                return true;
            }

            public void setTimeIncrease() {
                this.Time = (byte)(this.Time + 1);
                if (this.Time > 19) {
                    this.Time = 1;
                }
                this.CheckSupportNUse();
            }

            public void setTimeDecrease() {
                this.Time = (byte)(this.Time - 1);
                if (this.Time <= 0) {
                    this.Time = (byte)19;
                }
                this.CheckSupportNUse();
            }

            public byte getTemp() {
                return this.Temp;
            }

            public double getTempDouble() {
                double[] tempArray = new double[]{0.0, 0.5, 1.0, 1.5};
                try {
                    return tempArray[this.Temp];
                }
                catch (Exception e) {
                    Log.e((String)"DataClasses", (String)"[getTempDouble]");
                    e.printStackTrace();
                    return 0.0;
                }
            }

            public boolean setTemp(byte setTemp) {
                if (setTemp < 0 || setTemp > 3) {
                    return false;
                }
                this.Temp = setTemp;
                this.CheckSupportNUse();
                return true;
            }

            public void setTempIncrease() {
                this.Temp = (byte)(this.Temp + 1);
                if (this.Temp > 3) {
                    this.Temp = 1;
                }
                this.CheckSupportNUse();
            }

            public void setTempDecrease() {
                this.Temp = (byte)(this.Temp - 1);
                if (this.Temp <= 0) {
                    this.Temp = (byte)3;
                }
                this.CheckSupportNUse();
            }

            public byte getByte() {
                return (byte)(this.Time | (byte)(this.Temp << 5));
            }

            public void setByte(byte in) {
                this.setTime((byte)(in & 0x1F));
                this.setTemp((byte)(in >> 5 & 7));
            }

            private void CheckSupportNUse() {
                this.SupportNUse = this.Time != 0 || this.Temp != 0;
            }

            public String ToDebugString() {
                String retStr = "Time : " + this.getTimeStr() + " , Temp : " + this.getTempDouble() + "\u2103";
                return retStr;
            }
        }

        public static class ERROR {
            public boolean bRoomComm = false;
            public boolean bRoomTempSensor = false;
            public boolean bRoomSystem = false;
            public boolean bMainTempSensor = false;
            public boolean bMainSystem = false;
            public boolean bBoiler = false;
            public boolean bLeak = false;
            public boolean bEtc = false;

            public byte getByte() {
                byte ret = 0;
                if (this.bRoomComm) {
                    ret = (byte)(ret | 1);
                }
                if (this.bRoomTempSensor) {
                    ret = (byte)(ret | 2);
                }
                if (this.bRoomSystem) {
                    ret = (byte)(ret | 4);
                }
                if (this.bMainTempSensor) {
                    ret = (byte)(ret | 8);
                }
                if (this.bMainSystem) {
                    ret = (byte)(ret | 0x10);
                }
                if (this.bBoiler) {
                    ret = (byte)(ret | 0x20);
                }
                if (this.bLeak) {
                    ret = (byte)(ret | 0x40);
                }
                if (this.bEtc) {
                    ret = (byte)(ret | 0xFFFFFF80);
                }
                return ret;
            }

            public void setByte(byte in) {
                this.bRoomComm = (in & 1) != 0;
                this.bRoomTempSensor = (in & 2) != 0;
                this.bRoomSystem = (in & 4) != 0;
                this.bMainTempSensor = (in & 8) != 0;
                this.bMainSystem = (in & 0x10) != 0;
                this.bBoiler = (in & 0x20) != 0;
                this.bLeak = (in & 0x40) != 0;
                this.bEtc = (in & 0x80) != 0;
            }

            public String ToDebugString() {
                String retStr = "bRoomComm:" + this.ToStrBoolean(this.bRoomComm) + " , bRoomTempSensor:" + this.ToStrBoolean(this.bRoomTempSensor) + " , bRoomSystem:" + this.ToStrBoolean(this.bRoomSystem) + " , bMainTempSensor:" + this.ToStrBoolean(this.bMainTempSensor) + " , bMainSystem:" + this.ToStrBoolean(this.bMainSystem) + " , bBoiler:" + this.ToStrBoolean(this.bBoiler) + " , bLeak:" + this.ToStrBoolean(this.bLeak) + " , bEtc:" + this.ToStrBoolean(this.bEtc);
                return retStr;
            }

            private String ToStrBoolean(boolean in) {
                if (in) {
                    return "O";
                }
                return "X";
            }
        }

        public static class SET_TIME {
            public boolean bMinute30 = false;
            public byte Hour = 0;

            public String ToDebugString() {
                if (this.bMinute30) {
                    return String.format("%d:30", this.Hour);
                }
                return String.format("%d:00", this.Hour);
            }
        }

        public static class CtrlRoomData {
            public byte Mode = MODE.Idle;
            public double SetTemp = 0.0;
            public SLEEP Sleep = new SLEEP();
            public RESERVATION Reservation = new RESERVATION();
        }

        public static class RoomData {
            public byte Mode = MODE.HeatingOFF;
            public boolean bValveStatus = false;
            public double SetTemp = 10.0;
            public double NowTemp = 15.0;
            public ERROR Error = new ERROR();
            public SLEEP Sleep = new SLEEP();
            public RESERVATION Reservation = new RESERVATION();

            public String ToDebugString(byte RoomIndex) {
                String retStr = "==========================\r\nRoomData (" + (RoomIndex + 1) + ") \r\n==========================\r\nMode         : " + MODE.ToDebugString(this.Mode) + "\r\nbValveStatus : " + this.bValveStatus + "\r\nSetTemp      : " + this.SetTemp + "\r\nNowTemp      : " + this.NowTemp + "\r\nError        : " + this.Error.ToDebugString() + "\r\nSleep        : " + this.Sleep.ToDebugString() + "\r\nReservation  : " + this.Reservation.ToDebugString() + "\r\n==========================";
                return retStr;
            }
        }

        public static class Info {
            public byte RoomCount = 0;
            public byte Vender;
            public byte FwVer_Year;
            public byte FwVer_Month;
            public byte FwVer_Day;
            public byte FwVer_Number;
            public byte ProtocolVer_Main;
            public byte ProtocolVer_Sub;
            public SupportInfo Support = new SupportInfo();

            public String ToDebugString() {
                String retStr = "==========================\r\nInfo\r\n==========================\r\nRoomCount    : " + this.RoomCount + "\r\nVender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n[Support]\r\nMinSetTemp     : " + this.Support.MinSetTemp + "\r\nMaxSetTemp     : " + this.Support.MaxSetTemp + "\r\nSetTempPoint05 : " + this.Support.SetTempPoint05 + "\r\nOuting         : " + this.Support.Outing + "\r\nSleep          : " + this.Support.Sleep + "\r\nReservation    : " + this.Support.Reservation + "\r\nPause          : " + this.Support.Pause + "\r\nAI             : " + this.Support.AI + "\r\nOutsideTempUse : " + this.Support.OutsideTempUse + "\r\nBoiler         : " + this.Support.Boiler + "\r\nLeak           : " + this.Support.Leak + "\r\n==========================";
                return retStr;
            }

            public class SupportInfo {
                public byte MinSetTemp = (byte)5;
                public byte MaxSetTemp = (byte)40;
                public boolean SetTempPoint05 = false;
                public boolean Outing = false;
                public boolean Sleep = false;
                public boolean Reservation = false;
                public boolean Pause = false;
                public boolean AI = false;
                public boolean OutsideTempUse = false;
                public boolean Boiler = false;
                public boolean Leak = false;
            }
        }
    }

    public static class HeatingV1 {
        public byte RoomCount = 0;
        public boolean Pause = false;
        public boolean SetTempPoint05 = true;
        public byte Error = ERROR.Normal;
        public RoomData[] Room = null;
        public Info info = new Info();

        public boolean SetRoomCount(byte cnt) {
            if (cnt <= 0 || cnt > 8) {
                return false;
            }
            this.RoomCount = cnt;
            this.Room = new RoomData[cnt];
            for (byte i = 0; i < cnt; i = (byte)(i + 1)) {
                this.Room[i] = new RoomData();
            }
            return true;
        }

        public String ToDebugStringInfoNPause() {
            String retStr = "==========================\r\nInfoNPause\r\n==========================\r\nRoomCount      : " + this.RoomCount + "\r\nSetTempPoint05 : " + this.SetTempPoint05 + "\r\nError          : " + String.format("0x%02X", this.Error) + "\r\nPause          : " + this.Pause + "\r\n==========================";
            return retStr;
        }

        public String ToDebugStringRoom(byte index) {
            if (this.Room == null) {
                return "Error(Room is null)";
            }
            if (this.Room.length < index) {
                return "Error(index:" + index + ", Out Of Range !!!)";
            }
            return this.Room[index].ToDebugString(index);
        }

        public static class AllRoomData {
            public byte RoomCount;
            public boolean SetTempPoint05;
            public boolean Pause;
            public EachRoomData[] Room;
            public byte Error;

            public AllRoomData(byte nRoomCount) {
                this.RoomCount = nRoomCount;
                this.SetTempPoint05 = true;
                this.Room = new EachRoomData[this.RoomCount];
                for (byte i = 0; i < this.RoomCount; i = (byte)(i + 1)) {
                    this.Room[i] = new EachRoomData();
                }
                this.Error = ERROR.Normal;
            }

            public String ToDebugString() {
                String retStr = "==========================\r\nAllRoomData\r\n==========================\r\n";
                for (byte i = 0; i < this.RoomCount; i = (byte)(i + 1)) {
                    retStr = retStr + this.Room[i].ToDebugString(i);
                }
                retStr = retStr + "==========================";
                return retStr;
            }

            public class EachRoomData {
                public boolean bOnOff = false;
                public boolean bValveStatus = false;

                public String ToDebugString(byte RoomIndex) {
                    String retStr = "RoomData (" + (RoomIndex + 1) + ") \r\nbOnOff : " + this.bOnOff + "  /  bValveStatus : " + this.bValveStatus + "\r\n";
                    return retStr;
                }
            }
        }

        public static class ERROR {
            public static byte Normal = 0;
            public static byte RoomSystem = (byte)80;
            public static byte Controller = (byte)96;
            public static byte Eeprom = (byte)112;
            public static byte Boiler = (byte)35;

            public static String ToDebugString(byte Error) {
                String retStr = Error == Normal ? "Normal" : (Error == RoomSystem ? "RoomSystem" : (Error == Controller ? "Controller" : (Error == Eeprom ? "Eeprom" : (Error == Boiler ? "Boiler" : "UnDefined"))));
                return retStr;
            }

            public static boolean Check(byte Error) {
                if (Error == Normal) {
                    return true;
                }
                if (Error == RoomSystem) {
                    return true;
                }
                if (Error == Controller) {
                    return true;
                }
                if (Error == Eeprom) {
                    return true;
                }
                return Error == Boiler;
            }
        }

        public static class RoomData {
            public boolean bOnOff = false;
            public boolean bValveStatus = false;
            public double SetTemp = 10.0;
            public double NowTemp = 15.0;
            public byte Error = ERROR.Normal;

            public String ToDebugString(byte RoomIndex) {
                String retStr = "==========================\r\nRoomData (" + (RoomIndex + 1) + ") \r\n==========================\r\nbOnOff       : " + this.bOnOff + "\r\nbValveStatus : " + this.bValveStatus + "\r\nSetTemp      : " + this.SetTemp + "\r\nNowTemp      : " + this.NowTemp + "\r\nError        : " + ERROR.ToDebugString(this.Error) + "\r\n==========================";
                return retStr;
            }
        }

        public static class Info {
            public byte[] Data = new byte[8];
            private boolean bSet;

            public Info() {
                for (int i = 0; i < this.Data.length; ++i) {
                    this.Data[i] = 0;
                }
                this.bSet = false;
            }

            public boolean GetSet() {
                return this.bSet;
            }

            public boolean SetData(byte[] setdata) {
                if (setdata == null) {
                    return false;
                }
                if (setdata.length > 8) {
                    return false;
                }
                if (this.Data == null) {
                    return false;
                }
                if (setdata.length != this.Data.length) {
                    this.Data = new byte[setdata.length];
                }
                for (int i = 0; i < setdata.length; ++i) {
                    this.Data[i] = setdata[i];
                }
                this.bSet = true;
                return true;
            }

            public String ToDebugString() {
                String retStr = "==========================\r\nInfo\r\n==========================\r\n";
                retStr = this.Data == null ? retStr + "null\r\n" : retStr + this.Data.toString() + "\r\n";
                retStr = retStr + "==========================";
                return retStr;
            }
        }
    }

    public static class EnergyMeter {
        public Info info = new Info();
        public EachRoom[] eachRoom = null;

        public boolean setRoomCnt(byte nRoomCnt) {
            if (nRoomCnt <= 0) {
                return false;
            }
            if (nRoomCnt > 6) {
                return false;
            }
            if (this.info == null) {
                return false;
            }
            this.info.RoomCnt = nRoomCnt;
            this.eachRoom = new EachRoom[nRoomCnt];
            for (byte i = 0; i < nRoomCnt; i = (byte)(i + 1)) {
                this.eachRoom[i] = new EachRoom();
            }
            return true;
        }

        public boolean getAllLightOnOff() {
            if (this.eachRoom == null) {
                return false;
            }
            for (int i = 0; i < this.eachRoom.length; ++i) {
                if (this.eachRoom[i] == null || !this.eachRoom[i].getAllLightOnOff()) continue;
                return true;
            }
            return false;
        }

        public boolean getAllConcentOnOff() {
            if (this.eachRoom == null) {
                return false;
            }
            for (int i = 0; i < this.eachRoom.length; ++i) {
                if (this.eachRoom[i] == null || !this.eachRoom[i].getAllConcentOnOff()) continue;
                return true;
            }
            return false;
        }

        public static class Info {
            public byte RoomCnt = 0;
            public byte Vender;
            public byte FwVer_Year;
            public byte FwVer_Month;
            public byte FwVer_Day;
            public byte FwVer_Number;
            public byte ProtocolVer_Main;
            public byte ProtocolVer_Sub;
            public boolean AllLightRelay_Use = false;
            public boolean AccPw_Unit;

            public String ToDebugString() {
                String retStr = "==========================\r\nDevice - Info\r\n==========================\r\nRoomCnt      : " + this.RoomCnt + "\r\nVender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\nAllLightRelay_Use : " + this.AllLightRelay_Use + "\r\nAccPw_Unit   : " + this.AccPw_Unit + "\r\n==========================";
                return retStr;
            }
        }

        public static class EachRoom {
            public boolean Install = false;
            public boolean CommStatus;
            public boolean UnitError;
            public byte LightCnt = 0;
            public boolean[] LightOnOff;
            public double LightNowPw;
            public double LightAccPw;
            public boolean LightAccOverflow;
            public boolean LightOverLoad;
            public byte ConCnt = 0;
            public boolean ConMode = false;
            public boolean[] ConOnOff;
            public double[] ConCutOffVal;
            public boolean[] ConCutOffStatus;
            public boolean[] ConOverLoad;
            public double[] ConNowPw;
            public double[] ConAccPw;
            public boolean[] ConAccOverflow;
            public boolean AllLightRelay_Use = false;
            public boolean AllLightRelay_OnOff = false;

            public boolean setLightCnt(byte nLightCnt) {
                if (nLightCnt <= 0) {
                    return false;
                }
                this.LightCnt = nLightCnt;
                this.LightOnOff = new boolean[nLightCnt];
                for (int i = 0; i < nLightCnt; ++i) {
                    this.LightOnOff[i] = false;
                }
                return true;
            }

            public boolean setConCnt(byte nConCnt) {
                int i;
                if (nConCnt != 2 && nConCnt != 3) {
                    return false;
                }
                this.ConCnt = nConCnt;
                int ControlConcent = 2;
                this.ConOnOff = new boolean[ControlConcent];
                for (i = 0; i < this.ConOnOff.length; ++i) {
                    this.ConOnOff[i] = false;
                }
                this.ConCutOffVal = new double[ControlConcent];
                for (i = 0; i < this.ConCutOffVal.length; ++i) {
                    this.ConCutOffVal[i] = 0.0;
                }
                this.ConCutOffStatus = new boolean[ControlConcent];
                for (i = 0; i < this.ConCutOffStatus.length; ++i) {
                    this.ConCutOffStatus[i] = false;
                }
                this.ConOverLoad = new boolean[ControlConcent];
                for (i = 0; i < this.ConOverLoad.length; ++i) {
                    this.ConOverLoad[i] = false;
                }
                this.ConNowPw = new double[nConCnt];
                for (i = 0; i < nConCnt; ++i) {
                    this.ConNowPw[i] = 0.0;
                }
                this.ConAccPw = new double[nConCnt];
                for (i = 0; i < nConCnt; ++i) {
                    this.ConAccPw[i] = 0.0;
                }
                this.ConAccOverflow = new boolean[nConCnt];
                for (i = 0; i < nConCnt; ++i) {
                    this.ConAccOverflow[i] = false;
                }
                return true;
            }

            public boolean getAllLightOnOff() {
                if (this.LightOnOff == null) {
                    return false;
                }
                boolean OnOff = false;
                for (int i = 0; i < this.LightOnOff.length; ++i) {
                    if (!this.LightOnOff[i]) continue;
                    OnOff = true;
                    break;
                }
                return OnOff;
            }

            public boolean getAllConcentOnOff() {
                if (this.ConOnOff == null) {
                    return false;
                }
                boolean OnOff = false;
                for (int i = 0; i < this.ConOnOff.length; ++i) {
                    if (!this.ConOnOff[i]) continue;
                    OnOff = true;
                    break;
                }
                return OnOff;
            }

            public double getAllConcentNowPw() {
                if (this.ConNowPw == null) {
                    return 0.0;
                }
                double NowPw = 0.0;
                for (int i = 0; i < this.ConNowPw.length; ++i) {
                    NowPw += this.ConNowPw[i];
                }
                return Double.parseDouble(String.format("%.0f", NowPw));
            }

            public double getAllNowPw() {
                if (this.ConNowPw == null) {
                    return 0.0;
                }
                double NowPw = 0.0;
                for (int i = 0; i < this.ConNowPw.length; ++i) {
                    NowPw += this.ConNowPw[i];
                }
                return Double.parseDouble(String.format("%.0f", NowPw += this.LightNowPw));
            }

            public boolean getAllConcentCutOffStatus() {
                if (this.ConCutOffStatus == null) {
                    return false;
                }
                boolean OnOff = false;
                for (int i = 0; i < this.ConCutOffStatus.length; ++i) {
                    if (!this.ConCutOffStatus[i]) continue;
                    OnOff = true;
                    break;
                }
                return OnOff;
            }

            public boolean getAllConcentOverLoad() {
                if (this.ConOverLoad == null) {
                    return false;
                }
                boolean OverLoad = false;
                for (int i = 0; i < this.ConOverLoad.length; ++i) {
                    if (!this.ConOverLoad[i]) continue;
                    OverLoad = true;
                    break;
                }
                return OverLoad;
            }

            public String ToDebugString(byte RoomIndex) {
                String retStr = "==========================\r\nRoomNumber (" + (byte)(RoomIndex + 1) + ")\r\n==========================\r\nInstall    : " + this.Install + "\r\nCommError : " + this.CommStatus + "\r\nUnitError  : " + this.UnitError + "\r\n[Light]\r\nLightCnt   : " + this.LightCnt + "\r\n";
                retStr = retStr + this.BooleanArrayString("LightOnOff : ", this.LightOnOff);
                retStr = retStr + "LightNowPw       : " + this.LightNowPw + "\r\nLightAccPw       : " + this.LightAccPw + "\r\nLightAccOverflow : " + this.LightAccOverflow + "\r\nLightOverLoad    : " + this.LightOverLoad + "\r\n[Concent]\r\nConCnt  : " + this.ConCnt + "\r\nConMode : " + this.ConMode + "\r\n";
                retStr = retStr + this.BooleanArrayString("ConOnOff        : ", this.ConOnOff);
                retStr = retStr + this.DoubleArrayString("ConCutOffVal    : ", this.ConCutOffVal);
                retStr = retStr + this.BooleanArrayString("ConCutOffStatus : ", this.ConCutOffStatus);
                retStr = retStr + this.BooleanArrayString("ConOverLoad     : ", this.ConOverLoad);
                retStr = retStr + this.DoubleArrayString("ConNowPw        : ", this.ConNowPw);
                retStr = retStr + this.DoubleArrayString("ConAccPw        : ", this.ConAccPw);
                retStr = retStr + this.BooleanArrayString("ConAccOverflow  : ", this.ConAccOverflow);
                retStr = retStr + "[AllLightRelay]\r\nAllLightRelay_Use   : " + this.AllLightRelay_Use + "\r\nAllLightRelay_OnOff : " + this.AllLightRelay_OnOff + "\r\n";
                retStr = retStr + "==========================";
                return retStr;
            }

            private String BooleanArrayString(String Name, boolean[] DataArray) {
                String retStr = Name;
                if (DataArray == null) {
                    retStr = retStr + "null";
                } else {
                    for (int i = 0; i < DataArray.length; ++i) {
                        retStr = retStr + DataArray[i];
                        if (i + 1 == DataArray.length) continue;
                        retStr = retStr + ", ";
                    }
                }
                return retStr + "\r\n";
            }

            private String DoubleArrayString(String Name, double[] DataArray) {
                String retStr = Name;
                if (DataArray == null) {
                    retStr = retStr + "null";
                } else {
                    for (int i = 0; i < DataArray.length; ++i) {
                        retStr = retStr + DataArray[i];
                        if (i + 1 == DataArray.length) continue;
                        retStr = retStr + ", ";
                    }
                }
                return retStr + "\r\n";
            }
        }
    }

    public static class CutOffConcent {
        public Info info = new Info();
        public Circuit circuit = null;

        public void setCircuitCount(byte nCircuitCount) {
            if (nCircuitCount <= 0) {
                return;
            }
            this.info.CircuitCount = nCircuitCount;
            this.circuit = new Circuit(nCircuitCount);
        }

        public static class Circuit {
            public int CircuitCount;
            public boolean[] Mode;
            public boolean[] CutoffStatus;
            public boolean[] CutoffValStatus;
            public boolean[] OverloadError;

            public Circuit(byte nCircuitCount) {
                int i;
                if (nCircuitCount <= 0) {
                    return;
                }
                this.CircuitCount = nCircuitCount;
                this.Mode = new boolean[nCircuitCount];
                for (i = 0; i < nCircuitCount; ++i) {
                    this.Mode[i] = false;
                }
                this.CutoffStatus = new boolean[nCircuitCount];
                for (i = 0; i < nCircuitCount; ++i) {
                    this.CutoffStatus[i] = false;
                }
                this.CutoffValStatus = new boolean[nCircuitCount];
                for (i = 0; i < nCircuitCount; ++i) {
                    this.CutoffValStatus[i] = false;
                }
                this.OverloadError = new boolean[nCircuitCount];
                for (i = 0; i < nCircuitCount; ++i) {
                    this.OverloadError[i] = false;
                }
            }

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Circuit\r\n==========================\r\nCircuitCount : " + this.CircuitCount + "\r\n";
                for (int CircuitIndex = 0; CircuitIndex < this.CircuitCount; ++CircuitIndex) {
                    retStr = retStr + "  Concent [" + (CircuitIndex + 1) + "]\r\n  Mode            : " + this.Mode[CircuitIndex] + "\r\n  CutoffStatus    : " + this.CutoffStatus[CircuitIndex] + "\r\n  CutoffValStatus : " + this.CutoffValStatus[CircuitIndex] + "\r\n  OverloadError   : " + this.OverloadError[CircuitIndex] + "\r\n";
                }
                retStr = retStr + "==========================";
                return retStr;
            }
        }

        public static class Info {
            public boolean Install = false;
            public byte CircuitCount = 0;
            public byte Vender;
            public byte FwVer_Year;
            public byte FwVer_Month;
            public byte FwVer_Day;
            public byte FwVer_Number;
            public byte ProtocolVer_Main;
            public byte ProtocolVer_Sub;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Info\r\n==========================\r\nInstall      : " + this.Install + "\r\nCircuitCount : " + this.CircuitCount + "\r\nVender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\n==========================";
                return retStr;
            }
        }
    }

    public static class EnergyModule {
        public Info info = new Info();
        public Circuit circuit = null;

        public void setCircuitCount(byte nCircuitCount) {
            if (nCircuitCount <= 0) {
                return;
            }
            this.info.CircuitCount = nCircuitCount;
            this.circuit = new Circuit(nCircuitCount);
        }

        public static class Circuit {
            public boolean UnitError;
            public int CircuitCount;
            public double[] NowPw;
            public double[] AccPw;
            public boolean[] AccOverFlow;

            public Circuit(byte nCircuitCount) {
                int i;
                if (nCircuitCount <= 0) {
                    return;
                }
                this.UnitError = false;
                this.CircuitCount = nCircuitCount;
                this.NowPw = new double[nCircuitCount];
                for (i = 0; i < nCircuitCount; ++i) {
                    this.NowPw[i] = 0.0;
                }
                this.AccPw = new double[nCircuitCount];
                for (i = 0; i < nCircuitCount; ++i) {
                    this.AccPw[i] = 0.0;
                }
                this.AccOverFlow = new boolean[nCircuitCount];
                for (i = 0; i < nCircuitCount; ++i) {
                    this.AccOverFlow[i] = false;
                }
            }

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Circuit\r\n==========================\r\nUnitError    : " + this.UnitError + "\r\nCircuitCount : " + this.CircuitCount + "\r\n";
                for (int CircuitIndex = 0; CircuitIndex < this.CircuitCount; ++CircuitIndex) {
                    retStr = retStr + "  Concent [" + (CircuitIndex + 1) + "]\r\n  NowPw       : " + this.NowPw[CircuitIndex] + "\r\n  AccPw       : " + this.AccPw[CircuitIndex] + "\r\n  AccOverFlow : " + this.AccOverFlow[CircuitIndex] + "\r\n";
                }
                retStr = retStr + "==========================";
                return retStr;
            }
        }

        public static class Info {
            public boolean Install = false;
            public boolean AccPw_Unit;
            public byte CircuitCount = 0;
            public byte Vender;
            public byte FwVer_Year;
            public byte FwVer_Month;
            public byte FwVer_Day;
            public byte FwVer_Number;
            public byte ProtocolVer_Main;
            public byte ProtocolVer_Sub;

            public String ToDebugString(byte DeviceIdx) {
                String retStr = "==========================\r\n(" + (byte)(DeviceIdx + 1) + ") Device - Info\r\n==========================\r\nInstall      : " + this.Install + "\r\nCircuitCount : " + this.CircuitCount + "\r\nVender       : " + String.format("0x%02X", this.Vender) + "\r\nFwVer        : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "." + this.FwVer_Number + "\r\nProtocolVer  : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\nAccPw_Unit   : " + this.AccPw_Unit + "\r\n==========================";
                return retStr;
            }
        }
    }
}

