/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.wallpadsupport;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;

public class WpadScale {
    private static String TAG = "WpadScale";
    public static int DEFAULT_WIDTH_PIXELS = 1280;
    public static int DEFAULT_HEIGHT_PIXELS = 800;
    private static int mWidthPixels = DEFAULT_WIDTH_PIXELS;
    private static int mHeightPixels = DEFAULT_HEIGHT_PIXELS;
    private static double mWidthScaleValue = 1.0;
    private static double mHeightScaleValue = 1.0;
    private static boolean mAutoScale = false;
    private static int mAutoScaleMode = 0;
    private static int mSampleWidthPixels = 0;
    private static int mSampleHeightPixels = 0;

    public static int getWidthPixels() {
        return mWidthPixels;
    }

    public static int getHeightPixels() {
        return mHeightPixels;
    }

    public static void setAutoScale(boolean set) {
        Log.i((String)TAG, (String)("[setAutoScale] set : " + set));
        if (mAutoScale == set) {
            return;
        }
        mAutoScale = set;
    }

    public static void changeAutoScaleValue(int nDefaultWidthPixel, int nDefaultHeightPixel) {
        try {
            Log.i((String)TAG, (String)("[changeAutoScaleValue] nDefaultWidthPixel [" + nDefaultWidthPixel + "], nDefaultHeightPixel [" + nDefaultHeightPixel + "], mWidthScaleValue [" + mWidthScaleValue + "], mHeightScaleValue [" + mHeightScaleValue + "]"));
            mWidthScaleValue = (double)mWidthPixels / (double)nDefaultWidthPixel;
            mHeightScaleValue = (double)mHeightPixels / (double)nDefaultHeightPixel;
            Log.i((String)TAG, (String)("[changeAutoScaleValue] After -> mWidthScaleValue [" + mWidthScaleValue + "], mHeightScaleValue [" + mHeightScaleValue + "]"));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] changeAutoScaleValue(int nDefaultWidthPixel, int nDefaultHeightPixel)");
            e.printStackTrace();
        }
    }

    public static boolean getAutoScale() {
        return mAutoScale;
    }

    public static int getAutoScaleMode() {
        return mAutoScaleMode;
    }

    public static boolean setAutoScaleMode(int set) {
        if (mAutoScaleMode == set) {
            return true;
        }
        switch (set) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                Log.w((String)TAG, (String)("[setAutoScaleMode] Param : Out Of Range !!! (set:" + set + ")"));
                return false;
            }
        }
        mAutoScaleMode = set;
        return true;
    }

    public static boolean setSamplePixels(int w, int h) {
        if (w <= 0 || h <= 0) {
            Log.w((String)TAG, (String)("[setSamplePixels] Param : w  or  h  Out Of Range !!!(w:" + w + ", h:" + h + ")"));
            return false;
        }
        mSampleWidthPixels = w;
        mSampleHeightPixels = h;
        return true;
    }

    public static void Initializing(Context context) {
        if (mSampleWidthPixels == 0 && mSampleHeightPixels == 0) {
            Log.i((String)TAG, (String)"[CreatePixelsNScale] Default Mode Setting !!!");
            DisplayMetrics metrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(metrics);
            mWidthPixels = metrics.widthPixels;
            mHeightPixels = metrics.heightPixels;
            if (mWidthPixels == 1024) {
                mHeightPixels = 600;
            }
        } else {
            Log.i((String)TAG, (String)"[CreatePixelsNScale] Sample Mode Setting !!!");
            mWidthPixels = mSampleWidthPixels;
            mHeightPixels = mSampleHeightPixels;
        }
        if (mWidthPixels != DEFAULT_WIDTH_PIXELS || mHeightPixels != DEFAULT_HEIGHT_PIXELS) {
            mWidthScaleValue = (double)mWidthPixels / (double)DEFAULT_WIDTH_PIXELS;
            mHeightScaleValue = (double)mHeightPixels / (double)DEFAULT_HEIGHT_PIXELS;
        }
        Log.i((String)TAG, (String)("[CreatePixelsNScale] Pixels : " + mWidthPixels + " x " + mHeightPixels));
        Log.i((String)TAG, (String)("[CreatePixelsNScale] Scale  : " + mWidthScaleValue + " x " + mHeightScaleValue));
    }

    public static int getWidth(int w) {
        if (w == 0) {
            return 0;
        }
        if (mAutoScale && mWidthPixels != DEFAULT_WIDTH_PIXELS) {
            double dWidth = mWidthScaleValue * (double)w;
            return (int)Math.round(dWidth);
        }
        return w;
    }

    public static int getHeight(int h) {
        if (h == 0) {
            return 0;
        }
        if (mAutoScale && mHeightPixels != DEFAULT_HEIGHT_PIXELS) {
            double dHeight = mHeightScaleValue * (double)h;
            return (int)Math.round(dHeight);
        }
        return h;
    }

    public static float getWidth(float w) {
        if (w == 0.0f) {
            return 0.0f;
        }
        if (mAutoScale && mWidthPixels != DEFAULT_WIDTH_PIXELS) {
            return (float)mWidthScaleValue * w;
        }
        return w;
    }

    public static float getHeight(float h) {
        if (h == 0.0f) {
            return 0.0f;
        }
        if (mAutoScale && mHeightPixels != DEFAULT_HEIGHT_PIXELS) {
            return (float)mHeightScaleValue * h;
        }
        return h;
    }

    public static final class AUTOSCALE_MODE {
        public static final int NORMAL = 0;
        public static final int WIDTH_HOLD = 1;
        public static final int HEIGHT_HOLD = 2;
    }
}

