/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class SystemAirconAPI
extends WallPadDevAPI {
    private final String TAG = "SystemAirconAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"SystemAirconAPI", (String)s);
    }

    public SystemAirconAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("SystemAirconAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "AIRCON";
        this.data = new Data();
        int ret = this.Refresh((byte)100, false);
        if (ret == 0) {
            byte AirconCount = this.data.Device.info.hInsideAirconCnt;
            Log.i((String)"SystemAirconAPI", (String)("GetInfo() - OK!!! (RoomCount:" + AirconCount + ")"));
            this.data.Device.setInsideAirConditionerCnt(AirconCount);
        } else {
            Log.i((String)"SystemAirconAPI", (String)("GetInfo() - fail!!! " + ret));
        }
        int retSetting = this.Refresh((byte)110, false);
        if (retSetting == 0) {
            byte AirconCount = this.data.Device.info.hInsideAirconCnt;
            Log.i((String)"SystemAirconAPI", (String)("GetInfo() - OK!!! (RoomCount:" + AirconCount + ")"));
            this.data.Device.setInsideAirConditionerCnt(AirconCount);
        } else {
            Log.i((String)"SystemAirconAPI", (String)("GetInfoSetting() - fail!!! " + retSetting));
        }
    }

    public int Refresh(byte Index, boolean real) {
        if ((Index < 0 || Index > 14) && Index != -1 && Index != 100 && Index != 110) {
            Log.w((String)"SystemAirconAPI", (String)("[Refresh] Param (Index) Out Of Range !!! (" + Index + ")"));
            return -300;
        }
        if (Index == 100 && real) {
            Log.w((String)"SystemAirconAPI", (String)"[Refresh] If the Index is REFRESH_IDX.INFO does not support the real(true)");
            return -300;
        }
        if (Index == 110 && real) {
            Log.w((String)"SystemAirconAPI", (String)"[Refresh] If the Index is REFRESH_IDX.SETTING does not support the real(true)");
            return -300;
        }
        if (Index != 100 && this.data.Device.info.hInsideAirconCnt <= 0) {
            Log.w((String)"SystemAirconAPI", (String)("[Refresh] DEVICE IS NOT READY (" + Index + ")"));
            return -110;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = null;
        if (Index >= 0 && Index <= 14) {
            if (this.checkAirconIndexRange(Index) != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
                return -300;
            }
            ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingEachAircon(ret);
        }
        if (Index == -1) {
            if (real) {
                int iret = this.SendNReadCMD_int(MainCMD, SubCMD, -1, 0, 0, 0, 0);
                if (iret != 0) {
                    return -111;
                }
                MainCMD = "NOSINKCTRL";
            }
            if (this.ParsingEntireAircon(ret = this.SendNReadCMD_str(MainCMD, SubCMD, -1, 0, 0, 0, 0)) != 0) {
                return -111;
            }
            if (0 >= this.data.Device.info.hInsideAirconCnt) {
                return -111;
            }
            return 0;
        }
        if (Index == 100) {
            ret = this.SendNReadCMD_str("NOSINKCTRL", SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingInfo(ret);
        }
        if (Index == 110) {
            ret = this.SendNReadCMD_str("NOSINKCTRL", SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingSetting(ret);
        }
        Log.w((String)"SystemAirconAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
        return -300;
    }

    private int ParsingEachAircon(String ret) {
        this.DebugLogOutput("[ParsingEachAircon] START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SystemAirconAPI", (String)"[ParsingEachAircon] ret return value is null !!!");
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"SystemAirconAPI", (String)"[ParsingEachAircon] retData value is null !!!");
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SystemAirconAPI", (String)("[ParsingEachAircon] retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SystemAirconAPI", (String)("[ParsingEachAircon] retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.SystemAircon.AirconUnitData mAirconUnitData = new DataClasses.SystemAircon.AirconUnitData();
            int index = 1;
            byte hRequestIndex = Byte.parseByte(retData[index++]);
            mAirconUnitData.hInsideID = Byte.parseByte(retData[index++]);
            mAirconUnitData.hPower = Byte.parseByte(retData[index++]);
            mAirconUnitData.hMode = Byte.parseByte(retData[index++]);
            mAirconUnitData.hAirVol = Byte.parseByte(retData[index++]);
            mAirconUnitData.bAirSwing = Boolean.parseBoolean(retData[index++]);
            mAirconUnitData.hSetTemper = Byte.parseByte(retData[index++]);
            mAirconUnitData.hCurrentTemper = Byte.parseByte(retData[index++]);
            mAirconUnitData.bOutAirconError = Boolean.parseBoolean(retData[index++]);
            mAirconUnitData.bOutAirconError = Boolean.parseBoolean(retData[index++]);
            mAirconUnitData.hErrorCode1 = Byte.parseByte(retData[index++]);
            mAirconUnitData.hErrorCode1 = Byte.parseByte(retData[index++]);
            this.data.Device.Aircon[hRequestIndex] = mAirconUnitData;
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] ParsingEachAircon(String ret)");
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingEntireAircon(String ret) {
        this.DebugLogOutput("[ParsingEntireAircon] START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SystemAirconAPI", (String)"[ParsingEntireAircon] ret return value is null !!!");
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"SystemAirconAPI", (String)"[ParsingEntireAircon] retData value is null !!!");
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SystemAirconAPI", (String)("[ParsingEntireAircon] retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SystemAirconAPI", (String)("[ParsingEntireAircon] retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            int index = 1;
            int nUnitCnt = Byte.parseByte(retData[index++]);
            for (int i = 0; i < nUnitCnt; ++i) {
                DataClasses.SystemAircon.AirconUnitData mAirconUnitData = new DataClasses.SystemAircon.AirconUnitData();
                mAirconUnitData.hInsideID = Byte.parseByte(retData[index++]);
                mAirconUnitData.hPower = Byte.parseByte(retData[index++]);
                mAirconUnitData.hMode = Byte.parseByte(retData[index++]);
                mAirconUnitData.hAirVol = Byte.parseByte(retData[index++]);
                mAirconUnitData.bAirSwing = Boolean.parseBoolean(retData[index++]);
                mAirconUnitData.hSetTemper = Byte.parseByte(retData[index++]);
                mAirconUnitData.hCurrentTemper = Byte.parseByte(retData[index++]);
                mAirconUnitData.bOutAirconError = Boolean.parseBoolean(retData[index++]);
                mAirconUnitData.bInsideAirconError = Boolean.parseBoolean(retData[index++]);
                mAirconUnitData.hErrorCode1 = Byte.parseByte(retData[index++]);
                mAirconUnitData.hErrorCode1 = Byte.parseByte(retData[index++]);
                this.data.Device.Aircon[i] = mAirconUnitData;
                this.DebugLogOutput(this.data.Device.Aircon[i].ToDebugString());
            }
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] ParsingEntireAircon(String ret)");
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingInfo(String ret) {
        String FUNC_NAME = "[ParsingInfo]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.SystemAircon.Info info = new DataClasses.SystemAircon.Info();
            int index = 1;
            info.hInsideAirconCnt = Byte.parseByte(retData[index++]);
            info.hVendor = Byte.parseByte(retData[index++]);
            info.hAirconStatus = Byte.parseByte(retData[index++]);
            info.hFwVer_Year = Byte.parseByte(retData[index++]);
            info.hFwVer_Month = Byte.parseByte(retData[index++]);
            info.hFwVer_Day = Byte.parseByte(retData[index++]);
            info.hFwVer_No = Byte.parseByte(retData[index++]);
            info.hProtocolVer_Main = Byte.parseByte(retData[index++]);
            info.hProtocolVer_Sub = Byte.parseByte(retData[index++]);
            info.hOutsideAirconCnt = Byte.parseByte(retData[index++]);
            info.hFirtstOutAirconCnt = Byte.parseByte(retData[index++]);
            info.Support.hMinCoolSetTemper = Byte.parseByte(retData[index++]);
            info.Support.hMaxCoolSetTemper = Byte.parseByte(retData[index++]);
            info.Support.hMinHeatSetTemper = Byte.parseByte(retData[index++]);
            info.Support.hMaxHeatSetTemper = Byte.parseByte(retData[index++]);
            info.Support.bV2CMDUsage = Boolean.parseBoolean(retData[index++]);
            info.Support.bModeCtrl = Boolean.parseBoolean(retData[index++]);
            info.Support.bAirVolCtrl = Boolean.parseBoolean(retData[index++]);
            info.Support.bCtrlOnResidualHeatRemoval = Boolean.parseBoolean(retData[index++]);
            info.Support.bChangeTemperRange = Boolean.parseBoolean(retData[index++]);
            info.Support.bFCUInterlock = Boolean.parseBoolean(retData[index++]);
            info.Support.bModeCooling = Boolean.parseBoolean(retData[index++]);
            info.Support.bModeFan = Boolean.parseBoolean(retData[index++]);
            info.Support.bModeHeating = Boolean.parseBoolean(retData[index++]);
            info.Support.bModeDehumidify = Boolean.parseBoolean(retData[index++]);
            info.Support.bModeAuto = Boolean.parseBoolean(retData[index++]);
            info.Support.bAirSwing = Boolean.parseBoolean(retData[index++]);
            this.data.Device.info = info;
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingSetting(String ret) {
        this.DebugLogOutput("[ParsingSetting] START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SystemAirconAPI", (String)"[ParsingSetting] ret return value is null !!!");
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"SystemAirconAPI", (String)"[ParsingSetting] retData value is null !!!");
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SystemAirconAPI", (String)("[ParsingSetting] retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SystemAirconAPI", (String)("[ParsingSetting] retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            int index = 1;
            DataClasses.SystemAircon.Setting mSetting = new DataClasses.SystemAircon.Setting();
            mSetting.hSettingStatus = Byte.parseByte(retData[index++]);
            mSetting.hAirconSetting = Byte.parseByte(retData[index++]);
            mSetting.hManufactureSetting = Byte.parseByte(retData[index++]);
            mSetting.groupinfo.hSettingStatus = Byte.parseByte(retData[index++]);
            mSetting.groupinfo.hGroupCnt = Byte.parseByte(retData[index++]);
            int nGroupCnt = mSetting.groupinfo.hGroupCnt;
            mSetting.groupinfo.setGroupCnt(mSetting.groupinfo.hGroupCnt);
            for (int i = 0; i < nGroupCnt; ++i) {
                mSetting.groupinfo.group[i].hNo = Byte.parseByte(retData[index++]);
                mSetting.groupinfo.group[i].hGroupValue01 = Byte.parseByte(retData[index++]);
                mSetting.groupinfo.group[i].hGroupValue02 = Byte.parseByte(retData[index++]);
            }
            this.data.Device.setting = mSetting;
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] ParsingSetting(String ret)");
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    public int SetUnitDeviceStatus(byte hIndex, int nSetData, double SetTemp) {
        try {
            int ret = this.checkAirconIndexRange(hIndex);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] hIndex Out Of Range !!! (" + hIndex + ")"));
                return ret;
            }
            ret = this.CheckParamSetMode(nSetData);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] SetMode Out Of Range !!! (" + String.format("%02X", nSetData) + ")"));
                return -300;
            }
            byte ByteTemp = 0;
            if (SetTemp != 0.0 && ((ByteTemp = (byte)SetTemp) < this.data.Device.info.Support.hMinCoolSetTemper || ByteTemp > this.data.Device.info.Support.hMaxCoolSetTemper)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] SetMode Out Of Range !!! - (" + ByteTemp + ")"));
                return -300;
            }
            return this.SendNReadCMD_int("SINKCTRL", "SetUnitDeviceStatus", hIndex, nSetData, ByteTemp, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetUnitDeviceStatus(byte hIndex, int nSetData, double SetTemp)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetUnitDeviceStatus(byte hIndex, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper) {
        try {
            int ret = this.checkAirconIndexRange(hIndex);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] hIndex Out Of Range !!! (" + hIndex + ")"));
                return ret;
            }
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            if (hSetTemper != 0) {
                if (hMode == DataClasses.SystemAircon.MODE.Cooling) {
                    if (hSetTemper < this.data.Device.info.Support.hMinCoolSetTemper || this.data.Device.info.Support.hMaxCoolSetTemper < hSetTemper) {
                        Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] MODE.Cold -> hMinCoolSetTemper [" + this.data.Device.info.Support.hMinCoolSetTemper + "], hMaxCoolSetTemper [" + this.data.Device.info.Support.hMaxCoolSetTemper + "], hSetTemper Out Of Range !!! - (" + String.format("0x%02X", hSetTemper) + ")"));
                        return -300;
                    }
                } else if (hMode == DataClasses.SystemAircon.MODE.Heating && (hSetTemper < this.data.Device.info.Support.hMinHeatSetTemper || this.data.Device.info.Support.hMaxHeatSetTemper < hSetTemper)) {
                    Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatus] MODE.Heat -> hMinCoolSetTemper [" + this.data.Device.info.Support.hMinCoolSetTemper + "], hMaxCoolSetTemper [" + this.data.Device.info.Support.hMaxCoolSetTemper + "], hSetTemper Out Of Range !!! - (" + String.format("0x%02X", hSetTemper) + ")"));
                    return -300;
                }
            }
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            return this.SendNReadCMD_int("SINKCTRL", "SetUnitDeviceStatus", hIndex, hSetData, hSetTemper, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetUnitDeviceStatus(byte hIndex, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetUnitDeviceStatusV2(byte hIndex, byte hCtrlOption, byte hSetData, byte hSetTemper) {
        try {
            int ret = this.checkAirconIndexRange(hIndex);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hIndex Out Of Range !!! (" + hIndex + ")"));
                return ret;
            }
            this.DebugLogOutput("[SetUnitDeviceStatusV2] SetUnitDeviceStatusV2 - API OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetUnitDeviceStatusV2", hIndex, hCtrlOption, hSetData, hSetTemper, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetUnitDeviceStatusV2(byte hIndex, byte hCtrlOption, byte hSetData, byte hSetTemper)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetUnitDeviceStatusV2(byte hIndex, byte hCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper) {
        try {
            int ret = this.checkAirconIndexRange(hIndex);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hIndex Out Of Range !!! (" + hIndex + ")"));
                return ret;
            }
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            this.DebugLogOutput("[SetUnitDeviceStatusV2] SetUnitDeviceStatusV2 - API OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetUnitDeviceStatusV2", hIndex, hCtrlOption, hSetData, hSetTemper, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetUnitDeviceStatusV2(byte hIndex, byte hCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetUnitDeviceStatusV2(byte hIndex, boolean[] bCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper) {
        try {
            int ret = this.checkAirconIndexRange(hIndex);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hIndex Out Of Range !!! (" + hIndex + ")"));
                return ret;
            }
            if (bCtrlOption.length != 8) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] bCtrlOption length is wrong !!! (Length -> " + bCtrlOption.length + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            int nCtrlOption = 0;
            for (int i = 0; i < bCtrlOption.length; ++i) {
                if (!bCtrlOption[i]) continue;
                if (0 <= i && i < 3) {
                    Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] bCtrlOption[" + i + "] is wrong !!! (bCtrlOption[" + i + "] -> " + bCtrlOption[i] + ")"));
                    return -300;
                }
                if (i == 4) {
                    nCtrlOption += 8;
                    continue;
                }
                if (i == 5) {
                    nCtrlOption += 4;
                    continue;
                }
                if (i == 6) {
                    nCtrlOption += 2;
                    continue;
                }
                if (i != 7) continue;
                ++nCtrlOption;
            }
            byte hCtrlOption = (byte)nCtrlOption;
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            this.DebugLogOutput("[SetUnitDeviceStatusV2] SetUnitDeviceStatusV2 - API OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetUnitDeviceStatusV2", hIndex, hCtrlOption, hSetData, hSetTemper, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetUnitDeviceStatusV2(byte hIndex, boolean[] bCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetUnitDeviceStatusV2(byte hIndex, boolean bPowerCtrl, boolean bAirVolCtrl, boolean bModeCtrl, boolean bAirSwingCtrl, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper) {
        try {
            Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hIndex [" + hIndex + "], CtrlOption - bPowerCtrl [" + bPowerCtrl + "], bAirVolCtrl [" + bAirVolCtrl + "], bModeCtrl [" + bModeCtrl + "], bAirSwingCtrl [" + bAirSwingCtrl + "]"));
            Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hPower [" + String.format("0x%02X", hPower) + "], hAirVol [" + String.format("0x%02X", hAirVol) + "], hMode [" + String.format("0x%02X", hMode) + "], bAirSwing [" + bAirSwing + "], hSetTemper [" + String.format("0x%02X", hSetTemper) + "]"));
            int ret = this.checkAirconIndexRange(hIndex);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hIndex Out Of Range !!! (" + hIndex + ")"));
                return ret;
            }
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetUnitDeviceStatusV2] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            int nCtrlOption = 0;
            if (bPowerCtrl) {
                ++nCtrlOption;
            }
            if (bAirVolCtrl) {
                nCtrlOption += 2;
            }
            if (bModeCtrl) {
                nCtrlOption += 4;
            }
            if (bAirSwingCtrl) {
                nCtrlOption += 8;
            }
            byte hCtrlOption = (byte)nCtrlOption;
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            this.DebugLogOutput("[SetUnitDeviceStatusV2] SetUnitDeviceStatusV2 - API OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetUnitDeviceStatusV2", hIndex, hCtrlOption, hSetData, hSetTemper, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetUnitDeviceStatusV2(byte hIndex, boolean bPowerCtrl, boolean bAirVolCtrl, boolean bModeCtrl, boolean bAirSwingCtrl, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing, byte hSetTemper");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetEntireDeviceStatus(byte hSetData) {
        try {
            int ret = this.CheckParamSetMode(hSetData);
            if (ret != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatus] hSetData Out Of Range !!! (" + String.format("%02X", hSetData) + ")"));
                return -300;
            }
            this.DebugLogOutput("[AircornAPI----------------------------------------] SetEntireDeviceStatus - OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetEntireDeviceStatus", hSetData, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetEntireDeviceStatus(byte hSetData)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetEntireDeviceStatus(byte hPower, byte hAirVol, byte hMode, boolean bAirSwing) {
        try {
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatus] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatus] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatus] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            this.DebugLogOutput("[AircornAPI----------------------------------------] SetEntireDeviceStatus - OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetEntireDeviceStatus", hSetData, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetEntireDeviceStatus(byte hPower, byte hAirVol, byte hMode, boolean bAirSwing)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetEntireDeviceStatusV2(byte hCtrlOption, byte hSetData) {
        try {
            this.DebugLogOutput("[AircornAPI----------------------------------------] SetEntireDeviceStatusV2 - OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetEntireDeviceStatusV2", hCtrlOption, hSetData, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetEntireDeviceStatusV2(byte hCtrlOption, byte hSetData)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetEntireDeviceStatusV2(byte hCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing) {
        try {
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            this.DebugLogOutput("[AircornAPI----------------------------------------] SetEntireDeviceStatusV2 - OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetEntireDeviceStatusV2", hCtrlOption, hSetData, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetEntireDeviceStatusV2(byte hCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetEntireDeviceStatusV2(boolean[] bCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing) {
        try {
            if (bCtrlOption.length != 8) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] bCtrlOption length is wrong !!! (Length -> " + bCtrlOption.length + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            int nCtrlOption = 0;
            for (int i = 0; i < bCtrlOption.length; ++i) {
                if (!bCtrlOption[i]) continue;
                if (0 <= i && i < 3) {
                    Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] bCtrlOption[" + i + "] is wrong !!! (bCtrlOption[" + i + "] -> " + bCtrlOption[i] + ")"));
                    return -300;
                }
                if (i == 4) {
                    nCtrlOption += 8;
                    continue;
                }
                if (i == 5) {
                    nCtrlOption += 4;
                    continue;
                }
                if (i == 6) {
                    nCtrlOption += 2;
                    continue;
                }
                if (i != 7) continue;
                ++nCtrlOption;
            }
            byte hCtrlOption = (byte)nCtrlOption;
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            this.DebugLogOutput("[AircornAPI----------------------------------------] SetEntireDeviceStatusV2 - OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetEntireDeviceStatusV2", hCtrlOption, hSetData, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetEntireDeviceStatusV2(boolean[] bCtrlOption, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetEntireDeviceStatusV2(boolean bPowerCtrl, boolean bAirVolCtrl, boolean bModeCtrl, boolean bAirSwingCtrl, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing) {
        try {
            Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] CtrlOption - bPowerCtrl [" + bPowerCtrl + "], bAirVolCtrl [" + bAirVolCtrl + "], bModeCtrl [" + bModeCtrl + "], bAirSwingCtrl [" + bAirSwingCtrl + "]"));
            Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hPower [" + String.format("0x%02X", hPower) + "], hAirVol [" + String.format("0x%02X", hAirVol) + "], hMode [" + String.format("0x%02X", hMode) + "], bAirSwing [" + bAirSwing + "]"));
            if (!DataClasses.SystemAircon.POWER.checkPowerRange(hPower)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hPower Out Of Range !!! (" + String.format("0x%02X", hPower) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.AIRVOLUME.checkAirVolRange(hAirVol)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hAirVol Out Of Range !!! (" + String.format("0x%02X", hAirVol) + ")"));
                return -300;
            }
            if (!DataClasses.SystemAircon.MODE.checkModeRange(hMode)) {
                Log.w((String)"SystemAirconAPI", (String)("[SetEntireDeviceStatusV2] hMode Out Of Range !!! (" + String.format("0x%02X", hMode) + ")"));
                return -300;
            }
            int hAirSwing = 0;
            hAirSwing = bAirSwing ? 1 : 0;
            int nCtrlOption = 0;
            if (bPowerCtrl) {
                ++nCtrlOption;
            }
            if (bAirVolCtrl) {
                nCtrlOption += 2;
            }
            if (bModeCtrl) {
                nCtrlOption += 4;
            }
            if (bAirSwingCtrl) {
                nCtrlOption += 8;
            }
            byte hCtrlOption = (byte)nCtrlOption;
            byte hSetData = (byte)(hPower + (hAirVol << 2) + (hMode << 4) + (hAirSwing << 7));
            this.DebugLogOutput("[AircornAPI----------------------------------------] SetEntireDeviceStatusV2 - OK");
            return this.SendNReadCMD_int("SINKCTRL", "SetEntireDeviceStatusV2", hCtrlOption, hSetData, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetEntireDeviceStatusV2(boolean bPowerCtrl, boolean bAirVolCtrl, boolean bModeCtrl, boolean bAirSwingCtrl, byte hPower, byte hAirVol, byte hMode, boolean bAirSwing)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int GetDeviceSetting() {
        try {
            return this.SendNReadCMD_int("SINKCTRL", "GetDeviceSetting", 0, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] GetDeviceSetting()");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetDeviceSetting(byte hAirconSetting) {
        try {
            return this.SendNReadCMD_int("SINKCTRL", "SetDeviceSetting", hAirconSetting, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetDeviceSetting(byte hAirconSetting)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int GetDeviceSettingV2() {
        try {
            return this.SendNReadCMD_int("SINKCTRL", "GetDeviceSettingV2", 0, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] GetDeviceSettingV2()");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetDeviceSettingV2(byte hAirconSetting, byte hManufactureSetting) {
        try {
            return this.SendNReadCMD_int("SINKCTRL", "SetDeviceSettingV2", hAirconSetting, hManufactureSetting, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetDeviceSettingV2(byte hAirconSetting, byte hManufactureSetting)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetDeviceReboot() {
        try {
            return this.SendNReadCMD_int("SINKCTRL", "SetDeviceReboot", 0, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetDeviceReboot()");
            e.printStackTrace();
            return -100000;
        }
    }

    public int GetGroupSettingStatus() {
        try {
            return this.SendNReadCMD_int("SINKCTRL", "GetGroupSettingStatus", 0, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] GetGroupSettingStatus()");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetGroupSettingStatus(DataClasses.SystemAircon.Setting.GroupInfo mGroupInfo) {
        try {
            if (mGroupInfo == null) {
                return -300;
            }
            byte[] params = new byte[mGroupInfo.hGroupCnt * 3 + 2];
            int nIndex = 0;
            params[nIndex++] = mGroupInfo.hSettingStatus;
            params[nIndex++] = mGroupInfo.hGroupCnt;
            int nCnt = mGroupInfo.hGroupCnt;
            for (int i = 0; i < nCnt; ++i) {
                int nGroupIndex = 0;
                params[nIndex++] = mGroupInfo.group[nGroupIndex].hNo;
                params[nIndex++] = mGroupInfo.group[nGroupIndex].hGroupValue01;
                params[nIndex++] = mGroupInfo.group[nGroupIndex].hGroupValue02;
            }
            return this.SendNReadCMD_int("SINKCTRL", "SetGroupSettingStatus", params);
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] SetGroupSettingStatus(SystemAircon.Setting.GroupInfo mGroupInfo)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int SetPollingMode(byte ChangePollingMode, byte RoomIndex) {
        int ret;
        if (ChangePollingMode != 2 && ChangePollingMode != 3) {
            return -300;
        }
        if (ChangePollingMode == 3 && (ret = this.checkAirconIndexRange(RoomIndex)) != 0) {
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetPollingMode", ChangePollingMode, RoomIndex, 0, 0, 0);
    }

    private int checkAirconIndexRange(byte hIndex) {
        try {
            if (this.data.Device == null) {
                return -110;
            }
            byte AirCount = this.data.Device.info.hInsideAirconCnt;
            if (AirCount <= 0) {
                return -110;
            }
            if (this.data.Device.Aircon == null) {
                return -110;
            }
            if (this.data.Device.Aircon.length <= hIndex) {
                return -110;
            }
            return 0;
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)"[Exception] checkAirconIndexRange(byte hIndex)");
            e.printStackTrace();
            return -100000;
        }
    }

    private int CheckParamSetMode(int Mode) {
        return 0;
    }

    public static class Data {
        public DataClasses.SystemAircon Device = new DataClasses.SystemAircon();
    }

    public static final class POLLING_MODE {
        public static final byte Normal = 2;
        public static final byte FixRoom = 3;
    }

    public static final class REFRESH_IDX {
        public static final byte AIRCON_01 = 0;
        public static final byte AIRCON_02 = 1;
        public static final byte AIRCON_03 = 2;
        public static final byte AIRCON_04 = 3;
        public static final byte AIRCON_05 = 4;
        public static final byte AIRCON_06 = 5;
        public static final byte AIRCON_07 = 6;
        public static final byte AIRCON_08 = 7;
        public static final byte AIRCON_09 = 8;
        public static final byte AIRCON_10 = 9;
        public static final byte AIRCON_11 = 10;
        public static final byte AIRCON_12 = 11;
        public static final byte AIRCON_13 = 12;
        public static final byte AIRCON_14 = 13;
        public static final byte AIRCON_15 = 14;
        public static final byte ALL = -1;
        public static final byte INFO = 100;
        public static final byte SETTING = 110;
    }
}

