/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.commons;

import android.util.Log;
import com.artncore.commons.Sdb_DataClasses;

public class KNX_DataClasses {
    private static final String TAG = "KNX_DataClasses";

    public static class LivingEnergyMeterClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class ConcentRegisterClass {
            public boolean Registering = false;
            public int RemainingTime = 0;
            public byte Regi_Count = 0;

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter Concent Register ]] \r\n=========================================================\r\nRegistering : " + this.Registering + "\r\nRemainingTime : " + this.RemainingTime + "\r\nRegi_Count : " + this.Regi_Count + "\r\n";
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class LIV_LightClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean OnOff = false;
                public byte Dimming = (byte)10;
                public byte Color = (byte)10;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nOnOff     : " + this.OnOff + "\r\nDimming   : " + this.Dimming + "\r\nColor     : " + this.Color + "\r\n----------------------------------------\r\n";
                    return retStr;
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public byte Type = LIGHT_TYPE.NO_INFO;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nInstall      : " + this.Install + "\r\nType         : " + LIGHT_TYPE.ToString(this.Type) + " : " + this.Type + "\r\n----------------------------------------\r\n";
                    return retStr;
                }
            }
        }

        public static class DataClass {
            public byte DeviceInfo = 0;
            public boolean Fault_Button = false;
            public boolean Fault_ErrorDisplay = false;
            public boolean Fault_Init = false;
            public byte LightCount = 0;
            public LIV_LightClass[] LIV_Lights = null;

            public int setLivLight(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.LIV_Lights = new LIV_LightClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.LIV_Lights[i] = new LIV_LightClass();
                }
                return 0;
            }

            public int setLivLightInfo(byte nCount, byte lightType_1n2, byte lightType_3n4) {
                if (nCount <= 0) {
                    return -1;
                }
                byte[] lightInfoArr = new byte[]{(byte)(lightType_1n2 & 0xF), (byte)(lightType_1n2 >> 4 & 0xF), (byte)(lightType_3n4 & 0xF), (byte)(lightType_3n4 >> 4 & 0xF)};
                for (int i = 0; i < nCount; ++i) {
                    if (this.LIV_Lights[i] == null) continue;
                    this.LIV_Lights[i].Info.Install = true;
                    if (!LIGHT_TYPE.CheckRange(lightInfoArr[i])) continue;
                    this.LIV_Lights[i].Info.Type = lightInfoArr[i];
                }
                return 0;
            }

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter.Data ]] \r\n=========================================================\r\nDeviceInfo         : " + this.DeviceInfo + "\r\nFault_Button       : " + this.Fault_Button + "\r\nFault_ErrorDisplay : " + this.Fault_ErrorDisplay + "\r\nFault_Init         : " + this.Fault_Init + "\r\nLightCount         : " + this.LightCount + "\r\n";
                if (this.LIV_Lights != null) {
                    byte EmIndex = 0;
                    byte len = this.LIV_Lights.length;
                    for (byte i = 0; i < len; i = (byte)(i + 1)) {
                        retStr = retStr + this.LIV_Lights[i].Info.ToString(EmIndex, i);
                        retStr = retStr + this.LIV_Lights[i].Data.ToString(EmIndex, i);
                    }
                } else {
                    retStr = retStr + "LedLight is null !!!";
                }
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte FactorySet_Info = 0;
            public byte ErrorDisplay_Status = 0;
            public byte Linkage_Info = 0;
            public byte DIMnCOLOR_Level = 0;
            public byte LightCount = 0;
            public byte LightType_1n2 = 0;
            public byte LightType_3n4 = 0;
            LIGHT_TYPE[] LightTypes = null;
            public byte LightType_Expand = 0;
            public LightGroupClass LightGroup = new LightGroupClass();

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ LivingEnergyMeter.Info ]] \r\n----------------------------------------\r\nInstall             : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nFactorySet_Info     : " + this.FactorySet_Info + "\r\nErrorDisplay_Status : " + this.ErrorDisplay_Status + "\r\nLinkage_Info        : " + this.Linkage_Info + "\r\nDIMnCOLOR_Level     : " + this.DIMnCOLOR_Level + "\r\n\r\nLightCount          : " + this.LightCount + "\r\nLightType_1n2       : " + this.LightType_1n2 + "\r\nLightType_3n4       : " + this.LightType_3n4 + "\r\nLightType_Expand    : " + this.LightType_Expand + "\r\n" + this.LightGroup.ToString() + "----------------------------------------\r\n";
                return retStr;
            }

            public static class LightGroupClass {
                public boolean[] Group_Use = new boolean[4];

                public LightGroupClass() {
                    for (int i = 0; i < this.Group_Use.length; ++i) {
                        this.Group_Use[i] = false;
                    }
                }

                public String ToString() {
                    String retStr = "[LightGroup]\r\n";
                    for (int i = 0; i < this.Group_Use.length; ++i) {
                        retStr = retStr + "LIGHT #" + (i + 1) + "in GROUP : " + this.Group_Use.toString() + "\r\n";
                    }
                    return retStr;
                }
            }
        }
    }

    public static class LightSwithcClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class Light_SwitchClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault = false;
                public boolean OnOff = false;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\nOnOff     : " + this.OnOff + "\r\n----------------------------------------\r\n";
                    return retStr;
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public SupportClass Support = new SupportClass();

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nInstall         : " + this.Install + "\r\n----------------------------------------\r\n";
                    return retStr;
                }

                public static class SupportClass {
                    public boolean OnOff = false;
                }
            }
        }

        public static class DataClass {
            public boolean ExistSwitch = true;
            public byte DeviceInfo = 0;
            public boolean Fault_Button = false;
            public boolean Fault_ErrorDisplay = false;
            public boolean Fault_Init = false;
            public boolean CommFault;
            public byte LightCount = 0;
            public Light_SwitchClass[] LightSwitch;

            public int setLightSwitch(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.LightSwitch = new Light_SwitchClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.LightSwitch[i] = new Light_SwitchClass();
                }
                return 0;
            }

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter.Data ]] \r\n=========================================================\r\nDeviceInfo         : " + this.DeviceInfo + "\r\nFault_Button       : " + this.Fault_Button + "\r\nFault_ErrorDisplay : " + this.Fault_ErrorDisplay + "\r\nFault_Init         : " + this.Fault_Init + "\r\nLightCount         : " + this.LightCount + "\r\n";
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte FactorySet_Info = 0;
            public byte ErrorDisplay_Status = 0;
            public byte Linkage_Info = 0;
            public byte LightCount = 0;
            public byte LightType_1 = 0;
            public byte LightType_2 = 0;
            public byte LightType_3 = 0;
            public byte LightType_4 = 0;
            public byte LightType_Expand = 0;

            public String ToString(byte EmIndex) {
                String retStr = "----------------------------------------\r\n[[ EnergyMeter.Info ]] EM:#" + (EmIndex + 1) + "\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nLightCount : " + this.LightCount + "\r\n----------------------------------------\r\n";
                return retStr;
            }

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ LivingEnergyMeter.Info ]] \r\n----------------------------------------\r\nInstall             : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nFactorySet_Info     : " + this.FactorySet_Info + "\r\nErrorDisplay_Status : " + this.ErrorDisplay_Status + "\r\nLinkage_Info        : " + this.Linkage_Info + "\r\n\r\nLightCount          : " + this.LightCount + "\r\nLightType_1       : " + this.LightType_1 + "\r\nLightType_2       : " + this.LightType_2 + "\r\nLightType_3       : " + this.LightType_3 + "\r\nLightType_4       : " + this.LightType_4 + "\r\nLightType_Expand    : " + this.LightType_Expand + "\r\n----------------------------------------\r\n";
                return retStr;
            }
        }
    }

    public static class EnergyMeterClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class ConcentRegisterClass {
            public boolean Registering = false;
            public int RemainingTime = 0;
            public byte Regi_Count = 0;

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter Concent Register ]] \r\n=========================================================\r\nRegistering : " + this.Registering + "\r\nRemainingTime : " + this.RemainingTime + "\r\nRegi_Count : " + this.Regi_Count + "\r\n";
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class ConcentClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault = false;
                public CutOffConcentClass CutOffConcent = new CutOffConcentClass();
                public AlwaysConcentClass AlwaysConcent = new AlwaysConcentClass();

                public String ToString(byte EmIndex, byte ConcentIndex) {
                    String retStr = "----------------------------------------\r\n[[ Concent.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (ConcentIndex + 1) + "\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\n" + this.CutOffConcent.ToString() + this.AlwaysConcent.ToString() + "----------------------------------------\r\n";
                    return retStr;
                }

                public static class CONCENT_MODE {
                    public static byte Auto = 1;
                    public static byte Always = (byte)2;

                    public static String ToString(byte Mode) {
                        if (Mode == Auto) {
                            return "Auto";
                        }
                        if (Mode == Always) {
                            return "Always";
                        }
                        return "UnDefind";
                    }
                }

                public static class CONCENT_STATUS {
                    public static byte On = 1;
                    public static byte Off = (byte)2;
                    public static byte CutOff = (byte)3;
                    public static byte OverLoadOff = (byte)4;

                    public static String ToString(byte Status2) {
                        if (Status2 == On) {
                            return "On";
                        }
                        if (Status2 == Off) {
                            return "Off";
                        }
                        if (Status2 == CutOff) {
                            return "CutOff";
                        }
                        if (Status2 == OverLoadOff) {
                            return "OverLoadOff";
                        }
                        return "UnDefind";
                    }
                }

                public static class AlwaysConcentClass {
                    public double NowPw = 0.0;
                    public int AccPw = 0;

                    public String ToString() {
                        String retStr = "[AlwaysConcent]\r\nNowPw : " + this.NowPw + ",  AccPw : " + this.AccPw + "\r\n";
                        return retStr;
                    }
                }

                public static class CutOffConcentClass {
                    public byte Status = CONCENT_STATUS.Off;
                    public byte Mode = CONCENT_MODE.Always;
                    public double NowPw = 0.0;
                    public int AccPw = 0;
                    public double CutOffVal = 0.0;

                    public String ToString() {
                        String retStr = "[CutOffConcent]\r\nStatus : " + CONCENT_STATUS.ToString(this.Status) + ",  Mode : " + CONCENT_MODE.ToString(this.Mode) + "\r\nNowPw : " + this.NowPw + ",  AccPw : " + this.AccPw + ",  CutOffVal : " + this.CutOffVal + "\r\n";
                        return retStr;
                    }
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public VersionClass Version = new VersionClass();

                public String ToString(byte EmIndex, byte ConcentIndex) {
                    String retStr = "----------------------------------------\r\n[[ Concent.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (ConcentIndex + 1) + "\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "----------------------------------------\r\n";
                    return retStr;
                }
            }
        }

        public static class LIV_LightClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault;
                public boolean OnOff = false;
                public byte Dimming = (byte)10;
                public byte Color = (byte)10;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nOnOff     : " + this.OnOff + "\r\nDimming   : " + this.Dimming + "\r\nColor     : " + this.Color + "\r\n----------------------------------------\r\n";
                    return retStr;
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public SupportClass Support;
                public byte Type = LIGHT_TYPE.NO_INFO;

                public InfoClass() {
                    this.Support = new SupportClass();
                }

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLightExp.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nInstall      : " + this.Install + "\r\nType         : " + LIGHT_TYPE.ToString(this.Type) + " : " + this.Type + "\r\n----------------------------------------\r\n";
                    return retStr;
                }

                public static class CodeClass {
                    public byte Usage = Sdb_DataClasses.LEDLIGHT_USAGE_CODE.NOT_DEFINE;
                }

                public static class SupportClass {
                    public boolean OnOff = false;
                    public boolean Dimming = false;
                    public boolean Color = false;
                }
            }
        }

        public static class BAD_LightClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault = false;
                public boolean OnOff = false;
                public byte Dimming = (byte)10;
                public byte Color = (byte)10;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\nOnOff     : " + this.OnOff + "\r\nDimming   : " + this.Dimming + "\r\nColor     : " + this.Color + "\r\n----------------------------------------\r\n";
                    return retStr;
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public SupportClass Support = new SupportClass();

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nInstall         : " + this.Install + "\r\n----------------------------------------\r\n";
                    return retStr;
                }

                public static class CodeClass {
                    public byte Usage = Sdb_DataClasses.LEDLIGHT_USAGE_CODE.NOT_DEFINE;
                }

                public static class SupportClass {
                    public boolean OnOff = false;
                    public boolean Dimming = false;
                    public boolean Color = false;
                }
            }
        }

        public static class DataClass {
            public boolean ExistEM = true;
            public byte DeviceInfo = 0;
            public boolean Fault_Button = false;
            public boolean Fault_ErrorDisplay = false;
            public boolean Fault_Init = false;
            public boolean CommFault;
            public byte LightCount = 0;
            public boolean AlmostSenFault;
            public boolean WifiModuleFault;
            public boolean TempSenFault;
            public LIV_LightClass[] LivingLight;
            public BAD_LightClass[] BadLight;
            public ConcentClass[] Concent;

            public int setLivingLight(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.LivingLight = new LIV_LightClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.LivingLight[i] = new LIV_LightClass();
                }
                return 0;
            }

            public int setBadLight(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.BadLight = new BAD_LightClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.BadLight[i] = new BAD_LightClass();
                }
                return 0;
            }

            public int setConcent(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.Concent = new ConcentClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.Concent[i] = new ConcentClass();
                }
                return 0;
            }

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter.Data ]] \r\n=========================================================\r\nDeviceInfo         : " + this.DeviceInfo + "\r\nFault_Button       : " + this.Fault_Button + "\r\nFault_ErrorDisplay : " + this.Fault_ErrorDisplay + "\r\nFault_Init         : " + this.Fault_Init + "\r\nLightCount         : " + this.LightCount + "\r\n";
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte FactorySet_Info = 0;
            public byte ErrorDisplay_Status = 0;
            public byte Linkage_Info = 0;
            public byte DIMnCOLOR_Level = (byte)10;
            public byte LightCount = 0;
            public byte LightType_1 = 0;
            public byte LightType_2 = 0;
            public byte LightType_3 = 0;
            public byte LightType_4 = 0;
            public byte LightType_Expand = 0;
            public byte ConcentCount = 0;

            public String ToString(byte EmIndex) {
                String retStr = "----------------------------------------\r\n[[ EnergyMeter.Info ]] EM:#" + (EmIndex + 1) + "\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nLightCount : " + this.LightCount + "\r\nConcentCount : " + this.ConcentCount + "\r\n----------------------------------------\r\n";
                return retStr;
            }

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ LivingEnergyMeter.Info ]] \r\n----------------------------------------\r\nInstall             : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nFactorySet_Info     : " + this.FactorySet_Info + "\r\nErrorDisplay_Status : " + this.ErrorDisplay_Status + "\r\nLinkage_Info        : " + this.Linkage_Info + "\r\nDIMnCOLOR_Level     : " + this.DIMnCOLOR_Level + "\r\n\r\nLightCount          : " + this.LightCount + "\r\nLightType_1       : " + this.LightType_1 + "\r\nLightType_2       : " + this.LightType_2 + "\r\nLightType_3       : " + this.LightType_3 + "\r\nLightType_4       : " + this.LightType_4 + "\r\nLightType_Expand    : " + this.LightType_Expand + "\r\nConcentCount        : " + this.ConcentCount + "\r\n----------------------------------------\r\n";
                return retStr;
            }
        }
    }

    public static class MasterControllerClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class DataClass {
            public byte Init_Status = INIT_STATUS.NORMAL;
            public boolean PowerFault_Status = false;
            public boolean Fault_KnxGwComm = false;
            public boolean Fault_KnxGwSet = false;
            public boolean Fault_EmComm = false;
            public boolean Fault_LightSwitchComm = false;
            public byte OutingStatus = OUTING_STATUS.NO_INFO;
            public byte BatchOffStatus = BATCHOFF_STATUS.NO_SET;
            public byte AllConcentStatus = ALL_CONCENT_STATUS.NO_INFO;

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ MasterController.Data ]]\r\n----------------------------------------\r\nInit_Status           : " + INIT_STATUS.ToString(this.Init_Status) + "\r\nPowerFault_Status     : " + this.PowerFault_Status + "\r\nFault_KnxGwComm       : " + this.Fault_KnxGwComm + "\r\nFault_KnxGwSet        : " + this.Fault_KnxGwSet + "\r\nFault_EmComm          : " + this.Fault_EmComm + "\r\nFault_LightSwitchComm : " + this.Fault_LightSwitchComm + "\r\nOutingStatus          : " + OUTING_STATUS.ToString(this.OutingStatus) + "\r\nBatchOffStatus        : " + BATCHOFF_STATUS.ToString(this.BatchOffStatus) + "\r\nAllConcentStatus      : " + ALL_CONCENT_STATUS.ToString(this.AllConcentStatus) + "\r\n----------------------------------------\r\n";
                return retStr;
            }

            public static class ALL_CONCENT_STATUS {
                public static byte NO_INFO = 0;
                public static byte OFF = 1;
                public static byte ON = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return true;
                    }
                    if (nStatus == OFF) {
                        return true;
                    }
                    return nStatus == ON;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return "NO_INFO";
                    }
                    if (nStatus == OFF) {
                        return "OFF";
                    }
                    if (nStatus == ON) {
                        return "ON";
                    }
                    return "UnDefined";
                }
            }

            public static class OUTING_STATUS {
                public static byte NO_INFO = 0;
                public static byte SET = 1;
                public static byte CLR = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return true;
                    }
                    if (nStatus == SET) {
                        return true;
                    }
                    return nStatus == CLR;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return "NO_INFO";
                    }
                    if (nStatus == SET) {
                        return "SET";
                    }
                    if (nStatus == CLR) {
                        return "CLR";
                    }
                    return "UnDefined";
                }
            }

            public static class INIT_STATUS {
                public static byte NORMAL = 0;
                public static byte INIT_SET = 1;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NORMAL) {
                        return true;
                    }
                    return nStatus == INIT_SET;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == NORMAL) {
                        return "NORMAL";
                    }
                    if (nStatus == INIT_SET) {
                        return "INIT_SET";
                    }
                    return "UnDefined";
                }
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public boolean Fault_KnxGwComm = false;
            public boolean Fault_KnxGwSet = false;
            public byte Liv_EnergyMeterCount = 0;
            public byte Bad_EnergyMeterCount = 0;
            public byte Light_SwitchCount = 0;

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ MasterController.Info ]]\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nLiv_EnergyMeterCount : " + this.Liv_EnergyMeterCount + "\r\nEnergyMeterCount     : " + this.Bad_EnergyMeterCount + "\r\nLight_SwitchCount     : " + this.Light_SwitchCount + "\r\n\r\n----------------------------------------\r\n";
                return retStr;
            }

            public static class AIRCON_FUNC_TYPE {
                public static byte FUNC_NONE = 0;
                public static byte FUNC_COOL_ONLY = 1;
                public static byte FUNC_COOL_HEAT = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == FUNC_NONE) {
                        return true;
                    }
                    if (nStatus == FUNC_COOL_ONLY) {
                        return true;
                    }
                    return nStatus == FUNC_COOL_HEAT;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == FUNC_NONE) {
                        return "FUNC_NONE";
                    }
                    if (nStatus == FUNC_COOL_ONLY) {
                        return "FUNC_COOL_ONLY";
                    }
                    if (nStatus == FUNC_COOL_HEAT) {
                        return "FUNC_COOL_HEAT";
                    }
                    return "UnDefined";
                }
            }

            public static class AIRCON_TYPE {
                public static byte TYPE_SAMSUNG_OUTDOOR_UNIT_MASTER = 1;

                public static boolean CheckRange(byte nStatus) {
                    return nStatus == TYPE_SAMSUNG_OUTDOOR_UNIT_MASTER;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == TYPE_SAMSUNG_OUTDOOR_UNIT_MASTER) {
                        return "TYPE_SAMSUNG_OUTDOOR_UNIT_MASTER";
                    }
                    return "UnDefined";
                }
            }

            public static class LIGHT_SET {
                public static byte LIGHT_BUTTON_SYNC = 0;
                public static byte LIGHT_BUTTON_REVERSE = 1;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == LIGHT_BUTTON_SYNC) {
                        return true;
                    }
                    return nStatus == LIGHT_BUTTON_REVERSE;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == LIGHT_BUTTON_SYNC) {
                        return "LIGHT_BUTTON_SYNC";
                    }
                    if (nStatus == LIGHT_BUTTON_REVERSE) {
                        return "LIGHT_BUTTON_REVERSE";
                    }
                    return "UnDefined";
                }
            }
        }
    }

    public static class LIGHT_TYPE {
        public static byte NO_INFO = 0;
        public static byte TYPE_ONOFF = 1;
        public static byte TYPE_DIM = (byte)2;
        public static byte TYPE_DIMnCOLOR = (byte)3;

        public static boolean CheckRange(byte nStatus) {
            if (nStatus == NO_INFO) {
                return true;
            }
            if (nStatus == TYPE_ONOFF) {
                return true;
            }
            if (nStatus == TYPE_DIM) {
                return true;
            }
            return nStatus == TYPE_DIMnCOLOR;
        }

        public static String ToString(byte nStatus) {
            if (nStatus == NO_INFO) {
                return "NO_INFO";
            }
            if (nStatus == TYPE_ONOFF) {
                return "TYPE_ONOFF";
            }
            if (nStatus == TYPE_DIM) {
                return "TYPE_DIM";
            }
            if (nStatus == TYPE_DIMnCOLOR) {
                return "TYPE_DIMnCOLOR";
            }
            return "UnDefined";
        }
    }

    public static class BATCHOFF_STATUS {
        public static byte NO_SET = 0;
        public static byte SET = 1;
        public static byte CLR = (byte)2;
        public static byte CLR_LIGHT_RECOVER = (byte)3;
        public static byte CLR_ALLROOM_ON = (byte)4;

        public static boolean CheckRange(byte nStatus) {
            if (nStatus == NO_SET) {
                return true;
            }
            if (nStatus == SET) {
                return true;
            }
            if (nStatus == CLR) {
                return true;
            }
            if (nStatus == CLR_LIGHT_RECOVER) {
                return true;
            }
            return nStatus == CLR_ALLROOM_ON;
        }

        public static String ToString(byte nStatus) {
            if (nStatus == SET) {
                return "SET";
            }
            if (nStatus == CLR) {
                return "CLR";
            }
            if (nStatus == NO_SET) {
                return "NO_SET";
            }
            if (nStatus == SET) {
                return "SET";
            }
            if (nStatus == CLR) {
                return "CLR";
            }
            if (nStatus == CLR_LIGHT_RECOVER) {
                return "CLR_LIGHT_RECOVER";
            }
            if (nStatus == CLR_ALLROOM_ON) {
                return "CLR_ALLROOM_ON";
            }
            return "UnDefined";
        }
    }

    public static class KNXLIGHT_USAGE_CODE {
        public static byte NO_INFO = 0;
        public static byte ON_OFF_TYPE = 1;
        public static byte DIM_TYPE = (byte)2;
        public static byte DIM_COLOR_TYPE = (byte)3;
        public static byte NOT_DEFINE = (byte)-1;

        public static String ToString(byte code) {
            if (code == NO_INFO) {
                return "NO_INFO";
            }
            if (code == ON_OFF_TYPE) {
                return "ON_OFF_TYPE";
            }
            if (code == DIM_TYPE) {
                return "DIM_TYPE";
            }
            if (code == DIM_COLOR_TYPE) {
                return "DIM_COLOR_TYPE";
            }
            return "UnDefind(" + code + ")";
        }
    }

    public static class VersionClass {
        public byte FwVer_Year = 0;
        public byte FwVer_Month = 0;
        public byte FwVer_Day = 0;
        public byte FwVer_Number = 0;
        public byte ProtocolVer_Main = 0;
        public byte ProtocolVer_Sub = 0;
        public byte VenderCode = 0;
        public byte ModelCode = 0;

        public boolean setData(byte[] inData, int StartIndex) {
            if (inData == null) {
                return false;
            }
            if (inData.length < 8 + StartIndex) {
                return false;
            }
            int index = StartIndex;
            try {
                this.FwVer_Year = inData[index++];
                this.FwVer_Month = inData[index++];
                this.FwVer_Day = inData[index++];
                this.FwVer_Number = inData[index++];
                this.ProtocolVer_Main = inData[index++];
                this.ProtocolVer_Sub = inData[index++];
                this.VenderCode = inData[index++];
                this.ModelCode = inData[index++];
            }
            catch (Exception e) {
                Log.e((String)KNX_DataClasses.TAG, (String)"[VersionClass.setData(byte [], int)] - [Exception Error] ");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public boolean setData(String[] inData, int StartIndex) {
            if (inData == null) {
                return false;
            }
            if (inData.length < 8 + StartIndex) {
                return false;
            }
            int index = StartIndex;
            try {
                this.FwVer_Year = Byte.parseByte(inData[index++]);
                this.FwVer_Month = Byte.parseByte(inData[index++]);
                this.FwVer_Day = Byte.parseByte(inData[index++]);
                this.FwVer_Number = Byte.parseByte(inData[index++]);
                this.ProtocolVer_Main = Byte.parseByte(inData[index++]);
                this.ProtocolVer_Sub = Byte.parseByte(inData[index++]);
                this.VenderCode = Byte.parseByte(inData[index++]);
                this.ModelCode = Byte.parseByte(inData[index++]);
            }
            catch (Exception e) {
                Log.e((String)KNX_DataClasses.TAG, (String)"[VersionClass.setData(String [], int)] - [Exception Error] ");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public String getStringData() {
            String retStr = this.FwVer_Year + ";" + this.FwVer_Month + ";" + this.FwVer_Day + ";" + this.FwVer_Number + ";" + this.ProtocolVer_Main + ";" + this.ProtocolVer_Sub + ";" + this.VenderCode + ";" + this.ModelCode + ";";
            return retStr;
        }

        public String ToString() {
            String retStr = "[Version]\r\nFwVer       : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "(" + this.FwVer_Number + ")\r\nProtocolVer : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\nVender      : " + VENDER.ToString(this.VenderCode) + "\r\nModel       : " + MODEL.ToString(this.ModelCode) + "\r\n";
            return retStr;
        }

        public boolean Equals(VersionClass Version2) {
            if (this.FwVer_Year != Version2.FwVer_Year) {
                return false;
            }
            if (this.FwVer_Month != Version2.FwVer_Month) {
                return false;
            }
            if (this.FwVer_Day != Version2.FwVer_Day) {
                return false;
            }
            if (this.FwVer_Number != Version2.FwVer_Number) {
                return false;
            }
            if (this.ProtocolVer_Main != Version2.ProtocolVer_Main) {
                return false;
            }
            if (this.ProtocolVer_Sub != Version2.ProtocolVer_Sub) {
                return false;
            }
            if (this.VenderCode != Version2.VenderCode) {
                return false;
            }
            return this.ModelCode == Version2.ModelCode;
        }

        public static class MODEL {
            public static byte NO_INFO = 0;
            public static byte DEFAULT_MODEL = 1;

            public static String ToString(byte model) {
                if (model == NO_INFO) {
                    return "NO_INFO";
                }
                if (model == DEFAULT_MODEL) {
                    return "DEFAULT_MODEL";
                }
                return "UnDefind";
            }
        }

        public static class VENDER {
            public static byte ICONTROLS = 1;
            public static byte KAISER_SOLUTION = (byte)2;

            public static String ToString(byte vender) {
                if (vender == ICONTROLS) {
                    return "ICONTROLS";
                }
                if (vender == KAISER_SOLUTION) {
                    return "KAISER_SOLUTION";
                }
                return "UnDefind";
            }
        }
    }
}

