/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class InRoomDetectSensor_API
extends WallPadDevAPI {
    private final String TAG = "InRoomDetectSensor_API";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"InRoomDetectSensor_API", (String)s);
    }

    public InRoomDetectSensor_API(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("InRoomDetectSensor_API create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "INROOM_DETECT_SENSOR";
        this.data = new Data();
        this.GetDeviceCount();
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"InRoomDetectSensor_API", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"InRoomDetectSensor_API", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.DeviceCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.DeviceCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            boolean Install;
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.InRoomDetectSesnor Device2 = new DataClasses.InRoomDetectSesnor();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            if (Install = Boolean.parseBoolean(retData[index++])) {
                Device2.info.FwVer_Year = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Month = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Day = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Number = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
                Device2.info.Vendor = Byte.parseByte(retData[index++]);
                Device2.status.ActMode = Byte.parseByte(retData[index++]);
                Device2.status.DetectStatus = Byte.parseByte(retData[index++]);
                Device2.status.NonDetectOffStart = Boolean.parseBoolean(retData[index++]);
                Device2.status.SensingValue = Byte.parseByte(retData[index++]);
                Device2.status.KeepingTime = Byte.parseByte(retData[index++]);
                Device2.status.DetectCount_Upper = Byte.parseByte(retData[index++]);
                Device2.status.DetectCount_Down = Byte.parseByte(retData[index++]);
                Device2.status.DetectCountSum = Integer.parseInt(retData[index++]);
                Device2.status.Scenario_Mode = Byte.parseByte(retData[index++]);
            } else {
                Device2.info.Install = false;
            }
            this.data.Device[Current] = Device2;
        }
        catch (Exception e) {
            Log.e((String)"InRoomDetectSensor_API", (String)"[Exception Error] ProcResult");
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.DeviceCnt = DeviceCount;
                    this.data.Device = new DataClasses.InRoomDetectSesnor[DeviceCount];
                    return 0;
                }
                return -1;
            }
            catch (Exception e) {
                Log.e((String)"InRoomDetectSensor_API", (String)("[GetDeviceCount] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetEachSensorSetting(byte index, byte ActMode, byte Sensitivity, byte time, boolean initCount) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"InRoomDetectSensor_API", (String)"[SetEachSensorSetting] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(index)) {
            Log.w((String)"InRoomDetectSensor_API", (String)("[SetEachSensorSetting] Param - Index  : Out Of Range (Index:" + index + ")"));
            return -2;
        }
        if (!DataClasses.InRoomDetectSesnor.ACTIONMODE.CheckRange(ActMode)) {
            Log.w((String)"InRoomDetectSensor_API", (String)("[SetEachSensorSetting] param [change_ActMode] Out of Range!!! " + index));
            return -3;
        }
        if (Sensitivity < 1 || Sensitivity > 15) {
            Log.w((String)"InRoomDetectSensor_API", (String)("[SetEachSensorSetting] param [change_Sense] Out of Range!!! " + index));
            return -4;
        }
        if (time < 0 || time > 7) {
            Log.w((String)"InRoomDetectSensor_API", (String)("[SetEachSensorSetting] param [change_keeptime] Out of Range!!! " + index));
            return -5;
        }
        int ByteInit = 0;
        if (initCount) {
            ByteInit = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetEachSensorSetting", index, ActMode, Sensitivity, time, ByteInit);
    }

    public int SetAllSensorMode(byte ActMode) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"InRoomDetectSensor_API", (String)"[SetEachSensorSetting] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!DataClasses.InRoomDetectSesnor.ACTIONMODE.CheckRange(ActMode)) {
            Log.w((String)"InRoomDetectSensor_API", (String)"[SetEachSensorSetting] param [change_ActMode] Out of Range!!! ");
            return -2;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetAllSensorMode", ActMode, 0, 0, 0, 0);
    }

    private boolean DeviceIndexRangeCheck(byte Index) {
        try {
            return Index >= 0 && Index < this.data.DeviceCnt;
        }
        catch (Exception e) {
            Log.e((String)"InRoomDetectSensor_API", (String)"[Exception Error] DeviceIndexRangeCheck");
            e.printStackTrace();
            return false;
        }
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public DataClasses.InRoomDetectSesnor[] Device = null;
    }
}

