/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import android.util.Log;
import com.wgi.libwebeye.MD5;
import com.wgi.libwebeye.SocketOpener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class JWespWebEyeConfigControl
extends Thread {
    private static final String TAG = "Webeye_JWespWebEyeConfigControl";
    static final int TRANSMIT_REQ = 0;
    static final int TRANSMIT_RES = 1;
    static final int TRANSMIT_SVR = 2;
    static final int TRANSMIT_CLI = 3;
    static final int WESP10_HEADER_SIZE = 12;
    static final short WESP10_LOGIN = 1;
    static final short WESP10_DISCONNECT = 2;
    static final short WESP10_KEEPALIVE = 3;
    static final short WESP10_REBOOT = 4;
    static final short WESP10_FACTORY = 5;
    static final short WESP10_SYSINFO_GET = 6;
    static final short WESP10_SYSINFO_SET = 7;
    static final short WESP10_TIME_GET = 8;
    static final short WESP10_TIME_SET = 9;
    static final short WESP10_DSTPARM_GET = 10;
    static final short WESP10_NETINFO_GET = 11;
    static final short WESP10_NETINFO_SET = 12;
    static final short WESP10_NETCONF_GET = 13;
    static final short WESP10_NETCONF_SET = 14;
    static final short WESP10_SECURITY_GET = 15;
    static final short WESP10_SECURITY_SET = 16;
    static final short WESP10_USER_GET = 17;
    static final short WESP10_USER_SET = 18;
    static final short WESP10_CHANNEL_GET = 19;
    static final short WESP10_CHANNEL_SET = 20;
    static final short WESP10_DEVICE_CONF = 21;
    static final short WESP10_PTZ_CONF = 22;
    static final short WESP10_SCHEDTIME_GET = 23;
    static final short WESP10_SCHEDTIME_SET = 24;
    static final short WESP10_FTP_GET = 25;
    static final short WESP10_FTP_SET = 26;
    static final short WESP10_SMTP_GET = 27;
    static final short WESP10_SMTP_SET = 28;
    static final short WESP10_SCHEDMAP_GET = 29;
    static final short WESP10_SCHEDMAP_SET = 30;
    static final short WESP10_SCREEN_SET = 31;
    static final short WESP10_CAPABILITY_GET = 58;
    static final int WESP10_ALL_CONFIG_GET = 57615;
    static final short WESP10_BASEADDR_CONF = 64;
    static final short WESP10_SENSOR_PRESET_GET = 65;
    static final short WESP10_SENSOR_PRESET_SET = 66;
    static final short M_CHANNEL_GET = 768;
    static final short M_CHANNEL_SET = 769;
    static final short M_SYSTEM_LOG_GET = 531;
    static final short WESP10_VIDEO_CTRL_GET = 776;
    static final short WESP10_VIDEO_CTRL_SET = 777;
    static final short WESP10_VIDEO_CTRL_ADJUST = 778;
    static final short WESP10_RESOLUTION_MAP_GET = 779;
    static final short WESP10_MISCELLANEOUS_GET = 515;
    static final short WESP10_OPENSITE = 4099;
    public static final byte ENC_WAVLET = 1;
    public static final byte ENC_JPEG = 3;
    public static final byte ENC_MPEG = 4;
    public static final byte RES_TINY = 0;
    public static final byte RES_QCIF = 1;
    public static final byte RES_CIF = 2;
    public static final byte RES_HALF = 3;
    public static final byte RES_FULL = 4;
    public static final byte RES_M_QCIF = 5;
    public static final byte RES_M_CIF = 6;
    public static final byte RES_M_HALF = 7;
    public static final byte RES_M_D1 = 8;
    public static final byte RES_720P = 9;
    public static final byte RES_SXGA = 10;
    public static final byte VIDEO_CTRL_DC_LEVEL = 1;
    public static final byte VIDEO_CTRL_AGC = 2;
    public static final byte VIDEO_CTRL_BLC = 3;
    public static final byte VIDEO_CTRL_DSS = 4;
    public static final byte VIDEO_CTRL_WB = 5;
    public static final byte VIDEO_CTRL_PUSH_LOCK = 6;
    public static final byte VIDEO_CTRL_SHT = 7;
    public static final byte VIDEO_CTRL_STROBE = 8;
    public static final byte VIDEO_CTRL_AGC_VAL = 9;
    public static final byte VIDEO_CTRL_DSS_VAL = 10;
    public static final byte VIDEO_CTRL_SHT_VAL = 11;
    public static final byte VIDEO_CTRL_DNN = 12;
    public static final byte VIDEO_CTRL_ELC_LEVEL = 13;
    public static final byte VIDEO_CTRL_ADJUSTMENT = 14;
    public static final byte VIDEO_CTRL_LENS = 15;
    static final short WESP10_EVENT_LOGIN = 1;
    static final short WESP10_EVENT_SYSTEM_INFO = 4;
    static final short WESP10_EVENT_CURRENT_STATUS = 5;
    static final short WESP10_EVENT_INFO_GET = 6;
    static final short WESP10_EVENT_RELAY_OUTPUT = 7;
    public static final int ERR_NONE = 0;
    public static final int ERR_WESP_VER = 0x1000000;
    public static final int ERR_INVALID_PKT = 0x2000000;
    public static final int ERR_INVALID_CAT = 0x4000000;
    public static final int ERR_INVALID_CMD = 0x8000000;
    public static final int ERR_INVALID_OPT = 0x10000000;
    static final int ERR_UNAUTH_IP = 1;
    public static final int ERR_UNAUTH_USER = 2;
    public static final int ERR_INVALID_DATA = 3;
    public static final int ERR_VS_SVRFULL = 69635;
    static final int ERR_CONNECTION_FAIL = -2;
    static final int ERR_NETWORK = -3;
    private boolean isTerminate = true;
    public String username;
    public String password;
    public String host;
    public int port;
    Socket socket;
    DataInputStream inStream;
    DataOutputStream outStream;
    boolean isConnected = false;
    public String modelName;
    public byte majorVersion;
    public byte minorVersion;
    public short patchVersion;
    public int timeout = 9999999;
    int bootRemain = -1;
    public int addFunction = 0;
    public int lastErrorCode;
    StatusInfo statusInfo = null;
    SystemInfo sysinfo = null;
    EventSystemInfo eventsysinfo = null;
    TimeInfo timeinfo = null;
    public static final int INTERFACE_ETHERNET = 0;
    public static final int INTERFACE_XDSL = 1;
    public static final int INTERFACE_PSTN = 2;
    NetworkInfo netinfo = null;
    NetworkConfiguration netconf = null;
    SecurityInfo securityInfo = null;
    UserInfo[] userInfo = null;
    SystemLog[] systemLog = null;
    ChannelInfo[] channelInfo = null;
    D1ChannelInfo[] D1ChannelInfo = null;
    ScheduleTimeInfo scheduleTimeInfo = null;
    FtpInfo ftpinfo = null;
    SmtpInfo smtpinfo = null;
    ScheduleMapInfo schedMap = null;
    DeviceInfo deviceInfo = null;
    SerialDeviceInfo serialDeviceInfo = null;
    SensorInfo sensorInfo = null;
    SensorMode sensorMode = null;
    RelayInfo relayInfo = null;
    MiscInfo miscInfo = null;
    ModemDeviceInfo modemDeviceInfo = null;
    KeyboardDeviceInfo keyboardDeviceInfo = null;
    AudioDeviceInfo[] audioDeviceInfo = null;
    public static final byte DEVICE_RELAY = 1;
    public static final byte DEVICE_SENSOR = 2;
    public static final byte DEVICE_SERIAL = 3;
    public static final byte DEVICE_AUDIO = 4;
    public static final byte DEVICE_TEXT = 5;
    public static final byte DEVICE_MODEM = 6;
    public static final byte DEVICE_KEYBOARD = 7;
    public static final byte DEVICE_BUZZER = 8;
    public static final byte DEVICE_READ_DATA = 0;
    public static final byte DEVICE_WRITE_DATA = 1;
    public static final byte DEVICE_GET_CONF = 2;
    public static final byte DEVICE_SET_CONF = 3;
    public static final byte DEVICE_READ_DEVLIST = 4;
    public static final byte IPcam_enable = 1;
    public static final byte NoVideo = 2;
    public static final byte NightFilterOnOff = 3;
    public static final byte EncodingPolicy = 4;
    PtzInfo[] ptzinfo = null;
    BaseAddrInfo baseAddrInfo = null;
    ResolutionMap res_map = null;
    VideoCtrl video_ctrl = null;

    public JWespWebEyeConfigControl(String _username, String _password, String _host, int _port) {
        this.username = _username;
        this.password = _password;
        this.host = _host;
        this.port = _port;
    }

    public int getLastErrorCode() {
        return this.lastErrorCode;
    }

    public boolean connect(String _host, int _port, int _timeout) {
        this.socket = SocketOpener.openSocket(_host, _port, _timeout);
        if (this.socket == null) {
            return false;
        }
        this.isConnected = true;
        try {
            this.socket.setReceiveBufferSize(8192);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.setSoTimeout(180000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.inStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.outStream = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean login() {
        JWESP10Header resHeader;
        block15: {
            block14: {
                block13: {
                    block12: {
                        if (!this.connect(this.host, this.port, 30000)) {
                            this.lastErrorCode = -2;
                            return false;
                        }
                        resHeader = new JWESP10Header();
                        byte[] header = new byte[12];
                        this.encodeHeader(header, 0, (short)1, 0);
                        try {
                            this.outStream.write(header, 0, header.length);
                            this.outStream.flush();
                            if (this.readWesp10Header(resHeader)) break block12;
                            this.lastErrorCode = -2;
                            return false;
                        }
                        catch (IOException e) {
                            this.lastErrorCode = -2;
                            return false;
                        }
                    }
                    if (resHeader.errorCode == 0) break block13;
                    this.lastErrorCode = resHeader.errorCode;
                    return false;
                }
                byte authMethod = this.inStream.readByte();
                byte securityLevel = this.inStream.readByte();
                int nonceLength = this.inStream.readInt();
                byte[] nonce = new byte[nonceLength];
                this.inStream.read(nonce, 0, nonce.length);
                String nonceStr = new String(nonce);
                this.sendAuthCode(nonceStr);
                if (this.readWesp10Header(resHeader)) break block14;
                this.lastErrorCode = -2;
                return false;
            }
            if (resHeader.errorCode == 0) break block15;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        if (resHeader.transmitType == 1) {
            this.majorVersion = this.inStream.readByte();
            this.minorVersion = this.inStream.readByte();
            this.patchVersion = this.inStream.readShort();
            this.timeout = this.inStream.readInt();
            this.inStream.readByte();
            this.inStream.readShort();
            if (resHeader.bodySize > 11) {
                this.inStream.readShort();
                this.inStream.readByte();
                if (resHeader.bodySize > 14) {
                    this.addFunction = this.inStream.readInt();
                    if (resHeader.bodySize > 18) {
                        int size = resHeader.bodySize - 18;
                        byte[] dummy = new byte[size];
                        this.inStream.read(dummy, 0, size);
                    }
                }
            }
        }
        if (this.isTerminate) {
            this.isTerminate = false;
            this.start();
        }
        this.lastErrorCode = 0;
        return true;
    }

    public boolean loginevent(int win_dvr, String serial) {
        JWESP10Header resHeader;
        block18: {
            block17: {
                int nonceLength;
                block16: {
                    block15: {
                        block14: {
                            if (!this.connect(this.host, this.port, 30000)) {
                                this.lastErrorCode = -2;
                                return false;
                            }
                            resHeader = new JWESP10Header();
                            byte[] header = new byte[12];
                            this.encodeEventHeader(header, 0, (short)1, 0);
                            try {
                                this.outStream.write(header, 0, header.length);
                                this.outStream.flush();
                                if (this.readWesp10Header(resHeader)) break block14;
                                this.lastErrorCode = -2;
                                return false;
                            }
                            catch (Exception e) {
                                this.lastErrorCode = -2;
                                return false;
                            }
                        }
                        if (resHeader.errorCode == 0) break block15;
                        this.lastErrorCode = resHeader.errorCode;
                        return false;
                    }
                    byte authMethod = this.inStream.readByte();
                    byte securityLevel = this.inStream.readByte();
                    nonceLength = this.inStream.readInt();
                    if (nonceLength <= 48) break block16;
                    this.lastErrorCode = -3;
                    System.out.println("nonceLength = " + nonceLength);
                    return false;
                }
                byte[] nonce = new byte[nonceLength];
                this.inStream.read(nonce, 0, nonce.length);
                String nonceStr = new String(nonce);
                this.sendEventAuthCode(nonceStr);
                if (this.readWesp10Header(resHeader)) break block17;
                this.lastErrorCode = -2;
                return false;
            }
            if (resHeader.errorCode == 0) break block18;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        if (resHeader.transmitType == 1) {
            this.majorVersion = this.inStream.readByte();
            this.minorVersion = this.inStream.readByte();
            this.patchVersion = this.inStream.readShort();
            this.timeout = this.inStream.readInt();
            this.inStream.readByte();
            this.inStream.readShort();
            if (resHeader.bodySize > 11) {
                this.inStream.readShort();
                this.inStream.readByte();
                if (resHeader.bodySize > 14) {
                    this.addFunction = this.inStream.readInt();
                    if (resHeader.bodySize > 18) {
                        int size = resHeader.bodySize - 18;
                        byte[] dummy = new byte[size];
                        this.inStream.read(dummy, 0, size);
                    }
                }
            }
        }
        if (win_dvr == 2 && !this.openSite(serial)) {
            System.out.println("openSite = " + serial);
            return false;
        }
        if (this.isTerminate) {
            this.isTerminate = false;
            this.start();
        }
        this.lastErrorCode = 0;
        return true;
    }

    public boolean openSite(String serial) {
        JWESP10Header resHeader;
        block5: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            byte[] header = new byte[12];
            this.encodeEventHeader(header, 0, (short)4099, 24);
            byte[] serial_buf = new byte[24];
            System.arraycopy(serial.getBytes(), 0, serial_buf, 0, serial.length());
            try {
                this.outStream.write(header, 0, header.length);
                this.outStream.write(serial_buf);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -2;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -2;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        if (this.isTerminate) {
            this.isTerminate = false;
            this.start();
        }
        this.lastErrorCode = 0;
        return true;
    }

    public boolean reconnect(String _host) {
        this.host = _host;
        this.disconnect();
        return this.login();
    }

    private int sendAuthCode(String nonce) {
        if (!this.isConnected) {
            return -1;
        }
        byte[] header = new byte[12];
        byte[] digest = new MD5().toDigest(this.password.getBytes());
        String digestPasswd = new String(Base64.encodeBase64((byte[])digest));
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(nonce);
        strBuffer.append(":");
        strBuffer.append(digestPasswd);
        digest = new MD5().toDigest(strBuffer.toString().getBytes());
        String authCode = new String(Base64.encodeBase64((byte[])digest));
        byte[] byteID = this.username.getBytes();
        byte[] byteAuthCode = authCode.getBytes();
        int bodySize = byteID.length + byteAuthCode.length + 8;
        this.encodeHeader(header, 3, (short)1, bodySize);
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.writeInt(byteID.length);
            this.outStream.write(byteID, 0, byteID.length);
            this.outStream.writeInt(byteAuthCode.length);
            this.outStream.write(byteAuthCode, 0, byteAuthCode.length);
            this.outStream.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    private int sendEventAuthCode(String nonce) {
        if (!this.isConnected) {
            return -1;
        }
        byte[] header = new byte[12];
        byte[] digest = new MD5().toDigest(this.password.getBytes());
        String digestPasswd = new String(Base64.encodeBase64((byte[])digest));
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(nonce);
        strBuffer.append(":");
        strBuffer.append(digestPasswd);
        digest = new MD5().toDigest(strBuffer.toString().getBytes());
        String authCode = new String(Base64.encodeBase64((byte[])digest));
        byte[] byteID = this.username.getBytes();
        byte[] byteAuthCode = authCode.getBytes();
        int bodySize = byteID.length + byteAuthCode.length + 8;
        this.encodeEventHeader(header, 3, (short)1, bodySize);
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.writeInt(byteID.length);
            this.outStream.write(byteID, 0, byteID.length);
            this.outStream.writeInt(byteAuthCode.length);
            this.outStream.write(byteAuthCode, 0, byteAuthCode.length);
            this.outStream.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    private int getStringLength(byte[] _byte, int length) {
        int i = 0;
        while (i < length) {
            if (_byte[i] == 0) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getRemainBootingTime() {
        if (this.bootRemain < 0) {
            return 0;
        }
        return this.bootRemain;
    }

    public synchronized boolean reboot() {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)4, 0);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.bootRemain = this.inStream.readShort();
        return true;
    }

    public synchronized boolean setToFactoryDefault() {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)5, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized StatusInfo getEventCurrentStatus() {
        JWESP10Header resHeader;
        block8: {
            block7: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                Object tmp = null;
                this.encodeEventHeader(header, 0, (short)5, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block7;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block8;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            Log.v((String)TAG, (String)("resHeader.bodySize = " + resHeader.bodySize));
            this.statusInfo = new StatusInfo();
            this.statusInfo.cameraInfo = new CameraTimeInfo();
            this.statusInfo.cameraInfo.secTime = this.inStream.readInt();
            this.statusInfo.cameraInfo.msecTime = this.inStream.readShort();
            this.statusInfo.cameraInfo.dst = this.inStream.readByte();
            this.statusInfo.cameraInfo.timeZone = this.inStream.readShort();
            this.statusInfo.eventCount = this.inStream.readInt();
            Log.v((String)TAG, (String)("statusInfo.eventCount = " + this.statusInfo.eventCount));
            int nEventCount = (int)this.statusInfo.eventCount;
            int i = 0;
            while (i < nEventCount) {
                EventInfo info = new EventInfo();
                info.category = this.inStream.readByte();
                info.code = this.inStream.readInt();
                info.payloadCount = this.inStream.readByte();
                int j = 0;
                while (j < info.payloadCount) {
                    PayloadInfo payloadinfo = new PayloadInfo();
                    payloadinfo.payloadType = this.inStream.readByte();
                    payloadinfo.payloadLength = this.inStream.readShort();
                    if (payloadinfo.payloadLength > 0) {
                        payloadinfo.payload = new byte[payloadinfo.payloadLength];
                        this.inStream.read(payloadinfo.payload, 0, payloadinfo.payloadLength);
                    }
                    info.payloadInfo.add(payloadinfo);
                    ++j;
                }
                this.statusInfo.eventInfo.add(info);
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.statusInfo;
    }

    public StatusInfo getEventInfo() {
        block10: {
            JWESP10Header resHeader;
            block9: {
                block8: {
                    resHeader = new JWESP10Header();
                    if (this.readWesp10Header(resHeader)) break block8;
                    this.lastErrorCode = -3;
                    return null;
                }
                if (resHeader.errorCode == 0) break block9;
                this.lastErrorCode = resHeader.errorCode;
                return null;
            }
            if (resHeader.commandId == 6) break block10;
            return null;
        }
        try {
            this.statusInfo = new StatusInfo();
            this.statusInfo.cameraInfo = new CameraTimeInfo();
            this.statusInfo.cameraInfo.secTime = this.inStream.readInt();
            this.statusInfo.cameraInfo.msecTime = this.inStream.readShort();
            this.statusInfo.cameraInfo.dst = this.inStream.readByte();
            this.statusInfo.cameraInfo.timeZone = this.inStream.readShort();
            this.statusInfo.eventCount = this.inStream.readInt();
            int nEventCount = (int)this.statusInfo.eventCount;
            int i = 0;
            while (i < nEventCount) {
                EventInfo info = new EventInfo();
                info.category = this.inStream.readByte();
                info.code = this.inStream.readInt();
                info.payloadCount = this.inStream.readByte();
                int j = 0;
                while (j < info.payloadCount) {
                    PayloadInfo payloadinfo = new PayloadInfo();
                    payloadinfo.payloadType = this.inStream.readByte();
                    payloadinfo.payloadLength = this.inStream.readShort();
                    if (payloadinfo.payloadLength > 0) {
                        payloadinfo.payload = new byte[payloadinfo.payloadLength];
                        this.inStream.read(payloadinfo.payload, 0, payloadinfo.payloadLength);
                    }
                    info.payloadInfo.add(payloadinfo);
                    ++j;
                }
                this.statusInfo.eventInfo.add(info);
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.statusInfo;
    }

    public synchronized boolean setEventRelayOutput(byte relayNum, byte action) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                Object tmp = null;
                this.encodeEventHeader(header, 0, (short)7, 2);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(relayNum);
                this.outStream.writeByte(action);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            System.out.println("WESP ERROR " + this.lastErrorCode);
            return false;
        }
        return true;
    }

    public synchronized EventSystemInfo getEventSystemInfo() {
        byte[] tmp;
        block7: {
            JWESP10Header resHeader;
            block6: {
                block5: {
                    this.flushInStream();
                    resHeader = new JWESP10Header();
                    try {
                        byte[] header = new byte[12];
                        tmp = null;
                        this.encodeEventHeader(header, 0, (short)4, 0);
                        this.outStream.write(header, 0, header.length);
                        this.outStream.flush();
                        if (this.readWesp10Header(resHeader)) break block5;
                        this.lastErrorCode = -3;
                        return null;
                    }
                    catch (IOException e) {
                        this.lastErrorCode = -3;
                        return null;
                    }
                }
                if (resHeader.errorCode == 0) break block6;
                this.lastErrorCode = resHeader.errorCode;
                return null;
            }
            if (resHeader.bodySize >= 148) break block7;
            this.lastErrorCode = 0x2000000;
            return null;
        }
        this.eventsysinfo = new EventSystemInfo();
        tmp = new byte[24];
        this.inStream.read(tmp, 0, 24);
        this.eventsysinfo.modelName = new String(tmp, 0, this.getStringLength(tmp, 24));
        tmp = new byte[16];
        this.inStream.read(tmp, 0, 16);
        this.eventsysinfo.hwVersion = new String(tmp, 0, this.getStringLength(tmp, 16));
        tmp = new byte[16];
        this.inStream.read(tmp, 0, 16);
        this.eventsysinfo.swVersion = new String(tmp, 0, this.getStringLength(tmp, 16));
        tmp = new byte[24];
        this.inStream.read(tmp, 0, 24);
        this.eventsysinfo.serialNumber = new String(tmp, 0, this.getStringLength(tmp, 24));
        tmp = new byte[18];
        this.inStream.read(tmp, 0, 18);
        this.eventsysinfo.mac = new String(tmp, 0, this.getStringLength(tmp, 18));
        this.eventsysinfo.hddCount = this.inStream.readByte();
        this.eventsysinfo.serialCount = this.inStream.readByte();
        this.eventsysinfo.channelCount = this.inStream.readShort();
        this.eventsysinfo.channelReserved = this.inStream.readShort();
        this.eventsysinfo.channelEnable = this.inStream.readInt();
        this.eventsysinfo.sensorCount = this.inStream.readShort();
        this.eventsysinfo.sensorReserved = this.inStream.readShort();
        this.eventsysinfo.sensorEnable = this.inStream.readInt();
        this.eventsysinfo.relayCount = this.inStream.readShort();
        this.eventsysinfo.relayReserved = this.inStream.readShort();
        this.eventsysinfo.relayEnable = this.inStream.readInt();
        this.eventsysinfo.audioInCount = this.inStream.readShort();
        this.eventsysinfo.audioInReserved = this.inStream.readShort();
        this.eventsysinfo.audioInEnable = this.inStream.readInt();
        this.eventsysinfo.audioOutCount = this.inStream.readShort();
        this.eventsysinfo.audioOutReserved = this.inStream.readShort();
        this.eventsysinfo.audioOutEnable = this.inStream.readInt();
        this.eventsysinfo.textCount = this.inStream.readShort();
        this.eventsysinfo.textReserved = this.inStream.readShort();
        this.eventsysinfo.textEnable = this.inStream.readInt();
        return this.eventsysinfo;
    }

    public synchronized SystemInfo getSystemInfo() {
        byte[] tmp;
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    tmp = null;
                    this.encodeHeader(header, 0, (short)6, 0);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        this.sysinfo = new SystemInfo();
        this.sysinfo.magicNumber = this.inStream.readLong();
        tmp = new byte[24];
        this.inStream.read(tmp, 0, 24);
        this.sysinfo.modelName = new String(tmp, 0, this.getStringLength(tmp, 24));
        this.modelName = new String(tmp, 0, this.getStringLength(tmp, 24));
        tmp = new byte[24];
        this.inStream.read(tmp, 0, 24);
        this.sysinfo.userDefinedName = new String(tmp, 0, this.getStringLength(tmp, 24));
        tmp = new byte[16];
        this.inStream.read(tmp, 0, 16);
        this.sysinfo.hwVersion = new String(tmp, 0, this.getStringLength(tmp, 16));
        tmp = new byte[16];
        this.inStream.read(tmp, 0, 16);
        this.sysinfo.swVersion = new String(tmp, 0, this.getStringLength(tmp, 16));
        tmp = new byte[24];
        this.inStream.read(tmp, 0, 24);
        this.sysinfo.serial = new String(tmp, 0, this.getStringLength(tmp, 24));
        this.sysinfo.ip = this.inStream.readInt();
        tmp = new byte[48];
        this.inStream.read(tmp, 0, 48);
        this.sysinfo.description = new String(tmp, 0, this.getStringLength(tmp, 48));
        tmp = new byte[48];
        this.inStream.read(tmp, 0, 48);
        this.sysinfo.location = new String(tmp, 0, this.getStringLength(tmp, 48));
        this.sysinfo.mac = new byte[6];
        this.inStream.read(this.sysinfo.mac, 0, 6);
        return this.sysinfo;
    }

    public synchronized boolean setSystemInfo(SystemInfo info) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] msg = new byte[132];
                this.encodeHeader(msg, 0, (short)7, 120);
                byte[] src = info.description.getBytes();
                System.arraycopy(src, 0, msg, 12, src.length);
                src = info.location.getBytes();
                System.arraycopy(src, 0, msg, 60, src.length);
                src = info.userDefinedName.getBytes();
                System.arraycopy(src, 0, msg, 108, src.length);
                this.outStream.write(msg, 0, msg.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized DstInfo getDstParm() {
        DstInfo dstInfo;
        block8: {
            JWESP10Header resHeader;
            block7: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                dstInfo = new DstInfo();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)10, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block7;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block8;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            dstInfo.dstParm = new DstParm[this.inStream.readInt()];
            byte[] bytes = null;
            int i = 0;
            while (i < dstInfo.dstParm.length) {
                bytes = new byte[64];
                int nRemainRead = 64;
                while (nRemainRead != 0) {
                    int nRead = this.inStream.read(bytes, 0, nRemainRead);
                    if (nRead <= 0) break;
                    nRemainRead -= nRead;
                }
                dstInfo.dstParm[i] = new DstParm();
                dstInfo.dstParm[i].dstName = new String(bytes, 0, this.getStringLength(bytes, 64));
                dstInfo.dstParm[i].smon = this.inStream.readByte();
                dstInfo.dstParm[i].smday = this.inStream.readByte();
                dstInfo.dstParm[i].sweek = this.inStream.readByte();
                dstInfo.dstParm[i].swday = this.inStream.readByte();
                dstInfo.dstParm[i].shour = this.inStream.readByte();
                dstInfo.dstParm[i].smin = this.inStream.readByte();
                dstInfo.dstParm[i].emon = this.inStream.readByte();
                dstInfo.dstParm[i].esmday = this.inStream.readByte();
                dstInfo.dstParm[i].eweek = this.inStream.readByte();
                dstInfo.dstParm[i].eday = this.inStream.readByte();
                dstInfo.dstParm[i].ehour = this.inStream.readByte();
                dstInfo.dstParm[i].emin = this.inStream.readByte();
                dstInfo.dstParm[i].gmt = this.inStream.readByte();
                dstInfo.dstParm[i].shift = this.inStream.readShort();
                ++i;
            }
            dstInfo.tzCount = this.inStream.readInt();
            dstInfo.dstTable = new byte[80];
            i = 0;
            while (i < 80) {
                dstInfo.dstTable[i] = this.inStream.readByte();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return dstInfo;
    }

    public synchronized TimeInfo getTimeInfo() {
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)8, 0);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block5;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        this.timeinfo = new TimeInfo();
        this.timeinfo.time = (long)this.inStream.readInt() * 1000L;
        this.timeinfo.timeIndex = this.inStream.readShort();
        this.timeinfo.timeZone = this.inStream.readShort();
        this.timeinfo.isDstEnable = this.inStream.readByte() != 0;
        this.timeinfo.isDstNow = this.inStream.readByte() != 0;
        this.timeinfo.byNTPMode = this.inStream.readByte();
        this.timeinfo.byNTPIPUse = this.inStream.readByte();
        this.timeinfo.nNTPLocalIP = this.inStream.readInt();
        this.timeinfo.nNTPInterval = this.inStream.readInt();
        this.timeinfo.dstInfo = new DstInfo();
        this.timeinfo.dstInfo = this.getDstParm();
        if (this.timeinfo.dstInfo == null) {
            return null;
        }
        return this.timeinfo;
    }

    public synchronized boolean setTimeInfo(TimeInfo info) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)9, 20);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeInt((int)(info.time / 1000L));
                this.outStream.writeShort(info.timeIndex);
                this.outStream.writeShort(info.timeZone);
                this.outStream.writeByte(info.isDstEnable ? 1 : 0);
                this.outStream.writeByte(0);
                this.outStream.writeByte(info.byNTPMode);
                this.outStream.writeByte(info.byNTPIPUse);
                this.outStream.writeInt(info.nNTPLocalIP);
                this.outStream.writeInt(info.nNTPInterval);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized NetworkInfo getNetworkInfo() {
        byte[] tmpBytes;
        block7: {
            JWESP10Header resHeader;
            block6: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                tmpBytes = new byte[64];
                this.encodeHeader(header, 0, (short)11, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block6;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block7;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            this.netinfo = new NetworkInfo();
            this.netinfo.interfaceType = this.inStream.readByte();
            this.netinfo.isDHCPEnable = this.inStream.readByte() != 0;
            this.inStream.read(tmpBytes, 0, 2);
            this.netinfo.ip = this.inStream.readInt();
            this.netinfo.netmask = this.inStream.readInt();
            this.netinfo.broadcast = this.inStream.readInt();
            this.netinfo.gateway = this.inStream.readInt();
            this.netinfo.dns1 = this.inStream.readInt();
            this.netinfo.dns2 = this.inStream.readInt();
            this.netinfo.dns3 = this.inStream.readInt();
            this.inStream.read(tmpBytes, 0, 24);
            this.netinfo.domainName = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 24));
            this.netinfo.wrsRegistrationInterval = this.inStream.readShort();
            this.netinfo.isWrsPublic = this.inStream.readByte() != 0;
            this.netinfo.wrsStatus = this.inStream.readByte();
            this.inStream.read(tmpBytes, 0, 24);
            this.netinfo.wrsGroupName = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 24));
            this.inStream.read(tmpBytes, 0, 64);
            this.netinfo.wrsServer = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 64));
            this.inStream.read(tmpBytes, 0, 16);
            this.netinfo.wrsToken = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 16));
            this.inStream.read(tmpBytes, 0, 24);
            this.netinfo.networkId = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 24));
            this.inStream.read(tmpBytes, 0, 16);
            this.netinfo.networkPassword = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 16));
            this.inStream.read(tmpBytes, 0, 24);
            this.netinfo.xDSLAssignedIP = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 24));
            this.netinfo.xDSLStatus = this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.read(tmpBytes, 0, 32);
            this.netinfo.PSTNPhoneNumber = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 32));
            this.netinfo.PSTNTimeout = this.inStream.readInt();
            this.netinfo.PSTNISP = this.inStream.readByte();
            this.netinfo.PSTNScriptUse = this.inStream.readByte();
            this.inStream.read(tmpBytes, 0, 2);
            this.netinfo.PSTNScriptItem = new byte[10];
            int i = 0;
            while (i < 10) {
                this.netinfo.PSTNScriptItem[i] = this.inStream.readByte();
                ++i;
            }
            this.inStream.read(tmpBytes, 0, 2);
            this.netinfo.PSTNScriptParm = new String[10];
            i = 0;
            while (i < 10) {
                this.inStream.read(tmpBytes, 0, 40);
                this.netinfo.PSTNScriptParm[i] = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 40));
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.netinfo;
    }

    public synchronized boolean setNetworkInfo(NetworkInfo info) {
        JWESP10Header resHeader;
        block6: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                byte[] tmpBytes = null;
                this.encodeHeader(header, 0, (short)12, 684);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(this.netinfo.interfaceType);
                this.outStream.writeByte(this.netinfo.isDHCPEnable ? 1 : 0);
                this.outStream.writeShort(0);
                this.outStream.writeInt(this.netinfo.ip);
                this.outStream.writeInt(this.netinfo.netmask);
                this.outStream.writeInt(this.netinfo.broadcast);
                this.outStream.writeInt(this.netinfo.gateway);
                this.outStream.writeInt(this.netinfo.dns1);
                this.outStream.writeInt(this.netinfo.dns2);
                this.outStream.writeInt(this.netinfo.dns3);
                byte[] src = null;
                tmpBytes = new byte[24];
                src = this.netinfo.domainName.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                this.outStream.writeShort(this.netinfo.wrsRegistrationInterval);
                this.outStream.writeByte(this.netinfo.isWrsPublic ? 1 : 0);
                this.outStream.writeByte(this.netinfo.wrsStatus);
                tmpBytes = new byte[24];
                src = this.netinfo.wrsGroupName.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[64];
                src = this.netinfo.wrsServer.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[16];
                src = this.netinfo.wrsToken.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[24];
                src = this.netinfo.networkId.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[16];
                src = this.netinfo.networkPassword.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[24];
                src = this.netinfo.xDSLAssignedIP.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                this.outStream.writeByte(this.netinfo.xDSLStatus);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                tmpBytes = new byte[32];
                src = this.netinfo.PSTNPhoneNumber.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                this.outStream.writeInt(this.netinfo.PSTNTimeout);
                this.outStream.writeByte(this.netinfo.PSTNISP);
                this.outStream.writeByte(this.netinfo.PSTNScriptUse);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                int i = 0;
                while (i < 10) {
                    this.outStream.writeByte(this.netinfo.PSTNScriptItem[i]);
                    ++i;
                }
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                i = 0;
                while (i < 10) {
                    tmpBytes = new byte[40];
                    src = this.netinfo.PSTNScriptParm[i].getBytes();
                    System.arraycopy(src, 0, tmpBytes, 0, src.length);
                    this.outStream.write(tmpBytes, 0, tmpBytes.length);
                    ++i;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block6;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized NetworkConfiguration getNetworkConfiuration() {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)13, 0);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            return null;
        }
        this.netconf = new NetworkConfiguration();
        this.netconf.portSocketServer = this.inStream.readShort();
        this.inStream.readShort();
        this.netconf.keepAlive = this.inStream.readInt();
        return this.netconf;
    }

    public synchronized boolean setNetworkConfiguration(NetworkConfiguration info) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)14, 8);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeShort(this.netconf.portSocketServer);
                this.outStream.writeShort(0);
                this.outStream.writeInt(this.netconf.keepAlive);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized SecurityInfo getSecurityInfo() {
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)15, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            this.securityInfo = new SecurityInfo();
            byte[] bytes = new byte[12];
            this.inStream.read(bytes, 0, 12);
            this.securityInfo.encryptKey = new String(bytes, 0, this.getStringLength(bytes, 12));
            this.securityInfo.isEncryptEnable = this.inStream.readByte() != 0;
            this.securityInfo.securityLevel = this.inStream.readByte();
            this.inStream.readByte();
            byte attribute = this.inStream.readByte();
            this.securityInfo.isFilterEnable = (attribute & 0x80) != 0;
            this.securityInfo.isAllowMode = (attribute & 1) != 0;
            this.securityInfo.filter = new IPFilter[10];
            int i = 0;
            while (i < this.securityInfo.filter.length) {
                this.securityInfo.filter[i] = new IPFilter();
                this.securityInfo.filter[i].isEnable = this.inStream.readInt() != 0;
                this.securityInfo.filter[i].from = this.inStream.readInt();
                this.securityInfo.filter[i].to = this.inStream.readInt();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.securityInfo;
    }

    public synchronized boolean setSecurityInfo(SecurityInfo info) {
        JWESP10Header resHeader;
        block7: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)16, 136);
                this.outStream.write(header, 0, header.length);
                byte[] bytes = new byte[12];
                byte[] src = info.encryptKey.getBytes();
                System.arraycopy(src, 0, bytes, 0, src.length);
                this.outStream.write(bytes, 0, bytes.length);
                this.outStream.writeByte(info.isEncryptEnable ? 1 : 0);
                this.outStream.writeByte(info.securityLevel);
                this.outStream.writeByte(0);
                int attribute = 0;
                if (this.securityInfo.isFilterEnable) {
                    attribute = (byte)(attribute | 0x80);
                }
                if (this.securityInfo.isAllowMode) {
                    attribute = (byte)(attribute | 1);
                }
                this.outStream.writeByte(attribute);
                int i = 0;
                while (i < info.filter.length) {
                    this.outStream.writeInt(info.filter[i].isEnable ? 1 : 0);
                    this.outStream.writeInt(info.filter[i].from);
                    this.outStream.writeInt(info.filter[i].to);
                    ++i;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block7;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized UserInfo[] getUserInfo() {
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)17, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            int totalUserCount = this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            this.userInfo = new UserInfo[totalUserCount];
            byte[] tmpBytes = new byte[32];
            int i = 0;
            while (i < totalUserCount) {
                this.inStream.read(tmpBytes, 0, 32);
                int strlen = this.getStringLength(tmpBytes, 32);
                this.userInfo[i] = new UserInfo();
                this.userInfo[i].username = new String(tmpBytes, 0, strlen);
                this.inStream.read(tmpBytes, 0, 32);
                strlen = this.getStringLength(tmpBytes, 32);
                this.userInfo[i].password = new String(tmpBytes, 0, strlen);
                this.userInfo[i].userAttribute = this.inStream.readInt();
                this.userInfo[i].userChAttribute = this.inStream.readInt();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.userInfo;
    }

    public synchronized boolean setUserInfo(UserInfo[] info) {
        JWESP10Header resHeader;
        block5: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)18, 4 + 72 * info.length);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte((byte)info.length);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                byte[] bytes = null;
                byte[] src = null;
                int i = 0;
                while (i < info.length) {
                    bytes = new byte[32];
                    src = info[i].username.getBytes();
                    System.arraycopy(src, 0, bytes, 0, src.length);
                    this.outStream.write(bytes, 0, bytes.length);
                    bytes = new byte[32];
                    src = info[i].password.getBytes();
                    System.arraycopy(src, 0, bytes, 0, src.length);
                    this.outStream.write(bytes, 0, bytes.length);
                    this.outStream.writeInt(info[i].userAttribute);
                    this.outStream.writeInt(info[i].userChAttribute);
                    ++i;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized SystemLog[] getSystemLog() {
        block7: {
            JWESP10Header resHeader;
            block6: {
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)531, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block6;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block7;
            this.printWespHeader(resHeader);
            this.lastErrorCode = resHeader.errorCode;
            System.out.println("this.lastErrorCode : " + this.lastErrorCode);
            return null;
        }
        try {
            int count = this.inStream.readInt();
            this.systemLog = new SystemLog[count];
            int i = 0;
            while (i < count) {
                this.systemLog[i] = new SystemLog();
                this.systemLog[i].tm = this.inStream.readInt();
                this.systemLog[i].ms = this.inStream.readShort();
                this.systemLog[i].pay_load_size = this.inStream.readShort();
                this.systemLog[i].reserved = this.inStream.readByte();
                this.systemLog[i].category = this.inStream.readByte();
                this.systemLog[i].channel = this.inStream.readShort();
                this.systemLog[i].code = this.inStream.readInt();
                if (this.systemLog[i].pay_load_size > 0) {
                    byte[] pay_load = new byte[this.systemLog[i].pay_load_size];
                    this.inStream.read(pay_load);
                }
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.systemLog;
    }

    public synchronized boolean setScreen(byte channel, byte[] calibrate) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)31, 8);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(channel);
                this.outStream.write(calibrate, 0, calibrate.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized String getCapability() {
        JWESP10Header resHeader;
        String strCapability;
        block4: {
            strCapability = "";
            this.flushInStream();
            resHeader = new JWESP10Header();
            byte[] header = new byte[12];
            this.encodeHeader(header, 0, (short)58, 0);
            this.outStream.write(header, 0, header.length);
            this.outStream.flush();
            if (this.readWesp10Header(resHeader)) break block4;
            this.lastErrorCode = -3;
            return "";
        }
        try {
            Log.d((String)"LibWebEye", (String)("resHeader.bodySize = " + resHeader.bodySize));
            int nReceive = 0;
            while (nReceive < resHeader.bodySize) {
                int nAvailable = this.inStream.available();
                byte[] body = new byte[nAvailable];
                this.inStream.readFully(body);
                strCapability = String.valueOf(strCapability) + new String(body);
                nReceive += nAvailable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strCapability;
    }

    public synchronized String getAllConfig() {
        JWESP10Header resHeader;
        String strAllConfig;
        block8: {
            strAllConfig = "";
            this.flushInStream();
            resHeader = new JWESP10Header();
            byte[] header = new byte[12];
            this.encodeHeader2(header, 0, 57615, 0);
            this.outStream.write(header, 0, header.length);
            this.outStream.flush();
            if (this.readWesp10Header(resHeader)) break block8;
            this.lastErrorCode = -3;
            return "";
        }
        try {
            Log.d((String)"LibWebEye", (String)("resHeader.bodySize = " + resHeader.bodySize));
            int nReceive = 0;
            while (nReceive < resHeader.bodySize) {
                int nAvailable = this.inStream.available();
                if (nAvailable <= 0) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                byte[] body = new byte[nAvailable];
                this.inStream.readFully(body);
                String strReceive = new String(body, "utf-8");
                int nStartIndex = strReceive.indexOf("<?xml");
                if (nStartIndex != -1) {
                    strReceive = strReceive.substring(nStartIndex, strReceive.length());
                }
                strAllConfig = String.valueOf(strAllConfig) + strReceive;
                nReceive += nAvailable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strAllConfig;
    }

    public synchronized ChannelInfo[] getChannelInfo() {
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)19, 1);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(-1);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            int count = this.inStream.readByte();
            this.channelInfo = new ChannelInfo[count];
            this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            byte[] tmpBytes = new byte[24];
            byte attribute = 0;
            int i = 0;
            while (i < count) {
                this.inStream.read(tmpBytes, 0, 24);
                this.channelInfo[i] = new ChannelInfo();
                this.channelInfo[i].name = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 24));
                this.channelInfo[i].number = this.inStream.readByte();
                attribute = this.inStream.readByte();
                this.channelInfo[i].isEnable = (attribute & 0xFFFFFF80) != 0;
                this.channelInfo[i].isNTSC = (attribute & 8) == 0;
                this.channelInfo[i].isNTSCOut = (attribute & 0x40) == 0;
                this.channelInfo[i].isBWCamera = (attribute & 1) != 0;
                this.channelInfo[i].isInternal = (attribute & 0x10) != 0;
                this.channelInfo[i].isInternalExist = (attribute & 0x20) != 0;
                this.channelInfo[i].rotate = (byte)(attribute >> 1 & 3 & 0xFFFFFFFF);
                this.channelInfo[i].quality = this.inStream.readByte();
                this.inStream.readByte();
                this.channelInfo[i].calibrate = new byte[7];
                this.inStream.read(this.channelInfo[i].calibrate, 0, 7);
                this.channelInfo[i].md_sensitivity = this.inStream.readByte();
                attribute = this.inStream.readByte();
                this.channelInfo[i].hasFlikerless = (attribute & 0xFFFFFF80) != 0;
                this.channelInfo[i].isEnableFlikerless = (attribute & 1) != 0;
                attribute = this.inStream.readByte();
                this.channelInfo[i].hasIris = (attribute & 0xFFFFFF80) != 0;
                this.channelInfo[i].isEnableIris = (attribute & 1) != 0;
                this.channelInfo[i].isQboxEnable = this.inStream.readByte() != 0;
                this.channelInfo[i].qboxAmbientLevel = this.inStream.readByte();
                this.channelInfo[i].qboxX1 = this.inStream.readByte();
                this.channelInfo[i].qboxY1 = this.inStream.readByte();
                this.channelInfo[i].qboxX2 = this.inStream.readByte();
                this.channelInfo[i].qboxY2 = this.inStream.readByte();
                this.channelInfo[i].ptzPort = this.inStream.readByte();
                this.channelInfo[i].ptzBase = this.inStream.readByte();
                this.channelInfo[i].isPanReverse = this.inStream.readByte() != 0;
                this.channelInfo[i].isTileReverse = this.inStream.readByte() != 0;
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.channelInfo;
    }

    public synchronized boolean setChannelInfo(ChannelInfo info) {
        JWESP10Header resHeader;
        block14: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)20, 48);
                this.outStream.write(header, 0, header.length);
                byte[] bytes = null;
                byte[] src = null;
                int attribute = 0;
                bytes = new byte[24];
                src = info.name.getBytes();
                System.arraycopy(src, 0, bytes, 0, src.length);
                this.outStream.write(bytes, 0, bytes.length);
                this.outStream.writeByte(info.number);
                if (info.isEnable) {
                    attribute = (byte)(attribute | 0x80);
                }
                if (!info.isNTSC) {
                    attribute = (byte)(attribute | 8);
                }
                if (!info.isNTSCOut) {
                    attribute = (byte)(attribute | 0x40);
                }
                if (info.isBWCamera) {
                    attribute = (byte)(attribute | 1);
                }
                if (info.isInternal) {
                    attribute = (byte)(attribute | 0x10);
                }
                if (info.isInternalExist) {
                    attribute = (byte)(attribute | 0x20);
                }
                attribute = (byte)(attribute | (byte)(info.rotate << 1));
                this.outStream.writeByte(attribute);
                this.outStream.writeByte(info.quality);
                this.outStream.writeByte(0);
                this.outStream.write(info.calibrate, 0, info.calibrate.length);
                this.outStream.writeByte(info.md_sensitivity);
                attribute = 0;
                if (info.hasFlikerless) {
                    attribute = (byte)(attribute | 0x80);
                }
                if (info.isEnableFlikerless) {
                    attribute = (byte)(attribute | 1);
                }
                this.outStream.writeByte(attribute);
                attribute = 0;
                if (info.hasIris) {
                    attribute = (byte)(attribute | 0x80);
                }
                if (info.isEnableIris) {
                    attribute = (byte)(attribute | 1);
                }
                this.outStream.writeByte(attribute);
                this.outStream.writeByte(info.isQboxEnable ? 1 : 0);
                this.outStream.writeByte(info.qboxAmbientLevel);
                this.outStream.writeByte(info.qboxX1);
                this.outStream.writeByte(info.qboxY1);
                this.outStream.writeByte(info.qboxX2);
                this.outStream.writeByte(info.qboxX2);
                this.outStream.writeByte(info.ptzPort);
                this.outStream.writeByte(info.ptzBase);
                this.outStream.writeByte(info.isPanReverse ? 1 : 0);
                this.outStream.writeByte(info.isTileReverse ? 1 : 0);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block14;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized D1ChannelInfo[] getD1ChannelInfo() {
        block7: {
            JWESP10Header resHeader;
            block6: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)768, 1);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(-1);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block6;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block7;
            this.printWespHeader(resHeader);
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            int count = this.inStream.readByte();
            this.D1ChannelInfo = new D1ChannelInfo[count];
            this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            byte[] tmpBytes = new byte[24];
            byte attribute = 0;
            int i = 0;
            while (i < count) {
                this.inStream.read(tmpBytes, 0, 24);
                this.D1ChannelInfo[i] = new D1ChannelInfo();
                this.D1ChannelInfo[i].name = new String(tmpBytes, 0, this.getStringLength(tmpBytes, 24));
                this.D1ChannelInfo[i].number = this.inStream.readByte();
                attribute = this.inStream.readByte();
                this.D1ChannelInfo[i].isEnable = (attribute & 0xFFFFFF80) != 0;
                this.D1ChannelInfo[i].isNTSC = (attribute & 8) == 0;
                this.D1ChannelInfo[i].isNTSCOut = (attribute & 0x40) == 0;
                this.D1ChannelInfo[i].isBWCamera = (attribute & 1) != 0;
                this.D1ChannelInfo[i].isInternal = (attribute & 0x10) != 0;
                this.D1ChannelInfo[i].isInternalExist = (attribute & 0x20) != 0;
                this.D1ChannelInfo[i].rotate = (byte)(attribute >> 1 & 3 & 0xFFFFFFFF);
                this.inStream.readByte();
                this.inStream.readByte();
                this.D1ChannelInfo[i].calibrate = new byte[7];
                this.inStream.read(this.D1ChannelInfo[i].calibrate, 0, 7);
                this.D1ChannelInfo[i].md_sensitivity = this.inStream.readByte();
                attribute = this.inStream.readByte();
                this.D1ChannelInfo[i].hasFlikerless = (attribute & 0xFFFFFF80) != 0;
                this.D1ChannelInfo[i].isEnableFlikerless = (attribute & 1) != 0;
                attribute = this.inStream.readByte();
                this.D1ChannelInfo[i].hasIris = (attribute & 0xFFFFFF80) != 0;
                this.D1ChannelInfo[i].isEnableIris = (attribute & 1) != 0;
                this.D1ChannelInfo[i].isQboxEnable = this.inStream.readByte() != 0;
                this.D1ChannelInfo[i].qboxAmbientLevel = this.inStream.readByte();
                this.D1ChannelInfo[i].qboxX1 = this.inStream.readByte();
                this.D1ChannelInfo[i].qboxY1 = this.inStream.readByte();
                this.D1ChannelInfo[i].qboxX2 = this.inStream.readByte();
                this.D1ChannelInfo[i].qboxY2 = this.inStream.readByte();
                this.D1ChannelInfo[i].ptzPort = this.inStream.readByte();
                this.D1ChannelInfo[i].ptzBase = this.inStream.readByte();
                this.D1ChannelInfo[i].isPanReverse = this.inStream.readByte() != 0;
                this.D1ChannelInfo[i].isTileReverse = this.inStream.readByte() != 0;
                this.D1ChannelInfo[i].supportedResol = this.inStream.readShort();
                this.D1ChannelInfo[i].encCount = this.inStream.readByte();
                this.inStream.readByte();
                this.D1ChannelInfo[i].enc = new D1EncoderInfo[this.D1ChannelInfo[i].encCount];
                int j = 0;
                while (j < this.D1ChannelInfo[i].encCount) {
                    this.D1ChannelInfo[i].enc[j] = new D1EncoderInfo();
                    this.D1ChannelInfo[i].enc[j].encNo = this.inStream.readByte();
                    this.D1ChannelInfo[i].enc[j].enable = this.inStream.readByte();
                    this.D1ChannelInfo[i].enc[j].encType = this.inStream.readByte();
                    this.inStream.readByte();
                    this.D1ChannelInfo[i].enc[j].frameRate = this.inStream.readInt();
                    this.D1ChannelInfo[i].enc[j].bitRate = this.inStream.readInt();
                    this.D1ChannelInfo[i].enc[j].resol = this.inStream.readByte();
                    this.D1ChannelInfo[i].enc[j].brType = this.inStream.readByte();
                    this.D1ChannelInfo[i].enc[j].qual = this.inStream.readByte();
                    this.D1ChannelInfo[i].enc[j].ipratio = this.inStream.readByte();
                    this.inStream.readByte();
                    this.inStream.readByte();
                    this.inStream.readByte();
                    this.inStream.readByte();
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.D1ChannelInfo;
    }

    public synchronized boolean setD1ChannelInfo(D1ChannelInfo info) {
        JWESP10Header resHeader;
        block15: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)769, 52 + info.encCount * 20);
                this.outStream.write(header, 0, header.length);
                byte[] bytes = null;
                byte[] src = null;
                int attribute = 0;
                bytes = new byte[24];
                src = info.name.getBytes();
                System.arraycopy(src, 0, bytes, 0, src.length);
                this.outStream.write(bytes, 0, bytes.length);
                this.outStream.writeByte(info.number);
                if (info.isEnable) {
                    attribute = (byte)(attribute | 0x80);
                }
                if (!info.isNTSC) {
                    attribute = (byte)(attribute | 8);
                }
                if (!info.isNTSCOut) {
                    attribute = (byte)(attribute | 0x40);
                }
                if (info.isBWCamera) {
                    attribute = (byte)(attribute | 1);
                }
                if (info.isInternal) {
                    attribute = (byte)(attribute | 0x10);
                }
                if (info.isInternalExist) {
                    attribute = (byte)(attribute | 0x20);
                }
                attribute = (byte)(attribute | (byte)(info.rotate << 1));
                this.outStream.writeByte(attribute);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                this.outStream.write(info.calibrate, 0, info.calibrate.length);
                this.outStream.writeByte(info.md_sensitivity);
                attribute = 0;
                if (info.hasFlikerless) {
                    attribute = (byte)(attribute | 0x80);
                }
                if (info.isEnableFlikerless) {
                    attribute = (byte)(attribute | 1);
                }
                this.outStream.writeByte(attribute);
                attribute = 0;
                if (info.hasIris) {
                    attribute = (byte)(attribute | 0x80);
                }
                if (info.isEnableIris) {
                    attribute = (byte)(attribute | 1);
                }
                this.outStream.writeByte(attribute);
                this.outStream.writeByte(info.isQboxEnable ? 1 : 0);
                this.outStream.writeByte(info.qboxAmbientLevel);
                this.outStream.writeByte(info.qboxX1);
                this.outStream.writeByte(info.qboxY1);
                this.outStream.writeByte(info.qboxX2);
                this.outStream.writeByte(info.qboxX2);
                this.outStream.writeByte(info.ptzPort);
                this.outStream.writeByte(info.ptzBase);
                this.outStream.writeByte(info.isPanReverse ? 1 : 0);
                this.outStream.writeByte(info.isTileReverse ? 1 : 0);
                this.outStream.writeShort(info.supportedResol);
                this.outStream.writeByte(info.encCount);
                this.outStream.writeByte(0);
                int j = 0;
                while (j < info.encCount) {
                    System.out.println("SETD1Channel [" + j + "] " + info.enc[j].encType + ":" + info.enc[j].resol);
                    this.outStream.writeByte(info.enc[j].encNo);
                    this.outStream.writeByte(info.enc[j].enable);
                    this.outStream.writeByte(info.enc[j].encType);
                    this.outStream.writeByte(0);
                    this.outStream.writeInt(info.enc[j].frameRate);
                    this.outStream.writeInt(info.enc[j].bitRate);
                    this.outStream.writeByte(info.enc[j].resol);
                    this.outStream.writeByte(info.enc[j].brType);
                    this.outStream.writeByte(info.enc[j].qual);
                    this.outStream.writeByte(info.enc[j].ipratio);
                    this.outStream.writeInt(0);
                    ++j;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block15;
                this.lastErrorCode = -3;
                System.out.println("ERR_NETWORK");
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                System.out.println("5");
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            System.out.println("resHeader.errorCode : " + this.lastErrorCode);
            return false;
        }
        return true;
    }

    public synchronized ScheduleTimeInfo getScheduleTimeInfo() {
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)23, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            this.scheduleTimeInfo = new ScheduleTimeInfo();
            this.scheduleTimeInfo.weekdayStart = this.inStream.readByte();
            this.scheduleTimeInfo.weekdayEnd = this.inStream.readByte();
            this.inStream.readShort();
            this.scheduleTimeInfo.dayStart = this.inStream.readShort();
            this.scheduleTimeInfo.dayEnd = this.inStream.readShort();
            this.scheduleTimeInfo.specialTime = new SpecialTime[4];
            int i = 0;
            while (i < 4) {
                this.scheduleTimeInfo.specialTime[i] = new SpecialTime();
                this.scheduleTimeInfo.specialTime[i].dayStart = this.inStream.readShort();
                this.scheduleTimeInfo.specialTime[i].dayEnd = this.inStream.readShort();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.scheduleTimeInfo;
    }

    public synchronized boolean setScheduleTimeInfo(ScheduleTimeInfo info) {
        JWESP10Header resHeader;
        block5: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)24, 24);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(info.weekdayStart);
                this.outStream.writeByte(info.weekdayEnd);
                this.outStream.writeShort(0);
                this.outStream.writeShort(info.dayStart);
                this.outStream.writeShort(info.dayEnd);
                int i = 0;
                while (i < 4) {
                    this.outStream.writeShort(info.specialTime[i].dayStart);
                    this.outStream.writeShort(info.specialTime[i].dayEnd);
                    ++i;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized FtpInfo getFtpInfo() {
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)25, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            int chCount = this.inStream.readInt();
            this.ftpinfo = new FtpInfo();
            this.ftpinfo.chFtpInfo = new ChannelFtpInfo[chCount];
            byte[] tmpBytes = new byte[64];
            this.inStream.read(tmpBytes, 0, tmpBytes.length);
            this.ftpinfo.server = new String(tmpBytes, 0, this.getStringLength(tmpBytes, tmpBytes.length));
            tmpBytes = new byte[24];
            this.inStream.read(tmpBytes, 0, tmpBytes.length);
            this.ftpinfo.username = new String(tmpBytes, 0, this.getStringLength(tmpBytes, tmpBytes.length));
            tmpBytes = new byte[16];
            this.inStream.read(tmpBytes, 0, tmpBytes.length);
            this.ftpinfo.password = new String(tmpBytes, 0, this.getStringLength(tmpBytes, tmpBytes.length));
            tmpBytes = new byte[64];
            this.inStream.read(tmpBytes, 0, tmpBytes.length);
            this.ftpinfo.path = new String(tmpBytes, 0, this.getStringLength(tmpBytes, tmpBytes.length));
            int i = 0;
            while (i < chCount) {
                this.ftpinfo.chFtpInfo[i] = new ChannelFtpInfo();
                this.ftpinfo.chFtpInfo[i].nameMethod = new FileNameMethod();
                this.ftpinfo.chFtpInfo[i].resolution = this.inStream.readByte();
                byte tmpByte = this.inStream.readByte();
                this.ftpinfo.chFtpInfo[i].nameMethod.isDateTime = (tmpByte & 1) != 0;
                this.ftpinfo.chFtpInfo[i].nameMethod.isChNum = (tmpByte & 2) != 0;
                this.ftpinfo.chFtpInfo[i].nameMethod.isSystemName = (tmpByte & 4) != 0;
                this.ftpinfo.chFtpInfo[i].isPeriod = this.inStream.readByte() != 0;
                this.inStream.readByte();
                this.ftpinfo.chFtpInfo[i].periodInterval = this.inStream.readInt();
                this.ftpinfo.chFtpInfo[i].attribute = this.inStream.readInt();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.ftpinfo;
    }

    public synchronized boolean setFtpInfo(FtpInfo info) {
        JWESP10Header resHeader;
        block8: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)26, 172 + info.chFtpInfo.length * 12);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeInt(info.chFtpInfo.length);
                byte[] tmpBytes = new byte[64];
                byte[] src = null;
                src = info.server.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[24];
                src = info.username.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[16];
                src = info.password.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[64];
                src = info.path.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                int chCount = info.chFtpInfo.length;
                int i = 0;
                while (i < chCount) {
                    this.outStream.writeByte(info.chFtpInfo[i].resolution);
                    byte tmpByte = 0;
                    if (info.chFtpInfo[i].nameMethod.isDateTime) {
                        tmpByte = (byte)(tmpByte | 1);
                    }
                    if (info.chFtpInfo[i].nameMethod.isChNum) {
                        tmpByte = (byte)(tmpByte | 2);
                    }
                    if (info.chFtpInfo[i].nameMethod.isSystemName) {
                        tmpByte = (byte)(tmpByte | 4);
                    }
                    this.outStream.writeByte(tmpByte);
                    this.outStream.writeByte(info.chFtpInfo[i].isPeriod ? 1 : 0);
                    this.outStream.writeByte(0);
                    this.outStream.writeInt(info.chFtpInfo[i].periodInterval);
                    this.outStream.writeInt(info.chFtpInfo[i].attribute);
                    ++i;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block8;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized SmtpInfo getSmtpInfo() {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)27, 0);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        this.smtpinfo = new SmtpInfo();
        byte[] tmpBytes = new byte[64];
        this.inStream.read(tmpBytes, 0, tmpBytes.length);
        this.smtpinfo.recipientAddr = new String(tmpBytes, 0, this.getStringLength(tmpBytes, tmpBytes.length));
        tmpBytes = new byte[64];
        this.inStream.read(tmpBytes, 0, tmpBytes.length);
        this.smtpinfo.senderAddr = new String(tmpBytes, 0, this.getStringLength(tmpBytes, tmpBytes.length));
        tmpBytes = new byte[64];
        this.inStream.read(tmpBytes, 0, tmpBytes.length);
        this.smtpinfo.mailServer = new String(tmpBytes, 0, this.getStringLength(tmpBytes, tmpBytes.length));
        this.smtpinfo.isUseMailServer = this.inStream.readByte() != 0;
        this.smtpinfo.isBase64Encode = this.inStream.readByte() != 0;
        this.smtpinfo.period_interval = this.inStream.readShort();
        this.smtpinfo.attribute = this.inStream.readInt();
        return this.smtpinfo;
    }

    public synchronized boolean setSmtpInfo(SmtpInfo info) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)28, 200);
                this.outStream.write(header, 0, header.length);
                byte[] tmpBytes = new byte[64];
                byte[] src = null;
                src = info.recipientAddr.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[64];
                src = info.senderAddr.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                tmpBytes = new byte[64];
                src = info.mailServer.getBytes();
                System.arraycopy(src, 0, tmpBytes, 0, src.length);
                this.outStream.write(tmpBytes, 0, tmpBytes.length);
                this.outStream.writeByte(info.isUseMailServer ? 1 : 0);
                this.outStream.writeByte(info.isBase64Encode ? 1 : 0);
                this.outStream.writeShort(info.period_interval);
                this.outStream.writeInt(info.attribute);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized ScheduleMapInfo getScheduleMapInfo() {
        block9: {
            JWESP10Header resHeader;
            block8: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)29, 0);
                this.outStream.write(header, 0, header.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block8;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block9;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            this.schedMap = new ScheduleMapInfo();
            this.schedMap.relayTotalCount = this.inStream.readByte();
            byte speialTime = this.inStream.readByte();
            this.schedMap.isUseSpecialTime = new boolean[4];
            int i = 0;
            while (i < 4) {
                this.schedMap.isUseSpecialTime[i] = (speialTime & 1 << i) != 0;
                ++i;
            }
            this.inStream.readShort();
            this.schedMap.relayMap = new int[4][this.schedMap.relayTotalCount];
            i = 0;
            while (i < 4) {
                int j = 0;
                while (j < this.schedMap.relayTotalCount) {
                    this.schedMap.relayMap[i][j] = this.inStream.readInt();
                    ++j;
                }
                ++i;
            }
            this.schedMap.relay_post = new short[this.schedMap.relayTotalCount];
            i = 0;
            while (i < this.schedMap.relayTotalCount) {
                this.schedMap.relay_post[i] = this.inStream.readShort();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.schedMap;
    }

    public synchronized boolean setScheduleMapInfo(ScheduleMapInfo info) {
        JWESP10Header resHeader;
        block9: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)30, 18 * info.relayTotalCount + 4);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(info.relayTotalCount);
                int specialTime = -127;
                int i = 0;
                while (i < 4) {
                    if (info.isUseSpecialTime[i]) {
                        specialTime = (byte)(specialTime | 1 << i);
                    }
                    ++i;
                }
                this.outStream.writeByte(specialTime);
                this.outStream.writeShort(0);
                i = 0;
                while (i < 4) {
                    int j = 0;
                    while (j < this.schedMap.relayTotalCount) {
                        this.outStream.writeInt(this.schedMap.relayMap[i][j]);
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.schedMap.relayTotalCount) {
                    this.outStream.writeShort(this.schedMap.relay_post[i]);
                    ++i;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block9;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized SensorInfo getSensorInfo() {
        block7: {
            block6: {
                JWESP10Header resHeader;
                block5: {
                    this.flushInStream();
                    resHeader = new JWESP10Header();
                    try {
                        byte[] header = new byte[12];
                        this.encodeHeader(header, 0, (short)21, 6);
                        this.outStream.write(header, 0, header.length);
                        this.outStream.writeByte(2);
                        this.outStream.writeByte(0);
                        this.outStream.writeInt(0);
                        this.outStream.flush();
                        if (this.readWesp10Header(resHeader)) break block5;
                        this.lastErrorCode = -3;
                        return null;
                    }
                    catch (IOException e) {
                        this.lastErrorCode = -3;
                        return null;
                    }
                }
                if (resHeader.errorCode == 0) break block6;
                this.lastErrorCode = resHeader.errorCode;
                return null;
            }
            this.sensorInfo = new SensorInfo();
            int payloadLength = this.inStream.readInt();
            if (payloadLength == 5) break block7;
            return null;
        }
        this.sensorInfo.sensorCount = this.inStream.readByte();
        this.sensorInfo.status = this.inStream.readInt();
        return this.sensorInfo;
    }

    public synchronized SensorMode getSensorMode() {
        block7: {
            block6: {
                JWESP10Header resHeader;
                block5: {
                    this.flushInStream();
                    resHeader = new JWESP10Header();
                    try {
                        byte[] header = new byte[12];
                        this.encodeHeader(header, 0, (short)21, 6);
                        this.outStream.write(header, 0, header.length);
                        this.outStream.writeByte(2);
                        this.outStream.writeByte(2);
                        this.outStream.writeInt(0);
                        this.outStream.flush();
                        if (this.readWesp10Header(resHeader)) break block5;
                        this.lastErrorCode = -3;
                        return null;
                    }
                    catch (IOException e) {
                        this.lastErrorCode = -3;
                        return null;
                    }
                }
                if (resHeader.errorCode == 0) break block6;
                this.lastErrorCode = resHeader.errorCode;
                return null;
            }
            this.sensorMode = new SensorMode();
            int payloadLength = this.inStream.readInt();
            if (payloadLength == 5) break block7;
            return null;
        }
        this.sensorMode.sensorCount = this.inStream.readByte();
        this.sensorMode.mode = this.inStream.readInt();
        return this.sensorMode;
    }

    public synchronized RelayInfo getRelayInfo() {
        block7: {
            block6: {
                JWESP10Header resHeader;
                block5: {
                    this.flushInStream();
                    System.out.println("start getRelayInfo()\n");
                    resHeader = new JWESP10Header();
                    try {
                        byte[] header = new byte[12];
                        this.encodeHeader(header, 0, (short)21, 6);
                        this.outStream.write(header, 0, header.length);
                        this.outStream.writeByte(1);
                        this.outStream.writeByte(0);
                        this.outStream.writeInt(0);
                        this.outStream.flush();
                        if (this.readWesp10Header(resHeader)) break block5;
                        this.lastErrorCode = -3;
                        return null;
                    }
                    catch (IOException e) {
                        this.lastErrorCode = -3;
                        return null;
                    }
                }
                if (resHeader.errorCode == 0) break block6;
                this.lastErrorCode = resHeader.errorCode;
                return null;
            }
            this.relayInfo = new RelayInfo();
            int payloadLength = this.inStream.readInt();
            if (payloadLength == 5) break block7;
            return null;
        }
        this.relayInfo.relayCount = this.inStream.readByte();
        this.relayInfo.status = this.inStream.readInt();
        return this.relayInfo;
    }

    public synchronized MiscInfo getMiscellaneousInfo(byte type) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)515, 1);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(type);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        this.miscInfo = new MiscInfo();
        this.miscInfo.type = this.inStream.readByte();
        this.miscInfo.payload_len = this.inStream.readInt();
        this.miscInfo.payload = this.inStream.readByte();
        return this.miscInfo;
    }

    public synchronized DeviceInfo getDeviceInfo() {
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)21, 6);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(3);
                this.outStream.writeByte(4);
                this.outStream.writeInt(0);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            this.deviceInfo = new DeviceInfo();
            int payloadLength = this.inStream.readInt();
            this.deviceInfo.serialCount = this.inStream.readByte();
            int deviceCount = this.inStream.readByte();
            this.deviceInfo.device = new Device[deviceCount];
            int i = 0;
            while (i < deviceCount) {
                this.deviceInfo.device[i] = new Device();
                this.deviceInfo.device[i].dependency = this.inStream.readByte();
                this.deviceInfo.device[i].type = this.inStream.readByte();
                byte[] bytes = new byte[32];
                this.inStream.read(bytes, 0, bytes.length);
                this.deviceInfo.device[i].name = new String(bytes, 0, this.getStringLength(bytes, bytes.length));
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.deviceInfo;
    }

    public synchronized SerialDeviceInfo getSerialDevieInfo(byte serialNum) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)21, 7);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(3);
                    this.outStream.writeByte(2);
                    this.outStream.writeInt(1);
                    this.outStream.writeByte(serialNum);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        int payloadLength = this.inStream.readInt();
        this.serialDeviceInfo = new SerialDeviceInfo();
        this.serialDeviceInfo.index = this.inStream.readByte();
        this.serialDeviceInfo.interfaceType = this.inStream.readByte();
        this.serialDeviceInfo.paritybit = this.inStream.readByte();
        this.serialDeviceInfo.stopbit = this.inStream.readByte();
        this.serialDeviceInfo.databit = this.inStream.readByte();
        this.serialDeviceInfo.buadrate = this.inStream.readByte();
        return this.serialDeviceInfo;
    }

    public synchronized boolean setSerialDeviceInfo(byte serialNumber, SerialDeviceInfo info) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)21, 13);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(3);
                    this.outStream.writeByte(3);
                    this.outStream.writeInt(7);
                    this.outStream.writeByte(serialNumber);
                    this.outStream.writeByte(info.index);
                    this.outStream.writeByte(info.interfaceType);
                    this.outStream.writeByte(info.paritybit);
                    this.outStream.writeByte(info.stopbit);
                    this.outStream.writeByte(info.databit);
                    this.outStream.writeByte(info.buadrate);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    public synchronized ModemDeviceInfo getModemDevieInfo() {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)21, 6);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(6);
                    this.outStream.writeByte(0);
                    this.outStream.writeInt(0);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        int payloadLength = this.inStream.readInt();
        this.modemDeviceInfo = new ModemDeviceInfo();
        byte[] tmp = null;
        tmp = new byte[20];
        this.inStream.read(tmp, 0, 20);
        this.modemDeviceInfo.init_command = new String(tmp, 0, this.getStringLength(tmp, 20));
        return this.modemDeviceInfo;
    }

    public synchronized boolean setModemDeviceInfo(ModemDeviceInfo info) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)21, 26);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(6);
                    this.outStream.writeByte(1);
                    this.outStream.writeInt(20);
                    byte[] bytes = null;
                    byte[] src = null;
                    boolean attribute = false;
                    bytes = new byte[20];
                    src = info.init_command.getBytes();
                    System.arraycopy(src, 0, bytes, 0, src.length);
                    this.outStream.write(bytes, 0, bytes.length);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    public synchronized KeyboardDeviceInfo getKeyboardDevieInfo() {
        block7: {
            block6: {
                JWESP10Header resHeader;
                block5: {
                    this.flushInStream();
                    resHeader = new JWESP10Header();
                    try {
                        byte[] header = new byte[12];
                        this.encodeHeader(header, 0, (short)21, 6);
                        this.outStream.write(header, 0, header.length);
                        this.outStream.writeByte(7);
                        this.outStream.writeByte(0);
                        this.outStream.writeInt(0);
                        this.outStream.flush();
                        if (this.readWesp10Header(resHeader)) break block5;
                        this.lastErrorCode = -3;
                        return null;
                    }
                    catch (IOException e) {
                        this.lastErrorCode = -3;
                        return null;
                    }
                }
                if (resHeader.errorCode == 0) break block6;
                this.lastErrorCode = resHeader.errorCode;
                return null;
            }
            int payloadLength = this.inStream.readInt();
            if (payloadLength == 4) break block7;
            return null;
        }
        this.keyboardDeviceInfo = new KeyboardDeviceInfo();
        this.keyboardDeviceInfo.BaseAddress = this.inStream.readInt();
        return this.keyboardDeviceInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized AudioDeviceInfo[] getAudioDevieInfo() {
        int i = 0;
        this.flushInStream();
        JWESP10Header resHeader = new JWESP10Header();
        try {
            byte[] header = new byte[12];
            this.encodeHeader(header, 0, (short)21, 6);
            this.outStream.write(header, 0, header.length);
            this.outStream.writeByte(4);
            this.outStream.writeByte(4);
            this.outStream.writeInt(0);
            if (!this.readWesp10Header(resHeader)) {
                this.lastErrorCode = -3;
                return null;
            }
            int payloadLength = this.inStream.readInt();
            if (payloadLength != 1) {
                return null;
            }
            int count = this.inStream.readByte();
            if (count <= 0) {
                return null;
            }
            this.audioDeviceInfo = new AudioDeviceInfo[count];
            i = 0;
            while (true) {
                if (i >= count) {
                    return this.audioDeviceInfo;
                }
                this.encodeHeader(header, 0, (short)21, 7);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(4);
                this.outStream.writeByte(2);
                this.outStream.writeInt(1);
                this.outStream.writeByte(i + 1);
                this.outStream.flush();
                if (!this.readWesp10Header(resHeader)) {
                    this.lastErrorCode = -3;
                    return null;
                }
                if (resHeader.errorCode != 0) {
                    this.lastErrorCode = resHeader.errorCode;
                    return null;
                }
                payloadLength = this.inStream.readInt();
                if (payloadLength != 4) {
                    return null;
                }
                this.audioDeviceInfo[i] = new AudioDeviceInfo();
                short attribute = this.inStream.readShort();
                this.audioDeviceInfo[i].enable20db = (attribute & 1) > 0;
                this.audioDeviceInfo[i].enableChannel = (attribute & 2) > 0;
                this.audioDeviceInfo[i].enableRecord = (attribute & 4) > 0;
                this.audioDeviceInfo[i].level = this.inStream.readByte();
                this.audioDeviceInfo[i].channel = this.inStream.readByte();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized AudioDeviceInfo[] setAudioDeviceInfo(AudioDeviceInfo[] info) {
        int i = 0;
        this.flushInStream();
        JWESP10Header resHeader = new JWESP10Header();
        try {
            i = 0;
            while (true) {
                if (i >= info.length) {
                    return this.audioDeviceInfo;
                }
                byte[] header = new byte[12];
                this.encodeHeader(header, 0, (short)21, 11);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(4);
                this.outStream.writeByte(3);
                this.outStream.writeInt(5);
                this.outStream.writeByte(1);
                int attribute = 0;
                attribute += info[i].enable20db ? 1 : 0;
                attribute += info[i].enableChannel ? 2 : 0;
                this.outStream.writeShort(attribute += info[i].enableRecord ? 4 : 0);
                this.outStream.writeByte(info[i].level);
                this.outStream.writeByte(info[i].channel);
                this.outStream.flush();
                if (!this.readWesp10Header(resHeader)) {
                    this.lastErrorCode = -3;
                    return null;
                }
                int payloadLength = this.inStream.readInt();
                if (payloadLength != 0) {
                    return null;
                }
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
    }

    public synchronized boolean setKeyboardDeviceInfo(KeyboardDeviceInfo info) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)21, 10);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(7);
                    this.outStream.writeByte(1);
                    this.outStream.writeInt(4);
                    this.outStream.writeInt(info.BaseAddress);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    public synchronized boolean setSensorMode(SensorMode info) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)21, 10);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(2);
                    this.outStream.writeByte(3);
                    this.outStream.writeInt(4);
                    this.outStream.writeInt(info.mode);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        this.inStream.readByte();
        this.inStream.readInt();
        return true;
    }

    synchronized void getPtzAddributeInfo() {
        this.flushInStream();
        JWESP10Header resHeader = new JWESP10Header();
        try {
            byte[] header = new byte[12];
            Object tmp = null;
            this.encodeHeader(header, 0, (short)22, 6);
            this.outStream.write(header, 0, header.length);
            this.outStream.writeByte(1);
            this.outStream.writeByte(0);
            this.outStream.writeInt(0);
            this.outStream.flush();
            if (!this.readWesp10Header(resHeader)) {
                this.lastErrorCode = -3;
                return;
            }
            if (resHeader.errorCode != 0) {
                this.lastErrorCode = resHeader.errorCode;
                return;
            }
            int size = this.inStream.readInt();
            int chCount = this.inStream.readByte();
            if (this.ptzinfo == null) {
                this.ptzinfo = new PtzInfo[chCount];
            }
            int i = 0;
            while (i < chCount) {
                this.ptzinfo[i] = new PtzInfo();
                byte tmpByte = this.inStream.readByte();
                this.ptzinfo[i].bHasBlcMode = (tmpByte & 0xFFFFFF80) != 0;
                this.ptzinfo[i].isBlcMode = (tmpByte & 1) != 0;
                tmpByte = this.inStream.readByte();
                this.ptzinfo[i].bHasFlikerlessMode = (tmpByte & 0xFFFFFF80) != 0;
                this.ptzinfo[i].isFlikerlessMode = (tmpByte & 1) != 0;
                tmpByte = this.inStream.readByte();
                this.ptzinfo[i].isPanReverseMode = tmpByte != 0;
                tmpByte = this.inStream.readByte();
                this.ptzinfo[i].isTiltReverseMode = tmpByte != 0;
                this.ptzinfo[i].ptzMode = this.inStream.readByte();
                tmpByte = this.inStream.readByte();
                this.ptzinfo[i].isGiveTakeMode = tmpByte != 0;
                this.ptzinfo[i].timeoutGiveTake = this.inStream.readInt();
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lastErrorCode = -3;
    }

    synchronized void getPtzPresetInfo(byte channel) {
        this.flushInStream();
        JWESP10Header resHeader = new JWESP10Header();
        try {
            byte[] header = new byte[12];
            byte[] tmp = null;
            this.encodeHeader(header, 0, (short)22, 7);
            this.outStream.write(header, 0, header.length);
            this.outStream.writeByte(2);
            this.outStream.writeByte(0);
            this.outStream.writeInt(1);
            this.outStream.writeByte(channel);
            this.outStream.flush();
            if (!this.readWesp10Header(resHeader)) {
                this.lastErrorCode = -3;
                return;
            }
            if (resHeader.errorCode != 0) {
                this.lastErrorCode = resHeader.errorCode;
                return;
            }
            int preset_num = this.inStream.readInt() / 28;
            this.ptzinfo[channel - 1].preset = new PtzPresetInfo[preset_num];
            int i = 0;
            while (i < preset_num) {
                this.ptzinfo[channel - 1].preset[i] = new PtzPresetInfo();
                tmp = new byte[24];
                this.inStream.read(tmp, 0, 24);
                this.ptzinfo[channel - 1].preset[i].name = new String(tmp, 0, this.getStringLength(tmp, 24));
                int tmpInt = this.inStream.readInt();
                this.ptzinfo[channel - 1].preset[i].isEnable = (tmpInt & Integer.MIN_VALUE) != 0;
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return;
        }
    }

    synchronized PtzPresetInfo[] getPtzPresetInfo2(byte channel) {
        byte[] tmp;
        PtzPresetInfo[] preset;
        block6: {
            JWESP10Header resHeader;
            block5: {
                preset = null;
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                tmp = null;
                this.encodeHeader(header, 0, (short)22, 7);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(2);
                this.outStream.writeByte(0);
                this.outStream.writeInt(1);
                this.outStream.writeByte(channel);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            int preset_num = this.inStream.readInt() / 28;
            preset = new PtzPresetInfo[preset_num];
            int i = 0;
            while (i < preset_num) {
                preset[i] = new PtzPresetInfo();
                tmp = new byte[24];
                this.inStream.read(tmp, 0, 24);
                preset[i].name = new String(tmp, 0, this.getStringLength(tmp, 24));
                int tmpInt = this.inStream.readInt();
                preset[i].isEnable = (tmpInt & Integer.MIN_VALUE) != 0;
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return preset;
    }

    synchronized void getPtzGroupInfo(byte channel) {
        this.flushInStream();
        JWESP10Header resHeader = new JWESP10Header();
        try {
            byte[] header = new byte[12];
            byte[] tmp = null;
            this.encodeHeader(header, 0, (short)22, 7);
            this.outStream.write(header, 0, header.length);
            this.outStream.writeByte(3);
            this.outStream.writeByte(0);
            this.outStream.writeInt(1);
            this.outStream.writeByte(channel);
            this.outStream.flush();
            if (!this.readWesp10Header(resHeader)) {
                this.lastErrorCode = -3;
                return;
            }
            if (resHeader.errorCode != 0) {
                this.lastErrorCode = resHeader.errorCode;
                return;
            }
            int group_cnt = this.inStream.readInt();
            this.ptzinfo[channel - 1].byEnabledGroup = 0;
            this.ptzinfo[channel - 1].group = new PtzGroupInfo[3];
            int i = 0;
            while (i < 3) {
                this.ptzinfo[channel - 1].group[i] = new PtzGroupInfo();
                tmp = new byte[24];
                this.inStream.read(tmp, 0, 24);
                this.ptzinfo[channel - 1].group[i].name = new String(tmp, 0, this.getStringLength(tmp, 24));
                int tmpInt = this.inStream.readInt();
                boolean bl = this.ptzinfo[channel - 1].group[i].isEnable = tmpInt == Integer.MIN_VALUE;
                if (this.ptzinfo[channel - 1].group[i].isEnable) {
                    this.ptzinfo[channel - 1].byEnabledGroup = (byte)(i + 1);
                }
                this.ptzinfo[channel - 1].group[i].waitTime = this.inStream.readInt();
                this.ptzinfo[channel - 1].group[i].bySeq = new byte[16];
                this.inStream.read(this.ptzinfo[channel - 1].group[i].bySeq, 0, 16);
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return;
        }
    }

    synchronized void getPtzAuxInfo(byte channel) {
        this.flushInStream();
        JWESP10Header resHeader = new JWESP10Header();
        try {
            byte[] header = new byte[12];
            byte[] tmp = null;
            this.encodeHeader(header, 0, (short)22, 7);
            this.outStream.write(header, 0, header.length);
            this.outStream.writeByte(6);
            this.outStream.writeByte(0);
            this.outStream.writeInt(1);
            this.outStream.writeByte(channel);
            this.outStream.flush();
            if (!this.readWesp10Header(resHeader)) {
                this.lastErrorCode = -3;
                return;
            }
            if (resHeader.errorCode != 0) {
                this.lastErrorCode = resHeader.errorCode;
                return;
            }
            int aux_num = this.inStream.readInt() / 32;
            this.ptzinfo[channel - 1].auxInfo = new PtzAuxInfo[aux_num];
            int i = 0;
            while (i < aux_num) {
                this.ptzinfo[channel - 1].auxInfo[i] = new PtzAuxInfo();
                tmp = new byte[24];
                this.inStream.read(tmp, 0, 24);
                this.ptzinfo[channel - 1].auxInfo[i].name = new String(tmp, 0, this.getStringLength(tmp, 24));
                int tmpInt = this.inStream.readInt();
                this.ptzinfo[channel - 1].auxInfo[i].isUse = (tmpInt & Integer.MIN_VALUE) != 0;
                this.ptzinfo[channel - 1].auxInfo[i].value = this.inStream.readInt();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return;
        }
    }

    public synchronized PtzInfo[] getPtzInfo() {
        this.getPtzAddributeInfo();
        if (this.ptzinfo == null) {
            return null;
        }
        int i = 0;
        while (i < this.ptzinfo.length) {
            this.getPtzPresetInfo((byte)(i + 1));
            this.getPtzGroupInfo((byte)(i + 1));
            this.getPtzAuxInfo((byte)(i + 1));
            i = (byte)(i + 1);
        }
        return this.ptzinfo;
    }

    synchronized boolean setPtzAttributeInfo(byte channel, PtzInfo info) {
        block12: {
            JWESP10Header resHeader;
            block11: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)22, 17);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(1);
                    this.outStream.writeByte(1);
                    this.outStream.writeInt(11);
                    this.outStream.writeByte(channel);
                    int tmpByte = 0;
                    if (info.bHasBlcMode) {
                        tmpByte = (byte)(tmpByte | 0x80);
                    }
                    if (info.isBlcMode) {
                        tmpByte = (byte)(tmpByte | 1);
                    }
                    this.outStream.writeByte(tmpByte);
                    tmpByte = 0;
                    if (info.bHasFlikerlessMode) {
                        tmpByte = (byte)(tmpByte | 0x80);
                    }
                    if (info.isFlikerlessMode) {
                        tmpByte = (byte)(tmpByte | 1);
                    }
                    this.outStream.writeByte(tmpByte);
                    tmpByte = 0;
                    if (info.isPanReverseMode) {
                        tmpByte = 1;
                    }
                    this.outStream.writeByte(tmpByte);
                    tmpByte = 0;
                    if (info.isTiltReverseMode) {
                        tmpByte = 1;
                    }
                    this.outStream.writeByte(tmpByte);
                    this.outStream.writeByte(info.ptzMode);
                    tmpByte = 0;
                    if (info.isGiveTakeMode) {
                        tmpByte = 1;
                    }
                    this.outStream.writeByte(tmpByte);
                    this.outStream.writeInt(info.timeoutGiveTake);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block11;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block12;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    synchronized boolean setPtzGroupInfo(byte channel, PtzGroupInfo[] groupInfo) {
        block8: {
            JWESP10Header resHeader;
            block7: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)22, 7 + 48 * groupInfo.length);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(3);
                    this.outStream.writeByte(1);
                    this.outStream.writeInt(1 + 48 * groupInfo.length);
                    this.outStream.writeByte(channel);
                    int i = 0;
                    while (i < groupInfo.length) {
                        byte[] bytes = null;
                        byte[] src = null;
                        boolean attribute = false;
                        bytes = new byte[24];
                        src = groupInfo[i].name.getBytes();
                        System.arraycopy(src, 0, bytes, 0, src.length);
                        this.outStream.write(bytes, 0, bytes.length);
                        int tmpInfo = 0;
                        if (groupInfo[i].isEnable) {
                            tmpInfo = Integer.MIN_VALUE;
                        }
                        this.outStream.writeInt(tmpInfo);
                        this.outStream.writeInt(groupInfo[i].waitTime);
                        this.outStream.write(groupInfo[i].bySeq, 0, groupInfo[i].bySeq.length);
                        int j = 0;
                        while (j < groupInfo[i].bySeq.length) {
                            if (groupInfo[i].bySeq[j] == -86) break;
                            ++j;
                        }
                        ++i;
                    }
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block7;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block8;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    synchronized boolean setPtzPresetInfo(byte channel, PtzPresetInfo[] presetInfo) {
        block7: {
            JWESP10Header resHeader;
            block6: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)22, 7 + 28 * presetInfo.length);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(2);
                    this.outStream.writeByte(1);
                    this.outStream.writeInt(1 + 28 * presetInfo.length);
                    this.outStream.writeByte(channel);
                    byte[] bytes = null;
                    byte[] src = null;
                    boolean attribute = false;
                    int i = 0;
                    while (i < presetInfo.length) {
                        bytes = new byte[24];
                        src = presetInfo[i].name.getBytes();
                        System.arraycopy(src, 0, bytes, 0, src.length);
                        this.outStream.write(bytes, 0, bytes.length);
                        int tmpInt = 0;
                        if (presetInfo[i].isEnable) {
                            tmpInt |= Integer.MIN_VALUE;
                        }
                        this.outStream.writeInt(tmpInt);
                        ++i;
                    }
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block6;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block7;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    synchronized boolean setPtzAuxInfo(byte channel, PtzAuxInfo[] auxInfo) {
        block7: {
            JWESP10Header resHeader;
            block6: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    this.encodeHeader(header, 0, (short)22, 7 + 32 * auxInfo.length);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(6);
                    this.outStream.writeByte(1);
                    this.outStream.writeInt(1 + 32 * auxInfo.length);
                    this.outStream.writeByte(channel);
                    int i = 0;
                    while (i < auxInfo.length) {
                        byte[] bytes = null;
                        byte[] src = null;
                        boolean attribute = false;
                        bytes = new byte[24];
                        src = auxInfo[i].name.getBytes();
                        System.arraycopy(src, 0, bytes, 0, src.length);
                        this.outStream.write(bytes, 0, bytes.length);
                        int tmpInfo = 0;
                        if (auxInfo[i].isUse) {
                            tmpInfo |= Integer.MIN_VALUE;
                        }
                        this.outStream.writeInt(tmpInfo);
                        this.outStream.writeInt(auxInfo[i].value);
                        ++i;
                    }
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block6;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block7;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    public synchronized boolean setPtzInfo(PtzInfo[] info) {
        int i = 0;
        while (i < info.length) {
            if (!this.setPtzAttributeInfo((byte)(i + 1), info[i])) {
                return false;
            }
            if (!this.setPtzGroupInfo((byte)(i + 1), info[i].group)) {
                return false;
            }
            if (!this.setPtzPresetInfo((byte)(i + 1), info[i].preset)) {
                return false;
            }
            if (!this.setPtzAuxInfo((byte)(i + 1), info[i].auxInfo)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized boolean setPtzPreset(byte channel, byte presetNumber) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] msg = new byte[12];
                    this.encodeHeader(msg, 0, (short)22, 8);
                    this.outStream.writeByte(2);
                    this.outStream.writeByte(2);
                    this.outStream.writeInt(2);
                    this.outStream.writeByte(channel);
                    this.outStream.writeByte(presetNumber);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        this.inStream.readInt();
        return true;
    }

    public synchronized BaseAddrInfo getBaseAddrInfo() {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] msg = new byte[12];
                    this.encodeHeader(msg, 0, (short)64, 4);
                    this.outStream.write(msg, 0, msg.length);
                    this.outStream.writeInt(0);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        this.baseAddrInfo = new BaseAddrInfo();
        this.baseAddrInfo.baseAddress = this.inStream.readInt();
        return this.baseAddrInfo;
    }

    public synchronized boolean setBaseAddrInfo(BaseAddrInfo baseAddrInfo) {
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] msg = new byte[12];
                    this.encodeHeader(msg, 0, (short)64, 4);
                    this.outStream.write(msg, 0, msg.length);
                    this.outStream.writeInt(baseAddrInfo.baseAddress);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return false;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return false;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        baseAddrInfo.baseAddress = this.inStream.readInt();
        return true;
    }

    public synchronized SensorPresetInfo getSenorPreset() {
        SensorPresetInfo senPre;
        block6: {
            JWESP10Header resHeader;
            block5: {
                senPre = null;
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] msg = new byte[12];
                this.encodeHeader(msg, 0, (short)65, 0);
                this.outStream.write(msg, 0, msg.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            senPre = new SensorPresetInfo();
            senPre.channelCount = this.inStream.readInt();
            senPre.sensorCount = this.inStream.readInt();
            senPre.wdd = new SensorPresetSchedInfo[senPre.channelCount];
            senPre.wdn = new SensorPresetSchedInfo[senPre.channelCount];
            senPre.wed = new SensorPresetSchedInfo[senPre.channelCount];
            senPre.wen = new SensorPresetSchedInfo[senPre.channelCount];
            int i = 0;
            while (i < senPre.channelCount) {
                senPre.wdd[i] = new SensorPresetSchedInfo();
                senPre.wdd[i].postAlarm = this.inStream.readInt();
                senPre.wdd[i].swingTime = this.inStream.readInt();
                senPre.wdd[i].disableSpTime = this.inStream.readByte();
                senPre.wdd[i].sensorPreset = new byte[senPre.sensorCount];
                this.inStream.read(senPre.wdd[i].sensorPreset, 0, senPre.sensorCount);
                senPre.wdn[i] = new SensorPresetSchedInfo();
                senPre.wdn[i].postAlarm = this.inStream.readInt();
                senPre.wdn[i].swingTime = this.inStream.readInt();
                senPre.wdn[i].disableSpTime = this.inStream.readByte();
                senPre.wdn[i].sensorPreset = new byte[senPre.sensorCount];
                this.inStream.read(senPre.wdn[i].sensorPreset, 0, senPre.sensorCount);
                senPre.wed[i] = new SensorPresetSchedInfo();
                senPre.wed[i].postAlarm = this.inStream.readInt();
                senPre.wed[i].swingTime = this.inStream.readInt();
                senPre.wed[i].disableSpTime = this.inStream.readByte();
                senPre.wed[i].sensorPreset = new byte[senPre.sensorCount];
                this.inStream.read(senPre.wed[i].sensorPreset, 0, senPre.sensorCount);
                senPre.wen[i] = new SensorPresetSchedInfo();
                senPre.wen[i].postAlarm = this.inStream.readInt();
                senPre.wen[i].swingTime = this.inStream.readInt();
                senPre.wen[i].disableSpTime = this.inStream.readByte();
                senPre.wen[i].sensorPreset = new byte[senPre.sensorCount];
                this.inStream.read(senPre.wen[i].sensorPreset, 0, senPre.sensorCount);
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return senPre;
    }

    public synchronized boolean setSenorPreset(SensorPresetInfo senPre) {
        JWESP10Header resHeader;
        block5: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            int bodySize = 8 + senPre.channelCount * (4 * (9 + senPre.sensorCount));
            try {
                byte[] msg = new byte[12];
                this.encodeHeader(msg, 0, (short)66, bodySize);
                this.outStream.write(msg, 0, msg.length);
                this.outStream.writeInt(senPre.channelCount);
                this.outStream.writeInt(senPre.sensorCount);
                int i = 0;
                i = 0;
                while (i < senPre.channelCount) {
                    this.outStream.writeInt(senPre.wdd[i].postAlarm);
                    this.outStream.writeInt(senPre.wdd[i].swingTime);
                    this.outStream.writeByte(senPre.wdd[i].disableSpTime);
                    this.outStream.write(senPre.wdd[i].sensorPreset, 0, senPre.sensorCount);
                    this.outStream.writeInt(senPre.wdn[i].postAlarm);
                    this.outStream.writeInt(senPre.wdn[i].swingTime);
                    this.outStream.writeByte(senPre.wdn[i].disableSpTime);
                    this.outStream.write(senPre.wdn[i].sensorPreset, 0, senPre.sensorCount);
                    this.outStream.writeInt(senPre.wed[i].postAlarm);
                    this.outStream.writeInt(senPre.wed[i].swingTime);
                    this.outStream.writeByte(senPre.wed[i].disableSpTime);
                    this.outStream.write(senPre.wed[i].sensorPreset, 0, senPre.sensorCount);
                    this.outStream.writeInt(senPre.wen[i].postAlarm);
                    this.outStream.writeInt(senPre.wen[i].swingTime);
                    this.outStream.writeByte(senPre.wen[i].disableSpTime);
                    this.outStream.write(senPre.wen[i].sensorPreset, 0, senPre.sensorCount);
                    ++i;
                }
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized ResolutionMap getResolutionMap() {
        byte[] tmp;
        block6: {
            JWESP10Header resHeader;
            block5: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                byte[] header = new byte[12];
                tmp = null;
                this.encodeHeader(header, 0, (short)779, 28);
                this.outStream.write(header, 0, header.length);
                byte[] reserved1 = new byte[28];
                this.outStream.write(reserved1, 0, reserved1.length);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block5;
                this.lastErrorCode = -3;
                return null;
            }
            if (resHeader.errorCode == 0) break block6;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        try {
            this.res_map = new ResolutionMap();
            this.res_map.num = this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            this.inStream.readByte();
            this.res_map.info = new ResolutionInfo[this.res_map.num];
            int i = 0;
            while (i < this.res_map.num) {
                this.res_map.info[i] = new ResolutionInfo();
                tmp = new byte[16];
                this.inStream.read(tmp, 0, 16);
                this.res_map.info[i].name = new String(tmp, 0, this.getStringLength(tmp, 16));
                this.res_map.info[i].width = this.inStream.readShort();
                this.res_map.info[i].height = this.inStream.readShort();
                this.res_map.info[i].num = this.inStream.readShort();
                this.res_map.info[i].attr = this.inStream.readByte();
                this.inStream.readByte();
                this.inStream.readByte();
                this.inStream.readByte();
                this.inStream.readByte();
                this.inStream.readByte();
                ++i;
            }
        }
        catch (IOException e) {
            this.lastErrorCode = -3;
            return null;
        }
        return this.res_map;
    }

    public synchronized VideoCtrl getVideoCtrl(int ch) {
        byte[] tmp;
        block5: {
            JWESP10Header resHeader;
            block4: {
                this.flushInStream();
                resHeader = new JWESP10Header();
                try {
                    byte[] header = new byte[12];
                    tmp = null;
                    this.encodeHeader(header, 0, (short)776, 4);
                    this.outStream.write(header, 0, header.length);
                    this.outStream.writeByte(ch);
                    this.outStream.writeByte(0);
                    this.outStream.writeByte(0);
                    this.outStream.writeByte(0);
                    this.outStream.flush();
                    if (this.readWesp10Header(resHeader)) break block4;
                    this.lastErrorCode = -3;
                    return null;
                }
                catch (IOException e) {
                    this.lastErrorCode = -3;
                    return null;
                }
            }
            if (resHeader.errorCode == 0) break block5;
            this.lastErrorCode = resHeader.errorCode;
            return null;
        }
        this.video_ctrl = new VideoCtrl();
        this.video_ctrl.Attr = new byte[4];
        this.inStream.read(this.video_ctrl.Attr);
        this.video_ctrl.Version = this.inStream.readByte();
        tmp = new byte[3];
        this.inStream.read(tmp);
        this.video_ctrl.DCLevel = this.inStream.readByte();
        this.video_ctrl.AGC = this.inStream.readByte();
        this.video_ctrl.BLC = this.inStream.readByte();
        this.video_ctrl.DSS = this.inStream.readByte();
        this.video_ctrl.WB = this.inStream.readByte();
        this.video_ctrl.Shutter = this.inStream.readByte();
        this.video_ctrl.Strobe = this.inStream.readByte();
        this.video_ctrl.AGCVal = this.inStream.readByte();
        this.video_ctrl.DSSVal = this.inStream.readByte();
        this.video_ctrl.ShutterVal = this.inStream.readByte();
        this.video_ctrl.DNN = this.inStream.readByte();
        this.video_ctrl.ElcLevel = this.inStream.readByte();
        this.video_ctrl.DCLevelBase = this.inStream.readByte();
        this.video_ctrl.Lens = this.inStream.readByte();
        tmp = new byte[18];
        this.inStream.read(tmp);
        return this.video_ctrl;
    }

    public synchronized boolean setVideoCtrl(int ch, VideoCtrl info) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                byte[] tmp = null;
                this.encodeHeader(header, 0, (short)777, 36);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(ch);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                this.outStream.writeByte(info.DCLevel);
                System.out.println("setVideoCtrl : " + info.DCLevel);
                this.outStream.writeByte(info.AGC);
                this.outStream.writeByte(info.BLC);
                this.outStream.writeByte(info.DSS);
                this.outStream.writeByte(info.WB);
                this.outStream.writeByte(info.Shutter);
                this.outStream.writeByte(info.Strobe);
                this.outStream.writeByte(info.AGCVal);
                this.outStream.writeByte(info.DSSVal);
                this.outStream.writeByte(info.ShutterVal);
                this.outStream.writeByte(info.DNN);
                this.outStream.writeByte(info.ElcLevel);
                this.outStream.writeByte(info.DCLevelBase);
                this.outStream.writeByte(info.Lens);
                tmp = new byte[18];
                this.outStream.write(tmp);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public synchronized boolean adjustVideoCtrl(int ch, int type, int ver, int data) {
        JWESP10Header resHeader;
        block4: {
            this.flushInStream();
            resHeader = new JWESP10Header();
            try {
                byte[] header = new byte[12];
                Object tmp = null;
                this.encodeHeader(header, 0, (short)778, 8);
                this.outStream.write(header, 0, header.length);
                this.outStream.writeByte(ch);
                this.outStream.writeByte(type);
                this.outStream.writeByte(ver);
                this.outStream.writeByte(0);
                this.outStream.writeByte(data);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                this.outStream.writeByte(0);
                this.outStream.flush();
                if (this.readWesp10Header(resHeader)) break block4;
                this.lastErrorCode = -3;
                return false;
            }
            catch (IOException e) {
                this.lastErrorCode = -3;
                return false;
            }
        }
        if (resHeader.errorCode != 0) {
            this.lastErrorCode = resHeader.errorCode;
            return false;
        }
        return true;
    }

    public void disconnect() {
        try {
            this.stopThread();
            if (this.outStream != null) {
                this.outStream.close();
            }
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            this.isConnected = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stopThread() {
        this.isTerminate = true;
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized int sendKeepAlive() {
        System.out.println("start sendKeepAlive()\n");
        if (!this.isConnected) {
            return -1;
        }
        byte[] header = new byte[12];
        this.encodeEventHeader(header, 3, (short)3, 0);
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    @Override
    public void run() {
        long lastSendTime;
        long curTime = lastSendTime = System.currentTimeMillis();
        while (!this.isTerminate) {
            if (this.isConnected) {
                curTime = System.currentTimeMillis();
                if (curTime - lastSendTime > (long)(this.timeout / 2 * 1000)) {
                    this.sendKeepAlive();
                    lastSendTime = curTime;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean readWesp10Header(JWESP10Header header) {
        try {
            byte byteVal = this.inStream.readByte();
            header.version = (byte)(byteVal >> 4);
            header.transmitType = (byte)(byteVal & 0xF);
            header.categoryId = this.inStream.readByte();
            header.commandId = this.inStream.readShort();
            header.errorCode = this.inStream.readInt();
            header.bodySize = this.inStream.readInt();
            if (header.errorCode != 0) {
                Log.e((String)TAG, (String)("Get Error Message\nVersion : " + header.version + " TransmitType : " + header.transmitType + " CategoryId : " + header.categoryId + " CommandId : " + header.commandId + " ErrorCode : " + Integer.toHexString(header.errorCode) + " BodySize : " + header.bodySize));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void printWespHeader(JWESP10Header header) {
        System.out.println("version = " + Integer.toHexString(header.version & 0xFF));
        System.out.println("Transmit type = " + Integer.toHexString(header.transmitType & 0xFF));
        System.out.println("categoryId = " + Integer.toHexString(header.categoryId & 0xFF));
        System.out.println("commandId = " + Integer.toHexString(header.commandId & 0xFFFF));
        System.out.println("errorCode = " + Integer.toHexString(header.errorCode & 0xFFFFFFFF));
        System.out.println("bodySize = " + header.bodySize);
    }

    private byte[] encodeHeader(byte[] encPacket, int transmitType, short commandId, int bodySize) {
        encPacket[0] = (byte)(0xA0 | transmitType);
        encPacket[1] = 3;
        encPacket[2] = (byte)(commandId >> 8 & 0xFF);
        encPacket[3] = (byte)(commandId & 0xFF);
        encPacket[8] = (byte)(bodySize >> 24 & 0xFF);
        encPacket[9] = (byte)(bodySize >> 16 & 0xFF);
        encPacket[10] = (byte)(bodySize >> 8 & 0xFF);
        encPacket[11] = (byte)(bodySize & 0xFF);
        return encPacket;
    }

    private byte[] encodeHeader2(byte[] encPacket, int transmitType, int commandId, int bodySize) {
        encPacket[0] = (byte)(0xA0 | transmitType);
        encPacket[1] = 3;
        encPacket[2] = (byte)(commandId >> 8 & 0xFF);
        encPacket[3] = (byte)(commandId & 0xFF);
        encPacket[8] = (byte)(bodySize >> 24 & 0xFF);
        encPacket[9] = (byte)(bodySize >> 16 & 0xFF);
        encPacket[10] = (byte)(bodySize >> 8 & 0xFF);
        encPacket[11] = (byte)(bodySize & 0xFF);
        return encPacket;
    }

    private byte[] encodeEventHeader(byte[] encPacket, int transmitType, short commandId, int bodySize) {
        encPacket[0] = (byte)(0xA0 | transmitType);
        encPacket[1] = 2;
        encPacket[2] = (byte)(commandId >> 8 & 0xFF);
        encPacket[3] = (byte)(commandId & 0xFF);
        encPacket[8] = (byte)(bodySize >> 24 & 0xFF);
        encPacket[9] = (byte)(bodySize >> 16 & 0xFF);
        encPacket[10] = (byte)(bodySize >> 8 & 0xFF);
        encPacket[11] = (byte)(bodySize & 0xFF);
        return encPacket;
    }

    private synchronized int flushInStream() {
        int count = 0;
        try {
            count = this.inStream.available();
            if (count > 0) {
                byte[] temp = new byte[count];
                this.inStream.readFully(temp);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return count;
    }

    public boolean isServerRecordingMode() {
        boolean ret = false;
        MiscInfo miscInfo = this.getMiscellaneousInfo((byte)2);
        if (miscInfo.payload == 1) {
            return true;
        }
        return ret;
    }

    public class AudioDeviceInfo {
        public boolean enable20db;
        public boolean enableChannel;
        public boolean enableRecord;
        public byte level;
        public byte channel;
    }

    public class BaseAddrInfo {
        public int baseAddress;
    }

    public class CameraTimeInfo {
        public long secTime;
        public short msecTime;
        public byte dst;
        public short timeZone;
    }

    public class ChannelFtpInfo {
        public byte resolution;
        public FileNameMethod nameMethod;
        public boolean isPeriod;
        public int periodInterval;
        public int attribute;
    }

    public class ChannelInfo {
        public String name;
        public byte number;
        public boolean isEnable;
        public boolean isNTSCOut;
        public boolean isNTSC;
        public byte rotate;
        public boolean isBWCamera;
        public boolean isInternal;
        public boolean isInternalExist;
        public byte quality;
        public byte[] calibrate;
        public byte md_sensitivity;
        public boolean hasFlikerless;
        public boolean hasIris;
        public boolean isEnableFlikerless;
        public boolean isEnableIris;
        public boolean isQboxEnable;
        public byte qboxAmbientLevel;
        public byte qboxX1;
        public byte qboxY1;
        public byte qboxX2;
        public byte qboxY2;
        public byte ptzPort;
        public byte ptzBase;
        public boolean isPanReverse;
        public boolean isTileReverse;
    }

    public class D1ChannelInfo {
        public String name;
        public byte number;
        public boolean isEnable;
        public boolean isNTSC;
        public boolean isNTSCOut;
        public byte rotate;
        public boolean isBWCamera;
        public boolean isInternal;
        public boolean isInternalExist;
        public byte quality;
        public byte[] calibrate;
        public byte md_sensitivity;
        public boolean hasFlikerless;
        public boolean hasIris;
        public boolean isEnableFlikerless;
        public boolean isEnableIris;
        public boolean isQboxEnable;
        public byte qboxAmbientLevel;
        public byte qboxX1;
        public byte qboxY1;
        public byte qboxX2;
        public byte qboxY2;
        public byte ptzPort;
        public byte ptzBase;
        public boolean isPanReverse;
        public boolean isTileReverse;
        public short supportedResol;
        public byte encCount;
        public D1EncoderInfo[] enc;
    }

    public class D1EncoderInfo {
        public byte encNo;
        public byte enable;
        public byte encType;
        public int frameRate;
        public int bitRate;
        public byte resol;
        public byte brType;
        public byte qual;
        public byte ipratio;
    }

    public class Device {
        public byte type;
        public byte dependency;
        public String name;
    }

    public class DeviceInfo {
        public int serialCount;
        public Device[] device;
    }

    public class DstInfo {
        public DstParm[] dstParm;
        public int tzCount;
        public byte[] dstTable;
    }

    public class DstParm {
        public String dstName;
        public byte smon;
        public byte smday;
        public byte sweek;
        public byte swday;
        public byte shour;
        public byte smin;
        public byte emon;
        public byte esmday;
        public byte eweek;
        public byte eday;
        public byte ehour;
        public byte emin;
        public byte gmt;
        public short shift;
    }

    public class EventInfo {
        public byte category;
        public long code;
        public byte payloadCount;
        List<PayloadInfo> payloadInfo = new ArrayList<PayloadInfo>();
    }

    public class EventSystemInfo {
        public String modelName;
        public String hwVersion;
        public String swVersion;
        public String serialNumber;
        public String mac;
        public byte hddCount;
        public byte serialCount;
        public short channelCount;
        public short channelReserved;
        public long channelEnable;
        public short sensorCount;
        public short sensorReserved;
        public long sensorEnable;
        public short relayCount;
        public short relayReserved;
        public long relayEnable;
        public short audioInCount;
        public short audioInReserved;
        public long audioInEnable;
        public short audioOutCount;
        public short audioOutReserved;
        public long audioOutEnable;
        public short textCount;
        public short textReserved;
        public long textEnable;
    }

    public class FileNameMethod {
        public boolean isDateTime;
        public boolean isChNum;
        public boolean isSystemName;
    }

    public class FtpInfo {
        public String server;
        public String username;
        public String password;
        public String path;
        public ChannelFtpInfo[] chFtpInfo;
    }

    public class IPFilter {
        public boolean isEnable;
        public int from;
        public int to;
    }

    class JWESP10Header {
        byte version;
        byte transmitType;
        byte categoryId;
        short commandId;
        int errorCode;
        int bodySize;

        JWESP10Header() {
        }
    }

    public class KeyboardDeviceInfo {
        public int BaseAddress;
    }

    public class MiscInfo {
        public byte type;
        public int payload_len;
        public byte payload;
    }

    public class ModemDeviceInfo {
        public String init_command;
    }

    public class NetworkConfiguration {
        public short portSocketServer;
        public int keepAlive;
    }

    public class NetworkInfo {
        public byte interfaceType;
        public boolean isDHCPEnable;
        public int ip;
        public int netmask;
        public int broadcast;
        public int gateway;
        public int dns1;
        public int dns2;
        public int dns3;
        public String domainName;
        public short wrsRegistrationInterval;
        public boolean isWrsPublic;
        public byte wrsStatus;
        public String wrsGroupName;
        public String wrsServer;
        public String wrsToken;
        public String networkId;
        public String networkPassword;
        public String xDSLAssignedIP;
        public byte xDSLStatus;
        public String PSTNPhoneNumber;
        public int PSTNTimeout;
        public byte PSTNISP;
        public byte PSTNScriptUse;
        public byte[] PSTNScriptItem;
        public String[] PSTNScriptParm;
    }

    public class PayloadInfo {
        public byte payloadType;
        public short payloadLength;
        public byte[] payload;
    }

    public class PtzAuxInfo {
        public String name;
        public boolean isUse;
        public int value;
    }

    public class PtzGroupInfo {
        public String name;
        public boolean isEnable;
        public boolean[] preset;
        public int waitTime;
        public byte[] bySeq;
    }

    public class PtzInfo {
        public boolean bHasBlcMode;
        public boolean bHasFlikerlessMode;
        public boolean isBlcMode;
        public boolean isFlikerlessMode;
        public boolean isPanReverseMode;
        public boolean isTiltReverseMode;
        public byte ptzMode;
        public boolean isGiveTakeMode;
        public int timeoutGiveTake;
        public PtzPresetInfo[] preset;
        public byte byEnabledGroup;
        public PtzGroupInfo[] group;
        public PtzAuxInfo[] auxInfo;
    }

    public class PtzPresetInfo {
        public String name;
        public boolean isEnable;
    }

    public class RelayInfo {
        public int relayCount;
        public int status;
    }

    public class ResolutionInfo {
        public String name;
        public short width;
        public short height;
        public short num;
        public byte attr;
    }

    public class ResolutionMap {
        int num;
        ResolutionInfo[] info;
    }

    class ScheduleMapInfo {
        byte relayTotalCount;
        boolean[] isUseSpecialTime;
        int[][] relayMap;
        short[] relay_post;

        ScheduleMapInfo() {
        }
    }

    public class ScheduleTimeInfo {
        public byte weekdayStart;
        public byte weekdayEnd;
        public short dayStart;
        public short dayEnd;
        public SpecialTime[] specialTime;
    }

    public class SecurityInfo {
        public String encryptKey;
        public boolean isEncryptEnable;
        public byte securityLevel;
        public boolean isFilterEnable;
        public boolean isAllowMode;
        public IPFilter[] filter;
    }

    public class SensorInfo {
        public int sensorCount;
        public int status;
    }

    public class SensorMode {
        public int sensorCount;
        public int mode;
    }

    public class SensorPresetInfo {
        int channelCount;
        int sensorCount;
        SensorPresetSchedInfo[] wdd;
        SensorPresetSchedInfo[] wdn;
        SensorPresetSchedInfo[] wed;
        SensorPresetSchedInfo[] wen;
    }

    public class SensorPresetSchedInfo {
        int postAlarm;
        int swingTime;
        byte disableSpTime;
        byte[] sensorPreset;
    }

    public class SerialDeviceInfo {
        public int index;
        public byte interfaceType;
        public byte paritybit;
        public byte stopbit;
        public byte databit;
        public byte buadrate;
    }

    public class SmtpInfo {
        public String recipientAddr;
        public String senderAddr;
        public String mailServer;
        public boolean isUseMailServer;
        public boolean isBase64Encode;
        public short period_interval;
        public int attribute;
    }

    public class SpecialTime {
        public short dayStart;
        public short dayEnd;
    }

    public class StatusInfo {
        public CameraTimeInfo cameraInfo;
        public long eventCount;
        List<EventInfo> eventInfo = new ArrayList<EventInfo>();
    }

    public class SystemInfo {
        public long magicNumber;
        public String modelName;
        public String userDefinedName;
        public String hwVersion;
        public String swVersion;
        public String serial;
        public int ip;
        public String description;
        public String location;
        public byte[] mac;
    }

    public class SystemLog {
        public int tm;
        public short ms;
        public short pay_load_size;
        public byte reserved;
        public byte category;
        public short channel;
        public int code;
    }

    public class TimeInfo {
        public long time;
        public short timeIndex;
        public short timeZone;
        public boolean isDstEnable;
        public boolean isDstNow;
        public DstInfo dstInfo;
        public byte byNTPMode;
        public byte byNTPIPUse;
        public int nNTPLocalIP;
        public int nNTPInterval;
    }

    public class UserInfo {
        public String username;
        public String password;
        public int userAttribute;
        public int userChAttribute;
    }

    public class VideoCtrl {
        public byte[] Attr;
        public byte Version;
        public byte DCLevel;
        public byte AGC;
        public byte BLC;
        public byte DSS;
        public byte WB;
        public byte Shutter;
        public byte Strobe;
        public byte AGCVal;
        public byte DSSVal;
        public byte ShutterVal;
        public byte DNN;
        public byte ElcLevel;
        public byte DCLevelBase;
        public byte Lens;
    }
}

