/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import com.wgi.libwebeye.AUD;
import com.wgi.libwebeye.BS;
import com.wgi.libwebeye.NAL;
import com.wgi.libwebeye.PPS;
import com.wgi.libwebeye.SEI;
import com.wgi.libwebeye.SLICE;
import com.wgi.libwebeye.SPS;
import com.wgi.libwebeye.h264Stream;

public class H264Analyzer {
    static final int NAL_UNIT_TYPE_UNSPECIFIED = 0;
    static final int NAL_UNIT_TYPE_CODED_SLICE_NON_IDR = 1;
    static final int NAL_UNIT_TYPE_CODED_SLICE_DATA_PARTITION_A = 2;
    static final int NAL_UNIT_TYPE_CODED_SLICE_DATA_PARTITION_B = 3;
    static final int NAL_UNIT_TYPE_CODED_SLICE_DATA_PARTITION_C = 4;
    static final int NAL_UNIT_TYPE_CODED_SLICE_IDR = 5;
    static final int NAL_UNIT_TYPE_SEI = 6;
    static final int NAL_UNIT_TYPE_SPS = 7;
    static final int NAL_UNIT_TYPE_PPS = 8;
    static final int NAL_UNIT_TYPE_AUD = 9;
    static final int NAL_UNIT_TYPE_END_OF_SEQUENCE = 10;
    static final int NAL_UNIT_TYPE_END_OF_STREAM = 11;
    static final int NAL_UNIT_TYPE_FILLER = 12;
    static final int NAL_UNIT_TYPE_SPS_EXT = 13;
    static final int NAL_UNIT_TYPE_CODED_SLICE_AUX = 19;
    static final int SH_SLICE_TYPE_P = 0;
    static final int SH_SLICE_TYPE_B = 1;
    static final int SH_SLICE_TYPE_I = 2;
    static final int SH_SLICE_TYPE_SP = 3;
    static final int SH_SLICE_TYPE_SI = 4;
    static final int SH_SLICE_TYPE_P_ONLY = 5;
    static final int SH_SLICE_TYPE_B_ONLY = 6;
    static final int SH_SLICE_TYPE_I_ONLY = 7;
    static final int SH_SLICE_TYPE_SP_ONLY = 8;
    static final int SH_SLICE_TYPE_SI_ONLY = 9;
    static final int SAR_Unspecified = 0;
    static final int SAR_1_1 = 1;
    static final int SAR_12_11 = 2;
    static final int SAR_10_11 = 3;
    static final int SAR_16_11 = 4;
    static final int SAR_40_33 = 5;
    static final int SAR_24_11 = 6;
    static final int SAR_20_11 = 7;
    static final int SAR_32_11 = 8;
    static final int SAR_80_33 = 9;
    static final int SAR_18_11 = 10;
    static final int SAR_15_11 = 11;
    static final int SAR_64_33 = 12;
    static final int SAR_160_99 = 13;
    static final int SAR_Extended = 255;
    static final int RPLR_IDC_ABS_DIFF_ADD = 0;
    static final int RPLR_IDC_ABS_DIFF_SUBTRACT = 1;
    static final int RPLR_IDC_LONG_TERM = 2;
    static final int RPLR_IDC_END = 3;
    static final int MMCO_END = 0;
    static final int MMCO_SHORT_TERM_UNUSED = 1;
    static final int MMCO_LONG_TERM_UNUSED = 2;
    static final int MMCO_SHORT_TERM_TO_LONG_TERM = 3;
    static final int MMCO_LONG_TERM_MAX_INDEX = 4;
    static final int MMCO_ALL_UNUSED = 5;
    static final int MMCO_CURRENT_TO_LONG_TERM = 6;
    static final int AUD_PRIMARY_PIC_TYPE_I = 0;
    static final int AUD_PRIMARY_PIC_TYPE_IP = 1;
    static final int AUD_PRIMARY_PIC_TYPE_IPB = 2;
    static final int AUD_PRIMARY_PIC_TYPE_SI = 3;
    static final int AUD_PRIMARY_PIC_TYPE_SISP = 4;
    static final int AUD_PRIMARY_PIC_TYPE_ISI = 5;
    static final int AUD_PRIMARY_PIC_TYPE_ISIPSP = 6;
    static final int AUD_PRIMARY_PIC_TYPE_ISIPSPB = 7;
    static final int SEI_TYPE_BUFFERING_PERIOD = 0;
    static final int SEI_TYPE_PIC_TIMING = 1;
    static final int SEI_TYPE_PAN_SCAN_RECT = 2;
    static final int SEI_TYPE_FILLER_PAYLOAD = 3;
    static final int SEI_TYPE_USER_DATA_REGISTERED_ITU_T_T35 = 4;
    static final int SEI_TYPE_USER_DATA_UNREGISTERED = 5;
    static final int SEI_TYPE_RECOVERY_POINT = 6;
    static final int SEI_TYPE_DEC_REF_PIC_MARKING_REPETITION = 7;
    static final int SEI_TYPE_SPARE_PIC = 8;
    static final int SEI_TYPE_SCENE_INFO = 9;
    static final int SEI_TYPE_SUB_SEQ_INFO = 10;
    static final int SEI_TYPE_SUB_SEQ_LAYER_CHARACTERISTICS = 11;
    static final int SEI_TYPE_SUB_SEQ_CHARACTERISTICS = 12;
    static final int SEI_TYPE_FULL_FRAME_FREEZE = 13;
    static final int SEI_TYPE_FULL_FRAME_FREEZE_RELEASE = 14;
    static final int SEI_TYPE_FULL_FRAME_SNAPSHOT = 15;
    static final int SEI_TYPE_PROGRESSIVE_REFINEMENT_SEGMENT_START = 16;
    static final int SEI_TYPE_PROGRESSIVE_REFINEMENT_SEGMENT_END = 17;
    static final int SEI_TYPE_MOTION_CONSTRAINED_SLICE_GROUP_SET = 18;
    static final int SEI_TYPE_FILM_GRAIN_CHARACTERISTICS = 19;
    static final int SEI_TYPE_DEBLOCKING_FILTER_DISPLAY_PREFERENCE = 20;
    static final int SEI_TYPE_STEREO_VIDEO_INFO = 21;
    int nal_start = 0;
    int nal_end = 0;
    int image_width = -1;
    int image_height = -1;

    public H264Analyzer(byte[] buf, int size1) {
        h264Stream h = this.h264_new();
        int rsz = size1;
        int sz = 0;
        sz += rsz;
        boolean checker = false;
        this.nal_end = 0;
        this.nal_start = 0;
        while (this.find_nal_unit(buf, sz) > 0) {
            int size = this.nal_end - this.nal_start;
            char[] temp_buf = new char[size];
            int i = 0;
            while (i < size) {
                temp_buf[i] = (char)buf[this.nal_start + i];
                ++i;
            }
            this.read_nal_unit(h, temp_buf, size);
            if (h.myNAL.nal_unit_type == 7) {
                this.image_width = (h.mySPS.pic_width_in_mbs_minus1 + 1) * 16 - h.mySPS.frame_crop_left_offset * 2 - h.mySPS.frame_crop_right_offset * 2;
                int y = 2 * (2 - h.mySPS.frame_mbs_only_flag);
                this.image_height = (2 - h.mySPS.frame_mbs_only_flag) * (h.mySPS.pic_height_in_map_units_minus1 + 1) * 16 - (h.mySPS.frame_crop_top_offset + h.mySPS.frame_crop_bottom_offset) * y;
                break;
            }
            this.nal_start = this.nal_end;
            sz -= this.nal_end;
        }
    }

    void debug_sps(SPS sps) {
        System.out.println("======= SPS =======\n");
        System.out.println(" profile_idc : " + sps.profile_idc);
        System.out.println(" constraint_set0_flag : " + sps.constraint_set0_flag);
        System.out.println(" constraint_set1_flag : " + sps.constraint_set1_flag);
        System.out.println(" constraint_set2_flag : " + sps.constraint_set2_flag);
        System.out.println(" constraint_set3_flag : " + sps.constraint_set3_flag);
        System.out.println(" reserved_zero_4bits : " + sps.reserved_zero_4bits);
        System.out.println(" level_idc : " + sps.level_idc);
        System.out.println(" seq_parameter_set_id : " + sps.seq_parameter_set_id);
        System.out.println(" chroma_format_idc : " + sps.chroma_format_idc);
        System.out.println(" residual_colour_transform_flag : " + sps.residual_colour_transform_flag);
        System.out.println(" bit_depth_luma_minus8 : " + sps.bit_depth_luma_minus8);
        System.out.println(" bit_depth_chroma_minus8 : " + sps.bit_depth_chroma_minus8);
        System.out.println(" qpprime_y_zero_transform_bypass_flag : " + sps.qpprime_y_zero_transform_bypass_flag);
        System.out.println(" seq_scaling_matrix_present_flag : " + sps.seq_scaling_matrix_present_flag);
        System.out.println(" log2_max_frame_num_minus4 : " + sps.log2_max_frame_num_minus4);
        System.out.println(" pic_order_cnt_type : " + sps.pic_order_cnt_type);
        System.out.println("   log2_max_pic_order_cnt_lsb_minus4 : " + sps.log2_max_pic_order_cnt_lsb_minus4);
        System.out.println("   delta_pic_order_always_zero_flag : " + sps.delta_pic_order_always_zero_flag);
        System.out.println("   offset_for_non_ref_pic : " + sps.offset_for_non_ref_pic);
        System.out.println("   offset_for_top_to_bottom_field : " + sps.offset_for_top_to_bottom_field);
        System.out.println("   num_ref_frames_in_pic_order_cnt_cycle : " + sps.num_ref_frames_in_pic_order_cnt_cycle);
        System.out.println(" num_ref_frames : " + sps.num_ref_frames);
        System.out.println(" gaps_in_frame_num_value_allowed_flag : " + sps.gaps_in_frame_num_value_allowed_flag);
        System.out.println(" pic_width_in_mbs_minus1 : " + sps.pic_width_in_mbs_minus1);
        System.out.println(" pic_height_in_map_units_minus1 : " + sps.pic_height_in_map_units_minus1);
        System.out.println(" frame_mbs_only_flag : " + sps.frame_mbs_only_flag);
        System.out.println(" mb_adaptive_frame_field_flag : " + sps.mb_adaptive_frame_field_flag);
        System.out.println(" direct_8x8_inference_flag : " + sps.direct_8x8_inference_flag);
        System.out.println(" frame_cropping_flag : " + sps.frame_cropping_flag);
        System.out.println("   frame_crop_left_offset : " + sps.frame_crop_left_offset);
        System.out.println("   frame_crop_right_offset : " + sps.frame_crop_right_offset);
        System.out.println("   frame_crop_top_offset : " + sps.frame_crop_top_offset);
        System.out.println("   frame_crop_bottom_offset : " + sps.frame_crop_bottom_offset);
        System.out.println(" vui_parameters_present_flag : " + sps.vui_parameters_present_flag);
    }

    void debug_pps(PPS pps) {
        System.out.println("======= PPS =======\n");
        System.out.println(" pic_parameter_set_id : " + pps.pic_parameter_set_id);
        System.out.println(" seq_parameter_set_id : " + pps.seq_parameter_set_id);
        System.out.println(" entropy_coding_mode_flag : " + pps.entropy_coding_mode_flag);
        System.out.println(" pic_order_present_flag : " + pps.pic_order_present_flag);
        System.out.println(" num_slice_groups_minus1 : " + pps.num_slice_groups_minus1);
        System.out.println(" slice_group_map_type : " + pps.slice_group_map_type);
        System.out.println(" num_ref_idx_l0_active_minus1 : " + pps.num_ref_idx_l0_active_minus1);
        System.out.println(" num_ref_idx_l1_active_minus1 : " + pps.num_ref_idx_l1_active_minus1);
        System.out.println(" weighted_pred_flag : " + pps.weighted_pred_flag);
        System.out.println(" weighted_bipred_idc : " + pps.weighted_bipred_idc);
        System.out.println(" pic_init_qp_minus26 : " + pps.pic_init_qp_minus26);
        System.out.println(" pic_init_qs_minus26 : " + pps.pic_init_qs_minus26);
        System.out.println(" chroma_qp_index_offset : " + pps.chroma_qp_index_offset);
        System.out.println(" deblocking_filter_control_present_flag : " + pps.deblocking_filter_control_present_flag);
        System.out.println(" constrained_intra_pred_flag : " + pps.constrained_intra_pred_flag);
        System.out.println(" redundant_pic_cnt_present_flag : " + pps.redundant_pic_cnt_present_flag);
        System.out.println(" transform_8x8_mode_flag : " + pps.transform_8x8_mode_flag);
        System.out.println(" pic_scaling_matrix_present_flag : " + pps.pic_scaling_matrix_present_flag);
        System.out.println(" second_chroma_qp_index_offset : " + pps.second_chroma_qp_index_offset);
    }

    void debug_slice_header(SLICE sh) {
        String slice_type_name;
        System.out.println("======= Slice Header =======");
        System.out.println(" first_mb_in_slice : " + sh.first_mb_in_slice);
        switch (sh.slice_type) {
            case 0: {
                slice_type_name = "P slice";
                break;
            }
            case 1: {
                slice_type_name = "B slice";
                break;
            }
            case 2: {
                slice_type_name = "I slice";
                break;
            }
            case 3: {
                slice_type_name = "SP slice";
                break;
            }
            case 4: {
                slice_type_name = "SI slice";
                break;
            }
            case 5: {
                slice_type_name = "P slice only";
                break;
            }
            case 6: {
                slice_type_name = "B slice only";
                break;
            }
            case 7: {
                slice_type_name = "I slice only";
                break;
            }
            case 8: {
                slice_type_name = "SP slice only";
                break;
            }
            case 9: {
                slice_type_name = "SI slice only";
                break;
            }
            default: {
                slice_type_name = "Unknown";
            }
        }
        System.out.println(" slice_type : " + sh.slice_type + "( " + slice_type_name + " )");
        System.out.println(" pic_parameter_set_id : " + sh.pic_parameter_set_id);
        System.out.println(" frame_num : " + sh.frame_num);
        System.out.println(" field_pic_flag : " + sh.field_pic_flag);
        System.out.println(" bottom_field_flag : " + sh.bottom_field_flag);
        System.out.println(" idr_pic_id : " + sh.idr_pic_id);
        System.out.println(" pic_order_cnt_lsb : " + sh.pic_order_cnt_lsb);
        System.out.println(" delta_pic_order_cnt_bottom : " + sh.delta_pic_order_cnt_bottom);
        System.out.println(" redundant_pic_cnt : " + sh.redundant_pic_cnt);
        System.out.println(" direct_spatial_mv_pred_flag : " + sh.direct_spatial_mv_pred_flag);
        System.out.println(" num_ref_idx_active_override_flag : " + sh.num_ref_idx_active_override_flag);
        System.out.println(" num_ref_idx_l0_active_minus1 : " + sh.num_ref_idx_l0_active_minus1);
        System.out.println(" num_ref_idx_l1_active_minus1 : " + sh.num_ref_idx_l1_active_minus1);
        System.out.println(" cabac_init_idc : " + sh.cabac_init_idc);
        System.out.println(" slice_qp_delta : " + sh.slice_qp_delta);
        System.out.println(" sp_for_switch_flag : " + sh.sp_for_switch_flag);
        System.out.println(" slice_qs_delta : " + sh.slice_qs_delta);
        System.out.println(" disable_deblocking_filter_idc : " + sh.disable_deblocking_filter_idc);
        System.out.println(" slice_alpha_c0_offset_div2 : " + sh.slice_alpha_c0_offset_div2);
        System.out.println(" slice_beta_offset_div2 : " + sh.slice_beta_offset_div2);
        System.out.println(" slice_group_change_cycle : " + sh.slice_group_change_cycle);
        System.out.println("=== Prediction Weight Table ===\n");
        System.out.println(" luma_log2_weight_denom : " + sh.myPWT.luma_log2_weight_denom);
        System.out.println(" chroma_log2_weight_denom : " + sh.myPWT.chroma_log2_weight_denom);
        System.out.println(" luma_weight_l0_flag : " + sh.myPWT.luma_weight_l0_flag);
        System.out.println(" chroma_weight_l0_flag : " + sh.myPWT.chroma_weight_l0_flag);
        System.out.println(" luma_weight_l1_flag : " + sh.myPWT.luma_weight_l1_flag);
        System.out.println(" chroma_weight_l1_flag : " + sh.myPWT.chroma_weight_l1_flag);
        System.out.println("=== Ref Pic List Reordering ===\n");
        System.out.println(" ref_pic_list_reordering_flag_l0 : " + sh.myRPLR.ref_pic_list_reordering_flag_l0);
        System.out.println(" ref_pic_list_reordering_flag_l1 : " + sh.myRPLR.ref_pic_list_reordering_flag_l1);
        System.out.println("=== Decoded Ref Pic Marking ===\n");
        System.out.println(" no_output_of_prior_pics_flag : " + sh.myDRPM.no_output_of_prior_pics_flag);
        System.out.println(" long_term_reference_flag : " + sh.myDRPM.long_term_reference_flag);
        System.out.println(" adaptive_ref_pic_marking_mode_flag : " + sh.myDRPM.adaptive_ref_pic_marking_mode_flag);
    }

    void debug_aud(AUD aud) {
        String primary_pic_type_name;
        System.out.println("======= Access Unit Delimiter =======\n");
        switch (aud.primary_pic_type) {
            case 0: {
                primary_pic_type_name = "I";
                break;
            }
            case 1: {
                primary_pic_type_name = "I, P";
                break;
            }
            case 2: {
                primary_pic_type_name = "I, P, B";
                break;
            }
            case 3: {
                primary_pic_type_name = "SI";
                break;
            }
            case 4: {
                primary_pic_type_name = "SI, SP";
                break;
            }
            case 5: {
                primary_pic_type_name = "I, SI";
                break;
            }
            case 6: {
                primary_pic_type_name = "I, SI, P, SP";
                break;
            }
            case 7: {
                primary_pic_type_name = "I, SI, P, SP, B";
                break;
            }
            default: {
                primary_pic_type_name = "Unknown";
            }
        }
        System.out.println(" primary_pic_type : " + aud.primary_pic_type + "(" + primary_pic_type_name + ")");
    }

    void debug_seis(SEI[] seis, int num_seis) {
        System.out.println("======= SEI =======\n");
        int i = 0;
        while (i < num_seis) {
            String sei_type_name;
            SEI s = seis[i];
            switch (s.payloadType) {
                case 0: {
                    sei_type_name = "Buffering period";
                    break;
                }
                case 1: {
                    sei_type_name = "Pic timing";
                    break;
                }
                case 2: {
                    sei_type_name = "Pan scan rect";
                    break;
                }
                case 3: {
                    sei_type_name = "Filler payload";
                    break;
                }
                case 4: {
                    sei_type_name = "User data registered ITU-T T35";
                    break;
                }
                case 5: {
                    sei_type_name = "User data unregistered";
                    break;
                }
                case 6: {
                    sei_type_name = "Recovery point";
                    break;
                }
                case 7: {
                    sei_type_name = "Dec ref pic marking repetition";
                    break;
                }
                case 8: {
                    sei_type_name = "Spare pic";
                    break;
                }
                case 9: {
                    sei_type_name = "Scene info";
                    break;
                }
                case 10: {
                    sei_type_name = "Sub seq info";
                    break;
                }
                case 11: {
                    sei_type_name = "Sub seq layer characteristics";
                    break;
                }
                case 12: {
                    sei_type_name = "Sub seq characteristics";
                    break;
                }
                case 13: {
                    sei_type_name = "Full frame freeze";
                    break;
                }
                case 14: {
                    sei_type_name = "Full frame freeze release";
                    break;
                }
                case 15: {
                    sei_type_name = "Full frame snapshot";
                    break;
                }
                case 16: {
                    sei_type_name = "Progressive refinement segment start";
                    break;
                }
                case 17: {
                    sei_type_name = "Progressive refinement segment end";
                    break;
                }
                case 18: {
                    sei_type_name = "Motion constrained slice group set";
                    break;
                }
                case 19: {
                    sei_type_name = "Film grain characteristics";
                    break;
                }
                case 20: {
                    sei_type_name = "Deblocking filter display preference";
                    break;
                }
                case 21: {
                    sei_type_name = "Stereo video info";
                    break;
                }
                default: {
                    sei_type_name = "Unknown";
                }
            }
            System.out.println("=== " + sei_type_name + " ===\n");
            System.out.println(" payloadType : " + s.payloadType);
            System.out.println(" payloadSize : " + s.payloadSize);
            System.out.println(" payload : ");
            this.debug_bytes(s.payload, s.payloadSize);
            ++i;
        }
    }

    void debug_nal(h264Stream h, NAL nal) {
        String nal_unit_type_name;
        System.out.println("==================== NAL ====================\n");
        System.out.println(" forbidden_zero_bit : " + nal.forbidden_zero_bit);
        System.out.println(" nal_ref_idc : " + nal.nal_ref_idc);
        switch (nal.nal_unit_type) {
            case 0: {
                nal_unit_type_name = "Unspecified";
                break;
            }
            case 1: {
                nal_unit_type_name = "Coded slice of a non-IDR picture";
                break;
            }
            case 2: {
                nal_unit_type_name = "Coded slice data partition A";
                break;
            }
            case 3: {
                nal_unit_type_name = "Coded slice data partition B";
                break;
            }
            case 4: {
                nal_unit_type_name = "Coded slice data partition C";
                break;
            }
            case 5: {
                nal_unit_type_name = "Coded slice of an IDR picture";
                break;
            }
            case 6: {
                nal_unit_type_name = "Supplemental enhancement information (SEI)";
                break;
            }
            case 7: {
                nal_unit_type_name = "Sequence parameter set";
                break;
            }
            case 8: {
                nal_unit_type_name = "Picture parameter set";
                break;
            }
            case 9: {
                nal_unit_type_name = "Access unit delimiter";
                break;
            }
            case 10: {
                nal_unit_type_name = "End of sequence";
                break;
            }
            case 11: {
                nal_unit_type_name = "End of stream";
                break;
            }
            case 12: {
                nal_unit_type_name = "Filler data";
                break;
            }
            case 13: {
                nal_unit_type_name = "Sequence parameter set extension";
                break;
            }
            case 19: {
                nal_unit_type_name = "Coded slice of an auxiliary coded picture without partitioning";
                break;
            }
            default: {
                nal_unit_type_name = "Unknown";
            }
        }
        System.out.println(" nal_unit_type : " + nal.nal_unit_type + "(" + nal_unit_type_name + ")");
        if (nal.nal_unit_type == 1) {
            this.debug_slice_header(h.mySLICE);
        } else if (nal.nal_unit_type == 5) {
            this.debug_slice_header(h.mySLICE);
        } else if (nal.nal_unit_type == 7) {
            this.debug_sps(h.mySPS);
        } else if (nal.nal_unit_type == 8) {
            this.debug_pps(h.myPPS);
        } else if (nal.nal_unit_type == 9) {
            this.debug_aud(h.myAUD);
        } else if (nal.nal_unit_type == 6) {
            this.debug_seis(h.mySEIs, h.num_seis);
        }
    }

    void debug_bytes(char[] buf, int len) {
        int i = 0;
        while (i < len) {
            System.out.println(" " + buf[i] + " ");
            if ((i + 1) % 16 == 0) {
                System.out.println("\n");
            }
            ++i;
        }
        System.out.println("\n");
    }

    void debug_bs(BS b) {
        BS b2 = new BS();
        this.bs_init(b2, b.bitStream, b.end - b.start);
        while (b2.p < b.p || b2.p == b.p && b2.bits_left > b.bits_left) {
            System.out.println(this.bs_read_u1(b2));
            if (b2.bits_left != 8) continue;
            System.out.println(" ");
        }
        b2 = null;
    }

    public SEI sei_new() {
        SEI me = new SEI();
        me.payloadType = 0;
        me.payloadSize = 0;
        me.payload = null;
        return me;
    }

    public void sei_free(SEI sei) {
        if (sei.payload != null) {
            sei.payload = null;
        }
        sei = null;
    }

    public void read_sei_payload(h264Stream h264stream, BS bitStream, int payloadType, int payloadSize) {
        SEI mySEI = h264stream.mySEI;
        mySEI.payload = new char[payloadSize];
        int i = 0;
        while (i < payloadSize) {
            mySEI.payload[i] = (char)this.bs_read_u(bitStream, 8);
            ++i;
        }
    }

    int bs_byte_aligned(BS b) {
        if (b.bits_left == 8) {
            return 1;
        }
        return 0;
    }

    boolean bs_eof(BS b) {
        return b.p >= b.end;
    }

    int bs_pos(BS b) {
        return b.p - b.start;
    }

    BS bs_new(char[] startPos, int size) {
        BS b = new BS();
        this.bs_init(b, startPos, size);
        return b;
    }

    void bs_init(BS b, char[] startPos, int size) {
        b.start = 0;
        b.p = 0;
        b.end = size;
        b.bitStream = new char[size];
        int i = 0;
        while (i < size) {
            b.bitStream[i] = startPos[i];
            ++i;
        }
        b.bits_left = 8;
    }

    void bs_free(BS b) {
        if (b.bitStream != null) {
            b.bitStream = null;
        }
        b = null;
    }

    int bs_read_f(BS b, int n) {
        return this.bs_read_u(b, n);
    }

    int bs_read_u8(BS b) {
        return this.bs_read_u(b, 8);
    }

    int bs_read_ue(BS b) {
        int r = 0;
        int i = 0;
        while (this.bs_read_u1(b) == 0 && i < 32 && !this.bs_eof(b)) {
            ++i;
        }
        r = this.bs_read_u(b, i);
        return r += (1 << i) - 1;
    }

    int bs_read_se(BS b) {
        int r = this.bs_read_ue(b);
        r = (r & 1) == 1 ? (r + 1) / 2 : -(r / 2);
        return r;
    }

    int bs_read_u1(BS b) {
        int r = 0;
        if (this.bs_eof(b)) {
            return 0;
        }
        --b.bits_left;
        r = b.bitStream[b.p] >> b.bits_left & 1;
        if (b.bits_left == 0) {
            ++b.p;
            b.bits_left = 8;
        }
        return r;
    }

    int bs_read_u(BS b, int n) {
        int r = 0;
        int i = 0;
        while (i < n) {
            r |= this.bs_read_u1(b) << n - i - 1;
            ++i;
        }
        return r;
    }

    double log2(double x) {
        double temp = 1.0 / Math.log(2.0) * Math.log(x);
        return temp;
    }

    int is_slice_type(int slice_type, int cmp_type) {
        if (slice_type >= 5) {
            slice_type -= 5;
        }
        if (cmp_type >= 5) {
            cmp_type -= 5;
        }
        if (slice_type == cmp_type) {
            return 1;
        }
        return 0;
    }

    h264Stream h264_new() {
        h264Stream h = new h264Stream();
        h.myNAL = new NAL();
        h.mySPS = new SPS();
        h.myPPS = new PPS();
        h.myAUD = new AUD();
        h.mySLICE = new SLICE();
        h.num_seis = 0;
        h.mySEIs = null;
        return h;
    }

    void h264_free(h264Stream h) {
        h.myNAL = null;
        h.mySPS = null;
        h.myPPS = null;
        h.myAUD = null;
        h.mySLICE = null;
        int i = 0;
        while (i < h.num_seis) {
            this.sei_free(h.mySEIs[i]);
            ++i;
        }
        h.mySEIs = null;
        h = null;
    }

    int find_nal_unit(byte[] buf, int size) {
        int i = 0;
        while (!(buf[i] == 0 && buf[i + 1] == 0 && buf[i + 2] == 1 || buf[i] == 0 && buf[i + 1] == 0 && buf[i + 2] == 0 && buf[i + 3] == 1)) {
            if (++i + 4 < size) continue;
            return 0;
        }
        if (buf[i] != 0 || buf[i + 1] != 0 || buf[i + 2] != 1) {
            ++i;
        }
        if (buf[i] != 0 || buf[i + 1] != 0 || buf[i + 2] != 1) {
            return 0;
        }
        this.nal_start += (i += 3);
        while (!(buf[i] == 0 && buf[i + 1] == 0 && buf[i + 2] == 0 || buf[i] == 0 && buf[i + 1] == 0 && buf[i + 2] == 1)) {
            if (++i + 3 < size) continue;
            this.nal_end += size;
            return -1;
        }
        this.nal_end += i;
        return this.nal_end - this.nal_start;
    }

    boolean more_rbsp_data(h264Stream h, BS b) {
        return !this.bs_eof(b);
    }

    int next_bits(BS b, int n) {
        return 0;
    }

    void rbsp_to_nal(char[] rbsp_buf, int rbsp_size, char[] nal_buf, int nal_size) {
        int i = 1;
        int j = 0;
        while (i < nal_size && j < rbsp_size) {
            if (i + 3 < nal_size && j + 2 < rbsp_size && rbsp_buf[j] == '\u0000' && rbsp_buf[j + 1] == '\u0000' && (rbsp_buf[j + 2] == '\u0001' || rbsp_buf[j + 2] == '\u0002' || rbsp_buf[j + 2] == '\u0003')) {
                nal_buf[i] = rbsp_buf[j];
                nal_buf[i + 1] = rbsp_buf[j + 1];
                nal_buf[i + 2] = 3;
                nal_buf[i + 3] = rbsp_buf[j + 2];
                i += 4;
                j += 3;
                continue;
            }
            if (j == rbsp_size - 1 && rbsp_buf[j] == '\u0000') {
                nal_buf[i] = 3;
                ++i;
                continue;
            }
            nal_buf[i] = rbsp_buf[j];
            ++i;
            ++j;
        }
        nal_size = i;
    }

    int nal_to_rbsp(char[] nal_buf, int nal_size, char[] rbsp_buf, int rbsp_size) {
        int i = 1;
        int j = 0;
        while (i < nal_size) {
            if (i + 2 < nal_size && nal_buf[i] == '\u0000' && nal_buf[i + 1] == '\u0000' && nal_buf[i + 2] == '\u0003') {
                rbsp_buf[j] = nal_buf[i];
                rbsp_buf[j + 1] = nal_buf[i + 1];
                i += 3;
                j += 2;
                continue;
            }
            if (i + 2 < nal_size && nal_buf[i] == '\u0000' && nal_buf[i + 1] == '\u0000' && nal_buf[i + 2] == '\u0001') break;
            rbsp_buf[j] = nal_buf[i];
            ++i;
            ++j;
        }
        nal_size = i;
        rbsp_size = j;
        return j;
    }

    int read_nal_unit(h264Stream h, char[] buf, int size) {
        int rbsp_size = 0;
        int nal_size = size;
        NAL nal = h.myNAL;
        BS b = this.bs_new(buf, size);
        nal.forbidden_zero_bit = this.bs_read_f(b, 1);
        nal.nal_ref_idc = this.bs_read_u(b, 2);
        nal.nal_unit_type = this.bs_read_u(b, 5);
        this.bs_free(b);
        char[] rbsp_buf = new char[size];
        rbsp_size = this.nal_to_rbsp(buf, nal_size, rbsp_buf, rbsp_size);
        b = this.bs_new(rbsp_buf, rbsp_size);
        if (nal.nal_unit_type != 0) {
            if (nal.nal_unit_type == 1) {
                this.read_slice_layer_rbsp(h, b);
            } else if (nal.nal_unit_type != 2 && nal.nal_unit_type != 3 && nal.nal_unit_type != 4) {
                if (nal.nal_unit_type == 5) {
                    this.read_slice_layer_rbsp(h, b);
                } else if (nal.nal_unit_type == 6) {
                    this.read_sei_rbsp(h, b);
                } else if (nal.nal_unit_type == 7) {
                    this.read_seq_parameter_set_rbsp(h, b);
                } else if (nal.nal_unit_type == 8) {
                    this.read_pic_parameter_set_rbsp(h, b);
                } else if (nal.nal_unit_type == 9) {
                    this.read_access_unit_delimiter_rbsp(h, b);
                } else if (nal.nal_unit_type == 10) {
                    this.read_end_of_seq_rbsp(h, b);
                } else if (nal.nal_unit_type == 11) {
                    this.read_end_of_stream_rbsp(h, b);
                } else if (nal.nal_unit_type != 12 && nal.nal_unit_type != 13 && nal.nal_unit_type == 19) {
                    this.read_slice_layer_rbsp(h, b);
                }
            }
        }
        this.bs_free(b);
        rbsp_buf = null;
        return nal_size;
    }

    void read_seq_parameter_set_rbsp(h264Stream h, BS b) {
        int i;
        SPS sps = h.mySPS;
        sps.profile_idc = this.bs_read_u8(b);
        sps.constraint_set0_flag = this.bs_read_u1(b);
        sps.constraint_set1_flag = this.bs_read_u1(b);
        sps.constraint_set2_flag = this.bs_read_u1(b);
        sps.constraint_set3_flag = this.bs_read_u1(b);
        sps.reserved_zero_4bits = this.bs_read_u(b, 4);
        sps.level_idc = this.bs_read_u8(b);
        sps.seq_parameter_set_id = this.bs_read_ue(b);
        if (sps.profile_idc == 100 || sps.profile_idc == 110 || sps.profile_idc == 122 || sps.profile_idc == 144) {
            sps.chroma_format_idc = this.bs_read_ue(b);
            if (sps.chroma_format_idc == 3) {
                sps.residual_colour_transform_flag = this.bs_read_u1(b);
            }
            sps.bit_depth_luma_minus8 = this.bs_read_ue(b);
            sps.bit_depth_chroma_minus8 = this.bs_read_ue(b);
            sps.qpprime_y_zero_transform_bypass_flag = this.bs_read_u1(b);
            sps.seq_scaling_matrix_present_flag = this.bs_read_u1(b);
            if (sps.seq_scaling_matrix_present_flag == 1) {
                i = 0;
                while (i < 8) {
                    sps.seq_scaling_list_present_flag[i] = this.bs_read_u1(b);
                    if (sps.seq_scaling_list_present_flag[i] == 1) {
                        if (i < 6) {
                            this.read_scaling_list(b, sps.ScalingList4x4[i], 16, sps.UseDefaultScalingMatrix4x4Flag[i]);
                        } else {
                            this.read_scaling_list(b, sps.ScalingList8x8[i - 6], 64, sps.UseDefaultScalingMatrix8x8Flag[i - 6]);
                        }
                    }
                    ++i;
                }
            }
        }
        sps.log2_max_frame_num_minus4 = this.bs_read_ue(b);
        sps.pic_order_cnt_type = this.bs_read_ue(b);
        if (sps.pic_order_cnt_type == 0) {
            sps.log2_max_pic_order_cnt_lsb_minus4 = this.bs_read_ue(b);
        } else if (sps.pic_order_cnt_type == 1) {
            sps.delta_pic_order_always_zero_flag = this.bs_read_u1(b);
            sps.offset_for_non_ref_pic = this.bs_read_se(b);
            sps.offset_for_top_to_bottom_field = this.bs_read_se(b);
            sps.num_ref_frames_in_pic_order_cnt_cycle = this.bs_read_ue(b);
            i = 0;
            while (i < sps.num_ref_frames_in_pic_order_cnt_cycle) {
                sps.offset_for_ref_frame[i] = this.bs_read_se(b);
                ++i;
            }
        }
        sps.num_ref_frames = this.bs_read_ue(b);
        sps.gaps_in_frame_num_value_allowed_flag = this.bs_read_u1(b);
        sps.pic_width_in_mbs_minus1 = this.bs_read_ue(b);
        sps.pic_height_in_map_units_minus1 = this.bs_read_ue(b);
        sps.frame_mbs_only_flag = this.bs_read_u1(b);
        if (sps.frame_mbs_only_flag != 1) {
            sps.mb_adaptive_frame_field_flag = this.bs_read_u1(b);
        }
        sps.direct_8x8_inference_flag = this.bs_read_u1(b);
        sps.frame_cropping_flag = this.bs_read_u1(b);
        if (sps.frame_cropping_flag == 1) {
            sps.frame_crop_left_offset = this.bs_read_ue(b);
            sps.frame_crop_right_offset = this.bs_read_ue(b);
            sps.frame_crop_top_offset = this.bs_read_ue(b);
            sps.frame_crop_bottom_offset = this.bs_read_ue(b);
        }
        sps.vui_parameters_present_flag = this.bs_read_u1(b);
        if (sps.vui_parameters_present_flag == 1) {
            this.read_vui_parameters(h, b);
        }
        this.read_rbsp_trailing_bits(h, b);
    }

    void read_scaling_list(BS b, int[] scalingList, int sizeOfScalingList, int useDefaultScalingMatrixFlag) {
        int lastScale = 8;
        int nextScale = 8;
        int j = 0;
        while (j < sizeOfScalingList) {
            if (nextScale != 0) {
                int delta_scale = this.bs_read_se(b);
                nextScale = (lastScale + delta_scale + 256) % 256;
                useDefaultScalingMatrixFlag = j == 0 && nextScale == 0 ? 1 : 0;
            }
            scalingList[j] = nextScale == 0 ? lastScale : nextScale;
            lastScale = scalingList[j];
            ++j;
        }
    }

    void read_vui_parameters(h264Stream h, BS b) {
        SPS sps = h.mySPS;
        sps.myVUI.aspect_ratio_info_present_flag = this.bs_read_u1(b);
        if (sps.myVUI.aspect_ratio_info_present_flag == 1) {
            sps.myVUI.aspect_ratio_idc = this.bs_read_u8(b);
            if (sps.myVUI.aspect_ratio_idc == 255) {
                sps.myVUI.sar_width = this.bs_read_u(b, 16);
                sps.myVUI.sar_height = this.bs_read_u(b, 16);
            }
        }
        sps.myVUI.overscan_info_present_flag = this.bs_read_u1(b);
        if (sps.myVUI.overscan_info_present_flag == 1) {
            sps.myVUI.overscan_appropriate_flag = this.bs_read_u1(b);
        }
        sps.myVUI.video_signal_type_present_flag = this.bs_read_u1(b);
        if (sps.myVUI.video_signal_type_present_flag == 1) {
            sps.myVUI.video_format = this.bs_read_u(b, 3);
            sps.myVUI.video_full_range_flag = this.bs_read_u1(b);
            sps.myVUI.colour_description_present_flag = this.bs_read_u1(b);
            if (sps.myVUI.colour_description_present_flag == 1) {
                sps.myVUI.colour_primaries = this.bs_read_u8(b);
                sps.myVUI.transfer_characteristics = this.bs_read_u8(b);
                sps.myVUI.matrix_coefficients = this.bs_read_u8(b);
            }
        }
        sps.myVUI.chroma_loc_info_present_flag = this.bs_read_u1(b);
        if (sps.myVUI.chroma_loc_info_present_flag == 1) {
            sps.myVUI.chroma_sample_loc_type_top_field = this.bs_read_ue(b);
            sps.myVUI.chroma_sample_loc_type_bottom_field = this.bs_read_ue(b);
        }
        sps.myVUI.timing_info_present_flag = this.bs_read_u1(b);
        if (sps.myVUI.timing_info_present_flag == 1) {
            sps.myVUI.num_units_in_tick = this.bs_read_u(b, 32);
            sps.myVUI.time_scale = this.bs_read_u(b, 32);
            sps.myVUI.fixed_frame_rate_flag = this.bs_read_u1(b);
        }
        sps.myVUI.nal_hrd_parameters_present_flag = this.bs_read_u1(b);
        if (sps.myVUI.nal_hrd_parameters_present_flag == 1) {
            this.read_hrd_parameters(h, b);
        }
        sps.myVUI.vcl_hrd_parameters_present_flag = this.bs_read_u1(b);
        if (sps.myVUI.vcl_hrd_parameters_present_flag == 1) {
            this.read_hrd_parameters(h, b);
        }
        if (sps.myVUI.nal_hrd_parameters_present_flag == 1 || sps.myVUI.vcl_hrd_parameters_present_flag == 1) {
            sps.myVUI.low_delay_hrd_flag = this.bs_read_u1(b);
        }
        sps.myVUI.pic_struct_present_flag = this.bs_read_u1(b);
        sps.myVUI.bitstream_restriction_flag = this.bs_read_u1(b);
        if (sps.myVUI.bitstream_restriction_flag == 1) {
            sps.myVUI.motion_vectors_over_pic_boundaries_flag = this.bs_read_u1(b);
            sps.myVUI.max_bytes_per_pic_denom = this.bs_read_ue(b);
            sps.myVUI.max_bits_per_mb_denom = this.bs_read_ue(b);
            sps.myVUI.log2_max_mv_length_horizontal = this.bs_read_ue(b);
            sps.myVUI.log2_max_mv_length_vertical = this.bs_read_ue(b);
            sps.myVUI.num_reorder_frames = this.bs_read_ue(b);
            sps.myVUI.max_dec_frame_buffering = this.bs_read_ue(b);
        }
    }

    void read_hrd_parameters(h264Stream h, BS b) {
        SPS sps = h.mySPS;
        sps.myHRD.cpb_cnt_minus1 = this.bs_read_ue(b);
        sps.myHRD.bit_rate_scale = this.bs_read_u(b, 4);
        sps.myHRD.cpb_size_scale = this.bs_read_u(b, 4);
        int SchedSelIdx = 0;
        while (SchedSelIdx <= sps.myHRD.cpb_cnt_minus1) {
            sps.myHRD.bit_rate_value_minus1[SchedSelIdx] = this.bs_read_ue(b);
            sps.myHRD.cpb_size_value_minus1[SchedSelIdx] = this.bs_read_ue(b);
            sps.myHRD.cbr_flag[SchedSelIdx] = this.bs_read_u1(b);
            ++SchedSelIdx;
        }
        sps.myHRD.initial_cpb_removal_delay_length_minus1 = this.bs_read_u(b, 5);
        sps.myHRD.cpb_removal_delay_length_minus1 = this.bs_read_u(b, 5);
        sps.myHRD.dpb_output_delay_length_minus1 = this.bs_read_u(b, 5);
        sps.myHRD.time_offset_length = this.bs_read_u(b, 5);
    }

    void read_pic_parameter_set_rbsp(h264Stream h, BS b) {
        int i;
        PPS pps = h.myPPS;
        pps.pic_parameter_set_id = this.bs_read_ue(b);
        pps.seq_parameter_set_id = this.bs_read_ue(b);
        pps.entropy_coding_mode_flag = this.bs_read_u1(b);
        pps.pic_order_present_flag = this.bs_read_u1(b);
        pps.num_slice_groups_minus1 = this.bs_read_ue(b);
        if (pps.num_slice_groups_minus1 > 0) {
            int i_group;
            pps.slice_group_map_type = this.bs_read_ue(b);
            if (pps.slice_group_map_type == 0) {
                i_group = 0;
                while (i_group <= pps.num_slice_groups_minus1) {
                    pps.run_length_minus1[i_group] = this.bs_read_ue(b);
                    ++i_group;
                }
            } else if (pps.slice_group_map_type == 2) {
                i_group = 0;
                while (i_group < pps.num_slice_groups_minus1) {
                    pps.top_left[i_group] = this.bs_read_ue(b);
                    pps.bottom_right[i_group] = this.bs_read_ue(b);
                    ++i_group;
                }
            } else if (pps.slice_group_map_type == 3 || pps.slice_group_map_type == 4 || pps.slice_group_map_type == 5) {
                pps.slice_group_change_direction_flag = this.bs_read_u1(b);
                pps.slice_group_change_rate_minus1 = this.bs_read_ue(b);
            } else if (pps.slice_group_map_type == 6) {
                pps.pic_size_in_map_units_minus1 = this.bs_read_ue(b);
                i = 0;
                while (i <= pps.pic_size_in_map_units_minus1) {
                    pps.slice_group_id[i] = this.bs_read_u(b, (int)Math.ceil(this.log2(pps.num_slice_groups_minus1 + 1)));
                    ++i;
                }
            }
        }
        pps.num_ref_idx_l0_active_minus1 = this.bs_read_ue(b);
        pps.num_ref_idx_l1_active_minus1 = this.bs_read_ue(b);
        pps.weighted_pred_flag = this.bs_read_u1(b);
        pps.weighted_bipred_idc = this.bs_read_u(b, 2);
        pps.pic_init_qp_minus26 = this.bs_read_se(b);
        pps.pic_init_qs_minus26 = this.bs_read_se(b);
        pps.chroma_qp_index_offset = this.bs_read_se(b);
        pps.deblocking_filter_control_present_flag = this.bs_read_u1(b);
        pps.constrained_intra_pred_flag = this.bs_read_u1(b);
        pps.redundant_pic_cnt_present_flag = this.bs_read_u1(b);
        if (this.more_rbsp_data(h, b)) {
            pps.transform_8x8_mode_flag = this.bs_read_u1(b);
            pps.pic_scaling_matrix_present_flag = this.bs_read_u1(b);
            if (pps.pic_scaling_matrix_present_flag == 1) {
                i = 0;
                while (i < 6 + 2 * pps.transform_8x8_mode_flag) {
                    pps.pic_scaling_list_present_flag[i] = this.bs_read_u1(b);
                    if (pps.pic_scaling_list_present_flag[i] == 1) {
                        if (i < 6) {
                            this.read_scaling_list(b, pps.ScalingList4x4[i], 16, pps.UseDefaultScalingMatrix4x4Flag[i]);
                        } else {
                            this.read_scaling_list(b, pps.ScalingList8x8[i - 6], 64, pps.UseDefaultScalingMatrix8x8Flag[i - 6]);
                        }
                    }
                    ++i;
                }
            }
            pps.second_chroma_qp_index_offset = this.bs_read_se(b);
        }
        this.read_rbsp_trailing_bits(h, b);
    }

    void read_sei_rbsp(h264Stream h, BS b) {
        int i = 0;
        while (i < h.num_seis) {
            this.sei_free(h.mySEIs[i]);
            ++i;
        }
        h.num_seis = 0;
        do {
            ++h.num_seis;
            h.mySEIs[h.num_seis - 1] = this.sei_new();
            h.mySEI = h.mySEIs[h.num_seis - 1];
            this.read_sei_message(h, b);
        } while (this.more_rbsp_data(h, b));
        this.read_rbsp_trailing_bits(h, b);
    }

    int _read_ff_coded_number(BS b) {
        int n2;
        int n1 = 0;
        do {
            n2 = this.bs_read_u8(b);
            n1 += n2;
        } while (n2 == 255);
        return n1;
    }

    void read_sei_message(h264Stream h, BS b) {
        h.mySEI.payloadType = this._read_ff_coded_number(b);
        h.mySEI.payloadSize = this._read_ff_coded_number(b);
        this.read_sei_payload(h, b, h.mySEI.payloadType, h.mySEI.payloadSize);
    }

    void read_access_unit_delimiter_rbsp(h264Stream h, BS b) {
        h.myAUD.primary_pic_type = this.bs_read_u(b, 3);
        this.read_rbsp_trailing_bits(h, b);
    }

    void read_end_of_seq_rbsp(h264Stream h, BS b) {
    }

    void read_end_of_stream_rbsp(h264Stream h, BS b) {
    }

    void read_filler_data_rbsp(h264Stream h, BS b) {
        while (this.next_bits(b, 8) == 255) {
            int n = this.bs_read_f(b, 8);
        }
        this.read_rbsp_trailing_bits(h, b);
    }

    void read_slice_layer_rbsp(h264Stream h, BS b) {
        this.read_slice_header(h, b);
    }

    boolean more_rbsp_trailing_data(h264Stream h, BS b) {
        return !this.bs_eof(b);
    }

    void read_rbsp_slice_trailing_bits(h264Stream h, BS b) {
        this.read_rbsp_trailing_bits(h, b);
        if (h.myPPS.entropy_coding_mode_flag == 1) {
            while (this.more_rbsp_trailing_data(h, b)) {
                int n = this.bs_read_f(b, 16);
            }
        }
    }

    void read_rbsp_trailing_bits(h264Stream h, BS b) {
        if (this.bs_byte_aligned(b) != 1) {
            int rbsp_stop_one_bit = this.bs_read_f(b, 1);
            while (this.bs_byte_aligned(b) != 1) {
                int n = this.bs_read_f(b, 1);
            }
        }
    }

    void read_slice_header(h264Stream h, BS b) {
        SLICE sh = h.mySLICE;
        SPS sps = h.mySPS;
        PPS pps = h.myPPS;
        NAL nal = h.myNAL;
        sh.first_mb_in_slice = this.bs_read_ue(b);
        sh.slice_type = this.bs_read_ue(b);
        sh.pic_parameter_set_id = this.bs_read_ue(b);
        sh.frame_num = this.bs_read_u(b, sps.log2_max_frame_num_minus4 + 4);
        if (sps.frame_mbs_only_flag != 1) {
            sh.field_pic_flag = this.bs_read_u1(b);
            if (sh.field_pic_flag == 1) {
                sh.bottom_field_flag = this.bs_read_u1(b);
            }
        }
        if (nal.nal_unit_type == 5) {
            sh.idr_pic_id = this.bs_read_ue(b);
        }
        if (sps.pic_order_cnt_type == 0) {
            sh.pic_order_cnt_lsb = this.bs_read_u(b, sps.log2_max_pic_order_cnt_lsb_minus4 + 4);
            if (pps.pic_order_present_flag == 1 && sh.field_pic_flag != 1) {
                sh.delta_pic_order_cnt_bottom = this.bs_read_se(b);
            }
        }
        if (sps.pic_order_cnt_type == 1 && sps.delta_pic_order_always_zero_flag != 1) {
            sh.delta_pic_order_cnt[0] = this.bs_read_se(b);
            if (pps.pic_order_present_flag == 1 && sh.field_pic_flag != 1) {
                sh.delta_pic_order_cnt[1] = this.bs_read_se(b);
            }
        }
        if (pps.redundant_pic_cnt_present_flag == 1) {
            sh.redundant_pic_cnt = this.bs_read_ue(b);
        }
        if (this.is_slice_type(sh.slice_type, 1) == 1) {
            sh.direct_spatial_mv_pred_flag = this.bs_read_u1(b);
        }
        if (this.is_slice_type(sh.slice_type, 0) == 1 || this.is_slice_type(sh.slice_type, 3) == 1 || this.is_slice_type(sh.slice_type, 1) == 1) {
            sh.num_ref_idx_active_override_flag = this.bs_read_u1(b);
            if (sh.num_ref_idx_active_override_flag == 1) {
                sh.num_ref_idx_l0_active_minus1 = this.bs_read_ue(b);
                if (this.is_slice_type(sh.slice_type, 1) == 1) {
                    sh.num_ref_idx_l1_active_minus1 = this.bs_read_ue(b);
                }
            }
        }
        this.read_ref_pic_list_reordering(h, b);
        if (pps.weighted_pred_flag == 1 && (this.is_slice_type(sh.slice_type, 0) == 1 || this.is_slice_type(sh.slice_type, 3) == 1) || pps.weighted_bipred_idc == 1 && this.is_slice_type(sh.slice_type, 1) == 1) {
            this.read_pred_weight_table(h, b);
        }
        if (nal.nal_ref_idc != 0) {
            this.read_dec_ref_pic_marking(h, b);
        }
        if (pps.entropy_coding_mode_flag == 1 && this.is_slice_type(sh.slice_type, 2) != 1 && this.is_slice_type(sh.slice_type, 4) != 1) {
            sh.cabac_init_idc = this.bs_read_ue(b);
        }
        sh.slice_qp_delta = this.bs_read_se(b);
        if (this.is_slice_type(sh.slice_type, 3) == 1 || this.is_slice_type(sh.slice_type, 4) == 1) {
            if (this.is_slice_type(sh.slice_type, 3) == 1) {
                sh.sp_for_switch_flag = this.bs_read_u1(b);
            }
            sh.slice_qs_delta = this.bs_read_se(b);
        }
        if (pps.deblocking_filter_control_present_flag == 1) {
            sh.disable_deblocking_filter_idc = this.bs_read_ue(b);
            if (sh.disable_deblocking_filter_idc != 1) {
                sh.slice_alpha_c0_offset_div2 = this.bs_read_se(b);
                sh.slice_beta_offset_div2 = this.bs_read_se(b);
            }
        }
        if (pps.num_slice_groups_minus1 > 0 && pps.slice_group_map_type >= 3 && pps.slice_group_map_type <= 5) {
            sh.slice_group_change_cycle = this.bs_read_u(b, (int)Math.ceil(this.log2(pps.pic_size_in_map_units_minus1 + pps.slice_group_change_rate_minus1 + 1)));
        }
    }

    void read_ref_pic_list_reordering(h264Stream h, BS b) {
        SLICE sh = h.mySLICE;
        if (this.is_slice_type(sh.slice_type, 2) != 1 && this.is_slice_type(sh.slice_type, 4) != 1) {
            sh.myRPLR.ref_pic_list_reordering_flag_l0 = this.bs_read_u1(b);
            if (sh.myRPLR.ref_pic_list_reordering_flag_l0 == 1) {
                do {
                    sh.myRPLR.reordering_of_pic_nums_idc = this.bs_read_ue(b);
                    if (sh.myRPLR.reordering_of_pic_nums_idc == 0 || sh.myRPLR.reordering_of_pic_nums_idc == 1) {
                        sh.myRPLR.abs_diff_pic_num_minus1 = this.bs_read_ue(b);
                        continue;
                    }
                    if (sh.myRPLR.reordering_of_pic_nums_idc != 2) continue;
                    sh.myRPLR.long_term_pic_num = this.bs_read_ue(b);
                } while (sh.myRPLR.reordering_of_pic_nums_idc != 3 && !this.bs_eof(b));
            }
        }
        if (this.is_slice_type(sh.slice_type, 1) == 1) {
            sh.myRPLR.ref_pic_list_reordering_flag_l1 = this.bs_read_u1(b);
            if (sh.myRPLR.ref_pic_list_reordering_flag_l1 == 1) {
                do {
                    sh.myRPLR.reordering_of_pic_nums_idc = this.bs_read_ue(b);
                    if (sh.myRPLR.reordering_of_pic_nums_idc == 0 || sh.myRPLR.reordering_of_pic_nums_idc == 1) {
                        sh.myRPLR.abs_diff_pic_num_minus1 = this.bs_read_ue(b);
                        continue;
                    }
                    if (sh.myRPLR.reordering_of_pic_nums_idc != 2) continue;
                    sh.myRPLR.long_term_pic_num = this.bs_read_ue(b);
                } while (sh.myRPLR.reordering_of_pic_nums_idc != 3 && !this.bs_eof(b));
            }
        }
    }

    void read_pred_weight_table(h264Stream h, BS b) {
        int j;
        SLICE sh = h.mySLICE;
        SPS sps = h.mySPS;
        PPS pps = h.myPPS;
        sh.myPWT.luma_log2_weight_denom = this.bs_read_ue(b);
        if (sps.chroma_format_idc != 0) {
            sh.myPWT.chroma_log2_weight_denom = this.bs_read_ue(b);
        }
        int i = 0;
        while (i <= pps.num_ref_idx_l0_active_minus1) {
            sh.myPWT.luma_weight_l0_flag = this.bs_read_u1(b);
            if (sh.myPWT.luma_weight_l0_flag == 1) {
                sh.myPWT.luma_weight_l0[i] = this.bs_read_se(b);
                sh.myPWT.luma_offset_l0[i] = this.bs_read_se(b);
            }
            if (sps.chroma_format_idc != 0) {
                sh.myPWT.chroma_weight_l0_flag = this.bs_read_u1(b);
                if (sh.myPWT.chroma_weight_l0_flag == 1) {
                    j = 0;
                    while (j < 2) {
                        sh.myPWT.chroma_weight_l0[i][j] = this.bs_read_se(b);
                        sh.myPWT.chroma_offset_l0[i][j] = this.bs_read_se(b);
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (this.is_slice_type(sh.slice_type, 1) == 1) {
            i = 0;
            while (i <= pps.num_ref_idx_l1_active_minus1) {
                sh.myPWT.luma_weight_l1_flag = this.bs_read_u1(b);
                if (sh.myPWT.luma_weight_l1_flag == 1) {
                    sh.myPWT.luma_weight_l1[i] = this.bs_read_se(b);
                    sh.myPWT.luma_offset_l1[i] = this.bs_read_se(b);
                }
                if (sps.chroma_format_idc != 0) {
                    sh.myPWT.chroma_weight_l1_flag = this.bs_read_u1(b);
                    if (sh.myPWT.chroma_weight_l1_flag == 1) {
                        j = 0;
                        while (j < 2) {
                            sh.myPWT.chroma_weight_l1[i][j] = this.bs_read_se(b);
                            sh.myPWT.chroma_offset_l1[i][j] = this.bs_read_se(b);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    void read_dec_ref_pic_marking(h264Stream h, BS b) {
        SLICE sh = h.mySLICE;
        if (h.myNAL.nal_unit_type == 5) {
            sh.myDRPM.no_output_of_prior_pics_flag = this.bs_read_u1(b);
            sh.myDRPM.long_term_reference_flag = this.bs_read_u1(b);
        } else {
            sh.myDRPM.adaptive_ref_pic_marking_mode_flag = this.bs_read_u1(b);
            if (sh.myDRPM.adaptive_ref_pic_marking_mode_flag == 1) {
                do {
                    sh.myDRPM.memory_management_control_operation = this.bs_read_ue(b);
                    if (sh.myDRPM.memory_management_control_operation == 1 || sh.myDRPM.memory_management_control_operation == 3) {
                        sh.myDRPM.difference_of_pic_nums_minus1 = this.bs_read_ue(b);
                    }
                    if (sh.myDRPM.memory_management_control_operation == 2) {
                        sh.myDRPM.long_term_pic_num = this.bs_read_ue(b);
                    }
                    if (sh.myDRPM.memory_management_control_operation == 3 || sh.myDRPM.memory_management_control_operation == 6) {
                        sh.myDRPM.long_term_frame_idx = this.bs_read_ue(b);
                    }
                    if (sh.myDRPM.memory_management_control_operation != 4) continue;
                    sh.myDRPM.max_long_term_frame_idx_plus1 = this.bs_read_ue(b);
                } while (sh.myDRPM.memory_management_control_operation != 0 && !this.bs_eof(b));
            }
        }
    }
}

