/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class DLockAPI
extends WallPadDevAPI {
    private final String TAG = "DLockAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"DLockAPI", (String)s);
    }

    public DLockAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("DLockAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "DLOCK";
        this.data = new Data();
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        this.DebugLogOutput("DLockAPI getstate cmd ret : " + ret);
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 3) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.DoorStatus = Byte.parseByte(retlist[index++]);
                this.data.Fault = Byte.parseByte(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"DLockAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetDoorOpen() {
        return this.SendNReadCMD_int("SINKCTRL", "SetDoorOpen", 0, 0, 0, 0, 0);
    }

    public static class Data {
        public byte DoorStatus = DOORSTATUS.Operation;
        public byte Fault = 0;

        public String ToDebugString() {
            String retStr = "==========================\r\nDLockData\r\n==========================\r\nDoorStatus : " + DOORSTATUS.ToDebugString(this.DoorStatus) + "\r\nFault      : " + String.format("0x%02X", this.Fault) + "\r\n==========================\r\n";
            return retStr;
        }
    }

    public static class DOORSTATUS {
        public static byte Close = 0;
        public static byte Open = 1;
        public static byte Operation = (byte)2;
        public static byte Open_LockingForce = (byte)3;
        public static byte Close_LockingForce = (byte)4;

        public static boolean CheckRange(byte nStatus) {
            if (nStatus == Close) {
                return true;
            }
            if (nStatus == Open) {
                return true;
            }
            if (nStatus == Operation) {
                return true;
            }
            if (nStatus == Open_LockingForce) {
                return true;
            }
            return nStatus == Close_LockingForce;
        }

        public static String ToDebugString(byte nStatus) {
            String retStr = nStatus == Close ? "Close" : (nStatus == Open ? "Open" : (nStatus == Operation ? "Operation" : (nStatus == Open_LockingForce ? "Open_LockingForce" : (nStatus == Close_LockingForce ? "Close_LockingForce" : "UnDefined"))));
            return retStr;
        }
    }
}

