/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.sslapi;

import android.util.Log;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;

public class SSLServer {
    private final String TAG = "SSLServer";
    private SSLServerSocket sslServerSocket = null;

    public SSLServer(int port, InputStream key_stream, String key_Pass) {
        if (key_stream == null) {
            Log.w((String)"SSLServer", (String)"[SSLServer] Param 'key_stream' is null !!!");
        }
        if (key_Pass == null) {
            Log.w((String)"SSLServer", (String)"[SSLServer] Param 'key_Pass' is null !!!");
        }
        try {
            char[] passphrase = key_Pass.toCharArray();
            KeyStore keystore = KeyStore.getInstance("BKS");
            keystore.load(key_stream, passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keystore, passphrase);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(kmf.getKeyManagers(), null, null);
            this.sslServerSocket = (SSLServerSocket)context.getServerSocketFactory().createServerSocket(port);
        }
        catch (Exception e) {
            Log.e((String)"SSLServer", (String)"[SSLServer] SSL Socket Make Exception Error");
            e.printStackTrace();
        }
    }

    public SSLServerSocket getServerSocket() {
        return this.sslServerSocket;
    }
}

