/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.os.Build;
import android.support.v4.text.ICUCompatIcs;

public class ICUCompat {
    private static final ICUCompatImpl IMPL;

    public static String getScript(String locale) {
        return IMPL.getScript(locale);
    }

    public static String addLikelySubtags(String locale) {
        return IMPL.addLikelySubtags(locale);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 14 ? new ICUCompatImplIcs() : new ICUCompatImplBase();
    }

    static class ICUCompatImplIcs
    implements ICUCompatImpl {
        ICUCompatImplIcs() {
        }

        public String getScript(String locale) {
            return ICUCompatIcs.getScript(locale);
        }

        public String addLikelySubtags(String locale) {
            return ICUCompatIcs.addLikelySubtags(locale);
        }
    }

    static class ICUCompatImplBase
    implements ICUCompatImpl {
        ICUCompatImplBase() {
        }

        public String getScript(String locale) {
            return null;
        }

        public String addLikelySubtags(String locale) {
            return locale;
        }
    }

    static interface ICUCompatImpl {
        public String getScript(String var1);

        public String addLikelySubtags(String var1);
    }
}

