/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Xml;
import com.wgi.libwebeye.ContentInfo;
import com.wgi.libwebeye.JWebEyeParm;
import com.wgi.libwebeye.MonitorInterface;
import com.wgi.libwebeye.MonitorNetCtrl;
import com.wgi.libwebeye.StreamInfo;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class DVRPlayer
implements MonitorInterface {
    private static final String TAG = "LibWebEye";
    public static final int MSG_DRAW = 1;
    public static final int MSG_DISCONNECT = 2;
    public static final int MSG_NO_VIDEO = 3;
    public static final int MSG_STREAMINFO = 5;
    public static final int MSG_IS_NET_ERROR = 6;
    public static final int MSG_CONTENTINFO = 7;
    private static final int MSG_SEND_CONTENTINFO = 8;
    public static final int ERROR_SOCKET_TIMEOUT = 1000;
    public static final int ERROR_UNAUTH_IP = 1001;
    public static final int ERROR_UNAUTH_USER = 1002;
    public static final int ERROR_INVALID_DATA = 1003;
    public static final int ERROR_UNAUTH_RIGHT = 1004;
    public static final int ERROR_SVR_FULL = 1005;
    private String dvrIP;
    private int dvrPort;
    private int curDong = 0;
    private int curHo = 0;
    private Context parentContext;
    private StreamInfo[] streams = null;
    private Bitmap image = null;
    private JWebEyeParm parm = null;
    private MonitorNetCtrl monCtrl = null;
    String strPrevConnect;
    private boolean bOnErrorReconnect = true;
    private boolean bPostNoSignal = false;
    private boolean bOnlyContentInfo = false;
    ArrayList<String> arrayUsable;
    private OnUpdateImageCallback updateCallback = null;
    private OnErrorCallback errorCodeCallback = null;
    private OnChannelInfoCallback channelInfoCallback = null;
    final Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            int indx = msg.arg1 - 1;
            switch (msg.what) {
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 5: {
                    DVRPlayer.this.setStreamInfo((StreamInfo[])msg.obj, msg.arg2, msg.arg1);
                    break;
                }
                case 7: {
                    DVRPlayer.this.setContentInfo((ContentInfo[])msg.obj, msg.arg2);
                    break;
                }
                case 3: {
                    if (DVRPlayer.this.errorCodeCallback == null) break;
                    DVRPlayer.this.errorCodeCallback.onErrorCode(msg.what);
                    break;
                }
                case 6: {
                    if (!DVRPlayer.this.bOnErrorReconnect || DVRPlayer.this.monCtrl == null) break;
                    DVRPlayer.this.monCtrl.onDisconnect();
                    DVRPlayer.this.monCtrl = null;
                    DVRPlayer.this.playChannel(DVRPlayer.this.strPrevConnect);
                    break;
                }
                case 8: {
                    DVRPlayer.this.sendGetContentInfo();
                }
            }
        }
    };
    final Handler connectionfailhandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (DVRPlayer.this.errorCodeCallback == null) break;
                    DVRPlayer.this.errorCodeCallback.onErrorCode(1001);
                    break;
                }
                case 2: {
                    if (DVRPlayer.this.errorCodeCallback == null) break;
                    DVRPlayer.this.errorCodeCallback.onErrorCode(1002);
                    break;
                }
                case 3: {
                    if (DVRPlayer.this.errorCodeCallback == null) break;
                    DVRPlayer.this.errorCodeCallback.onErrorCode(1003);
                    break;
                }
                case 5: {
                    if (DVRPlayer.this.errorCodeCallback == null) break;
                    DVRPlayer.this.errorCodeCallback.onErrorCode(1004);
                    break;
                }
                case 1000: {
                    if (DVRPlayer.this.errorCodeCallback == null) break;
                    DVRPlayer.this.errorCodeCallback.onErrorCode(1000);
                    break;
                }
                case 69635: {
                    if (DVRPlayer.this.errorCodeCallback == null) break;
                    DVRPlayer.this.errorCodeCallback.onErrorCode(1005);
                    break;
                }
                default: {
                    Log.e((String)DVRPlayer.TAG, (String)("Received Error : " + msg.arg1));
                    return;
                }
            }
        }
    };

    public DVRPlayer(Context context) {
        this.parentContext = context;
        this.arrayUsable = new ArrayList();
    }

    public void setOnUpdateImageCb(OnUpdateImageCallback callback) {
        this.updateCallback = callback;
    }

    public void setOnErrorCodeCb(OnErrorCallback callback) {
        this.errorCodeCallback = callback;
    }

    public void setOnChannelInfoCb(OnChannelInfoCallback callback) {
        this.channelInfoCallback = callback;
    }

    public void setDVRConnectInfo(String strIP, int nPort) {
        this.dvrIP = strIP;
        this.dvrPort = nPort;
        if (this.parm != null) {
            this.parm = null;
        }
        if (this.parm == null) {
            this.parm = new JWebEyeParm();
            this.parm.webeyeService = this;
            this.parm.username = "user10";
            this.parm.password = "12345";
            this.parm.address = this.dvrIP;
            this.parm.port = this.dvrPort;
            this.parm.win_dvr = 0;
            this.parm.requestMode = 0;
            this.parm.frameRate = 30;
        }
    }

    public void playChannel(String strConnect) {
        int ret;
        if (this.monCtrl != null) {
            this.stopChannel();
        }
        this.bPostNoSignal = false;
        this.strPrevConnect = strConnect;
        this.bOnlyContentInfo = false;
        this.parm.channelNum = Integer.parseInt(strConnect);
        this.parm.monNum = Integer.parseInt(strConnect);
        if (this.monCtrl == null) {
            this.monCtrl = new MonitorNetCtrl(this.parm, this.parentContext);
        }
        if ((ret = this.monCtrl.Login()) != 0) {
            this.monCtrl = null;
            Message emsg = this.connectionfailhandler.obtainMessage(3, this.parm.channelNum, -1, null);
            this.connectionfailhandler.sendMessage(emsg);
            return;
        }
    }

    public void stopChannel() {
        if (this.monCtrl != null) {
            this.monCtrl.stopService();
            this.monCtrl.onDisconnect();
            this.monCtrl = null;
        }
    }

    public void getCCTVViewInfo(int nDong, int nHo) {
        this.curDong = nDong;
        this.curHo = nHo;
        Message msg = this.getHandler().obtainMessage(8, 0, 0, null);
        this.getHandler().sendMessage(msg);
    }

    private void sendGetContentInfo() {
        int ret;
        this.bOnlyContentInfo = true;
        if (this.monCtrl == null) {
            this.monCtrl = new MonitorNetCtrl(this.parm, this.parentContext);
        }
        if ((ret = this.monCtrl.Login()) != 0) {
            this.monCtrl = null;
            Message emsg = this.connectionfailhandler.obtainMessage(3, this.parm.channelNum, -1, null);
            this.connectionfailhandler.sendMessage(emsg);
            return;
        }
    }

    public void setContentInfo(ContentInfo[] info, int count) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter writer = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)writer);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            xmlSerializer.startTag("", "imap");
            xmlSerializer.attribute("", "ver", "1.0");
            xmlSerializer.attribute("", "address", String.format("%s", this.parm.address));
            xmlSerializer.attribute("", "sender", "CCTV");
            xmlSerializer.startTag("", "service");
            xmlSerializer.attribute("", "type", "reply");
            xmlSerializer.attribute("", "name", "get_cctv_viewinfo");
            xmlSerializer.attribute("", "result", "ok");
            xmlSerializer.startTag("", "cctv_info");
            xmlSerializer.attribute("", "dong", String.format("%d", this.curDong));
            xmlSerializer.attribute("", "ho", String.format("%d", this.curHo));
            xmlSerializer.attribute("", "count", String.format("%d", count));
            int i = 0;
            while (i < count) {
                String strChannel = String.format("%d", info[i].channel_number);
                xmlSerializer.startTag("", "channel_info");
                xmlSerializer.attribute("", "index", String.format("%d", i + 1));
                xmlSerializer.attribute("", "name", info[i].channel_name);
                xmlSerializer.attribute("", "url", strChannel);
                xmlSerializer.endTag("", "channel_info");
                ++i;
            }
            xmlSerializer.endTag("", "cctv_info");
            xmlSerializer.endTag("", "service");
            xmlSerializer.endTag("", "imap");
            xmlSerializer.endDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.monCtrl != null) {
            this.monCtrl = null;
        }
        String strXML = writer.toString();
        if (this.channelInfoCallback != null) {
            this.channelInfoCallback.onChannelInfo(strXML);
        }
    }

    public void setStreamInfo(StreamInfo[] info, int count, int monNum) {
        Log.d((String)TAG, (String)("SET STREAMINFO - MONITOR : " + System.currentTimeMillis()));
        byte firstStream = -1;
        int secondStream = -1;
        this.streams = info;
        int i = 0;
        while (i < this.streams.length) {
            if (this.streams[i] != null && this.streams[i].encoding_type == 6) {
                if (this.streams[i].resolution > firstStream) {
                    this.parm.playbackstream1 = this.streams[i];
                    firstStream = this.streams[i].resolution;
                }
                if (this.streams[i].resolution <= firstStream) {
                    this.parm.playbackstream2 = this.streams[i];
                    secondStream = this.streams[i].resolution;
                }
            }
            ++i;
        }
        if (this.monCtrl.isResolutionMap == 1) {
            String res1 = "" + firstStream;
            String res2 = "" + secondStream;
            int j = 0;
            while (j < this.monCtrl.resolutionlist.size()) {
                if (((String)this.monCtrl.resolutionlist.get((int)j).second).equalsIgnoreCase(res1)) {
                    this.parm.playbackstream1.stream_name = (String)this.monCtrl.resolutionlist.get((int)j).first;
                }
                if (((String)this.monCtrl.resolutionlist.get((int)j).second).equalsIgnoreCase(res2)) {
                    this.parm.playbackstream2.stream_name = (String)this.monCtrl.resolutionlist.get((int)j).first;
                }
                ++j;
            }
        }
        this.parm.setStreamInfo(this.streams[1]);
        this.monCtrl.startService(this.parm);
    }

    @Override
    public void loginOK(JWebEyeParm curParam) {
        if (this.monCtrl == null) {
            return;
        }
        if (this.bOnlyContentInfo) {
            this.monCtrl.requestContentInfo();
        } else {
            if (this.monCtrl.isResolutionMap == 1) {
                this.monCtrl.requestResolutionMap();
            }
            Log.i((String)TAG, (String)("REQUEST STREAM - MONITOR : " + System.currentTimeMillis()));
            this.monCtrl.requestStreamsInfo();
        }
    }

    @Override
    public void loginOK(int channel_id) {
    }

    @Override
    public void ptzDisconnect(int type) {
    }

    @Override
    public void loginFail(JWebEyeParm curParam, int error) {
        if (this.monCtrl != null) {
            this.monCtrl = null;
        }
        Message msg = this.connectionfailhandler.obtainMessage(error, this.parm.channelNum, -1, null);
        this.connectionfailhandler.sendMessage(msg);
    }

    @Override
    public void displayError(int ch, int error) {
    }

    @Override
    public void displayImage(Bitmap img, boolean running, int ch) {
        if (this.updateCallback != null) {
            if (img == null) {
                if (!this.bPostNoSignal) {
                    this.bPostNoSignal = true;
                    Message msg = this.getHandler().obtainMessage(3, this.parm.channelNum, -1, null);
                    this.getHandler().sendMessage(msg);
                }
                return;
            }
            this.updateCallback.onUpdateImage(img, ch);
        }
    }

    @Override
    public void displayImage2(Bitmap img, boolean running, int ch) {
    }

    @Override
    public void displayImage3(Bitmap img, boolean running, int ch) {
    }

    @Override
    public void displayImage4(Bitmap img, boolean running, int ch) {
    }

    @Override
    public void onServiceStop(JWebEyeParm parm) {
    }

    @Override
    public void onPTZEnable(int nMon, boolean bEnable) {
    }

    @Override
    public void onFrameStart() {
    }

    @Override
    public void onCPmode() {
    }

    @Override
    public void setStreamTransition(JWebEyeParm parm) {
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    private void LogcatOutput(String TAG, String message) {
        int maxLogSize = 1000;
        int i = 0;
        while (i <= message.length() / maxLogSize) {
            int start = i * maxLogSize;
            int end = (i + 1) * maxLogSize;
            end = end > message.length() ? message.length() : end;
            Log.d((String)TAG, (String)message.substring(start, end));
            ++i;
        }
    }

    private void parseDVRConfigInfo(String strXMLInfo) {
        this.arrayUsable.clear();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)new StringReader(strXMLInfo));
            int eventType = parser.getEventType();
            boolean bUserRight = false;
            boolean bUser10 = false;
            String strChannel = "";
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        String strUserName;
                        String startTag = parser.getName();
                        if (startTag.equals("user_right_channel")) {
                            strChannel = parser.getAttributeValue(0);
                            bUserRight = true;
                            break;
                        }
                        if (!bUserRight || !startTag.equals("bool") || !(strUserName = parser.getAttributeValue(0)).equals("user10")) break;
                        bUser10 = true;
                        break;
                    }
                    case 3: {
                        String endTag = parser.getName();
                        if (!endTag.equals("user_right_channel")) break;
                        bUserRight = false;
                        break;
                    }
                    case 4: {
                        if (!bUser10) break;
                        String strUsable = parser.getText();
                        if (strUsable.equals("true")) {
                            this.arrayUsable.add(strChannel);
                            Log.d((String)TAG, (String)("CH " + strChannel + " is usable!!"));
                        } else {
                            Log.d((String)TAG, (String)("CH " + strChannel + " is not usable!!"));
                        }
                        bUser10 = false;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d((String)TAG, (String)("Channel Usable Count =  " + this.arrayUsable.size()));
    }

    public static interface OnChannelInfoCallback {
        public void onChannelInfo(String var1);
    }

    public static interface OnErrorCallback {
        public void onErrorCode(int var1);
    }

    public static interface OnUpdateImageCallback {
        public void onUpdateImage(Bitmap var1, int var2);
    }
}

