/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class FP_DlockAPI
extends WallPadDevAPI {
    private final String TAG = "FP_DlockAPI";
    private final boolean DEBUG_LOG_ON = true;
    DataClasses.FP_DoorLock fp_doorLock_Data;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"FP_DlockAPI", (String)s);
    }

    public FP_DlockAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("FP_DlockAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "FP_DLOCK";
        this.data = new Data();
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        this.DebugLogOutput("FP_DlockAPI getstate cmd ret : " + ret);
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 3) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.DoorStatus = Byte.parseByte(retlist[index++]);
                this.data.Fault = Byte.parseByte(retlist[index++]);
            }
            catch (Exception e) {
                Log.e((String)"FP_DlockAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetDoorOpen() {
        return this.SendNReadCMD_int("SINKCTRL", "SetDoorOpen", 0, 0, 0, 0, 0);
    }

    public static class Data {
        public byte DoorStatus = DataClasses.FP_DoorLock.Device.DOORSTATUS.Operation;
        public byte Fault = 0;

        public String ToDebugString() {
            String retStr = "==========================\r\nFP_DoorLock Data\r\n==========================\r\nDoorStatus : " + DataClasses.FP_DoorLock.Device.DOORSTATUS.ToDebugString(this.DoorStatus) + "\r\nFault      : " + String.format("0x%02X", this.Fault) + "\r\n==========================\r\n";
            return retStr;
        }
    }
}

