/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.wallpadsupport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.util.LinkedList;

@SuppressLint(value={"HandlerLeak"})
public class WpadSound {
    private String TAG = "WpadSound";
    private Context mContext;
    private final String SOUND_PATH_ROOT = "/system/media/audio/wallpad/";
    private final int SOUNDPOOL_MAX_STREAMS = 8;
    private SoundPool mSoundPool = null;
    private MediaPlayer mRepeatMediaPlayer = null;
    protected Handler mPlayRepeatHandler = null;
    private MediaPlayer mMentMediaPlayer = null;
    private AudioManager mAudioManager = null;
    private int mDefultVolume = 3;
    private LinkedList<PLAY_LIST> mPlayQueue;
    private REPEAT Repeat = null;
    private AlwaysSND alwaysSND = null;

    public Context getContext() {
        return this.mContext;
    }

    private String getFilePath(int index) {
        String FileName = null;
        switch (index) {
            case 0: {
                FileName = "number/0.wav";
                break;
            }
            case 1: {
                FileName = "number/1.wav";
                break;
            }
            case 2: {
                FileName = "number/2.wav";
                break;
            }
            case 3: {
                FileName = "number/3.wav";
                break;
            }
            case 4: {
                FileName = "number/4.wav";
                break;
            }
            case 5: {
                FileName = "number/5.wav";
                break;
            }
            case 6: {
                FileName = "number/6.wav";
                break;
            }
            case 7: {
                FileName = "number/7.wav";
                break;
            }
            case 8: {
                FileName = "number/8.wav";
                break;
            }
            case 9: {
                FileName = "number/9.wav";
                break;
            }
            case 100: {
                FileName = "effect/button.wav";
                break;
            }
            case 101: {
                FileName = "effect/touch-latched.wav";
                break;
            }
            case 102: {
                FileName = "effect/touch-unlatched.wav";
                break;
            }
            case 103: {
                FileName = "effect/effect1.wav";
                break;
            }
            case 104: {
                FileName = "effect/end_2_mono.wav";
                break;
            }
            case 105: {
                FileName = "effect/Warning005.wav";
                break;
            }
            case 200: {
                FileName = "setting/dong.wav";
                break;
            }
            case 201: {
                FileName = "setting/ho.wav";
                break;
            }
            case 202: {
                FileName = "setting/Hour.wav";
                break;
            }
            case 203: {
                FileName = "setting/Minute.wav";
                break;
            }
            case 204: {
                FileName = "setting/Setting.wav";
                break;
            }
            case 205: {
                FileName = "setting/RetryAction.wav";
                break;
            }
            case 206: {
                FileName = "setting/RetryInput.wav";
                break;
            }
            case 300: {
                FileName = "bell/Bell_Front.wav";
                break;
            }
            case 301: {
                FileName = "bell/Bell_Front.wav";
                break;
            }
            case 302: {
                FileName = "bell/Bell_Front.wav";
                break;
            }
            case 303: {
                FileName = "bell/Bell_Neighboor.wav";
                break;
            }
            case 304: {
                FileName = "bell/Bell_Pstn.wav";
                break;
            }
            case 305: {
                FileName = "bell/Alram.wav";
                break;
            }
            case 306: {
                FileName = "bell/MoningCall01.wav";
                break;
            }
            case 307: {
                FileName = "bell/MoningCall02.wav";
                break;
            }
            case 308: {
                FileName = "bell/MoningCall03.wav";
                break;
            }
            case 400: {
                FileName = "call/callVOIP.wav";
                break;
            }
            case 401: {
                FileName = "call/CallStart.wav";
                break;
            }
            case 402: {
                FileName = "call/DingDong.wav";
                break;
            }
            case 403: {
                FileName = "call/FrontCallSound.wav";
                break;
            }
            case 404: {
                FileName = "call/RingBusy.wav";
                break;
            }
            case 405: {
                FileName = "call/ConnectSubPhone.wav";
                break;
            }
            case 406: {
                FileName = "call/MoipCallReceiveSound.wav";
                break;
            }
            case 407: {
                FileName = "call/MoipCallSendSound.wav";
                break;
            }
            case 408: {
                FileName = "call/BusyTryLater.wav";
                break;
            }
            case 500: {
                FileName = "elevator/CallElevator.wav";
                break;
            }
            case 501: {
                FileName = "elevator/ElevatorArrived.wav";
                break;
            }
            case 502: {
                FileName = "elevator/MoveUp.wav";
                break;
            }
            case 503: {
                FileName = "elevator/ORG_ElevatorArrived.wav";
                break;
            }
            case 600: {
                FileName = "emergency/Emergency.wav";
                break;
            }
            case 601: {
                FileName = "emergency/EmergencyAram.wav";
                break;
            }
            case 602: {
                FileName = "emergency/EmergencyInvasion.wav";
                break;
            }
            case 603: {
                FileName = "emergency/EmergencyRelease_Comeback.wav";
                break;
            }
            case 604: {
                FileName = "emergency/Comeback_Emergency.wav";
                break;
            }
            case 605: {
                FileName = "emergency/sirlen1.wav";
                break;
            }
            case 606: {
                FileName = "emergency/StopSiren.wav";
                break;
            }
            case 607: {
                FileName = "emergency/silent.wav";
                break;
            }
            case 700: {
                FileName = "mode/NormalModeComeback.wav";
                break;
            }
            case 701: {
                FileName = "mode/HomeDeviceCheck.wav";
                break;
            }
            case 702: {
                FileName = "mode/InModeSetting.wav";
                break;
            }
            case 703: {
                FileName = "mode/OutModeSetting.wav";
                break;
            }
            case 704: {
                FileName = "mode/OutModeSetting_low.wav";
                break;
            }
            case 705: {
                FileName = "mode/SensorInvasion.wav";
                break;
            }
            case 706: {
                FileName = "mode/SensorMotion_Release.wav";
                break;
            }
            case 707: {
                FileName = "mode/start_2_mono.wav";
                break;
            }
            case 708: {
                FileName = "mode/Visitor_OutModeRun.wav";
                break;
            }
            case 709: {
                FileName = "mode/ArrivedCar.wav";
                break;
            }
            case 710: {
                FileName = "mode/BoxArrived.wav";
                break;
            }
            case 711: {
                FileName = "mode/OpenDoor.wav";
                break;
            }
            case 800: {
                FileName = "ars_ment/ARS1_1.wav";
                break;
            }
            case 801: {
                FileName = "ars_ment/ARS1_2.wav";
                break;
            }
            case 802: {
                FileName = "ars_ment/ARS1_3.wav";
                break;
            }
            case 803: {
                FileName = "ars_ment/ARS1_4.wav";
                break;
            }
            case 804: {
                FileName = "ars_ment/ARS2_3.wav";
                break;
            }
            case 805: {
                FileName = "ars_ment/ARS2_3_NoLight.wav";
                break;
            }
            case 806: {
                FileName = "ars_ment/ARS3_3.wav";
                break;
            }
            case 807: {
                FileName = "ars_ment/ARS3_4.wav";
                break;
            }
            case 808: {
                FileName = "ars_ment/ARS3_6.wav";
                break;
            }
            case 809: {
                FileName = "ars_ment/ARS4_1.wav";
                break;
            }
            case 810: {
                FileName = "ars_ment/ARS4_3.wav";
                break;
            }
            case 811: {
                FileName = "ars_ment/ARS4_4.wav";
                break;
            }
            case 812: {
                FileName = "ars_ment/ARS5_1.wav";
                break;
            }
            case 813: {
                FileName = "ars_ment/ARS5_2.wav";
                break;
            }
            case 814: {
                FileName = "ars_ment/ARS6_1.wav";
                break;
            }
            case 815: {
                FileName = "ars_ment/ARS7_1.wav";
                break;
            }
            case 816: {
                FileName = "ars_ment/ARS8_1.wav";
                break;
            }
            case 817: {
                FileName = "ars_ment/ARS9_1.wav";
                break;
            }
            case 818: {
                FileName = "ars_ment/ARS9_2.wav";
                break;
            }
            case 5100: {
                FileName = "lobby/bell_01.ogg";
                break;
            }
            case 5101: {
                FileName = "lobby/bell_02.ogg";
                break;
            }
            case 5102: {
                FileName = "lobby/bell_03.ogg";
                break;
            }
            case 5103: {
                FileName = "lobby/bell_04.ogg";
                break;
            }
            case 5104: {
                FileName = "lobby/bell_05.ogg";
                break;
            }
            case 5105: {
                FileName = "lobby/bell_06.ogg";
                break;
            }
            case 5106: {
                FileName = "lobby/booting.ogg";
                break;
            }
            case 5107: {
                FileName = "lobby/busytrylater.ogg";
                break;
            }
            case 5108: {
                FileName = "lobby/button.ogg";
                break;
            }
            case 5109: {
                FileName = "lobby/callend.ogg";
                break;
            }
            case 5110: {
                FileName = "lobby/callstart.ogg";
                break;
            }
            case 5111: {
                FileName = "lobby/confirmsetting.ogg";
                break;
            }
            case 5112: {
                FileName = "lobby/dooropen.ogg";
                break;
            }
            case 5113: {
                FileName = "lobby/inputfail.ogg";
                break;
            }
            case 5114: {
                FileName = "lobby/packagearrived.ogg";
                break;
            }
            case 5115: {
                FileName = "lobby/resultok.ogg";
                break;
            }
            case 5116: {
                FileName = "lobby/retryinput.ogg";
                break;
            }
            case 5117: {
                FileName = "lobby/setting.ogg";
                break;
            }
            case 5118: {
                FileName = "lobby/trylater.ogg";
                break;
            }
            case 6100: {
                FileName = "guard/bell_01.ogg";
                break;
            }
            case 6101: {
                FileName = "guard/bell_02.ogg";
                break;
            }
            case 6102: {
                FileName = "guard/bell_03.ogg";
                break;
            }
            case 6103: {
                FileName = "guard/bell_04.ogg";
                break;
            }
            case 6104: {
                FileName = "guard/bell_05.ogg";
                break;
            }
            case 6105: {
                FileName = "guard/bell_06.ogg";
                break;
            }
            case 6106: {
                FileName = "guard/booting.ogg";
                break;
            }
            case 6107: {
                FileName = "guard/break.ogg";
                break;
            }
            case 6108: {
                FileName = "guard/busytrylater.ogg";
                break;
            }
            case 6109: {
                FileName = "guard/button.ogg";
                break;
            }
            case 6110: {
                FileName = "guard/callend.ogg";
                break;
            }
            case 6111: {
                FileName = "guard/callreceived.ogg";
                break;
            }
            case 6112: {
                FileName = "guard/callstart.ogg";
                break;
            }
            case 6113: {
                FileName = "guard/confirmsetting.ogg";
                break;
            }
            case 6114: {
                FileName = "guard/dooropen.ogg";
                break;
            }
            case 6115: {
                FileName = "guard/emer_com.ogg";
                break;
            }
            case 6116: {
                FileName = "guard/emergency.ogg";
                break;
            }
            case 6117: {
                FileName = "guard/fire.ogg";
                break;
            }
            case 6118: {
                FileName = "guard/gas.ogg";
                break;
            }
            case 6119: {
                FileName = "guard/inputfail.ogg";
                break;
            }
            case 6120: {
                FileName = "guard/packagearrived.ogg";
                break;
            }
            case 6121: {
                FileName = "guard/release.ogg";
                break;
            }
            case 6122: {
                FileName = "guard/resultok.ogg";
                break;
            }
            case 6123: {
                FileName = "guard/retryinput.ogg";
                break;
            }
            case 6124: {
                FileName = "guard/setting.ogg";
                break;
            }
            case 6125: {
                FileName = "guard/trylater.ogg";
                break;
            }
            case 6126: {
                FileName = "guard/no_sound.ogg";
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)("[Error] getFileName - Index Not Found!!! (" + index + ")"));
            }
        }
        if (FileName == null) {
            return null;
        }
        return "/system/media/audio/wallpad/" + FileName;
    }

    public WpadSound(Context context) {
        this.mContext = context;
        this.setRepeatInit();
        this.mSoundPool = new SoundPool(8, 3, 0);
        this.mPlayQueue = new LinkedList();
        this.alwaysSND = new AlwaysSND();
        this.mSoundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                if (((WpadSound)WpadSound.this).alwaysSND.LoadWaitCount > 0) {
                    --((WpadSound)WpadSound.this).alwaysSND.LoadWaitCount;
                } else {
                    if (WpadSound.this.mPlayQueue == null) {
                        return;
                    }
                    PLAY_LIST PlayList = null;
                    for (int i = 0; i < 10 && !WpadSound.this.mPlayQueue.isEmpty(); ++i) {
                        try {
                            PlayList = null;
                            PlayList = (PLAY_LIST)WpadSound.this.mPlayQueue.getFirst();
                            if (PlayList == null) continue;
                            WpadSound.this.mPlayQueue.removeFirst();
                            if (PlayList.sample_id != sampleId) continue;
                            WpadSound.this._play(PlayList.sample_id, false, PlayList.volume_kind);
                            soundPool.unload(PlayList.sample_id);
                        }
                        catch (Exception e) {
                            Log.e((String)WpadSound.this.TAG, (String)"[Exception Error] mSoundPool.setOnLoadCompleteListener");
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
        this.setAlwaysSNDLoad();
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
    }

    public boolean Play(int SND_index) {
        return this.Playbase(SND_index, this.mDefultVolume);
    }

    public boolean Play_lobby(int SND_index) {
        return this.Playbase_lobby(SND_index, this.mDefultVolume);
    }

    public boolean Play(int SND_index, int volume_kind) {
        return this.Playbase(SND_index, volume_kind);
    }

    public boolean PlayRepeat(int SND_index, int term_ms) {
        return this.PlayRepeatBase(SND_index, term_ms, this.mDefultVolume);
    }

    public boolean PlayRepeat_lobby(int SND_index, int term_ms) {
        return this.PlayRepeatBase_lobby(SND_index, term_ms, this.mDefultVolume);
    }

    public boolean PlayRepeat(int SND_index, int term_ms, int volume_kind) {
        return this.PlayRepeatBase(SND_index, term_ms, volume_kind);
    }

    public boolean isPlayRepeating() {
        return this.Repeat.getRun();
    }

    public boolean StopRepeat() {
        this.setRepeatInit();
        if (this.mRepeatMediaPlayer == null) {
            return false;
        }
        if (this.mPlayRepeatHandler != null) {
            this.mPlayRepeatHandler.removeMessages(0);
            this.mPlayRepeatHandler = null;
        }
        this.mRepeatMediaPlayer.stop();
        this.mRepeatMediaPlayer.release();
        this.mRepeatMediaPlayer = null;
        return true;
    }

    public int PlayMent(int SND_index) {
        return this.PlayMentBase(SND_index, this.mDefultVolume);
    }

    public int PlayMent_lobby(int SND_index) {
        return this.PlayMentBase_lobby(SND_index, this.mDefultVolume);
    }

    public int PlayMent(int SND_index, int volume_kind) {
        return this.PlayMentBase(SND_index, volume_kind);
    }

    public boolean StopMent() {
        if (this.mMentMediaPlayer == null) {
            return false;
        }
        this.mMentMediaPlayer.stop();
        this.mMentMediaPlayer.release();
        this.mMentMediaPlayer = null;
        return true;
    }

    public boolean isPlayMent() {
        if (this.mMentMediaPlayer == null) {
            return false;
        }
        return this.mMentMediaPlayer.isPlaying();
    }

    public int getPlayMentRemainingTime() {
        if (!this.isPlayMent()) {
            return 0;
        }
        int Position = this.mMentMediaPlayer.getCurrentPosition();
        int Duration = this.mMentMediaPlayer.getDuration();
        return Duration - Position;
    }

    public void StopAll() {
        if (this.mSoundPool != null) {
            this.mSoundPool.release();
            this.setRepeatInit();
            this.mSoundPool = new SoundPool(8, 3, 0);
            this.setAlwaysSNDLoad();
        }
        this.StopRepeat();
        this.StopMent();
    }

    public void Release() {
        if (this.mSoundPool != null) {
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
        this.StopRepeat();
        this.StopMent();
    }

    private void setAlwaysSNDLoad() {
        String filepath = null;
        filepath = this.getFilePath(101);
        this.alwaysSND.TOUCH_LATCHED = this.mSoundPool.load(filepath, 1);
        filepath = this.getFilePath(100);
        this.alwaysSND.BUTTON = this.mSoundPool.load(filepath, 1);
    }

    private int getAlwaysSNDFilter(int SND_index) {
        switch (SND_index) {
            case 101: {
                return this.alwaysSND.TOUCH_LATCHED;
            }
            case 100: {
                return this.alwaysSND.BUTTON;
            }
        }
        return -1;
    }

    private int _play(int SoundId, boolean loop, int volume_kind) {
        float PlayVolume;
        if (this.mSoundPool == null) {
            return 0;
        }
        int loopParam = 0;
        if (loop) {
            loopParam = -1;
        }
        if ((PlayVolume = this.getPlayVolume(volume_kind)) < 0.0f) {
            PlayVolume = 1.0f;
        }
        return this.mSoundPool.play(SoundId, PlayVolume, PlayVolume, 0, loopParam, 1.0f);
    }

    private float getPlayVolume(int volume_kind) {
        if (this.mAudioManager == null) {
            return -1.0f;
        }
        int streamNfixed = -1;
        switch (volume_kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                streamNfixed = 1;
                break;
            }
            default: {
                if (volume_kind < 100 || volume_kind > 115) break;
                streamNfixed = 2;
            }
        }
        if (streamNfixed == -1) {
            Log.e((String)this.TAG, (String)("[getVolume] Parameters - volume_kind Out of range !!! (" + volume_kind + ")"));
            return -1.0f;
        }
        float calcVolume = -1.0f;
        if (streamNfixed == 1) {
            float nowVolume = this.mAudioManager.getStreamVolume(volume_kind);
            float maxVolume = this.mAudioManager.getStreamMaxVolume(volume_kind);
            calcVolume = nowVolume / maxVolume;
        } else if (streamNfixed == 2) {
            float fixedVolume = (float)volume_kind - 100.0f;
            float maxVolume = 15.0f;
            calcVolume = fixedVolume / maxVolume;
        }
        return calcVolume;
    }

    private boolean Playbase(int SND_index, int volume_kind) {
        if (this.mSoundPool == null) {
            return false;
        }
        try {
            int AlwaysSoundId = this.getAlwaysSNDFilter(SND_index);
            if (AlwaysSoundId > 0) {
                this._play(AlwaysSoundId, false, volume_kind);
            } else {
                String filepath = this.getFilePath(SND_index);
                if (filepath == null) {
                    Log.e((String)this.TAG, (String)("[Play] - SND_index  Not Found FilePath !!! (" + SND_index + ")"));
                    return false;
                }
                int SoundId = this.mSoundPool.load(filepath, 1);
                if (SoundId <= 0) {
                    Log.e((String)this.TAG, (String)("[Play] Did not get !!! - path : " + filepath));
                    return false;
                }
                PLAY_LIST PlayList = new PLAY_LIST();
                PlayList.sample_id = SoundId;
                PlayList.volume_kind = volume_kind;
                this.mPlayQueue.add(PlayList);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"[Exception Error] [WpadSound.Play] - Param 'SoundId' not found!!!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean Playbase_lobby(int SND_index, int volume_kind) {
        if (this.mSoundPool == null) {
            return false;
        }
        try {
            int AlwaysSoundId = this.getAlwaysSNDFilter(SND_index);
            if (AlwaysSoundId > 0) {
                this._play(AlwaysSoundId, false, volume_kind);
            } else {
                int SoundId = this.mSoundPool.load(this.mContext, SND_index, 1);
                if (SoundId <= 0) {
                    Log.e((String)this.TAG, (String)("[Playbase_lobby] Did not get !!! - SND_index : " + SND_index));
                    return false;
                }
                PLAY_LIST PlayList = new PLAY_LIST();
                PlayList.sample_id = SoundId;
                PlayList.volume_kind = volume_kind;
                this.mPlayQueue.add(PlayList);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"[Exception Error] [WpadSound.Playbase_lobby] - Param 'SoundId' not found!!!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void setRepeatInit() {
        this.Repeat = new REPEAT();
    }

    private boolean PlayRepeatBase(int SND_index, int term_ms, int volume_kind) {
        this.StopRepeat();
        String filepath = this.getFilePath(SND_index);
        if (filepath == null) {
            Log.e((String)this.TAG, (String)("[PlayRepeat] - SND_index  Not Found FilePath !!! (" + SND_index + ")"));
            return false;
        }
        this.mRepeatMediaPlayer = new MediaPlayer();
        try {
            this.mRepeatMediaPlayer.setDataSource(filepath);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayRepeat->setDataSource : " + e));
            this.mRepeatMediaPlayer = null;
            return false;
        }
        try {
            this.mRepeatMediaPlayer.prepare();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayRepeat->prepare : " + e));
            this.mRepeatMediaPlayer = null;
            return false;
        }
        float PlayVolume = this.getPlayVolume(volume_kind);
        if (PlayVolume < 0.0f) {
            PlayVolume = 1.0f;
        }
        this.mRepeatMediaPlayer.setVolume(PlayVolume, PlayVolume);
        this.mRepeatMediaPlayer.setAudioStreamType(3);
        if (term_ms <= 0) {
            this.Repeat.setTermMs(0);
            this.Repeat.setRun(true);
            this.mRepeatMediaPlayer.setLooping(true);
            try {
                this.mRepeatMediaPlayer.start();
            }
            catch (Exception e) {
                this.setRepeatInit();
                Log.e((String)this.TAG, (String)("[ExceptionError] - PlayRepeat->start#1 : " + e));
                return false;
            }
        }
        this.Repeat.setTermMs(term_ms);
        this.Repeat.setRun(true);
        this.mPlayRepeatHandler = new Handler(){

            @SuppressLint(value={"HandlerLeak"})
            public void handleMessage(Message msg) {
                if (msg.what == 0 && WpadSound.this.Repeat.getRun()) {
                    try {
                        WpadSound.this.mRepeatMediaPlayer.start();
                    }
                    catch (Exception e) {
                        Log.e((String)WpadSound.this.TAG, (String)("[ExceptionError] - PlayRepeat->handleMessage->start : " + e));
                        WpadSound.this.StopRepeat();
                    }
                }
            }
        };
        this.mRepeatMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (WpadSound.this.Repeat.getRun()) {
                    WpadSound.this.mPlayRepeatHandler.sendEmptyMessageDelayed(0, (long)WpadSound.this.Repeat.getTermMs());
                }
            }
        });
        try {
            this.mRepeatMediaPlayer.start();
        }
        catch (Exception e) {
            this.setRepeatInit();
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayRepeat->start#2 : " + e));
            return false;
        }
        return true;
    }

    private boolean PlayRepeatBase_lobby(int SND_index, int term_ms, int volume_kind) {
        this.StopRepeat();
        this.mRepeatMediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)SND_index);
        float PlayVolume = this.getPlayVolume(volume_kind);
        if (PlayVolume < 0.0f) {
            PlayVolume = 1.0f;
        }
        this.mRepeatMediaPlayer.setVolume(PlayVolume, PlayVolume);
        this.mRepeatMediaPlayer.setAudioStreamType(3);
        if (term_ms <= 0) {
            this.Repeat.setTermMs(0);
            this.Repeat.setRun(true);
            this.mRepeatMediaPlayer.setLooping(true);
            try {
                this.mRepeatMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        mp.start();
                    }
                });
            }
            catch (Exception e) {
                this.setRepeatInit();
                Log.e((String)this.TAG, (String)("[ExceptionError] - PlayRepeatBase_lobby->start#1 : " + e));
                return false;
            }
        }
        this.Repeat.setTermMs(term_ms);
        this.Repeat.setRun(true);
        this.mPlayRepeatHandler = new Handler(){

            @SuppressLint(value={"HandlerLeak"})
            public void handleMessage(Message msg) {
                if (msg.what == 0 && WpadSound.this.Repeat.getRun()) {
                    try {
                        WpadSound.this.mRepeatMediaPlayer.start();
                    }
                    catch (Exception e) {
                        Log.e((String)WpadSound.this.TAG, (String)("[ExceptionError] - PlayRepeatBase_lobby->handleMessage->start : " + e));
                        WpadSound.this.StopRepeat();
                    }
                }
            }
        };
        this.mRepeatMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (WpadSound.this.Repeat.getRun()) {
                    WpadSound.this.mPlayRepeatHandler.sendEmptyMessageDelayed(0, (long)WpadSound.this.Repeat.getTermMs());
                }
            }
        });
        try {
            this.mRepeatMediaPlayer.start();
        }
        catch (Exception e) {
            this.setRepeatInit();
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayRepeatBase_lobby->start#2 : " + e));
            return false;
        }
        return true;
    }

    @SuppressLint(value={"HandlerLeak"})
    private int PlayMentBase(int SND_index, int volume_kind) {
        this.StopMent();
        String filepath = this.getFilePath(SND_index);
        if (filepath == null) {
            Log.e((String)this.TAG, (String)("[PlayMent] - SND_index  Not Found FilePath !!! (" + SND_index + ")"));
            return -1;
        }
        this.mMentMediaPlayer = new MediaPlayer();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filepath);
            FileDescriptor fileDescriptor = fileInputStream.getFD();
            this.mMentMediaPlayer.setDataSource(fileDescriptor);
            fileInputStream.close();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayMent->setDataSource : " + e));
            return -2;
        }
        try {
            this.mMentMediaPlayer.prepare();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayMent->prepare : " + e));
            return -3;
        }
        float PlayVolume = this.getPlayVolume(volume_kind);
        if (PlayVolume < 0.0f) {
            PlayVolume = 1.0f;
        }
        this.mMentMediaPlayer.setVolume(PlayVolume, PlayVolume);
        this.mMentMediaPlayer.setAudioStreamType(3);
        try {
            this.mMentMediaPlayer.start();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayMent->start : " + e));
            return -4;
        }
        return this.mMentMediaPlayer.getDuration();
    }

    private int PlayMentBase_lobby(int SND_index, int volume_kind) {
        this.StopMent();
        this.mMentMediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)SND_index);
        float PlayVolume = this.getPlayVolume(volume_kind);
        if (PlayVolume < 0.0f) {
            PlayVolume = 1.0f;
        }
        this.mMentMediaPlayer.setVolume(PlayVolume, PlayVolume);
        this.mMentMediaPlayer.setAudioStreamType(3);
        try {
            this.mMentMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    try {
                        mp.start();
                    }
                    catch (Exception e) {
                        Log.e((String)WpadSound.this.TAG, (String)"[Exception] onPrepared");
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PlayMentBase_lobby->prepare : " + e));
            return -1;
        }
        return this.mMentMediaPlayer.getDuration();
    }

    public static final class SND {

        public final class guard {
            public static final int BELL_01 = 6100;
            public static final int BELL_02 = 6101;
            public static final int BELL_03 = 6102;
            public static final int BELL_04 = 6103;
            public static final int BELL_05 = 6104;
            public static final int BELL_06 = 6105;
            public static final int BOOTING = 6106;
            public static final int BREAK = 6107;
            public static final int BUSYTRYLATER = 6108;
            public static final int BUTTON = 6109;
            public static final int CALLEND = 6110;
            public static final int CALLRECEIVED = 6111;
            public static final int CALLSTART = 6112;
            public static final int CONFIRMSETTING = 6113;
            public static final int DOOROPEN = 6114;
            public static final int EMER_COM = 6115;
            public static final int EMERGENCY = 6116;
            public static final int FIRE = 6117;
            public static final int GAS = 6118;
            public static final int INPUTFAIL = 6119;
            public static final int PACKAGEARRIVED = 6120;
            public static final int RELEASE = 6121;
            public static final int RESULTOK = 6122;
            public static final int RETRYINPUT = 6123;
            public static final int SETTING = 6124;
            public static final int TRYLATER = 6125;
            public static final int NOSOUND = 6126;
        }

        public final class lobby {
            public static final int BELL_01 = 5100;
            public static final int BELL_02 = 5101;
            public static final int BELL_03 = 5102;
            public static final int BELL_04 = 5103;
            public static final int BELL_05 = 5104;
            public static final int BELL_06 = 5105;
            public static final int BOOTING = 5106;
            public static final int BUSYTRYLATER = 5107;
            public static final int BUTTON = 5108;
            public static final int CALLED = 5109;
            public static final int CALLSTART = 5110;
            public static final int CONFIRMSETTING = 5111;
            public static final int DOOROPEN = 5112;
            public static final int INPUTFAIL = 5113;
            public static final int PACKAGEARRIVED = 5114;
            public static final int RESULTOK = 5115;
            public static final int RETRYINPUT = 5116;
            public static final int SETTING = 5117;
            public static final int TRYLATER = 5118;
        }

        public final class ars_ment {
            public static final int ARS1_1 = 800;
            public static final int ARS1_2 = 801;
            public static final int ARS1_3 = 802;
            public static final int ARS1_4 = 803;
            public static final int ARS2_3 = 804;
            public static final int ARS2_3_NOLIGHT = 805;
            public static final int ARS3_3 = 806;
            public static final int ARS3_4 = 807;
            public static final int ARS3_6 = 808;
            public static final int ARS4_1 = 809;
            public static final int ARS4_3 = 810;
            public static final int ARS4_4 = 811;
            public static final int ARS5_1 = 812;
            public static final int ARS5_2 = 813;
            public static final int ARS6_1 = 814;
            public static final int ARS7_1 = 815;
            public static final int ARS8_1 = 816;
            public static final int ARS9_1 = 817;
            public static final int ARS9_2 = 818;
        }

        public final class mode {
            public static final int NORMALMODE_COMEBACK = 700;
            public static final int HOME_DEVICE_CHECK = 701;
            public static final int INMODE_SETTING = 702;
            public static final int OUTMODE_SETTING = 703;
            public static final int OUTMODE_SETTING_LOW = 704;
            public static final int SENSOR_INVASION = 705;
            public static final int SENSORMOTION_RELEASE = 706;
            public static final int START_2_MONO = 707;
            public static final int VISITOR_OUTMODERUN = 708;
            public static final int CAR_ARRIVED = 709;
            public static final int BOX_ARRIVED = 710;
            public static final int OPENDOOR = 711;
        }

        public final class emergency {
            public static final int DEFAULT = 600;
            public static final int ALARM = 601;
            public static final int INVASION = 602;
            public static final int RELEASE_COMEBACK = 603;
            public static final int COMEBACK = 604;
            public static final int SIRLEN1 = 605;
            public static final int STOP_SIREN = 606;
            public static final int SILENT = 607;
        }

        public final class elevator {
            public static final int CALL = 500;
            public static final int DN_ARRIVED = 501;
            public static final int UP_ARRIVED = 502;
            public static final int ORG_ARRIVED = 503;
        }

        public final class call {
            public static final int CALL_VOIP = 400;
            public static final int CALLSTART = 401;
            public static final int DINGDONG = 402;
            public static final int FRONTCALL = 403;
            public static final int RING_BUSY = 404;
            public static final int CONNECT_SUBPHONE = 405;
            public static final int RECEIVE_CALL = 406;
            public static final int SEND_CALL = 407;
            public static final int BUSY_TRY_LATER = 408;
        }

        public final class bell {
            public static final int FRONT = 300;
            public static final int GUARDROOM = 301;
            public static final int LOBBY = 302;
            public static final int NEIGHBOOR = 303;
            public static final int PSTN = 304;
            public static final int ALRAM = 305;
            public static final int MONINGCALL_01 = 306;
            public static final int MONINGCALL_02 = 307;
            public static final int MONINGCALL_03 = 308;
        }

        public final class setting {
            public static final int DONG = 200;
            public static final int HO = 201;
            public static final int HOUR = 202;
            public static final int MINUTE = 203;
            public static final int SETTING = 204;
            public static final int RETRY_ACTION = 205;
            public static final int RETRY_INPUT = 206;
        }

        public final class effect {
            public static final int BUTTON = 100;
            public static final int TOUCH_LATCHED = 101;
            public static final int TOUCH_UNLATCHED = 102;
            public static final int EFFECT1 = 103;
            public static final int END_2_MONO = 104;
            public static final int WARNING005 = 105;
        }

        public static final class number {
            public static final int NUM0 = 0;
            public static final int NUM1 = 1;
            public static final int NUM2 = 2;
            public static final int NUM3 = 3;
            public static final int NUM4 = 4;
            public static final int NUM5 = 5;
            public static final int NUM6 = 6;
            public static final int NUM7 = 7;
            public static final int NUM8 = 8;
            public static final int NUM9 = 9;
        }
    }

    public static final class VOLUME_KIND {

        public static final class fixed {
            public static final int BASE = 100;
            public static final int MUTE = 100;
            public static final int LEV0 = 100;
            public static final int LEV1 = 101;
            public static final int LEV2 = 102;
            public static final int LEV3 = 103;
            public static final int LEV4 = 104;
            public static final int LEV5 = 105;
            public static final int LEV6 = 106;
            public static final int LEV7 = 107;
            public static final int LEV8 = 108;
            public static final int LEV9 = 109;
            public static final int LEV10 = 110;
            public static final int LEV11 = 111;
            public static final int LEV12 = 112;
            public static final int LEV13 = 113;
            public static final int LEV14 = 114;
            public static final int LEV15 = 115;
            public static final int MAX = 115;
        }

        public static final class stream {
            public static final int ALARM = 4;
            public static final int DTMF = 8;
            public static final int MUSIC = 3;
            public static final int NOTIFICATION = 5;
            public static final int RING = 2;
            public static final int SYSTEM = 1;
            public static final int VOICE_CALL = 0;
        }
    }

    private class AlwaysSND {
        public int TOUCH_LATCHED = -1;
        public int BUTTON = -1;
        public int LoadWaitCount = 2;
    }

    protected class REPEAT {
        protected boolean Run;
        protected int TermMs;

        private boolean getRun() {
            return this.Run;
        }

        private void setRun(boolean set) {
            this.Run = set;
        }

        private int getTermMs() {
            return this.TermMs;
        }

        private void setTermMs(int set) {
            this.TermMs = set;
        }

        public REPEAT() {
            this.setRun(false);
            this.setTermMs(-1);
        }
    }

    private class PLAY_LIST {
        int sample_id = -1;
        int volume_kind = -1;

        private PLAY_LIST() {
        }
    }
}

