/*
 * Decompiled with CFR 0.152.
 */
package bssoft.stack.sip;

import bssoft.stack.sip.SIPStack;
import java.util.StringTokenizer;

public class SIPVIAHeader {
    public String header = null;
    public String headerValue = null;
    public String branch = null;
    public String received = null;
    public int rport = -1;
    public String ip = null;
    public int port = 0;
    public String tag = null;
    public boolean rportService = false;
    public boolean flag = false;

    public SIPVIAHeader(String message) {
        if (message != null && message.length() > 0) {
            this.rport = 0;
            this.received = null;
            int iS = message.indexOf("Via: ");
            int iE = 0;
            if (iS < 0 && (iS = message.indexOf(String.valueOf(SIPStack.SIP_LINE_END) + "v: ")) >= 0) {
                iS += 2;
            }
            if (iS >= 0 && (iE = message.indexOf(SIPStack.SIP_LINE_END, iS)) > 0) {
                this.header = message.substring(iS, iE);
                if (this.header.startsWith("Via: ")) {
                    this.headerValue = this.header.substring(5);
                } else if (this.header.startsWith("v: ")) {
                    this.headerValue = this.header.substring(3);
                }
            }
            if (this.headerValue != null && this.headerValue.length() > 0) {
                StringTokenizer st = new StringTokenizer(this.headerValue, ";", true);
                int tokenCount = 0;
                String token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (token == null || token.length() <= 0 || token.compareTo(";") == 0) continue;
                    if (++tokenCount == 1 && token.startsWith("SIP/")) {
                        StringTokenizer tokenArray = new StringTokenizer(token, " ", true);
                        int fieldCount = 0;
                        while (tokenArray.hasMoreTokens()) {
                            String field = tokenArray.nextToken().trim();
                            if (field == null || field.length() <= 0 || field.compareTo(" ") == 0 || ++fieldCount != 2) continue;
                            iS = field.indexOf(":");
                            if (iS > 0) {
                                this.port = Integer.parseInt(field.substring(iS + 1));
                                this.ip = field.substring(0, iS);
                                continue;
                            }
                            this.port = 5060;
                            this.ip = field;
                        }
                        continue;
                    }
                    if (tokenCount != 1 && token.startsWith("branch=")) {
                        this.branch = token.substring(7);
                        continue;
                    }
                    if (tokenCount != 1 && token.compareTo("rport") == 0) {
                        this.rportService = true;
                        continue;
                    }
                    if (tokenCount != 1 && token.startsWith("rport=")) {
                        this.rportService = true;
                        this.rport = Integer.parseInt(token.substring(6).trim());
                        continue;
                    }
                    if (tokenCount == 1 || !token.startsWith("received=")) continue;
                    this.rportService = true;
                    this.received = token.substring(9).trim();
                }
                this.flag = true;
            }
        }
    }

    public String getReceived() {
        return this.received;
    }

    public int getRport() {
        return this.rport;
    }

    public String getAddress() {
        return String.valueOf(this.ip) + ":" + this.port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getBranch() {
        return this.branch;
    }
}

