package kr.co.icontrols.iencryptor;

import kr.co.icontrols.iencryptor.aes128.AES_128;
import kr.co.icontrols.iencryptor.aes128.AES_128.ENCRYPTTYPE;
import kr.co.icontrols.iencryptor.ukey.UKEY;
import android.app.Activity;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;

public class IEncryptorActivity extends Activity {
    static final String TAG = "IEncryptorActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_iencryptor);
        
        TextView TextView_Version = (TextView)findViewById(R.id.textView3);
        TextView_Version.setText(getLibVersion());
        
        Log.i(TAG, "***** Available Encryption *****");
        Log.i(TAG, "1) HDC SmartKey");
        Log.i(TAG, "2) Chamsule Tech U-Key(HDEC)");
        
        String strTargetData = "AF0E2089B00C021F";
        Log.i(TAG, "[onCreate] Target       = " + printHexs(StringToHex(strTargetData)));
        Log.i(TAG, "[onCreate] HDC Encrypted = " + printHexs(AES_128.Encrypt(ENCRYPTTYPE.NORMAL, StringToHex(strTargetData))));
        Log.i(TAG, "[onCreate] U-KEY Encrypted = " + printHexs(UKEY.Encrypt(StringToHex(strTargetData))));
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.iencryptor, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
    
    private String getLibVersion() {
        try {
            PackageInfo mPackageInfo = getPackageManager().getPackageInfo(getPackageName(), 0);
            return mPackageInfo.versionName;
        } catch (NameNotFoundException nfe) {
            Log.e(TAG, "[NameNotFoundException] HextoString(data) : " + nfe);
            nfe.printStackTrace();
            return "ERROR";
        } catch (Exception e) {
            Log.e(TAG, "[Exception] HextoString(data) : " + e);
            e.printStackTrace();
            return "ERROR";
        }
    }
    
    // Byte迭 ϴ Լ
    public static String printHexs(byte[] hdata) {
        try {
            String strResult = "";
//            Log.d(TAG, "[printHexs] hdata.length = " + hdata.length);
            for (int i = 0; i < hdata.length; i++) {
                strResult += HextoString(hdata[i]) + " ";
            }
            return strResult;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] HextoString(hdata) : " + e);
            e.printStackTrace();
            return null;
        }
    }
    
    // Byte String ȯ
    public static String HextoString(byte data) {
        try {
            return String.format("%02X", data);
        } catch (Exception e) {
            Log.e(TAG, "[Exception] HextoString(data) : " + e);
            e.printStackTrace();
            return null;
        }
    }
    
    // String Byte迭 ȯ
    public static byte[] StringToHex(String strTargetData) {
        try {
            if (strTargetData == null || strTargetData.length() == 0) {
                Log.d(TAG, "[StringToHex] strTargetData is null or it's length is 0!!");
                return null;
            }
            
            if ((strTargetData.length() % 2) != 0) {
                Log.d(TAG, "[StringToHex] The length of strTargetData is not even!!");
                return null;
            }
          
            byte[] hResult = new byte[strTargetData.length() / 2];
            
            for (int i = 0; i < hResult.length; i++) {
                hResult[i] = (byte)Integer.parseInt(strTargetData.substring(2 * i, 2 * i + 2), 16);
            }
            return hResult;
        } catch (Exception e) {
            Log.e(TAG, "[Exception] StringToHex(TargetData) : " + e);
            e.printStackTrace();
            return null;
        }
    }
    
    // Byte迭 String ȯ
    public static String HexToString(byte[] hTargetData) {
        try {
            if (hTargetData == null || hTargetData.length == 0) {
                Log.d(TAG, "[StringToHex] hTargetData is null or it's length is 0!!");
                return null;
            }
            
            StringBuffer mStringBuffer = new StringBuffer(hTargetData.length * 2);
            String strHexNum;
            for (int i = 0; i < hTargetData.length; i++) {
                strHexNum = "0" + Integer.toHexString(0xFF & hTargetData[i]).toUpperCase();
                mStringBuffer.append(strHexNum.substring(strHexNum.length() - 2));
            }
            return mStringBuffer.toString();
        } catch (Exception e) {
            Log.e(TAG, "[Exception] HexToString(hTargetData) : " + e);
            e.printStackTrace();
            return null;
        }
    }
    
}
