/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.commons;

import android.util.Log;

public class Sdb_DataClasses {
    private static final String TAG = "Sdb_DataClasses";

    public static class LivingEnergyMeterClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class ConcentRegisterClass {
            public boolean Registering = false;
            public int RemainingTime = 0;
            public byte Regi_Count = 0;

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter Concent Register ]] \r\n=========================================================\r\nRegistering : " + this.Registering + "\r\nRemainingTime : " + this.RemainingTime + "\r\nRegi_Count : " + this.Regi_Count + "\r\n";
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class LightRegisterClass {
            public boolean Registering = false;
            public int RemainingTime = 0;
            public byte Regi_Count = 0;

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter Light Register ]] \r\n=========================================================\r\nRegistering : " + this.Registering + "\r\nRemainingTime : " + this.RemainingTime + "\r\nRegi_Count : " + this.Regi_Count + "\r\n";
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class DataClass {
            public byte OutingStatus = EnergyControllerClass.DataClass.OUTING_STATUS.NO_INFO;
            public boolean LightLimitControl = false;
            public double LightElecNow = 0.0;
            public int LightElecAcc = 0;
            public byte LightMode = 0;
            public EnergyMeterClass.LedLightClass[] LedLight = null;

            public int setLedLight(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.LedLight = new EnergyMeterClass.LedLightClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.LedLight[i] = new EnergyMeterClass.LedLightClass();
                }
                return 0;
            }

            public String ToString() {
                String retStr = "=========================================================\r\n[[ LivingEnergyMeter.Data ]] \r\n=========================================================\r\nLightLimitControl : " + this.LightLimitControl + "\r\nLightElecNow : " + this.LightElecNow + ",  LightElecAcc : " + this.LightElecAcc + "\r\nLightMode : " + this.LightMode + "\r\n";
                if (this.LedLight != null) {
                    byte EmIndex = 15;
                    byte len = this.LedLight.length;
                    for (byte i = 0; i < len; i = (byte)(i + 1)) {
                        retStr = retStr + this.LedLight[i].Info.ToString(EmIndex, i);
                    }
                } else {
                    retStr = retStr + "LedLight is null !!!";
                }
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte LightCount = 0;
            public boolean bHallwayLight2GroupSet = false;
            public boolean bHallwayLight2GroupSupport = false;
            public LightGroupClass LightGroup = new LightGroupClass();

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ LivingEnergyMeter.Info ]] \r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nLightCount : " + this.LightCount + "\r\nbHallwayLight2GroupSet : " + this.bHallwayLight2GroupSet + "\r\nbHallwayLight2GroupSupport : " + this.bHallwayLight2GroupSupport + "\r\n" + this.LightGroup.ToString() + "----------------------------------------\r\n";
                return retStr;
            }

            public static class LightGroupClass {
                public boolean Exist_Indirect = false;
                public boolean Exist_Hallway = false;
                public boolean Group_Indirect = false;
                public boolean Group_Hallway = false;

                public String ToString() {
                    String retStr = "[LightGroup]\r\nExist_Indirect : " + this.Exist_Indirect + "\r\nExist_Hallway  : " + this.Exist_Hallway + "\r\nGroup_Indirect : " + this.Group_Indirect + "\r\nGroup_Hallway  : " + this.Group_Hallway + "\r\n";
                    return retStr;
                }
            }
        }
    }

    public static class BathRoomSensorLightClass {
        public byte Count = 0;
        public StatusClass[] Status = null;

        public int setStatus(byte nCount) {
            if (nCount <= 0) {
                return -1;
            }
            this.Status = new StatusClass[nCount];
            for (int i = 0; i < nCount; ++i) {
                this.Status[i] = new StatusClass();
            }
            return 0;
        }

        public String ToString() {
            String retStr = "----------------------------------------\r\n[BathRoomSensorLight]\r\n----------------------------------------\r\nCount : " + this.Count + "\r\n";
            if (this.Status != null) {
                for (int i = 0; i < this.Status.length; ++i) {
                    retStr = retStr + this.Status[i].ToString((byte)i);
                }
            } else {
                retStr = retStr + "Status is null !!!";
            }
            retStr = retStr + "----------------------------------------\r\n";
            return retStr;
        }

        public static class StatusClass {
            public byte EnergyIndex = (byte)-1;
            public byte Usage = LEDLIGHT_USAGE_CODE.NOT_DEFINE;
            public boolean UseOnOff = false;

            public String ToString(byte SensorIndex) {
                String retStr = "[Sensor ID #" + (SensorIndex + 1) + "]\r\nEnergyIndex : " + this.EnergyIndex + "\r\nUsage : " + LEDLIGHT_USAGE_CODE.ToString(this.Usage) + "\r\nUseOnOff  : " + this.UseOnOff + "\r\n";
                return retStr;
            }
        }
    }

    public static class DcApuClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class DataClass {
            public boolean CommFault = false;
            public boolean SMPS_Shared = false;
            public byte BatchOffStatus = BATCHOFF_STATUS.CLR;
            public SMPSClass[] SMPS = null;

            public int setSMPS(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.SMPS = new SMPSClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.SMPS[i] = new SMPSClass();
                }
                return 0;
            }

            public String ToString() {
                String retStr = "----------------------------------------\r\n[DcApu.Data]\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\nSMPS_Shared : " + this.SMPS_Shared + "\r\nBatchOffStatus : " + BATCHOFF_STATUS.ToString(this.BatchOffStatus) + "\r\n";
                if (this.SMPS != null) {
                    int len = this.SMPS.length;
                    for (int i = 0; i < len; ++i) {
                        retStr = retStr + this.SMPS[i].ToString((byte)i);
                    }
                } else {
                    retStr = retStr + "SMPS is null !!!";
                }
                retStr = retStr + "----------------------------------------\r\n";
                return retStr;
            }

            public static class SMPSClass {
                public boolean OnOff = false;
                public boolean Volt_Fault = false;
                public boolean Overload_Fault = false;
                public double Volt = 0.0;
                public double Current = 0.0;

                public String ToString(byte SMPSIndex) {
                    String retStr = "[SMPS ID:#" + (SMPSIndex + 1) + "]\r\nOnOff : " + this.OnOff + "\r\nVolt_Fault : " + this.Volt_Fault + "\r\nOverload_Fault : " + this.Overload_Fault + "\r\nVolt : " + this.Volt + "\r\nCurrent : " + this.Current + "\r\n";
                    return retStr;
                }
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte SMPSCnt = 0;
            public boolean bSMPS_01_VoltMeasurable = false;
            public boolean bSMPS_02_VoltMeasurable = false;
            public boolean bSMPS_01_CurrentMeasurable = false;
            public boolean bSMPS_02_CurrentMeasurable = false;
            public boolean bLumpSumLightsOffStatusLink = false;
            public boolean bSMPFaultVoltageCriteriaUsage = false;
            public boolean bSMPFaultCurrentCriteriaUsage = false;
            public boolean bForceBlockingNotiUsage = false;
            public boolean bTempRangeErrorNotiUsage = false;
            public boolean bFETBreakageNotiUsage = false;
            public byte hModelType = 0;

            public String ToString() {
                String retStr = "----------------------------------------\r\n[DcApu.Info]\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nSMPSCnt : " + this.SMPSCnt + "\r\nSMPSCnt : " + this.SMPSCnt + "\r\nbSMPS_01_VoltMeasurable : " + this.bSMPS_01_VoltMeasurable + "\r\nbSMPS_02_VoltMeasurable : " + this.bSMPS_02_VoltMeasurable + "\r\nbSMPS_01_CurrentMeasurable : " + this.bSMPS_01_CurrentMeasurable + "\r\nbSMPS_02_CurrentMeasurable : " + this.bSMPS_02_CurrentMeasurable + "\r\nbLumpSumLightsOffStatusLink : " + this.bLumpSumLightsOffStatusLink + "\r\nbSMPFaultVoltageCriteriaUsage : " + this.bSMPFaultVoltageCriteriaUsage + "\r\nbSMPFaultCurrentCriteriaUsage : " + this.bSMPFaultCurrentCriteriaUsage + "\r\nbForceBlockingNotiUsage : " + this.bForceBlockingNotiUsage + "\r\nbTempRangeErrorNotiUsage : " + this.bTempRangeErrorNotiUsage + "\r\nbFETBreakageNotiUsage : " + this.bFETBreakageNotiUsage + "\r\nhModelType : " + this.hModelType + "\r\n----------------------------------------\r\n";
                return retStr;
            }
        }
    }

    public static class IntPowerControllerClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class DataClass {
            public boolean CommFault = false;
            public boolean AcApu = false;
            public CircuitClass[] Circuit = null;

            public int setCircuit(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.Circuit = new CircuitClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.Circuit[i] = new CircuitClass();
                }
                return 0;
            }

            public String ToString() {
                String retStr = "----------------------------------------\r\n[IntPowerController.Data]\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\nAcApu : " + this.AcApu + "\r\n";
                if (this.Circuit != null) {
                    int len = this.Circuit.length;
                    for (int i = 0; i < len; ++i) {
                        retStr = retStr + this.Circuit[i].ToString((byte)i);
                    }
                } else {
                    retStr = retStr + "Circuit is null !!!";
                }
                retStr = retStr + "----------------------------------------\r\n";
                return retStr;
            }

            public static class CIRCUIT_STATUS {
                public static byte On = 1;
                public static byte Off = (byte)2;
                public static byte OverLoadOff = (byte)3;

                public static String ToString(byte Status2) {
                    if (Status2 == On) {
                        return "On";
                    }
                    if (Status2 == Off) {
                        return "Off";
                    }
                    if (Status2 == OverLoadOff) {
                        return "OverLoadOff";
                    }
                    return "UnDefind";
                }
            }

            public static class CircuitClass {
                public byte Status = CIRCUIT_STATUS.Off;
                public int NowPw = 0;
                public int AccPw = 0;

                public String ToString(byte CircuitIndex) {
                    String retStr = "[Circuit ID:#" + (CircuitIndex + 1) + "]\r\nStatus : " + CIRCUIT_STATUS.ToString(this.Status) + "\r\nNowPw : " + this.NowPw + "\r\nAccPw : " + this.AccPw + "\r\n";
                    return retStr;
                }
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte CircuitCount = 0;

            public String ToString() {
                String retStr = "----------------------------------------\r\n[IntPowerController.Info]\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nCircuitCount : " + this.CircuitCount + "\r\n----------------------------------------\r\n";
                return retStr;
            }
        }
    }

    public static class EnergyMeterClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class ConcentClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault = false;
                public CutOffConcentClass CutOffConcent = new CutOffConcentClass();
                public AlwaysConcentClass AlwaysConcent = new AlwaysConcentClass();

                public String ToString(byte EmIndex, byte ConcentIndex) {
                    String retStr = "----------------------------------------\r\n[[ Concent.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (ConcentIndex + 1) + "\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\n" + this.CutOffConcent.ToString() + this.AlwaysConcent.ToString() + "----------------------------------------\r\n";
                    return retStr;
                }

                public static class CONCENT_MODE {
                    public static byte Auto = 1;
                    public static byte Always = (byte)2;

                    public static String ToString(byte Mode) {
                        if (Mode == Auto) {
                            return "Auto";
                        }
                        if (Mode == Always) {
                            return "Always";
                        }
                        return "UnDefind";
                    }
                }

                public static class CONCENT_STATUS {
                    public static byte On = 1;
                    public static byte Off = (byte)2;
                    public static byte CutOff = (byte)3;
                    public static byte OverLoadOff = (byte)4;

                    public static String ToString(byte Status2) {
                        if (Status2 == On) {
                            return "On";
                        }
                        if (Status2 == Off) {
                            return "Off";
                        }
                        if (Status2 == CutOff) {
                            return "CutOff";
                        }
                        if (Status2 == OverLoadOff) {
                            return "OverLoadOff";
                        }
                        return "UnDefind";
                    }
                }

                public static class AlwaysConcentClass {
                    public double NowPw = 0.0;
                    public int AccPw = 0;

                    public String ToString() {
                        String retStr = "[AlwaysConcent]\r\nNowPw : " + this.NowPw + ",  AccPw : " + this.AccPw + "\r\n";
                        return retStr;
                    }
                }

                public static class CutOffConcentClass {
                    public byte Status = CONCENT_STATUS.Off;
                    public byte Mode = CONCENT_MODE.Always;
                    public double NowPw = 0.0;
                    public int AccPw = 0;
                    public double CutOffVal = 0.0;

                    public String ToString() {
                        String retStr = "[CutOffConcent]\r\nStatus : " + CONCENT_STATUS.ToString(this.Status) + ",  Mode : " + CONCENT_MODE.ToString(this.Mode) + "\r\nNowPw : " + this.NowPw + ",  AccPw : " + this.AccPw + ",  CutOffVal : " + this.CutOffVal + "\r\n";
                        return retStr;
                    }
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public VersionClass Version = new VersionClass();

                public String ToString(byte EmIndex, byte ConcentIndex) {
                    String retStr = "----------------------------------------\r\n[[ Concent.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (ConcentIndex + 1) + "\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "----------------------------------------\r\n";
                    return retStr;
                }
            }
        }

        public static class LedSensorLightClass {
            public LedLightExpClass.InfoClass Info = new LedLightExpClass.InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault = false;
                public boolean UseOnOff = false;
                public byte Location = LOCATION.NONE;
                public byte Level = 0;
                public byte DetectionCount = 0;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedSensorLightClass.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\nUseOnOff : " + this.UseOnOff + ",  Location : " + LOCATION.ToString(this.Location) + "\r\nLevel : " + this.Level + ",  DetectionCount : " + this.DetectionCount + "\r\n----------------------------------------\r\n";
                    return retStr;
                }

                public static class LOCATION {
                    public static byte NONE = 0;
                    public static byte SHARED = 1;
                    public static byte COUPLE = (byte)2;

                    public static String ToString(byte Loc) {
                        if (Loc == NONE) {
                            return "NONE";
                        }
                        if (Loc == SHARED) {
                            return "SHARED";
                        }
                        if (Loc == COUPLE) {
                            return "COUPLE";
                        }
                        return "UnDefind";
                    }
                }
            }
        }

        public static class LedLightExpClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault = false;
                public boolean OnOff = false;
                public byte Dimming = (byte)10;
                public byte Color = (byte)10;
                public byte Channel_Count = 0;
                public double Channel1_InVolt = 0.0;
                public double Channel2_InVolt = 0.0;
                public double InTemp = 0.0;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLightExp.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\nOnOff : " + this.OnOff + ",  Dimming : " + this.Dimming + ",  Color : " + this.Color + "\r\nChannel_Count : " + this.Channel_Count + ",  Channel1_InVolt : " + this.Channel1_InVolt + ",  Channel2_InVolt : " + this.Channel2_InVolt + ",  InTemp : " + this.InTemp + "\r\n----------------------------------------\r\n";
                    return retStr;
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public VersionClass Version = new VersionClass();
                public SupportClass Support = new SupportClass();
                public CodeClass Code = new CodeClass();

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLightExp.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + this.Support.ToString() + this.Code.ToString() + "----------------------------------------\r\n";
                    return retStr;
                }

                public static class CodeClass {
                    public byte Usage = LEDLIGHT_USAGE_CODE.NOT_DEFINE;
                    public byte Controller = CONTROLLER.NOT_DEFINE;
                    public byte Volume = VOLUME.NOT_DEFINE;
                    public byte LightVendor = LIGHT_VENDOR.NOT_DEFINE;

                    public String ToString() {
                        String retStr = "[Code] \r\nUsage  : " + LEDLIGHT_USAGE_CODE.ToString(this.Usage) + ",  Controller : " + CONTROLLER.ToString(this.Controller) + "\r\nVolume : " + VOLUME.ToString(this.Volume) + ",  LightVendor : " + LIGHT_VENDOR.ToString(this.LightVendor) + "\r\n";
                        return retStr;
                    }

                    public static class LIGHT_VENDOR {
                        public static byte ICONTROLS = 0;
                        public static byte SOLUX = 1;
                        public static byte BLK = (byte)2;
                        public static byte H_AVENUE = (byte)3;
                        public static byte NOT_DEFINE = (byte)-1;

                        public static String ToString(byte code) {
                            if (code == ICONTROLS) {
                                return "ICONTROLS";
                            }
                            if (code == SOLUX) {
                                return "SOLUX";
                            }
                            if (code == BLK) {
                                return "BLK";
                            }
                            if (code == H_AVENUE) {
                                return "H_AVENUE";
                            }
                            return "UnDefind(" + code + ")";
                        }
                    }

                    public static class VOLUME {
                        public static byte _7W = 1;
                        public static byte _8W = (byte)2;
                        public static byte _10W = (byte)3;
                        public static byte _14W = (byte)4;
                        public static byte _15W = (byte)5;
                        public static byte _20W = (byte)6;
                        public static byte _28W = (byte)7;
                        public static byte _30W = (byte)8;
                        public static byte _40W = (byte)9;
                        public static byte _50W = (byte)10;
                        public static byte _60W = (byte)11;
                        public static byte _80W = (byte)12;
                        public static byte _120W = (byte)13;
                        public static byte _25W = (byte)14;
                        public static byte _36W = (byte)15;
                        public static byte _4W = (byte)16;
                        public static byte _18W = (byte)18;
                        public static byte _24W = (byte)19;
                        public static byte _34W = (byte)20;
                        public static byte _38W = (byte)21;
                        public static byte _44W = (byte)22;
                        public static byte _48W = (byte)23;
                        public static byte _54W = (byte)24;
                        public static byte _58W = (byte)25;
                        public static byte _55W = (byte)26;
                        public static byte _110W = (byte)27;
                        public static byte NOT_DEFINE = (byte)-1;

                        public static int getIntger(byte code) {
                            if (code == _7W) {
                                return 7;
                            }
                            if (code == _8W) {
                                return 8;
                            }
                            if (code == _10W) {
                                return 10;
                            }
                            if (code == _14W) {
                                return 14;
                            }
                            if (code == _15W) {
                                return 15;
                            }
                            if (code == _20W) {
                                return 20;
                            }
                            if (code == _28W) {
                                return 28;
                            }
                            if (code == _30W) {
                                return 30;
                            }
                            if (code == _40W) {
                                return 40;
                            }
                            if (code == _50W) {
                                return 50;
                            }
                            if (code == _60W) {
                                return 60;
                            }
                            if (code == _80W) {
                                return 80;
                            }
                            if (code == _120W) {
                                return 120;
                            }
                            if (code == _25W) {
                                return 25;
                            }
                            if (code == _36W) {
                                return 36;
                            }
                            if (code == _4W) {
                                return 4;
                            }
                            if (code == _18W) {
                                return 18;
                            }
                            if (code == _24W) {
                                return 24;
                            }
                            if (code == _34W) {
                                return 34;
                            }
                            if (code == _38W) {
                                return 38;
                            }
                            if (code == _44W) {
                                return 44;
                            }
                            if (code == _48W) {
                                return 48;
                            }
                            if (code == _54W) {
                                return 54;
                            }
                            if (code == _58W) {
                                return 58;
                            }
                            if (code == _55W) {
                                return 55;
                            }
                            if (code == _110W) {
                                return 110;
                            }
                            return 0;
                        }

                        public static String ToString(byte code) {
                            if (code == _7W) {
                                return "7W";
                            }
                            if (code == _8W) {
                                return "8W";
                            }
                            if (code == _10W) {
                                return "10W";
                            }
                            if (code == _14W) {
                                return "14W";
                            }
                            if (code == _15W) {
                                return "15W";
                            }
                            if (code == _20W) {
                                return "20W";
                            }
                            if (code == _28W) {
                                return "28W";
                            }
                            if (code == _30W) {
                                return "30W";
                            }
                            if (code == _40W) {
                                return "40W";
                            }
                            if (code == _50W) {
                                return "50W";
                            }
                            if (code == _60W) {
                                return "60W";
                            }
                            if (code == _80W) {
                                return "80W";
                            }
                            if (code == _120W) {
                                return "120W";
                            }
                            if (code == _25W) {
                                return "25W";
                            }
                            if (code == _36W) {
                                return "36W";
                            }
                            if (code == _4W) {
                                return "4W";
                            }
                            if (code == _18W) {
                                return "18W";
                            }
                            if (code == _24W) {
                                return "24W";
                            }
                            if (code == _34W) {
                                return "34W";
                            }
                            if (code == _38W) {
                                return "38W";
                            }
                            if (code == _44W) {
                                return "44W";
                            }
                            if (code == _48W) {
                                return "48W";
                            }
                            if (code == _54W) {
                                return "54W";
                            }
                            if (code == _58W) {
                                return "58W";
                            }
                            if (code == _55W) {
                                return "55W";
                            }
                            if (code == _110W) {
                                return "110W";
                            }
                            return "UnDefind(" + code + ")";
                        }
                    }

                    public static class CONTROLLER {
                        public static byte RT11 = 1;
                        public static byte RF12 = (byte)2;
                        public static byte RD22 = (byte)3;
                        public static byte CT11 = (byte)4;
                        public static byte CT22 = (byte)5;
                        public static byte RD11 = (byte)6;
                        public static byte CC12 = (byte)7;
                        public static byte CC24 = (byte)8;
                        public static byte RS21 = (byte)9;
                        public static byte RC12 = (byte)10;
                        public static byte RC24 = (byte)11;
                        public static byte RD12 = (byte)12;
                        public static byte ILH_RD11 = (byte)13;
                        public static byte NOT_DEFINE = (byte)-1;

                        public static String ToString(byte code) {
                            if (code == RT11) {
                                return "RT11";
                            }
                            if (code == RF12) {
                                return "RF12";
                            }
                            if (code == RD22) {
                                return "RD22";
                            }
                            if (code == CT11) {
                                return "CT11";
                            }
                            if (code == CT22) {
                                return "CT22";
                            }
                            if (code == RD11) {
                                return "RD11";
                            }
                            if (code == CC12) {
                                return "CC12";
                            }
                            if (code == CC24) {
                                return "CC24";
                            }
                            if (code == RS21) {
                                return "RS21";
                            }
                            if (code == RC12) {
                                return "RC12";
                            }
                            if (code == RC24) {
                                return "RC24";
                            }
                            if (code == RD12) {
                                return "RD12";
                            }
                            if (code == ILH_RD11) {
                                return "ILH_RD11";
                            }
                            return "UnDefind(" + code + ")";
                        }
                    }
                }

                public static class SupportClass {
                    public boolean OnOff = false;
                    public boolean Dimming = false;
                    public boolean Color = false;
                    public boolean VoltCheck = false;
                    public boolean Sensor = false;
                    public boolean SensorSensitAdjust = false;
                    public boolean BoardTemp = false;
                    public boolean FullControl_12ea = false;
                    public boolean SensorDetectionCount = false;

                    public String ToString() {
                        String retStr = "[Support] \r\nOnOff : " + this.OnOff + ",  Dimming : " + this.Dimming + ",  Color : " + this.Color + "\r\nVoltCheck : " + this.VoltCheck + ",  Sensor : " + this.Sensor + ",  SensorSensitAdjust : " + this.SensorSensitAdjust + "\r\nBoardTemp : " + this.BoardTemp + ",  FullControl_12ea : " + this.FullControl_12ea + ",  SensorDetectionCount : " + this.SensorDetectionCount + "\r\n";
                        return retStr;
                    }
                }
            }
        }

        public static class LedLightClass {
            public InfoClass Info = new InfoClass();
            public DataClass Data = new DataClass();

            public static class DataClass {
                public boolean CommFault = false;
                public boolean OnOff = false;
                public byte Dimming = (byte)10;
                public byte Color = (byte)10;

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Data ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nCommFault : " + this.CommFault + "\r\nOnOff     : " + this.OnOff + "\r\nDimming   : " + this.Dimming + "\r\nColor     : " + this.Color + "\r\n----------------------------------------\r\n";
                    return retStr;
                }
            }

            public static class InfoClass {
                public boolean Install = false;
                public SupportClass Support = new SupportClass();
                public CodeClass Code = new CodeClass();

                public String ToString(byte EmIndex, byte LightIndex) {
                    String retStr = "----------------------------------------\r\n[[ LedLight.Info ]] EM:#" + (EmIndex + 1) + " - ID:#" + (LightIndex + 1) + "\r\n----------------------------------------\r\nInstall         : " + this.Install + "\r\nSupport.OnOff   : " + this.Support.OnOff + "\r\nSupport.Dimming : " + this.Support.Dimming + "\r\nSupport.Color   : " + this.Support.Color + "\r\nCode.Usage      : " + LEDLIGHT_USAGE_CODE.ToString(this.Code.Usage) + "\r\n----------------------------------------\r\n";
                    return retStr;
                }

                public static class CodeClass {
                    public byte Usage = LEDLIGHT_USAGE_CODE.NOT_DEFINE;
                }

                public static class SupportClass {
                    public boolean OnOff = false;
                    public boolean Dimming = false;
                    public boolean Color = false;
                }
            }
        }

        public static class DataClass {
            public boolean CommFault = false;
            public boolean AlmostSenFault = false;
            public boolean WifiModuleFault = false;
            public boolean TempSenFault = false;
            public double LightBD_Temp = 0.0;
            public double LightBD_Volt = 0.0;
            public double LightElecNow = 0.0;
            public int LightElecAcc = 0;
            public LedLightClass[] LedLight = null;
            public LedLightExpClass[] LedLightExp = null;
            public LedSensorLightClass LedSensorLight = null;
            public ConcentClass[] Concent = null;

            public int setLedLight(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.LedLightExp = null;
                this.LedLight = new LedLightClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.LedLight[i] = new LedLightClass();
                }
                return 0;
            }

            public int setLedLightExp(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.LedLight = null;
                this.LedLightExp = new LedLightExpClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.LedLightExp[i] = new LedLightExpClass();
                }
                return 0;
            }

            public int setConcent(byte nCount) {
                if (nCount <= 0) {
                    return -1;
                }
                this.Concent = new ConcentClass[nCount];
                for (int i = 0; i < nCount; ++i) {
                    this.Concent[i] = new ConcentClass();
                }
                return 0;
            }

            public String ToString(byte EmIndex, boolean AllData_Output) {
                String retStr = "=========================================================\r\n[[ EnergyMeter.Data ]] EM:#" + (EmIndex + 1) + "\r\n=========================================================\r\nCommFault : " + this.CommFault + ",  AlmostSenFault : " + this.AlmostSenFault + "\r\nWifiModuleFault : " + this.WifiModuleFault + ",  TempSenFault : " + this.TempSenFault + "\r\nLightBD_Temp : " + this.LightBD_Temp + ",  LightBD_Volt : " + this.LightBD_Volt + "\r\nLightElecNow : " + this.LightElecNow + ",  LightElecAcc : " + this.LightElecAcc + "\r\n";
                if (AllData_Output) {
                    byte i;
                    if (this.LedLightExp != null) {
                        for (i = 0; i < this.LedLightExp.length; i = (byte)(i + 1)) {
                            retStr = retStr + this.LedLightExp[i].Data.ToString(EmIndex, i);
                        }
                    }
                    if (this.LedLight != null) {
                        for (i = 0; i < this.LedLight.length; i = (byte)(i + 1)) {
                            retStr = retStr + this.LedLight[i].Data.ToString(EmIndex, i);
                        }
                    }
                    if (this.Concent != null) {
                        for (i = 0; i < this.Concent.length; i = (byte)(i + 1)) {
                            retStr = retStr + this.Concent[i].Data.ToString(EmIndex, i);
                        }
                    }
                }
                retStr = retStr + "=========================================================\r\n";
                return retStr;
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte LightCount = 0;
            public byte SensorLightCount = 0;
            public byte ConcentCount = 0;

            public String ToString(byte EmIndex) {
                String retStr = "----------------------------------------\r\n[[ EnergyMeter.Info ]] EM:#" + (EmIndex + 1) + "\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nLightCount : " + this.LightCount + "\r\nSensorLightCount : " + this.SensorLightCount + "\r\nConcentCount : " + this.ConcentCount + "\r\n----------------------------------------\r\n";
                return retStr;
            }
        }
    }

    public static class EnergyControllerClass {
        public InfoClass Info = new InfoClass();
        public DataClass Data = new DataClass();

        public static class DataClass {
            public byte BatchOffStatus = BATCHOFF_STATUS.NO_SET;
            public byte AllConcentStatus = ALL_CONCENT_STATUS.NO_INFO;
            public byte OutingStatus = OUTING_STATUS.NO_INFO;
            public boolean LightLimitControl = false;
            public byte LighLimitLevel = 0;
            public byte SmartPhoneLightControl = SMARTPHONE_LIGHT_CTRL_STATUS.NO_INFO;

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ EnergyController.Data ]]\r\n----------------------------------------\r\nBatchOffStatus   : " + BATCHOFF_STATUS.ToString(this.BatchOffStatus) + "\r\nAllConcentStatus : " + ALL_CONCENT_STATUS.ToString(this.AllConcentStatus) + "\r\nOutingStatus     : " + OUTING_STATUS.ToString(this.OutingStatus) + "\r\nLighLimitLevel   : " + this.LighLimitLevel + "\r\nSmartPhoneLightControl : " + SMARTPHONE_LIGHT_CTRL_STATUS.ToString(this.SmartPhoneLightControl) + "\r\n----------------------------------------\r\n";
                return retStr;
            }

            public static class SMARTPHONE_LIGHT_CTRL_STATUS {
                public static byte NO_INFO = 0;
                public static byte CLR = 1;
                public static byte SET = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return true;
                    }
                    if (nStatus == CLR) {
                        return true;
                    }
                    return nStatus == SET;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return "NO_INFO";
                    }
                    if (nStatus == CLR) {
                        return "CLR";
                    }
                    if (nStatus == SET) {
                        return "SET";
                    }
                    return "UnDefined";
                }
            }

            public static class OUTING_STATUS {
                public static byte NO_INFO = 0;
                public static byte SET = 1;
                public static byte CLR = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return true;
                    }
                    if (nStatus == SET) {
                        return true;
                    }
                    return nStatus == CLR;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return "NO_INFO";
                    }
                    if (nStatus == SET) {
                        return "SET";
                    }
                    if (nStatus == CLR) {
                        return "CLR";
                    }
                    return "UnDefined";
                }
            }

            public static class ALL_CONCENT_STATUS {
                public static byte NO_INFO = 0;
                public static byte OFF = 1;
                public static byte ON = (byte)2;

                public static boolean CheckRange(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return true;
                    }
                    if (nStatus == OFF) {
                        return true;
                    }
                    return nStatus == ON;
                }

                public static String ToString(byte nStatus) {
                    if (nStatus == NO_INFO) {
                        return "NO_INFO";
                    }
                    if (nStatus == OFF) {
                        return "OFF";
                    }
                    if (nStatus == ON) {
                        return "ON";
                    }
                    return "UnDefined";
                }
            }
        }

        public static class InfoClass {
            public boolean Install = false;
            public VersionClass Version = new VersionClass();
            public byte EnergyMeterCount = 0;

            public String ToString() {
                String retStr = "----------------------------------------\r\n[[ EnergyController.Info ]]\r\n----------------------------------------\r\nInstall : " + this.Install + "\r\n\r\n" + this.Version.ToString() + "\r\nEnergyMeterCount : " + this.EnergyMeterCount + "\r\n----------------------------------------\r\n";
                return retStr;
            }
        }
    }

    public static class BATCHOFF_STATUS {
        public static byte NO_SET = 0;
        public static byte SET = 1;
        public static byte CLR = (byte)2;

        public static boolean CheckRange(byte nStatus) {
            if (nStatus == SET) {
                return true;
            }
            return nStatus == CLR;
        }

        public static String ToString(byte nStatus) {
            if (nStatus == SET) {
                return "SET";
            }
            if (nStatus == CLR) {
                return "CLR";
            }
            return "UnDefined";
        }
    }

    public static class LEDLIGHT_USAGE_CODE {
        public static byte LIVINGROOM = 0;
        public static byte INNERROOM = 1;
        public static byte BEDROOM = (byte)2;
        public static byte KITCHEN = (byte)3;
        public static byte TABLE = (byte)4;
        public static byte HALLWAY = (byte)5;
        public static byte BALCONY = (byte)6;
        public static byte INDIRECT = (byte)7;
        public static byte COUPLE_BATHROOM_SENSOR = (byte)8;
        public static byte SHARED_BATHROOM_SENSOR = (byte)9;
        public static byte IRELAND = (byte)10;
        public static byte KITCHEN_AUX = (byte)11;
        public static byte WALL_WASHER = (byte)12;
        public static byte NOT_DEFINE = (byte)-1;

        public static String ToString(byte code) {
            if (code == LIVINGROOM) {
                return "LIVINGROOM";
            }
            if (code == INNERROOM) {
                return "INNERROOM";
            }
            if (code == BEDROOM) {
                return "BEDROOM";
            }
            if (code == KITCHEN) {
                return "KITCHEN";
            }
            if (code == TABLE) {
                return "TABLE";
            }
            if (code == HALLWAY) {
                return "HALLWAY";
            }
            if (code == BALCONY) {
                return "BALCONY";
            }
            if (code == INDIRECT) {
                return "INDIRECT";
            }
            if (code == COUPLE_BATHROOM_SENSOR) {
                return "COUPLE_BATHROOM_SENSOR";
            }
            if (code == SHARED_BATHROOM_SENSOR) {
                return "SHARED_BATHROOM_SENSOR";
            }
            if (code == IRELAND) {
                return "IRELAND";
            }
            if (code == KITCHEN_AUX) {
                return "KITCHEN_AUX";
            }
            if (code == WALL_WASHER) {
                return "WALL_WASHER";
            }
            return "UnDefind(" + code + ")";
        }
    }

    public static class VersionClass {
        public byte FwVer_Year = 0;
        public byte FwVer_Month = 0;
        public byte FwVer_Day = 0;
        public byte FwVer_Number = 0;
        public byte ProtocolVer_Main = 0;
        public byte ProtocolVer_Sub = 0;
        public byte VendorCode = 0;

        public boolean setData(byte[] inData, int StartIndex) {
            if (inData == null) {
                return false;
            }
            if (inData.length < 7 + StartIndex) {
                return false;
            }
            int index = StartIndex;
            try {
                this.FwVer_Year = inData[index++];
                this.FwVer_Month = inData[index++];
                this.FwVer_Day = inData[index++];
                this.FwVer_Number = inData[index++];
                this.ProtocolVer_Main = inData[index++];
                this.ProtocolVer_Sub = inData[index++];
                this.VendorCode = inData[index++];
            }
            catch (Exception e) {
                Log.e((String)Sdb_DataClasses.TAG, (String)"[VersionClass.setData(byte [], int)] - [Exception Error] ");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public boolean setData(String[] inData, int StartIndex) {
            if (inData == null) {
                return false;
            }
            if (inData.length < 7 + StartIndex) {
                return false;
            }
            int index = StartIndex;
            try {
                this.FwVer_Year = Byte.parseByte(inData[index++]);
                this.FwVer_Month = Byte.parseByte(inData[index++]);
                this.FwVer_Day = Byte.parseByte(inData[index++]);
                this.FwVer_Number = Byte.parseByte(inData[index++]);
                this.ProtocolVer_Main = Byte.parseByte(inData[index++]);
                this.ProtocolVer_Sub = Byte.parseByte(inData[index++]);
                this.VendorCode = Byte.parseByte(inData[index++]);
            }
            catch (Exception e) {
                Log.e((String)Sdb_DataClasses.TAG, (String)"[VersionClass.setData(String [], int)] - [Exception Error] ");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public String getStringData() {
            String retStr = this.FwVer_Year + ";" + this.FwVer_Month + ";" + this.FwVer_Day + ";" + this.FwVer_Number + ";" + this.ProtocolVer_Main + ";" + this.ProtocolVer_Sub + ";" + this.VendorCode + ";";
            return retStr;
        }

        public String ToString() {
            String retStr = "[Version]\r\nFW Ver.       : " + (this.FwVer_Year + 2000) + "." + this.FwVer_Month + "." + this.FwVer_Day + "(" + this.FwVer_Number + ")\r\nProtocol Ver. : V" + this.ProtocolVer_Main + "." + this.ProtocolVer_Sub + "\r\nVendor      : " + VENDOR.ToString(this.VendorCode) + "\r\n";
            return retStr;
        }

        public boolean Equals(VersionClass Version2) {
            if (this.FwVer_Year != Version2.FwVer_Year) {
                return false;
            }
            if (this.FwVer_Month != Version2.FwVer_Month) {
                return false;
            }
            if (this.FwVer_Day != Version2.FwVer_Day) {
                return false;
            }
            if (this.FwVer_Number != Version2.FwVer_Number) {
                return false;
            }
            if (this.ProtocolVer_Main != Version2.ProtocolVer_Main) {
                return false;
            }
            if (this.ProtocolVer_Sub != Version2.ProtocolVer_Sub) {
                return false;
            }
            return this.VendorCode == Version2.VendorCode;
        }

        public static class VENDOR {
            public static byte ICONTROLS = 1;
            public static byte CHEIL = (byte)2;
            public static byte NESTFIELD = (byte)3;

            public static String ToString(byte vendor) {
                if (vendor == ICONTROLS) {
                    return "ICONTROLS";
                }
                if (vendor == CHEIL) {
                    return "CHEIL";
                }
                if (vendor == NESTFIELD) {
                    return "NESTFIELD";
                }
                return "UnDefind";
            }
        }
    }
}

