/*
 * Decompiled with CFR 0.152.
 */
package com.wgi.libwebeye;

import android.util.Log;
import com.wgi.libwebeye.JWebEyeParm;
import com.wgi.libwebeye.MD5;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.commons.codec.binary.Base64;

abstract class BaseNetCtrl
extends Thread {
    protected String TAG = "WebEye_BaseNetCtrl";
    static final int TRANSMIT_REQ = 0;
    static final int TRANSMIT_RES = 1;
    static final int TRANSMIT_SVR = 2;
    static final int TRANSMIT_CLI = 3;
    static final int TRANSMIT_SVR2 = 4;
    static final byte DEVICE_RELAY = 1;
    static final byte DEVICE_SENSOR = 2;
    static final byte DEVICE_READ_DATA = 0;
    static final byte DEVICE_WRITE_DATA = 1;
    static final byte DEVICE_GET_CONF = 2;
    static final byte DEVICE_SET_CONF = 3;
    static final byte DEVICE_READ_DEVLIST = 4;
    static final int WESP10_HEADER_SIZE = 12;
    static final short WESP10_LOGIN = 1;
    static final short WESP10_DISCONNECT = 2;
    static final short WESP10_KEEPALIVE = 3;
    static final short WESP10_TAKECONTROL = 4;
    static final short WESP10_PTZINFO = 5;
    static final short WESP10_PTZACTION = 6;
    static final short WESP10_GIVECONTROL = 7;
    static final short WESP10_GET_PTZPOS = 8;
    static final short WESP10_SET_PTZPOS = 9;
    static final short WESP10_STREAMINFO = 10;
    static final short WESP10_SET_OSD = 11;
    static final short WESP10_RESOLUTIONINFO = 12;
    static final short WESP10_CONTENTINFO = 4;
    static final short WESP10_DEVICE_CONF = 21;
    static final short WESP10_MONTHLOG = 25;
    static final short WESP10_SERVICE_START = 6;
    static final short WESP10_SERVICE_STOP = 7;
    static final short WESP10_OPENSITE = 4099;
    static final short WESP10_PLAY_COMMAND = 7;
    static final short WESP10_PLAY_EVENTMAP = 5;
    static final short ERR_UNAUTH_IP = 1;
    static final short ERR_UNAUTH_USER = 2;
    static final short ERR_INVALID_DATA = 3;
    static final short ERR_UNAUTH_RIGHT = 5;
    static final int ERR_SVR_FULL = 69635;
    public static final int ERR_NONE = 0;
    protected Socket socket;
    protected DataInputStream inStream;
    protected DataOutputStream outStream;
    protected boolean isConnected = false;
    protected boolean isTerminate = true;
    protected boolean isNetError = false;
    protected int lastErrorCode;
    public static Thread curThread = null;
    public JWebEyeParm webeyeParm = null;
    protected static int timeout = 15000;
    protected int category = 1;
    public boolean isTryConnecting = false;
    protected long AddedFunction = 0L;
    public short timezone = (short)540;
    public byte DSTEnable;
    public int isResolutionMap = 0;
    public int isPlaybackSecondStream = 0;
    public int isPTZSupported = 0;
    public int isServiceChannel = 0;
    public int socketTimeoutChecker = 0;

    BaseNetCtrl() {
    }

    public int Login() {
        if (this.webeyeParm == null) {
            return -1;
        }
        if (this.isTerminate) {
            if (curThread != null && curThread.isAlive()) {
                this.isTerminate = true;
            } else {
                this.isTerminate = false;
                this.isTryConnecting = true;
                this.start();
            }
        }
        return 0;
    }

    protected int LoginResponse(JWESP10Header resHeader, DataInputStream di) {
        block14: {
            String nonceStr;
            block15: {
                block13: {
                    block12: {
                        Log.d((String)this.TAG, (String)"LoginResponse");
                        if (di != null) break block12;
                        Log.e((String)this.TAG, (String)"di is null~!!!!");
                        return -1;
                    }
                    if (resHeader.errorCode == 0) break block13;
                    return -3;
                }
                if (resHeader.transmitType == 1) {
                    byte majorVersion = di.readByte();
                    byte minorVersion = di.readByte();
                    short patchVersion = di.readShort();
                    timeout = di.readInt();
                    di.readByte();
                    this.timezone = di.readShort();
                    Log.d((String)this.TAG, (String)("timezone(min) : " + this.timezone));
                    if (resHeader.bodySize > 11) {
                        short timezone_index = di.readShort();
                        this.DSTEnable = di.readByte();
                        this.AddedFunction = (long)di.readInt() & 0xFFFFFFFFFFFFFFFFL;
                        String function = String.format("0x%02X", this.AddedFunction);
                        if ((this.AddedFunction >> 6 & 1L) == 1L) {
                            this.isResolutionMap = 1;
                        }
                        if ((this.AddedFunction >> 2 & 1L) == 1L) {
                            this.isPlaybackSecondStream = 1;
                        }
                        if ((this.AddedFunction >> 14 & 1L) == 0L) {
                            this.isPTZSupported = 1;
                        }
                        if ((this.AddedFunction >> 28 & 1L) == 1L) {
                            Log.d((String)this.TAG, (String)"Service Channel Supported");
                            this.isServiceChannel = 1;
                        }
                        if (resHeader.bodySize > 18) {
                            int size = resHeader.bodySize - 18;
                            byte[] dummy = new byte[size];
                            di.read(dummy, 0, size);
                        }
                    }
                    Log.d((String)this.TAG, (String)("login ok" + this.webeyeParm.channelNum));
                    break block14;
                }
                byte authMethod = di.readByte();
                byte securityLevel = di.readByte();
                int nonceLength = di.readInt();
                byte[] nonce = new byte[nonceLength];
                di.read(nonce, 0, nonce.length);
                nonceStr = new String(nonce);
                if (securityLevel <= 1) break block15;
                return -4;
            }
            try {
                this.sendAuthCode(nonceStr);
                return -2;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void openSite(String serial) {
        Log.d((String)this.TAG, (String)("open Site : " + serial));
        byte[] header = new byte[12];
        byte[] serial_buf = new byte[24];
        this.writeHeader(header, 0, 4099, 24);
        try {
            this.outStream.write(header);
            System.arraycopy(serial.getBytes(), 0, serial_buf, 0, serial.length());
            this.outStream.write(serial_buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int WESPLogin() {
        byte[] header = new byte[12];
        this.writeHeader(header, 0, 1, 0);
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.flush();
        }
        catch (IOException e) {
            this.webeyeParm.webeyeService.loginFail(this.webeyeParm, -1);
            return -1;
        }
        return 0;
    }

    public int RequestLogin() {
        this.socketTimeoutChecker = 0;
        boolean temp_connect = this.connect(this.webeyeParm.address, this.webeyeParm.port, 5000);
        if (!temp_connect) {
            this.isTryConnecting = false;
            if (this.socketTimeoutChecker == 1) {
                this.webeyeParm.webeyeService.loginFail(this.webeyeParm, 1000);
            } else {
                this.webeyeParm.webeyeService.loginFail(this.webeyeParm, -2);
            }
            return -2;
        }
        this.isTryConnecting = false;
        this.isNetError = false;
        byte[] header = new byte[12];
        this.writeHeader(header, 0, 1, 0);
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.flush();
            Log.d((String)this.TAG, (String)"outStream write : RequestLogin");
        }
        catch (IOException e) {
            this.webeyeParm.webeyeService.loginFail(this.webeyeParm, -1);
            return -1;
        }
        return 0;
    }

    private int sendAuthCode(String nonce) {
        if (this.webeyeParm == null || !this.isConnected) {
            return -1;
        }
        if (this.webeyeParm.password == null || this.webeyeParm.username == null) {
            return -1;
        }
        byte[] header = new byte[12];
        byte[] digest = new MD5().toDigest(this.webeyeParm.password.getBytes());
        String digestPasswd = new String(Base64.encodeBase64((byte[])digest));
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(nonce);
        strBuffer.append(":");
        strBuffer.append(digestPasswd);
        digest = new MD5().toDigest(strBuffer.toString().getBytes());
        String authCode = new String(Base64.encodeBase64((byte[])digest));
        byte[] byteID = this.webeyeParm.username.getBytes();
        byte[] byteAuthCode = authCode.getBytes();
        int bodySize = byteID.length + byteAuthCode.length + 8;
        this.writeHeader(header, 3, 1, bodySize);
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.writeInt(byteID.length);
            this.outStream.write(byteID, 0, byteID.length);
            this.outStream.writeInt(byteAuthCode.length);
            this.outStream.write(byteAuthCode, 0, byteAuthCode.length);
            this.outStream.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    private boolean connect(String _host, int _port, int _timeout) {
        try {
            InetAddress serverAddr = InetAddress.getByName(this.webeyeParm.address);
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(serverAddr, this.webeyeParm.port), 10000);
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)("\uc18c\ucf13 \ud0c0\uc784\uc544\uc6c3 : " + e.toString()));
            this.socketTimeoutChecker = 1;
            return false;
        }
        if (this.socket == null) {
            Log.e((String)this.TAG, (String)"socket fails 1");
            return false;
        }
        this.isConnected = true;
        try {
            this.socket.setSoTimeout(30000);
            this.socket.setSendBufferSize(8192);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Set Socket Option Fail");
        }
        try {
            this.inStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.outStream = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)"socket fails 2");
            return false;
        }
        return true;
    }

    public void onDisconnect() {
        Log.d((String)this.TAG, (String)("================onDisconnect()============" + this.webeyeParm.channelNum));
        this.isTryConnecting = false;
        try {
            this.stopThread();
            this.Disconnect();
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
            if (this.socket != null) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
                this.socket = null;
            }
            this.isConnected = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int Disconnect() {
        byte[] header = new byte[12];
        this.writeHeader(header, 0, 2, 0);
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.flush();
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    private void stopThread() {
        this.isTerminate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readHeader(JWESP10Header header) {
        header.version = 0;
        header.transmitType = 0;
        header.categoryId = 0;
        header.commandId = 0;
        header.errorCode = 0;
        header.bodySize = 0;
        try {
            DataInputStream dataInputStream = this.inStream;
            synchronized (dataInputStream) {
                byte byteVal = this.inStream.readByte();
                header.version = (byte)(byteVal >> 4);
                header.transmitType = (byte)(byteVal & 0xF);
                header.categoryId = this.inStream.readByte();
                header.commandId = this.inStream.readShort();
                header.errorCode = this.inStream.readInt();
                header.bodySize = this.inStream.readInt();
                if (header.errorCode != 0) {
                    Log.e((String)this.TAG, (String)("Get Header Message\nVersion : " + header.version + " TransmitType : " + header.transmitType + " CategoryId : " + header.categoryId + " CommandId : " + header.commandId + " ErrorCode : " + Integer.toHexString(header.errorCode) + " BodySize : " + header.bodySize));
                }
                if (header.bodySize >= 0) return true;
                Log.e((String)this.TAG, (String)"--------------------readHeader fail");
                return false;
            }
        }
        catch (SocketTimeoutException e) {
            Log.e((String)this.TAG, (String)"readWesp10Header1 SocketTimeoutException ", (Throwable)e);
            return false;
        }
        catch (EOFException e) {
            Log.e((String)this.TAG, (String)"readWesp10Header1 EOFException ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)"readWesp10Header1 IOException ", (Throwable)e);
            return false;
        }
    }

    protected byte[] writeHeader(byte[] encPacket, int transmitType, int commandId, int bodySize) {
        encPacket[0] = (byte)(0xA0 | transmitType);
        encPacket[1] = (byte)this.category;
        encPacket[2] = (byte)(commandId >> 8 & 0xFF);
        encPacket[3] = (byte)(commandId & 0xFF);
        encPacket[8] = (byte)(bodySize >> 24 & 0xFF);
        encPacket[9] = (byte)(bodySize >> 16 & 0xFF);
        encPacket[10] = (byte)(bodySize >> 8 & 0xFF);
        encPacket[11] = (byte)(bodySize & 0xFF);
        return encPacket;
    }

    protected synchronized int sendKeepAlive() {
        if (this.webeyeParm == null || !this.isConnected) {
            return -1;
        }
        byte[] header = new byte[12];
        this.writeHeader(header, 3, 3, 0);
        if (this.outStream == null) {
            return 0;
        }
        try {
            this.outStream.write(header, 0, header.length);
            this.outStream.flush();
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)"sendKeepAlive fail~!!", (Throwable)e);
            return -1;
        }
        return 0;
    }

    class JWESP10Header {
        byte version;
        byte transmitType;
        byte categoryId;
        short commandId;
        int errorCode;
        int bodySize;

        JWESP10Header() {
        }
    }

    public class RelayInfo {
        public int relayCount;
        public int status;
    }
}

