/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class AirQualitySensorAPI
extends WallPadDevAPI {
    private final String TAG = "AirQualitySensorAPI";
    private final boolean DEBUG_LOG_ON = true;
    public DataClasses.AirQualityData mAirQualityData;

    private void DebugLogOutput(String s) {
        Log.d((String)"AirQualitySensorAPI", (String)s);
    }

    public AirQualitySensorAPI(DevCtrCMD devctrcmd) {
        try {
            this.DebugLogOutput("AirQualitySensorAPI create " + devctrcmd);
            this.ErrorCode = new APIErrorCode();
            this.DevctrCMD = devctrcmd;
            this.TitleStr = "AIRQUALITYSENSOR";
            this.mAirQualityData = new DataClasses.AirQualityData();
        }
        catch (Exception e) {
            Log.e((String)"AirQualitySensorAPI", (String)"[Exception] AirQualitySensorAPI(DevCtrCMD devctrcmd)");
            e.printStackTrace();
        }
    }

    public AirQualitySensorAPI() {
        try {
            this.DebugLogOutput("AirQualitySensorAPI create public()");
            this.ErrorCode = new APIErrorCode();
            this.TitleStr = "AIRQUALITYSENSOR";
            this.mAirQualityData = new DataClasses.AirQualityData();
        }
        catch (Exception e) {
            Log.e((String)"AirQualitySensorAPI", (String)"[Exception] AirQualitySensorAPI()");
            e.printStackTrace();
        }
    }

    public String ToDebugString() {
        return this.mAirQualityData.device.ToDebugString();
    }

    public int Refresh(boolean bReal) {
        try {
            String MainCMD = null;
            String SubCMD = "Refresh";
            MainCMD = bReal ? "SINKCTRL" : "NOSINKCTRL";
            String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
            if (ret == null) {
                return -101;
            }
            String[] retlist = ret.split(";");
            if (retlist == null) {
                return -101;
            }
            if (retlist.length != 21) {
                return -102;
            }
            if (retlist[0].equals("SUCCESS")) {
                int index = 0;
                try {
                    index = 1;
                    this.mAirQualityData.info.Support.bSensePM10 = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.info.Support.bSensePM2p5 = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.info.Support.bSensePM1p0 = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.info.Support.bSenseCO2 = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.info.Support.bCtrlableLEDBrightness = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.info.Support.bCtrlableFanMode = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.device.bPMSensorStatus = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.device.bCo2SensorStatus = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.device.bAutoLEDCtrl = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.device.bAutoFanCtrl = Boolean.parseBoolean(retlist[index++]);
                    this.mAirQualityData.device.hLEDBrightness = Byte.parseByte(retlist[index++]);
                    this.mAirQualityData.device.hFanMode = Byte.parseByte(retlist[index++]);
                    this.mAirQualityData.device.hLevel_PM10 = Byte.parseByte(retlist[index++]);
                    this.mAirQualityData.device.dFigure_PM10 = Double.parseDouble(retlist[index++]);
                    this.mAirQualityData.device.hLevel_PM2p5 = Byte.parseByte(retlist[index++]);
                    this.mAirQualityData.device.dFigure_PM2p5 = Double.parseDouble(retlist[index++]);
                    this.mAirQualityData.device.hLevel_PM1p0 = Byte.parseByte(retlist[index++]);
                    this.mAirQualityData.device.dFigure_PM1p0 = Double.parseDouble(retlist[index++]);
                    this.mAirQualityData.device.hLevel_CO2 = Byte.parseByte(retlist[index++]);
                    this.mAirQualityData.device.dFigure_CO2 = Double.parseDouble(retlist[index++]);
                }
                catch (Exception e) {
                    Log.e((String)"AirQualitySensorAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                    e.printStackTrace();
                    return -100;
                }
                return 0;
            }
            this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"AirQualitySensorAPI", (String)"[Exception] Refresh(boolean bReal)");
            e.printStackTrace();
            return -101;
        }
    }

    public int ctrlLEDBrightness(byte hBrightness) {
        try {
            if (!DataClasses.AirQualityData.Device.LEDBrightness.checkRange(hBrightness)) {
                Log.w((String)"AirQualitySensorAPI", (String)("[ctrlLEDBrightness] Param : hBrightness out of range !!! -> " + String.format("0x%02X", hBrightness)));
                return -300;
            }
            return this.SendNReadCMD_int("SINKCTRL", "ctrlLEDBrightness", hBrightness, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"AirQualitySensorAPI", (String)"[Exception] ctrlLEDBrightness(byte hBrightness)");
            e.printStackTrace();
            return -100000;
        }
    }

    public int ctrlFanMode(byte hMode) {
        try {
            if (!DataClasses.AirQualityData.Device.FanMode.checkRange(hMode)) {
                Log.w((String)"AirQualitySensorAPI", (String)("[ctrlFanMode] Param : hMode out of range !!! -> " + String.format("0x%02X", hMode)));
                return -300;
            }
            return this.SendNReadCMD_int("SINKCTRL", "ctrlFanMode", hMode, 0, 0, 0, 0);
        }
        catch (Exception e) {
            Log.e((String)"AirQualitySensorAPI", (String)"[Exception] ctrlFanMode(byte hMode)");
            e.printStackTrace();
            return -100000;
        }
    }
}

