/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import java.util.ArrayList;
import org.iotivity.OCMain;
import org.iotivity.OCMethod;
import org.iotivity.OCRequestHandler;
import org.iotivity.OCResource;
import org.iotivity.oc.OcDevice;

public class OcResource {
    protected String name;
    protected String uri;
    protected String[] resourceTypes;
    protected int[] interfaceMasks;
    private int defaultInterfaceMask;
    private boolean discoverable;
    private boolean observable;
    private int periodicObservable;
    private OCRequestHandler getRequestHandler;
    private OCRequestHandler putRequestHandler;
    private OCRequestHandler postRequestHandler;
    private OCRequestHandler deleteRequestHandler;
    protected OCResource nativeResource;

    protected OcResource() {
    }

    public OcResource(OcDevice ocDevice, String string, String string2, String[] stringArray, int[] nArray) {
        if (ocDevice == null) {
            throw new IllegalArgumentException("OcDevice cannot be null");
        }
        this.name = string != null ? string : "";
        this.uri = string2 != null ? string2 : "";
        this.resourceTypes = stringArray != null ? stringArray : new String[]{};
        this.interfaceMasks = nArray != null ? nArray : new int[]{};
        this.nativeResource = OCMain.newResource(this.name, this.uri, (short)this.resourceTypes.length, ocDevice.getDeviceIndex());
        if (this.nativeResource != null) {
            for (String string4 : this.resourceTypes) {
                OCMain.resourceBindResourceType(this.nativeResource, string4);
            }
            for (int n : this.interfaceMasks) {
                OCMain.resourceBindResourceInterface(this.nativeResource, n);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public String[] getResourceTypes() {
        return this.resourceTypes;
    }

    public int[] getInterfaceMasks() {
        int n = this.nativeResource.getInterfaces();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if ((n & 2) > 0) {
            arrayList.add(2);
        }
        if ((n & 4) > 0) {
            arrayList.add(4);
        }
        if ((n & 8) > 0) {
            arrayList.add(8);
        }
        if ((n & 0x10) > 0) {
            arrayList.add(16);
        }
        if ((n & 0x20) > 0) {
            arrayList.add(32);
        }
        if ((n & 0x40) > 0) {
            arrayList.add(64);
        }
        if ((n & 0x80) > 0) {
            arrayList.add(128);
        }
        int n2 = 0;
        int[] nArray = new int[arrayList.size()];
        for (Integer n3 : arrayList) {
            nArray[n2++] = n3;
        }
        return nArray;
    }

    public int getDefaultInterfaceMask() {
        return this.defaultInterfaceMask;
    }

    public void setDefaultInterfaceMask(int n) {
        this.defaultInterfaceMask = n;
        OCMain.resourceSetDefaultInterface(this.nativeResource, this.defaultInterfaceMask);
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public void setDiscoverable(boolean bl) {
        this.discoverable = bl;
        OCMain.resourceSetDiscoverable(this.nativeResource, this.discoverable);
    }

    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean bl) {
        this.observable = bl;
        OCMain.resourceSetObservable(this.nativeResource, this.observable);
    }

    public int getPeriodicObservable() {
        return this.periodicObservable;
    }

    public void setPeriodicObservable(int n) {
        this.periodicObservable = n;
        OCMain.resourceSetPeriodicObservable(this.nativeResource, this.periodicObservable);
    }

    public OCRequestHandler getGetRequestHandler() {
        return this.getRequestHandler;
    }

    public void setGetRequestHandler(OCRequestHandler oCRequestHandler) {
        if (oCRequestHandler != null) {
            OCMain.resourceSetRequestHandler(this.nativeResource, OCMethod.OC_GET, oCRequestHandler);
            this.getRequestHandler = oCRequestHandler;
        }
    }

    public OCRequestHandler getPutRequestHandler() {
        return this.putRequestHandler;
    }

    public void setPutRequestHandler(OCRequestHandler oCRequestHandler) {
        if (oCRequestHandler != null) {
            OCMain.resourceSetRequestHandler(this.nativeResource, OCMethod.OC_PUT, oCRequestHandler);
            this.putRequestHandler = oCRequestHandler;
        }
    }

    public OCRequestHandler getPostRequestHandler() {
        return this.postRequestHandler;
    }

    public void setPostRequestHandler(OCRequestHandler oCRequestHandler) {
        if (oCRequestHandler != null) {
            OCMain.resourceSetRequestHandler(this.nativeResource, OCMethod.OC_POST, oCRequestHandler);
            this.postRequestHandler = oCRequestHandler;
        }
    }

    public OCRequestHandler getDeleteRequestHandler() {
        return this.deleteRequestHandler;
    }

    public void setDeleteRequestHandler(OCRequestHandler oCRequestHandler) {
        if (oCRequestHandler != null) {
            OCMain.resourceSetRequestHandler(this.nativeResource, OCMethod.OC_DELETE, oCRequestHandler);
            this.deleteRequestHandler = oCRequestHandler;
        }
    }

    public int notifyObservers() {
        return OCMain.notifyObservers(this.nativeResource);
    }

    OCResource getNativeResource() {
        return this.nativeResource;
    }
}

