/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import org.iotivity.OCArray;
import org.iotivity.OCRep;
import org.iotivity.OCRepresentation;
import org.iotivity.OCType;
import org.iotivity.OCValue;
import org.iotivity.oc.OcCborException;

public class OcRepresentation {
    private OCRepresentation nativeRepresentation;

    public OcRepresentation(OCRepresentation oCRepresentation) {
        if (oCRepresentation == null) {
            throw new IllegalArgumentException("Native OCRepresentation cannot be null");
        }
        this.nativeRepresentation = oCRepresentation;
    }

    public static OcRepresentation createOcRepresentaionFromRoot() throws OcCborException {
        OCRepresentation oCRepresentation = OCRep.getOCRepresentaionFromRootObject();
        if (oCRepresentation != null) {
            return new OcRepresentation(oCRepresentation);
        }
        throw new OcCborException("Failed to create OcRepresentation from root object");
    }

    public String getKey() {
        return this.nativeRepresentation.getName();
    }

    public OCType getType() {
        return this.nativeRepresentation.getType();
    }

    public boolean getBoolean() throws OcCborException {
        Boolean bl = this.getValue().getBool();
        if (bl != null) {
            return bl;
        }
        throw new OcCborException("Failed to get boolean");
    }

    public long getLong() throws OcCborException {
        Long l = this.getValue().getInteger();
        if (l != null) {
            return l;
        }
        throw new OcCborException("Failed to get long");
    }

    public double getDouble() throws OcCborException {
        Double d = this.getValue().getDouble();
        if (d != null) {
            return d;
        }
        throw new OcCborException("Failed to get double");
    }

    public String getString() throws OcCborException {
        String string = this.getValue().getString();
        if (string != null) {
            return string;
        }
        throw new OcCborException("Failed to get string");
    }

    public OCArray getArray() throws OcCborException {
        OCArray oCArray = this.getValue().getArray();
        if (oCArray != null) {
            return oCArray;
        }
        throw new OcCborException("Failed to get array");
    }

    public OcRepresentation getObject() throws OcCborException {
        OCRepresentation oCRepresentation = this.getValue().getObject();
        if (oCRepresentation != null) {
            return new OcRepresentation(oCRepresentation);
        }
        throw new OcCborException("Failed to get object");
    }

    public OcRepresentation getObjectArray() throws OcCborException {
        OCRepresentation oCRepresentation = this.getValue().getObjectArray();
        if (oCRepresentation != null) {
            return new OcRepresentation(oCRepresentation);
        }
        throw new OcCborException("Failed to get object array");
    }

    public OCValue getValue() throws OcCborException {
        OCValue oCValue = this.nativeRepresentation.getValue();
        if (oCValue != null) {
            return oCValue;
        }
        throw new OcCborException("Failed to get value");
    }

    public boolean getBoolean(String string) throws OcCborException {
        Boolean bl = OCRep.getBoolean(this.nativeRepresentation, string);
        if (bl != null) {
            return bl;
        }
        throw new OcCborException("Failed to get boolean for key " + string);
    }

    public long getLong(String string) throws OcCborException {
        Long l = OCRep.getLong(this.nativeRepresentation, string);
        if (l != null) {
            return l;
        }
        throw new OcCborException("Failed to get long for key " + string);
    }

    public double getDouble(String string) throws OcCborException {
        Double d = OCRep.getDouble(this.nativeRepresentation, string);
        if (d != null) {
            return d;
        }
        throw new OcCborException("Failed to get double for key " + string);
    }

    public String getString(String string) throws OcCborException {
        String string2 = OCRep.getString(this.nativeRepresentation, string);
        if (string2 != null) {
            return string2;
        }
        throw new OcCborException("Failed to get string for key " + string);
    }

    public byte[] getByteString(String string) throws OcCborException {
        byte[] byArray = OCRep.getByteString(this.nativeRepresentation, string);
        if (byArray != null) {
            return byArray;
        }
        throw new OcCborException("Failed to get byte string for key " + string);
    }

    public OcRepresentation getObject(String string) throws OcCborException {
        OCRepresentation oCRepresentation = OCRep.getObject(this.nativeRepresentation, string);
        if (oCRepresentation != null) {
            return new OcRepresentation(oCRepresentation);
        }
        throw new OcCborException("Failed to get object for key " + string);
    }

    public boolean[] getBooleanArray(String string) throws OcCborException {
        boolean[] blArray = OCRep.getBooleanArray(this.nativeRepresentation, string);
        if (blArray != null) {
            return blArray;
        }
        throw new OcCborException("Failed to get boolean array for key " + string);
    }

    public long[] getLongArray(String string) throws OcCborException {
        long[] lArray = OCRep.getLongArray(this.nativeRepresentation, string);
        if (lArray != null) {
            return lArray;
        }
        throw new OcCborException("Failed to get long array for key " + string);
    }

    public double[] getDoubleArray(String string) throws OcCborException {
        double[] dArray = OCRep.getDoubleArray(this.nativeRepresentation, string);
        if (dArray != null) {
            return dArray;
        }
        throw new OcCborException("Failed to get double array for key " + string);
    }

    public String[] getStringArray(String string) throws OcCborException {
        String[] stringArray = OCRep.getStringArray(this.nativeRepresentation, string);
        if (stringArray != null) {
            return stringArray;
        }
        throw new OcCborException("Failed to get string array for key " + string);
    }

    public byte[][] getByteStringArray(String string) throws OcCborException {
        byte[][] byArray = OCRep.getByteStringArray(this.nativeRepresentation, string);
        if (byArray != null) {
            return byArray;
        }
        throw new OcCborException("Failed to get byte string array for key " + string);
    }

    public OcRepresentation getObjectArray(String string) throws OcCborException {
        OCRepresentation oCRepresentation = OCRep.getObjectArray(this.nativeRepresentation, string);
        if (oCRepresentation != null) {
            return new OcRepresentation(oCRepresentation);
        }
        throw new OcCborException("Failed to get object array for key " + string);
    }

    public OcRepresentation getNext() {
        OCRepresentation oCRepresentation = this.nativeRepresentation.getNext();
        if (oCRepresentation != null) {
            return new OcRepresentation(oCRepresentation);
        }
        return null;
    }
}

