/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.iotivity.OCMain;
import org.iotivity.OCMainInitHandler;
import org.iotivity.oc.OcDevice;

public class OcPlatform {
    private AtomicInteger deviceIndex = new AtomicInteger();
    private Map<OcDevice, AtomicInteger> deviceIndexLookup = new ConcurrentHashMap<OcDevice, AtomicInteger>();
    private static OcPlatform instance;

    private OcPlatform() {
    }

    public static OcPlatform getInstance() {
        if (instance == null) {
            instance = new OcPlatform();
        }
        return instance;
    }

    public void systemShutdown() {
        OCMain.mainShutdown();
        this.deviceIndex.set(0);
        this.deviceIndexLookup.clear();
    }

    public void systemInit(OCMainInitHandler oCMainInitHandler) {
        int n = OCMain.mainInit(oCMainInitHandler);
        if (n < 0) {
            System.exit(n);
        }
    }

    public int platformInit(String string) {
        string = string != null ? string : "";
        return OCMain.initPlatform(string);
    }

    public void reset() {
        OCMain.reset();
    }

    public int addDevice(OcDevice ocDevice) {
        int n = -1;
        if (ocDevice != null) {
            ocDevice.setDeviceIndex(this.deviceIndex.get());
            this.deviceIndexLookup.put(ocDevice, this.deviceIndex);
            n = ocDevice.getAddDeviceCallback() != null ? OCMain.addDevice(ocDevice.getUri(), ocDevice.getRt(), ocDevice.getName(), ocDevice.getSpecVersion(), ocDevice.getDataModelVersion(), ocDevice.getAddDeviceCallback()) : OCMain.addDevice(ocDevice.getUri(), ocDevice.getRt(), ocDevice.getName(), ocDevice.getSpecVersion(), ocDevice.getDataModelVersion());
            if (n >= 0) {
                this.deviceIndex.getAndIncrement();
            }
        }
        return n;
    }
}

