/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.iotivity.OCAddDeviceHandler;
import org.iotivity.OCConnectivity;
import org.iotivity.OCCoreRes;
import org.iotivity.OCIntrospection;
import org.iotivity.OCMain;
import org.iotivity.OCResource;
import org.iotivity.OCUuid;
import org.iotivity.oc.OcCollection;
import org.iotivity.oc.OcResource;

public class OcDevice {
    private Map<OcResource, OCResource> resourceLookup = new ConcurrentHashMap<OcResource, OCResource>();
    private String uri;
    private String rt;
    private String name;
    private String specVersion;
    private String dataModelVersion;
    private OCAddDeviceHandler addDeviceCallback;
    private int deviceIndex;

    public OcDevice(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4, string5, null);
    }

    public OcDevice(String string, String string2, String string3, String string4, String string5, OCAddDeviceHandler oCAddDeviceHandler) {
        this.uri = string != null ? string : "";
        this.rt = string2 != null ? string2 : "";
        this.name = string3 != null ? string3 : "";
        this.specVersion = string4 != null ? string4 : "";
        this.dataModelVersion = string5 != null ? string5 : "";
        this.addDeviceCallback = oCAddDeviceHandler;
    }

    public String getUri() {
        return this.uri;
    }

    public String getRt() {
        return this.rt;
    }

    public String getName() {
        return this.name;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getDataModelVersion() {
        return this.dataModelVersion;
    }

    public OCAddDeviceHandler getAddDeviceCallback() {
        return this.addDeviceCallback;
    }

    public OCUuid getId() {
        return OCCoreRes.getDeviceId(this.deviceIndex);
    }

    public void setIntrospectionData(byte[] byArray) {
        OCIntrospection.setIntrospectionData(this.deviceIndex, byArray);
    }

    public void setImmutableDeviceId(OCUuid oCUuid) {
        OCMain.setImmutableDeviceIdentifier(this.deviceIndex, oCUuid);
    }

    public void addResource(OcResource ocResource) {
        if (ocResource != null) {
            if (ocResource instanceof OcCollection) {
                OCMain.addCollection(ocResource.getNativeResource());
            } else {
                OCMain.addResource(ocResource.getNativeResource());
            }
            this.resourceLookup.put(ocResource, ocResource.getNativeResource());
        }
    }

    public boolean deleteResource(OcResource ocResource) {
        if (ocResource != null) {
            this.resourceLookup.remove(ocResource);
            if (ocResource instanceof OcCollection) {
                OCMain.deleteCollection(ocResource.getNativeResource());
                return true;
            }
            return OCMain.deleteResource(ocResource.getNativeResource());
        }
        return false;
    }

    public void addCollection(OcCollection ocCollection) {
        this.addResource(ocCollection);
    }

    public boolean deleteCollection(OcCollection ocCollection) {
        return this.deleteResource(ocCollection);
    }

    public OcResource[] getResources() {
        return this.resourceLookup.keySet().toArray(new OcResource[0]);
    }

    public OcCollection[] getCollections() {
        ArrayList<OcCollection> arrayList = new ArrayList<OcCollection>();
        for (OcResource ocResource : this.resourceLookup.keySet()) {
            if (!(ocResource instanceof OcCollection)) continue;
            OcCollection ocCollection = (OcCollection)ocResource;
            arrayList.add(ocCollection);
        }
        return arrayList.toArray(new OcCollection[0]);
    }

    public void bindResourceType(String string) {
        OCMain.deviceBindResourceType(this.deviceIndex, string);
    }

    public void resetDevice() {
        OCMain.resetDevice(this.deviceIndex);
    }

    public int initConnectivity() {
        return OCConnectivity.init(this.deviceIndex);
    }

    public void shutdownConnectivity() {
        OCConnectivity.shutdown(this.deviceIndex);
    }

    int getDeviceIndex() {
        return this.deviceIndex;
    }

    void setDeviceIndex(int n) {
        this.deviceIndex = n;
    }
}

