/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import org.iotivity.CborEncoder;
import org.iotivity.OCMain;
import org.iotivity.OCRep;
import org.iotivity.OCResource;
import org.iotivity.oc.OcResource;

public class OcCborEncoder {
    private boolean isDone;
    private boolean hasKey;
    private EncoderType encoderType;
    private OcCborEncoder parentEncoder;
    private CborEncoder nativeCborEncoder;

    private OcCborEncoder(EncoderType encoderType, CborEncoder cborEncoder) {
        this(encoderType, null, false, cborEncoder);
    }

    private OcCborEncoder(EncoderType encoderType, OcCborEncoder ocCborEncoder, boolean bl, CborEncoder cborEncoder) {
        this.encoderType = encoderType;
        this.parentEncoder = ocCborEncoder;
        this.hasKey = bl;
        this.nativeCborEncoder = cborEncoder;
    }

    public static OcCborEncoder createOcCborEncoder(EncoderType encoderType) {
        CborEncoder cborEncoder;
        if (encoderType == null) {
            throw new IllegalArgumentException("EncoderType cannot be null");
        }
        switch (encoderType) {
            case ROOT: {
                cborEncoder = OCRep.beginRootObject();
                break;
            }
            case LINKS_ARRAY: {
                cborEncoder = OCRep.beginLinksArray();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal EncoderType " + encoderType.name());
            }
        }
        OcCborEncoder ocCborEncoder = new OcCborEncoder(encoderType, cborEncoder);
        return ocCborEncoder;
    }

    public static OcCborEncoder createOcCborEncoder(EncoderType encoderType, OcCborEncoder ocCborEncoder) {
        CborEncoder cborEncoder;
        if (encoderType == null) {
            throw new IllegalArgumentException("EncoderType cannot be null");
        }
        if (ocCborEncoder == null) {
            throw new IllegalArgumentException("OcCborEncoder parent cannot be null");
        }
        switch (encoderType) {
            case OBJECT: {
                cborEncoder = OCRep.beginObject(ocCborEncoder.getNativeEncoder());
                break;
            }
            case ARRAY: {
                cborEncoder = OCRep.beginArray(ocCborEncoder.getNativeEncoder());
                break;
            }
            case ARRAY_ITEM: {
                cborEncoder = OCRep.objectArrayBeginItem(ocCborEncoder.getNativeEncoder());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal EncoderType " + encoderType.name());
            }
        }
        OcCborEncoder ocCborEncoder2 = new OcCborEncoder(encoderType, ocCborEncoder, false, cborEncoder);
        return ocCborEncoder2;
    }

    public static OcCborEncoder createOcCborEncoder(EncoderType encoderType, OcCborEncoder ocCborEncoder, String string) {
        CborEncoder cborEncoder;
        if (encoderType == null) {
            throw new IllegalArgumentException("EncoderType cannot be null");
        }
        if (ocCborEncoder == null) {
            throw new IllegalArgumentException("OcCborEncoder parent cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("String key cannot be null");
        }
        switch (encoderType) {
            case OBJECT: {
                cborEncoder = OCRep.openObject(ocCborEncoder.getNativeEncoder(), string);
                break;
            }
            case ARRAY: {
                cborEncoder = OCRep.openArray(ocCborEncoder.getNativeEncoder(), string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal EncoderType " + encoderType.name());
            }
        }
        OcCborEncoder ocCborEncoder2 = new OcCborEncoder(encoderType, ocCborEncoder, true, cborEncoder);
        return ocCborEncoder2;
    }

    public void done() {
        if (this.isDone) {
            throw new UnsupportedOperationException("done() cannot be called twice. Encoder type is " + this.encoderType.name());
        }
        switch (this.encoderType) {
            case ROOT: {
                OCRep.endRootObject();
                break;
            }
            case LINKS_ARRAY: {
                OCRep.endLinksArray();
                break;
            }
            case OBJECT: {
                if (this.hasKey) {
                    OCRep.closeObject(this.parentEncoder.getNativeEncoder(), this.getNativeEncoder());
                    break;
                }
                OCRep.endObject(this.parentEncoder.getNativeEncoder(), this.getNativeEncoder());
                break;
            }
            case ARRAY: {
                if (this.hasKey) {
                    OCRep.closeArray(this.parentEncoder.getNativeEncoder(), this.getNativeEncoder());
                    break;
                }
                OCRep.endArray(this.parentEncoder.getNativeEncoder(), this.getNativeEncoder());
                break;
            }
            case ARRAY_ITEM: {
                OCRep.objectArrayEndItem(this.parentEncoder.getNativeEncoder(), this.getNativeEncoder());
                break;
            }
        }
        this.isDone = true;
    }

    public void processBaselineInterface(OcResource ocResource) {
        this.processBaselineInterface(ocResource.getNativeResource());
    }

    public void processBaselineInterface(OCResource oCResource) {
        if (this.encoderType != EncoderType.ROOT) {
            throw new UnsupportedOperationException(this.getBadEncoderTypeMsg(this.encoderType, EncoderType.ROOT));
        }
        OCMain.processBaselineInterface(oCResource);
    }

    public void addBoolean(boolean bl) {
        if (this.encoderType != EncoderType.ARRAY) {
            throw new UnsupportedOperationException(this.getBadEncoderTypeMsg(this.encoderType, EncoderType.ARRAY));
        }
        OCRep.addBoolean(this.getNativeEncoder(), bl);
    }

    public void addLong(long l) {
        if (this.encoderType != EncoderType.ARRAY) {
            throw new UnsupportedOperationException(this.getBadEncoderTypeMsg(this.encoderType, EncoderType.ARRAY));
        }
        OCRep.addLong(this.getNativeEncoder(), l);
    }

    public void addDouble(double d) {
        if (this.encoderType != EncoderType.ARRAY) {
            throw new UnsupportedOperationException(this.getBadEncoderTypeMsg(this.encoderType, EncoderType.ARRAY));
        }
        OCRep.addDouble(this.getNativeEncoder(), d);
    }

    public void addByteString(byte[] byArray) {
        if (this.encoderType != EncoderType.ARRAY) {
            throw new UnsupportedOperationException(this.getBadEncoderTypeMsg(this.encoderType, EncoderType.ARRAY));
        }
        OCRep.addByteString(this.getNativeEncoder(), byArray);
    }

    public void addTextString(String string) {
        if (this.encoderType != EncoderType.ARRAY) {
            throw new UnsupportedOperationException(this.getBadEncoderTypeMsg(this.encoderType, EncoderType.ARRAY));
        }
        OCRep.addTextString(this.getNativeEncoder(), string);
    }

    public void setBoolean(String string, boolean bl) {
        OCRep.setBoolean(this.getNativeEncoder(), string, bl);
    }

    public void setUnsignedInt(String string, long l) {
        OCRep.setUnsignedInt(this.getNativeEncoder(), string, l);
    }

    public void setLong(String string, long l) {
        OCRep.setLong(this.getNativeEncoder(), string, l);
    }

    public void setDouble(String string, double d) {
        OCRep.setDouble(this.getNativeEncoder(), string, d);
    }

    public void setByteString(String string, byte[] byArray) {
        OCRep.setByteString(this.getNativeEncoder(), string, byArray);
    }

    public void setTextString(String string, String string2) {
        OCRep.setTextString(this.getNativeEncoder(), string, string2);
    }

    public void setBooleanArray(String string, boolean[] blArray) {
        OCRep.setBooleanArray(this.getNativeEncoder(), string, blArray);
    }

    public void setLongArray(String string, long[] lArray) {
        OCRep.setLongArray(this.getNativeEncoder(), string, lArray);
    }

    public void setDoubleArray(String string, double[] dArray) {
        OCRep.setDoubleArray(this.getNativeEncoder(), string, dArray);
    }

    public void setStringArray(String string, String[] stringArray) {
        OCRep.setStringArray(this.getNativeEncoder(), string, stringArray);
    }

    CborEncoder getNativeEncoder() {
        return this.nativeCborEncoder;
    }

    private String getBadEncoderTypeMsg(EncoderType encoderType, EncoderType encoderType2) {
        return new String("Encoder type " + encoderType.name() + " not allowed. Encoder type must be " + encoderType2.name());
    }

    public static enum EncoderType {
        ROOT,
        LINKS_ARRAY,
        OBJECT,
        ARRAY,
        ARRAY_ITEM;

    }
}

