/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import org.iotivity.OCAddDeviceHandler;
import org.iotivity.OCBridge;
import org.iotivity.OCMain;
import org.iotivity.oc.OcVirtualDevice;

public class OcBridge {
    private String name;
    private String specVersion;
    private String dataModelVersion;

    public OcBridge(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public OcBridge(String string, String string2, String string3, OCAddDeviceHandler oCAddDeviceHandler) {
        this.name = string != null ? string : "";
        this.specVersion = string2 != null ? string2 : "";
        this.dataModelVersion = string3 != null ? string3 : "";
        int n = OCBridge.addBridgeDevice(this.name, this.specVersion, this.dataModelVersion, oCAddDeviceHandler);
        if (n < 0) {
            System.err.println("Error in OCBridge.addBridgeDevice() in OcBridge.ctor()");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getDataModelVersion() {
        return this.dataModelVersion;
    }

    public int addVirtualDevice(OcVirtualDevice ocVirtualDevice) {
        int n = -1;
        if (ocVirtualDevice != null && (n = OCBridge.addVirtualDevice(ocVirtualDevice.getVirtualDeviceId(), ocVirtualDevice.getEcoSystemName(), ocVirtualDevice.getUri(), ocVirtualDevice.getRt(), ocVirtualDevice.getName(), ocVirtualDevice.getSpecVersion(), ocVirtualDevice.getDataModelVersion(), ocVirtualDevice.getAddDeviceCallback())) > 0) {
            ocVirtualDevice.setDeviceIndex(n);
        }
        return n;
    }

    public int removeVirtualDevice(OcVirtualDevice ocVirtualDevice) {
        if (ocVirtualDevice != null) {
            return OCBridge.removeVirtualDevice(ocVirtualDevice.getDeviceIndex());
        }
        return -1;
    }

    public int deleteVirtualDevice(OcVirtualDevice ocVirtualDevice) {
        if (ocVirtualDevice != null) {
            return OCBridge.deleteVirtualDevice(ocVirtualDevice.getDeviceIndex());
        }
        return -1;
    }

    public void reset() {
        OCMain.resetDevice(0L);
    }
}

