/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity;

import org.iotivity.OCArray;
import org.iotivity.OCRepJNI;
import org.iotivity.OCRepresentation;

public class OCValue {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected OCValue(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(OCValue oCValue) {
        return oCValue == null ? 0L : oCValue.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OCRepJNI.delete_OCValue(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setInteger(long l) {
        OCRepJNI.OCValue_integer_set(this.swigCPtr, this, l);
    }

    public long getInteger() {
        return OCRepJNI.OCValue_integer_get(this.swigCPtr, this);
    }

    public void setBool(boolean bl) {
        OCRepJNI.OCValue_Bool_set(this.swigCPtr, this, bl);
    }

    public boolean getBool() {
        return OCRepJNI.OCValue_Bool_get(this.swigCPtr, this);
    }

    public void setDouble(double d) {
        OCRepJNI.OCValue_Double_set(this.swigCPtr, this, d);
    }

    public double getDouble() {
        return OCRepJNI.OCValue_Double_get(this.swigCPtr, this);
    }

    public void setString(String string) {
        OCRepJNI.OCValue_string_set(this.swigCPtr, this, string);
    }

    public String getString() {
        return OCRepJNI.OCValue_string_get(this.swigCPtr, this);
    }

    public void setArray(OCArray oCArray) {
        OCRepJNI.OCValue_array_set(this.swigCPtr, this, OCArray.getCPtr(oCArray), oCArray);
    }

    public OCArray getArray() {
        long l = OCRepJNI.OCValue_array_get(this.swigCPtr, this);
        return l == 0L ? null : new OCArray(l, false);
    }

    public void setObject(OCRepresentation oCRepresentation) {
        OCRepJNI.OCValue_object_set(this.swigCPtr, this, OCRepresentation.getCPtr(oCRepresentation), oCRepresentation);
    }

    public OCRepresentation getObject() {
        long l = OCRepJNI.OCValue_object_get(this.swigCPtr, this);
        return l == 0L ? null : new OCRepresentation(l, false);
    }

    public void setObjectArray(OCRepresentation oCRepresentation) {
        OCRepJNI.OCValue_objectArray_set(this.swigCPtr, this, OCRepresentation.getCPtr(oCRepresentation), oCRepresentation);
    }

    public OCRepresentation getObjectArray() {
        long l = OCRepJNI.OCValue_objectArray_get(this.swigCPtr, this);
        return l == 0L ? null : new OCRepresentation(l, false);
    }

    public OCValue() {
        this(OCRepJNI.new_OCValue(), true);
    }
}

