/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iotivity.OCUuid;
import org.iotivity.oc.OcRemoteResource;

public class OcRemoteDevice {
    private OCUuid di;
    private String name;
    private String piid;
    private String icv;
    private String dmv;
    private List<OcRemoteResource> resources = Collections.synchronizedList(new ArrayList());

    OcRemoteDevice(OCUuid oCUuid, String string, String string2, String string3, String string4) {
        if (oCUuid == null || string == null) {
            throw new IllegalArgumentException("di or name cannot be null");
        }
        this.di = oCUuid;
        this.name = string;
        this.piid = string2 != null ? string2 : "";
        this.icv = string3 != null ? string3 : "";
        this.dmv = string4 != null ? string4 : "";
    }

    public OCUuid getDeviceId() {
        return this.di;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocolIndependentId() {
        return this.piid;
    }

    public String getSpecVersion() {
        return this.icv;
    }

    public String getDataModelVersion() {
        return this.dmv;
    }

    public OcRemoteResource[] getResources() {
        return this.resources.toArray(new OcRemoteResource[0]);
    }

    public void addResource(OcRemoteResource ocRemoteResource) {
        if (ocRemoteResource != null) {
            this.resources.add(ocRemoteResource);
        }
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.di.hashCode();
        n = 37 * n + this.name.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        OcRemoteDevice ocRemoteDevice = (OcRemoteDevice)object;
        return this.di.equals(ocRemoteDevice.di) && this.name.equals(ocRemoteDevice.name);
    }
}

