/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import org.iotivity.OCLink;
import org.iotivity.OCMain;
import org.iotivity.oc.OcResource;

public class OcLink {
    private OcResource resource;
    private OCLink nativeLink;

    public OcLink(OcResource ocResource) {
        this(ocResource, 0L, null);
    }

    public OcLink(OcResource ocResource, long l, String[] stringArray) {
        if (ocResource != null) {
            this.nativeLink = OCMain.newLink(ocResource.getNativeResource());
            if (this.nativeLink != null) {
                this.resource = ocResource;
                this.setInstance(l);
                this.addRelations(stringArray);
            }
        } else {
            throw new IllegalArgumentException("OcResource cannot be null");
        }
    }

    public OcResource getResource() {
        return this.resource;
    }

    public long getInstance() {
        return this.nativeLink.getIns();
    }

    public void setInstance(long l) {
        if (l != 0L) {
            this.nativeLink.setIns(l);
        }
    }

    public String[] getRelations() {
        return this.nativeLink.getRel();
    }

    public void addRelations(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addRelation(string);
            }
        }
    }

    public void addRelation(String string) {
        if (string != null) {
            OCMain.linkAddRelation(this.nativeLink, string);
        }
    }

    OCLink getNativeLink() {
        return this.nativeLink;
    }
}

