/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import org.iotivity.OCClientResponse;
import org.iotivity.OCEndpoint;
import org.iotivity.OCResponseHandler;
import org.iotivity.OCUuidUtil;
import org.iotivity.oc.OcCborException;
import org.iotivity.oc.OcDeviceDiscoveryHandler;
import org.iotivity.oc.OcGetRemoteResourcesHandler;
import org.iotivity.oc.OcRemoteDevice;
import org.iotivity.oc.OcRepresentation;
import org.iotivity.oc.OcUtils;

class OcGetRemoteDeviceHandler
implements OCResponseHandler {
    private static final String N_KEY = "n";
    private static final String DI_KEY = "di";
    private static final String PIID_KEY = "piid";
    private static final String ICV_KEY = "icv";
    private static final String DMV_KEY = "dmv";
    private OcDeviceDiscoveryHandler deviceDiscoveryHandler;

    public OcGetRemoteDeviceHandler(OcDeviceDiscoveryHandler ocDeviceDiscoveryHandler) {
        this.deviceDiscoveryHandler = ocDeviceDiscoveryHandler;
    }

    @Override
    public void handler(OCClientResponse oCClientResponse) {
        OcRepresentation ocRepresentation = null;
        try {
        }
        catch (Exception exception) {
            System.err.println("Failed to get representation from client response, " + exception.getMessage());
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (ocRepresentation = new OcRepresentation(oCClientResponse.getPayload()); ocRepresentation != null; ocRepresentation = ocRepresentation.getNext()) {
            try {
                if (N_KEY.equals(ocRepresentation.getKey())) {
                    string = ocRepresentation.getString(N_KEY);
                }
                if (DI_KEY.equals(ocRepresentation.getKey())) {
                    string2 = ocRepresentation.getString(DI_KEY);
                }
                if (PIID_KEY.equals(ocRepresentation.getKey())) {
                    string3 = ocRepresentation.getString(PIID_KEY);
                }
                if (ICV_KEY.equals(ocRepresentation.getKey())) {
                    string4 = ocRepresentation.getString(ICV_KEY);
                }
                if (!DMV_KEY.equals(ocRepresentation.getKey())) continue;
                string5 = ocRepresentation.getString(DMV_KEY);
                continue;
            }
            catch (OcCborException ocCborException) {
                System.err.println(ocCborException.getMessage());
            }
        }
        if (string2 != null && string != null) {
            OcRemoteDevice ocRemoteDevice = new OcRemoteDevice(OCUuidUtil.stringToUuid(string2), string, string3, string4, string5);
            for (OCEndpoint oCEndpoint = oCClientResponse.getEndpoint(); oCEndpoint != null; oCEndpoint = oCEndpoint.getNext()) {
                if (!OcUtils.endpointToString(oCEndpoint).startsWith("coap://")) continue;
                boolean bl = OcUtils.doIPDiscoveryAllAtEndpoint(new OcGetRemoteResourcesHandler(ocRemoteDevice, this.deviceDiscoveryHandler), oCEndpoint);
                if (bl) {
                    return;
                }
                System.err.println("Error issuing resource discovery all request for uuid " + string2 + " at endpoint " + OcUtils.endpointToString(oCEndpoint));
            }
            System.err.println("Cannot issue resource discovery all request to any 'coap://' endpoint");
            return;
        }
        System.err.println("'di' or 'n' cannot be null");
    }
}

