/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.oc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.iotivity.OCLink;
import org.iotivity.OCMain;
import org.iotivity.oc.OcDevice;
import org.iotivity.oc.OcLink;
import org.iotivity.oc.OcResource;

public class OcCollection
extends OcResource {
    private Map<OcLink, OCLink> linkLookup = new ConcurrentHashMap<OcLink, OCLink>();
    private String[] supportedRts;
    private String[] mandatoryRts;

    public OcCollection(OcDevice ocDevice, String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (ocDevice == null) {
            throw new IllegalArgumentException("OcDevice cannot be null");
        }
        this.name = string != null ? string : "";
        this.uri = string2 != null ? string2 : "";
        this.resourceTypes = stringArray != null ? stringArray : new String[]{};
        this.interfaceMasks = new int[0];
        this.supportedRts = stringArray2 != null ? stringArray2 : new String[]{};
        this.mandatoryRts = stringArray3 != null ? stringArray3 : new String[]{};
        this.nativeResource = OCMain.newCollection(this.name, this.uri, (short)this.resourceTypes.length, ocDevice.getDeviceIndex());
        if (this.nativeResource != null) {
            for (String string3 : this.resourceTypes) {
                OCMain.resourceBindResourceType(this.nativeResource, string3);
            }
            for (String string3 : this.supportedRts) {
                OCMain.collectionAddSupportedResourceType(this.nativeResource, string3);
            }
            for (String string3 : this.mandatoryRts) {
                OCMain.collectionAddMandatoryResourceType(this.nativeResource, string3);
            }
        }
    }

    public String[] getSupportedRts() {
        return this.supportedRts;
    }

    public String[] getMandatoryRts() {
        return this.mandatoryRts;
    }

    public void addLink(OcLink ocLink) {
        if (ocLink != null) {
            OCMain.collectionAddLink(this.nativeResource, ocLink.getNativeLink());
            this.linkLookup.put(ocLink, ocLink.getNativeLink());
        }
    }

    public void deleteLink(OcLink ocLink) {
        if (ocLink != null) {
            this.linkLookup.remove(ocLink);
            OCMain.deleteLink(ocLink.getNativeLink());
        }
    }

    public OcLink[] getLinks() {
        return this.linkLookup.keySet().toArray(new OcLink[0]);
    }
}

