/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity;

import org.iotivity.DevAddr;
import org.iotivity.OCEndpointParseException;
import org.iotivity.OCEndpointUtilJNI;
import org.iotivity.OCFVersion;
import org.iotivity.OCUuid;

public class OCEndpoint {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected OCEndpoint(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(OCEndpoint oCEndpoint) {
        return oCEndpoint == null ? 0L : oCEndpoint.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OCEndpointUtilJNI.delete_OCEndpoint(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setAddr(DevAddr devAddr) {
        OCEndpointUtilJNI.OCEndpoint_addr_set(this.swigCPtr, this, DevAddr.getCPtr(devAddr), devAddr);
    }

    public DevAddr getAddr() {
        long l = OCEndpointUtilJNI.OCEndpoint_addr_get(this.swigCPtr, this);
        return l == 0L ? null : new DevAddr(l, false);
    }

    public void setAddrLocal(DevAddr devAddr) {
        OCEndpointUtilJNI.OCEndpoint_addrLocal_set(this.swigCPtr, this, DevAddr.getCPtr(devAddr), devAddr);
    }

    public DevAddr getAddrLocal() {
        long l = OCEndpointUtilJNI.OCEndpoint_addrLocal_get(this.swigCPtr, this);
        return l == 0L ? null : new DevAddr(l, false);
    }

    public void setNext(OCEndpoint oCEndpoint) {
        OCEndpointUtilJNI.OCEndpoint_next_set(this.swigCPtr, this, OCEndpoint.getCPtr(oCEndpoint), oCEndpoint);
    }

    public OCEndpoint getNext() {
        long l = OCEndpointUtilJNI.OCEndpoint_next_get(this.swigCPtr, this);
        return l == 0L ? null : new OCEndpoint(l, false);
    }

    public void setDevice(long l) {
        OCEndpointUtilJNI.OCEndpoint_device_set(this.swigCPtr, this, l);
    }

    public long getDevice() {
        return OCEndpointUtilJNI.OCEndpoint_device_get(this.swigCPtr, this);
    }

    public void setFlags(int n) {
        OCEndpointUtilJNI.OCEndpoint_flags_set(this.swigCPtr, this, n);
    }

    public int getFlags() {
        return OCEndpointUtilJNI.OCEndpoint_flags_get(this.swigCPtr, this);
    }

    public OCUuid getDi() {
        long l = OCEndpointUtilJNI.OCEndpoint_di_get(this.swigCPtr, this);
        return l == 0L ? null : new OCUuid(l, false);
    }

    public void setInterfaceIndex(int n) {
        OCEndpointUtilJNI.OCEndpoint_interfaceIndex_set(this.swigCPtr, this, n);
    }

    public int getInterfaceIndex() {
        return OCEndpointUtilJNI.OCEndpoint_interfaceIndex_get(this.swigCPtr, this);
    }

    public void setPriority(short s) {
        OCEndpointUtilJNI.OCEndpoint_priority_set(this.swigCPtr, this, s);
    }

    public short getPriority() {
        return OCEndpointUtilJNI.OCEndpoint_priority_get(this.swigCPtr, this);
    }

    public void setVersion(OCFVersion oCFVersion) {
        OCEndpointUtilJNI.OCEndpoint_version_set(this.swigCPtr, this, oCFVersion.swigValue());
    }

    public OCFVersion getVersion() {
        return OCFVersion.swigToEnum(OCEndpointUtilJNI.OCEndpoint_version_get(this.swigCPtr, this));
    }

    public OCEndpoint() {
        this(OCEndpointUtilJNI.new_OCEndpoint__SWIG_0(), true);
    }

    public OCEndpoint(String string) throws OCEndpointParseException {
        this(OCEndpointUtilJNI.new_OCEndpoint__SWIG_1(string), true);
    }

    public void setDi(OCUuid oCUuid) {
        OCEndpointUtilJNI.OCEndpoint_setDi(this.swigCPtr, this, OCUuid.getCPtr(oCUuid), oCUuid);
    }

    public String toString() {
        return OCEndpointUtilJNI.OCEndpoint_toString(this.swigCPtr, this);
    }

    public boolean isIPv6LinkLocal() {
        return OCEndpointUtilJNI.OCEndpoint_isIPv6LinkLocal(this.swigCPtr, this);
    }

    public boolean compare(OCEndpoint oCEndpoint) {
        return OCEndpointUtilJNI.OCEndpoint_compare(this.swigCPtr, this, OCEndpoint.getCPtr(oCEndpoint), oCEndpoint);
    }

    public boolean compareAddress(OCEndpoint oCEndpoint) {
        return OCEndpointUtilJNI.OCEndpoint_compareAddress(this.swigCPtr, this, OCEndpoint.getCPtr(oCEndpoint), oCEndpoint);
    }

    public void setLocalAddress(int n) {
        OCEndpointUtilJNI.OCEndpoint_setLocalAddress(this.swigCPtr, this, n);
    }

    public OCEndpoint copy() {
        long l = OCEndpointUtilJNI.OCEndpoint_copy(this.swigCPtr, this);
        return l == 0L ? null : new OCEndpoint(l, true);
    }
}

