﻿

BemsWebApplication.Formula = function (params, viewInfo) {
    "use strict";

    var FACILITY_TYPE_DEPTH = 2,
        FACILITY_DEPTH = 3,
        FORMULA_DEPTH = 4;

    var facilityTypeDataSource = BemsWebApplication.db.createDataSource('BemsFacilityType'),
        facilityDataSource = BemsWebApplication.db.createDataSource('CmFacility', true),
        formulaBaseDataSource = BemsWebApplication.db.createDataSource('BemsFormulaBase'),
        formulaDataSource = BemsWebApplication.db.createDataSource('BemsFormula'),
        tableDataSource = BemsWebApplication.db.createDataSource('BemsFormulaTable'),

        parameterDataSource = BWA.DataUtil.createDataSource({
            dataSourceOptions: {
                select: [
                    'SiteId', 'FacilityTypeId', 'FacilityCode', 'FormulaId',
                    'ParameterId',
                    'ParameterFacilityCode', 'ParameterPropertyId',
                    'CmFacility/Name', 'BemsMonitoringPoint/Name'
                ],
                expand: ['CmFacility', 'BemsMonitoringPoint'],
                extendOptions: {
                    alterNames: {
                        'CmFacility/Name': 'FacilityName',
                        'BemsMonitoringPoint/Name': 'PointName',
                    }
                }
            }
        }, 'BemsFormulaParameter'),


        formulaDataViewModel = new BWA.BemsFormulaViewModel(),

        factory = BemsWebApplication.Factory.PointLocationMapping,

        viewModel,
        formulaPointPopup = null,
        gridView,

        popupVisible = ko.observable(false),

        parameters = ko.observableArray(),
        facilityParameters = ko.observableArray(),

        selectedTreeItem = ko.observable(null),
//        selectedPoints = ko.observableArray(),


        pointDataSource = factory.getDataSource(),

        pointDataGridOptions = utils.datagrid.defaultOptions({
            dxDataSource: pointDataSource,
            datagridId: 'pointDataGrid',
            dbId: 'BemsMonitoringPoint',
            width: '100%',
            height: 706,
            //selection: {
            //    mode: 'multiple'
            //},

            columns: factory.getColumns([
                //{ dataField: 'FacilityName', width: '30%' },
                { dataField: 'CmFacility/Name', width: '30%' },
                { dataField: 'Name', width: '55%' },
                { dataField: 'ValueType', width: '15%' }
            ]),
            wordWrapEnabled: true,
            rowPrepared: function (rowElement, rowInfo) {
                if (rowInfo.rowType != 'data') {
                    return;
                }
                rowElement
                    .addClass('draggablePointRow')
                    .data('data', rowInfo.data)
                    .data('keyValue', rowInfo.key);
            },

            contentReadyAction: function (e) {

                e.element.find('.draggablePointRow').draggable({
                    cursor: 'point',
                    appendTo: '#mainContents',
                    cursorAt: { right: 0, bottom: 0 },
                    helper: function (e) {
                        var div = $('<div>', {
                            'overflow': 'auto'
                        });
                        div.text('test');
                        return div;
                    },
                    start: function (event, ui) {
                        var $originalRow = $(this);

                        var $originalRowCells = $originalRow.children();
                        var key = $originalRow.data('keyValue');
                        var data = $originalRow.data('data');
                        ui.helper
                            .data('keyValue', key)
                            .data('data', data)
                        //.text('{0} [{1}]'.formati(data.FacilityName(), data.Name()))
                        .text('{0} [{1}]'.formati(data['CmFacility/Name'](), data.Name()))

                            .addClass('drag-helper');

                        //console.log(ui.helper);
                        //var $originalRowCells = $originalRow.children(),
                        //    $clonedRowCells = $clonedRow.children();
                        //$('<div>').text($clonedRowCells.get(1).text());
                        ////var $originalRowCells = $originalRow.children(),
                        ////    $clonedRowCells = $clonedRow.children();
                        ////for (var i = 0; i < $originalRowCells.length; i++)
                        ////    $($clonedRowCells.get(i)).width($($originalRowCells.get(i)).width());
                        //$clonedRow
                        //    .width($originalRow.width())
                        //    .addClass('drag-helper');
                        //console.log(ui.helper.offset());
                        //var offset = ui.helper.offset();
                        //ui.helper.appendTo($('#mainContents'));
                        //ui.position.top = offset.top;
                        //ui.position.left = offset.left;
                        //console.log('after');
                        //console.log(ui.helper.offset());

                        ////ui.helper.offset(offset);
                        //ui.helper.css({
                        //    left: offset.left,
                        //    top: offset.top
                        //});
                        //console.log(ui.helper.offset());
                    }
                });
            },

            handleDataGridRowClick: function() {
                formulaPointPopup.handleDataGridRowClick.apply(this, arguments);
            },
            //    : function (id, dataGrid, clickRow, popupVisible) {
            //    viewModel.formulaPointPopup.show();
            //}
        }),

        parameterDataGridOptions = utils.datagrid.defaultOptions({
            dataSource: parameters,
            datagridId: 'parameterDataGrid',
            width: '100%',
            height: 320,
            pager: {
                showPageSizeSelector: false,
                allowedPageSizes: []
            },
            //selection: {
            //    mode: 'multiple'
            //},

            columns: [
                { dataField: 'ParameterId', caption: $G('variable'), width: '10%' },
                { dataField: 'FacilityName', caption: $G('facilityName'), width: '45%' },
                //{ dataField: 'CmFacility/Name', caption: $G('facilityName'), width: '45%' },
                { dataField: 'PointName', caption: $G('pointName'), width: '45%' },
            ],
            wordWrapEnabled: true,
            rowPrepared: function (rowElement, rowInfo) {
                if (rowInfo.rowType != 'data') {
                    return;
                }
                rowElement
                    .addClass('droppableParameterRow')
                    .data('keyValue', rowInfo.key)
                    .data('data', rowInfo.data);
            },
            contentReadyAction: function (e) {

                e.element.find('.droppableParameterRow').droppable({
                    drop: function (event, ui) {
                        var draggingRowKey = ui.draggable.data('keyValue');
                        var draggingRowData = ui.draggable.data('data');

                        var targetRowKey = $(this).data('keyValue');
                        var draggingIndex = null,
                            targetIndex = null;
                        console.log(draggingRowKey);
                        console.log(targetRowKey);
                        var paramter = _.find(parameters(), function (x) {
                            return x.ParameterId === targetRowKey.ParameterId;
                        });
                        paramter.FacilityKey = draggingRowKey;
                        //paramter.FacilityName = draggingRowData.FacilityName();
                        paramter.FacilityName = draggingRowData['CmFacility/Name']();
                        paramter.PointName = draggingRowData.Name();
                        paramter.ParameterFacilityCode = draggingRowData.FacilityCode();
                        paramter.ParameterPropertyId = draggingRowData.PropertyId();

                        $('#parameterDataGrid').dxDataGrid('instance').refresh();
                        console.log($('#parameterDataGrid').dxDataGrid('instance').option('hoverStateEnabled'));
                    }
                });
            },
            handleDataGridRowClick: function (id, dataGrid, clickRow, popupVisible) {
            },
        }),


        tableDataGridOptions = utils.datagrid.defaultOptions({
            dxDataSource: tableDataSource,
            datagridId: 'tableDataGrid',
            dbId: 'BemsFormulaTable',
            width: '100%',
            height: 240,
            pager: {
                showPageSizeSelector: false,
                allowedPageSizes: []
            },
            //selection: {
            //    mode: 'multiple'
            //},

            columns: [
                { dataField: 'FunctionName', caption: $G('functionName'), width: '20%' },
                { dataField: 'Description', caption: $G('description'), width: '80%' },
            ],
            wordWrapEnabled: true,
            handleDataGridRowClick: function (id, dataGrid, clickRow, popupVisible) {
            }
        });
    formulaDataViewModel.Name = ko.observable();

    function refreshList() {
    }

    function handleClickTreeItem(element, data) {

        var depth = data.depth;
        if (depth !== FORMULA_DEPTH) return;

        var eq = BWA.DataUtil.constructEqualFilter;

        var parent = data.parentData;
        var data = data.data;
        selectedTreeItem(data);
        var siteId = BWA.UserInfo.SiteId();
        var filter = [
            eq('SiteId', siteId),
            'and',
            eq('FacilityTypeId', data.FacilityTypeId()),
            'and',
            eq('FormulaId', data.FormulaId()),
            'and',
            eq('FacilityCode', parent.data.FacilityCode()),
        ];

        formulaDataViewModel.SiteId(siteId);
        formulaDataViewModel.FacilityTypeId(data.FacilityTypeId());
        formulaDataViewModel.FacilityCode(parent.data.FacilityCode()); // parent 값을 가져올 수 있도록 treewidget를 수정 하자.
        formulaDataViewModel.FormulaId(data.FormulaId());
        formulaDataViewModel.Name(data.Name);

        formulaDataSource.filter(filter);
        formulaDataSource.load().done(function (result) {

            if (_.isEmpty(result)) {
                //                BWA.DataUtil.resetViewModel(formulaDataViewModel);
                formulaDataViewModel.Formula('');
                parameters([]);
                return;
            }
            formulaDataViewModel.fromJS(result[0].toJS());
            formulaDataViewModel.Name(data.Name());

            parameterDataSource.filter([
                eq('SiteId', siteId),
                'and',
                eq('FacilityTypeId', data.FacilityTypeId()),
                'and',
                //eq('FacilityCode', parent.data.FacilityCode()),
                eq('FacilityCode', formulaDataViewModel.FacilityCode()),
                'and',
                eq('FormulaId', data.FormulaId())
            ]);
            parameterDataSource.load().done(function (paramterArray) {
                //                if (_.isEmpty(paramterArray) === false) {
                parameters(paramterArray);
                //              }
            });
        });
    }

    function handleViewShown() {

        // 트리노드 선택 후 다른 화면으로 이동 한 경우,
        // 다시 현재 화면으로 들어왔을 때 이전에 선택되어 있던 트리노드가
        // 계속 선택된 상태로 표시되는 현상을 막기 위한 코드
        if (facilityDataSource._items.length != 0) {
            $('#formulaTreeView').cwTreeView('reload', selectedTreeItem().parentData);
        }

        var eq = BWA.DataUtil.constructEqualFilter;
        $('#formulaTreeView').cwTreeView({
            width: '40%',
            height: 'auto',
            onClickTreeItem: handleClickTreeItem,
            delegateDataSource: function (data, alterObj) {
                var id = data.id;
                var depth = data.depth;
                var promise = null;
                switch (depth) {
                    case 0:
                        var typeDeferred = new $.Deferred();
                        promise = typeDeferred.promise();
                        alterObj.IsFunction = false;
                        typeDeferred.resolve([
                            { Id: 99, Name: '등록설비' },
                            { Id: 100, Name: '시스템' }
                        ]);
                        break;
                    case 1:
                        var filter;
                        switch (data.data.Id) {
                            case 99: filter = [['FacilityTypeId', '<', 99]]; break;
                            case 100:filter = [['FacilityTypeId', '>', 99]]; break;
                        }

                        facilityTypeDataSource.filter(filter);
                        promise = facilityTypeDataSource.load();
                        break;
                    case 2:
                        facilityDataSource.filter([
                            eq('SiteId', BWA.UserInfo.SiteId()),
                            'and',
                            eq('FacilityTypeId', data.data.FacilityTypeId())
                        ]);
                        promise = facilityDataSource.load();
                        break;
                    case 3:
                        formulaBaseDataSource.filter([
                            eq('FacilityTypeId', data.data.FacilityTypeId())
                        ]);
                        promise = formulaBaseDataSource.load();
                        break;
                }
                return promise;
            },
        });
    }

    function hanleRemoveSelectedParameter() {
        var gridView = $('#parameterDataGrid').dxDataGrid('instance');
        var rows = gridView.getSelectedRowsData();

        console.log(rows);
    }

    function getParametersFromFormula() {

        var regex = /\b[A-Z]\b/g;

        var match;
        //        var ps = parameters();
        var list = [];
        while (match = regex.exec(formulaDataViewModel.Formula())) {

            var variable = match[0];
            if (_.some(list, function (x) {
                return x.ParameterId() === variable;
            })) continue;

            list.push({
                'ParameterId': ko.observable(variable)
            });
        }
        return list;
    }

    function formulaValueChangeAction(e) {

        var savedParameters = parameters();
        var formulaParameters = getParametersFromFormula();

        console.log(savedParameters);
        console.log(formulaParameters);

        _.each(formulaParameters, function (p) {

            if (_.some(savedParameters, function (x) {

                return x.ParameterId() === p.ParameterId();
            })) return;

            parameters.push(p);
        });

        for (var i = 0 ; i < savedParameters.length ; i++) {

            var p = savedParameters[i];
            if (_.some(formulaParameters, function (x) {
                console.log(x.ParameterId() + ' !== ' + p.ParameterId());
                return x.ParameterId() === p.ParameterId();
            })) {
                continue;
            }

            parameters.splice(i, 1);
            i--;

        }
    }

    function saveFormula() {

        var formula = formulaDataViewModel.toJS();

        if (_.some(parameters(), function (x) {

            // 아래 코드에서 오류발생하여 변경 
            //return _.isUndefined(x.ParameterFacilityCode) || _.isUndefined(x.ParameterFacilityCode());
            return _.isUndefined(x.ParameterFacilityCode);
        })) {
            utils.toast.show('관제점이 할당되지 않은 파라미터가 존재합니다.', 'error');
            return;
        }

        formula.Paramters = _.map(parameters(), function (x) {

            x = BWA.DataUtil.convertHybridViewModelToJS(x);
            x.SiteId = formula.SiteId;
            x.FacilityTypeId = formula.FacilityTypeId;
            x.FacilityCode = formula.FacilityCode;
            x.FormulaId = formula.FormulaId;

            return _.pick(x, 'SiteId', 'FacilityTypeId', 'FacilityCode',
                'FormulaId', 'ParameterId',
                'ParameterFacilityCode', 'ParameterPropertyId');
        });

        var promise = BWA.api.post('BemsFormula', formula);
        promise.done(function () {
            utils.toast.show($G('successDatabaseProcessMsg'));
        });
    }

    viewModel = {

        //        viewShown: handleViewShown,

        refreshList: refreshList,
        saveFormula: saveFormula,

        pointDataGridOptions: pointDataGridOptions,
        parameterDataGridOptions: parameterDataGridOptions,
        tableDataGridOptions: tableDataGridOptions,

        formulaDataViewModel: formulaDataViewModel,

        formulaValueChangeAction: formulaValueChangeAction,

        hanleRemoveSelectedParameter: hanleRemoveSelectedParameter
    };


    formulaPointPopup = viewModel.formulaPointPopup = BWA.Popup.FormulaPointPopup.create(viewModel);

    return $.extend(BWA.CommonView.create(params, viewInfo, viewModel.options, null, handleViewShown), viewModel);
};